/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.classifiers.DataPointPair;
import jsat.classifiers.trees.ImpurityScore;
import jsat.distributions.ContinuousDistribution;
import jsat.distributions.empirical.KernelDensityEstimator;
import jsat.distributions.empirical.kernelfunc.EpanechnikovKF;
import jsat.distributions.empirical.kernelfunc.KernelFunction;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.math.Function;
import jsat.math.OnLineStatistics;
import jsat.math.rootfinding.Zeroin;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;
import jsat.regression.RegressionDataSet;
import jsat.regression.Regressor;
import jsat.utils.DoubleList;
import jsat.utils.IntList;
import jsat.utils.IntSet;
import jsat.utils.PairedReturn;
import jsat.utils.QuickSort;

public class DecisionStump
implements Classifier,
Regressor,
Parameterized {
    private static final long serialVersionUID = -2849268862089019515L;
    private int splittingAttribute;
    private CategoricalData predicting;
    private CategoricalData[] catAttributes;
    private List<Double> boundries;
    private List<Integer> owners;
    private CategoricalResults[] results;
    private double[] regressionResults;
    private ImpurityScore.ImpurityMeasure gainMethod = ImpurityScore.ImpurityMeasure.INFORMATION_GAIN_RATIO;
    private NumericHandlingC numericHandlingC;
    private boolean removeContinuousAttributes;
    private int minResultSplitSize = 10;
    private static final double almost0 = 1.0E-6;
    private static final double almost1 = 0.999999;

    public DecisionStump() {
        this.setNumericHandling(NumericHandlingC.BINARY_BEST_GAIN);
        this.removeContinuousAttributes = false;
    }

    public void setRemoveContinuousAttributes(boolean removeContinuousAttributes) {
        this.removeContinuousAttributes = removeContinuousAttributes;
    }

    public void setGainMethod(ImpurityScore.ImpurityMeasure gainMethod) {
        this.gainMethod = gainMethod;
    }

    public ImpurityScore.ImpurityMeasure getGainMethod() {
        return this.gainMethod;
    }

    public void setNumericHandling(NumericHandlingC numericHandlingC) {
        this.numericHandlingC = numericHandlingC;
    }

    public NumericHandlingC getNumericHandling() {
        return this.numericHandlingC;
    }

    public void setMinResultSplitSize(int minResultSplitSize) {
        if (minResultSplitSize <= 1) {
            throw new ArithmeticException("Min split size must be a positive value ");
        }
        this.minResultSplitSize = minResultSplitSize;
    }

    public int getMinResultSplitSize() {
        return this.minResultSplitSize;
    }

    public int getSplittingAttribute() {
        return this.splittingAttribute;
    }

    public void setPredicting(CategoricalData predicting) {
        this.predicting = predicting;
    }

    @Override
    public double regress(DataPoint data) {
        if (this.regressionResults == null) {
            throw new RuntimeException("Decusion stump has not been trained for regression");
        }
        return this.regressionResults[this.whichPath(data)];
    }

    @Override
    public void train(RegressionDataSet dataSet, ExecutorService threadPool) {
        this.train(dataSet);
    }

    @Override
    public void train(RegressionDataSet dataSet) {
        IntSet options = new IntSet(dataSet.getNumFeatures());
        for (int i = 0; i < dataSet.getNumFeatures(); ++i) {
            options.add(i);
        }
        this.trainR(dataSet.getDPPList(), options);
    }

    protected double getGain(ImpurityScore origScore, List<List<DataPointPair<Integer>>> aSplit) {
        ImpurityScore[] scores = new ImpurityScore[aSplit.size()];
        for (int i = 0; i < aSplit.size(); ++i) {
            scores[i] = this.getClassGainScore(aSplit.get(i));
        }
        return ImpurityScore.gain(origScore, scores);
    }

    public static PairedReturn<Integer, Double> threshholdSplit(final ContinuousDistribution dist1, final ContinuousDistribution dist2) {
        double d;
        double d2;
        double d3;
        double d4;
        if (dist1 == null && dist2 == null) {
            throw new ArithmeticException("No Distributions given");
        }
        if (dist1 == null) {
            return new PairedReturn<Integer, Double>(1, Double.POSITIVE_INFINITY);
        }
        if (dist2 == null) {
            return new PairedReturn<Integer, Double>(0, Double.POSITIVE_INFINITY);
        }
        double tmp1 = dist1.invCdf(1.0E-6);
        double tmp2 = dist2.invCdf(0.999999);
        if (d4 > d3) {
            return new PairedReturn<Integer, Double>(1, (tmp1 + tmp2) * 0.5);
        }
        tmp1 = dist1.invCdf(0.999999);
        tmp2 = dist2.invCdf(1.0E-6);
        if (d2 < d) {
            return new PairedReturn<Integer, Double>(0, (tmp1 + tmp2) * 0.5);
        }
        Function f = new Function(){
            private static final long serialVersionUID = -8587449421333790319L;

            @Override
            public double f(double ... x) {
                return dist1.pdf(x[0]) - dist2.pdf(x[0]);
            }

            @Override
            public double f(Vec x) {
                return dist1.pdf(x.get(0)) - dist2.pdf(x.get(0));
            }
        };
        double minRange = Math.min(dist1.mean(), dist2.mean());
        double maxRange = Math.max(dist1.mean(), dist2.mean());
        double split = Double.POSITIVE_INFINITY;
        try {
            split = Zeroin.root(1.0E-8, minRange, maxRange, f, 0.0);
        }
        catch (ArithmeticException ex) {
            minRange = Math.min(dist1.invCdf(1.0E-6), dist2.invCdf(1.0E-6));
            maxRange = Math.max(dist1.invCdf(0.999999), dist2.invCdf(0.999999));
            split = Zeroin.root(1.0E-8, minRange, maxRange, f, 0.0);
        }
        double minStnd = Math.min(dist1.standardDeviation(), dist2.standardDeviation());
        int left = 0;
        if (dist2.pdf(split - minStnd / 2.0) > dist1.pdf(split - minStnd / 2.0)) {
            left = 1;
        }
        return new PairedReturn<Integer, Double>(left, split);
    }

    public static PairedReturn<List<Double>, List<Integer>> intersections(final List<ContinuousDistribution> dists) {
        double minRange = Double.MAX_VALUE;
        double maxRange = Double.MIN_VALUE;
        double stepSize = Double.MAX_VALUE;
        final IntList belongsTo = new IntList();
        DoubleList splitPoints = new DoubleList();
        for (ContinuousDistribution cd : dists) {
            if (cd == null) continue;
            minRange = Math.min(minRange, cd.invCdf(1.0E-6));
            maxRange = Math.max(maxRange, cd.invCdf(0.999999));
            double stndDev = cd.standardDeviation();
            if (!(stndDev > 0.0)) continue;
            stepSize = Math.min(stepSize, stndDev);
        }
        if ((maxRange - minRange) / (stepSize /= 4.0) > (double)(50 * dists.size())) {
            stepSize = (maxRange - minRange) / (double)(50 * dists.size());
        } else if (maxRange - minRange == 0.0 || minRange + stepSize == minRange) {
            return null;
        }
        belongsTo.add(Integer.valueOf(DecisionStump.maxPDF(dists, minRange)));
        for (double curPos = minRange + stepSize; curPos <= maxRange; curPos += stepSize) {
            double crossOverPoint;
            final int newMax = DecisionStump.maxPDF(dists, curPos);
            if (newMax == (Integer)belongsTo.get(belongsTo.size() - 1)) continue;
            Function f = new Function(){
                private static final long serialVersionUID = 2620160933085186146L;

                @Override
                public double f(double ... x) {
                    return ((ContinuousDistribution)dists.get((Integer)belongsTo.get(belongsTo.size() - 1))).pdf(x[0]) - ((ContinuousDistribution)dists.get(newMax)).pdf(x[0]);
                }

                @Override
                public double f(Vec x) {
                    return ((ContinuousDistribution)dists.get((Integer)belongsTo.get(belongsTo.size() - 1))).pdf(x.get(0)) - ((ContinuousDistribution)dists.get(newMax)).pdf(x.get(0));
                }
            };
            try {
                crossOverPoint = Zeroin.root(1.0E-6, curPos - stepSize, curPos, f, 0.0);
            }
            catch (ArithmeticException ex) {
                crossOverPoint = (curPos * 2.0 - stepSize) * 0.5;
            }
            splitPoints.add(Double.valueOf(crossOverPoint));
            belongsTo.add(Integer.valueOf(newMax));
        }
        splitPoints.add(Double.valueOf(Double.POSITIVE_INFINITY));
        return new PairedReturn<List<Double>, List<Integer>>(splitPoints, belongsTo);
    }

    private static int maxPDF(List<ContinuousDistribution> dits, double x) {
        double maxVal = -1.0;
        int best = -1;
        for (int i = 0; i < dits.size(); ++i) {
            double tmp;
            if (dits.get(i) == null || !((tmp = dits.get(i).pdf(x)) > maxVal)) continue;
            maxVal = tmp;
            best = i;
        }
        return best;
    }

    public int whichPath(DataPoint data) {
        int paths = this.getNumberOfPaths();
        if (paths < 0) {
            return paths;
        }
        if (paths == 1) {
            return 0;
        }
        if (this.splittingAttribute < this.catAttributes.length) {
            return data.getCategoricalValue(this.splittingAttribute);
        }
        int numerAttribute = this.splittingAttribute - this.catAttributes.length;
        if (this.results != null) {
            int pos = Collections.binarySearch(this.boundries, data.getNumericalValues().get(numerAttribute));
            pos = pos < 0 ? -pos - 1 : pos;
            return this.owners.get(pos);
        }
        if (this.regressionResults.length == 1) {
            return 0;
        }
        if (data.getNumericalValues().get(numerAttribute) <= this.regressionResults[2]) {
            return 0;
        }
        return 1;
    }

    public int getNumberOfPaths() {
        if (this.results != null) {
            return this.results.length;
        }
        if (this.catAttributes != null) {
            if (this.regressionResults.length == 1) {
                return 1;
            }
            if (this.splittingAttribute < this.catAttributes.length) {
                return this.catAttributes[this.splittingAttribute].getNumOfCategories();
            }
            return 2;
        }
        return -1;
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        if (this.results == null) {
            throw new RuntimeException("DecisionStump has not been trained for classification");
        }
        return this.results[this.whichPath(data)];
    }

    public CategoricalResults result(int i) {
        if (i < 0 || i >= this.getNumberOfPaths()) {
            throw new IndexOutOfBoundsException("Invalid path, can to return a result for path " + i);
        }
        return this.results[i];
    }

    @Override
    public void trainC(ClassificationDataSet dataSet, ExecutorService threadPool) {
        this.trainC(dataSet);
    }

    @Override
    public void trainC(ClassificationDataSet dataSet) {
        IntSet splitOptions = new IntSet(dataSet.getNumFeatures());
        for (int i = 0; i < dataSet.getNumFeatures(); ++i) {
            splitOptions.add(i);
        }
        this.predicting = dataSet.getPredicting();
        this.trainC(dataSet.getAsDPPList(), splitOptions);
    }

    /*
     * WARNING - void declaration
     */
    public List<List<DataPointPair<Integer>>> trainC(List<DataPointPair<Integer>> dataPoints, Set<Integer> options) {
        if (this.predicting == null) {
            throw new RuntimeException("Predicting value has not been set");
        }
        this.catAttributes = dataPoints.get(0).getDataPoint().getCategoricalData();
        ImpurityScore origScoreObj = this.getClassGainScore(dataPoints);
        double origScore = origScoreObj.getScore();
        if (origScore == 0.0) {
            this.results = new CategoricalResults[1];
            this.results[0] = new CategoricalResults(this.predicting.getNumOfCategories());
            this.results[0].setProb(dataPoints.get(0).getPair(), 1.0);
            ArrayList<List<DataPointPair<Integer>>> toReturn = new ArrayList<List<DataPointPair<Integer>>>();
            toReturn.add(dataPoints);
            return toReturn;
        }
        ArrayList<List<DataPointPair<Integer>>> bestSplit = null;
        double bestGain = -1.0;
        this.splittingAttribute = -1;
        double[] gainRet = new double[]{Double.NaN};
        for (int attribute : options) {
            void var12_15;
            gainRet[0] = Double.NaN;
            PairedReturn<List<Double>, List<Integer>> tmp = null;
            if (attribute < this.catAttributes.length) {
                List<List<DataPointPair<Integer>>> list = DecisionStump.listOfLists(this.catAttributes[attribute].getNumOfCategories());
                for (DataPointPair<Integer> dpp : dataPoints) {
                    list.get(dpp.getDataPoint().getCategoricalValue(attribute)).add(dpp);
                }
            } else {
                List<List<DataPointPair<Integer>>> list;
                int N = this.predicting.getNumOfCategories();
                tmp = this.createNumericCSplit(dataPoints, N, attribute -= this.catAttributes.length, list = DecisionStump.listOfLists(2), origScoreObj, gainRet);
                if (tmp == null) continue;
                attribute += this.catAttributes.length;
            }
            double d = Double.isNaN(gainRet[0]) ? this.getGain(origScoreObj, (List<List<DataPointPair<Integer>>>)var12_15) : gainRet[0];
            double gain = d;
            if (!(gain > bestGain)) continue;
            bestGain = gain;
            this.splittingAttribute = attribute;
            bestSplit = var12_15;
            if (attribute < this.catAttributes.length) continue;
            this.boundries = tmp.getFirstItem();
            this.owners = tmp.getSecondItem();
        }
        if (bestGain <= 1.0E-9 || this.splittingAttribute == -1) {
            bestSplit = new ArrayList<List<DataPointPair<Integer>>>(1);
            bestSplit.add(dataPoints);
            CategoricalResults badResult = new CategoricalResults(this.predicting.getNumOfCategories());
            for (DataPointPair<Integer> dataPointPair : dataPoints) {
                badResult.incProb(dataPointPair.getPair(), 1.0);
            }
            badResult.normalize();
            this.results = new CategoricalResults[]{badResult};
            return bestSplit;
        }
        if (this.splittingAttribute < this.catAttributes.length || this.removeContinuousAttributes) {
            options.remove(this.splittingAttribute);
        }
        this.results = new CategoricalResults[bestSplit.size()];
        for (int i = 0; i < bestSplit.size(); ++i) {
            this.results[i] = new CategoricalResults(this.predicting.getNumOfCategories());
            for (DataPointPair dataPointPair : (List)bestSplit.get(i)) {
                this.results[i].incProb((Integer)dataPointPair.getPair(), dataPointPair.getDataPoint().getWeight());
            }
            this.results[i].normalize();
        }
        return bestSplit;
    }

    private PairedReturn<List<Double>, List<Integer>> createNumericCSplit(List<DataPointPair<Integer>> dataPoints, int N, int attribute, List<List<DataPointPair<Integer>>> aSplit, ImpurityScore origScore, double[] finalGain) {
        if (this.numericHandlingC == NumericHandlingC.PDF_INTERSECTIONS) {
            while (aSplit.size() < N) {
                aSplit.add(new ArrayList());
            }
            ArrayList<DoubleList> weights = new ArrayList<DoubleList>(N);
            ArrayList<DoubleList> values = new ArrayList<DoubleList>(N);
            for (int i = 0; i < N; ++i) {
                weights.add(new DoubleList());
                values.add(new DoubleList());
            }
            for (DataPointPair<Integer> dpp : dataPoints) {
                int theClass = dpp.getPair();
                double value = dpp.getVector().get(attribute);
                ((List)weights.get(theClass)).add(dpp.getDataPoint().getWeight());
                ((List)values.get(theClass)).add(value);
            }
            ContinuousDistribution[] dist = new ContinuousDistribution[N];
            for (int i = 0; i < N; ++i) {
                if (((List)weights.get(i)).isEmpty()) {
                    dist[i] = null;
                    continue;
                }
                DenseVector theVals = new DenseVector(((List)weights.get(i)).size());
                double[] theWeights = new double[((Vec)theVals).length()];
                for (int j = 0; j < theWeights.length; ++j) {
                    ((Vec)theVals).set(j, (Double)((List)values.get(i)).get(j));
                    theWeights[j] = (Double)((List)weights.get(i)).get(j);
                }
                dist[i] = new KernelDensityEstimator((Vec)theVals, (KernelFunction)EpanechnikovKF.getInstance(), theWeights);
            }
            PairedReturn<List<Double>, List<Integer>> tmp = DecisionStump.intersections(Arrays.asList(dist));
            if (tmp == null) {
                return null;
            }
            List<Double> tmpBoundries = tmp.getFirstItem();
            List<Integer> tmpOwners = tmp.getSecondItem();
            for (DataPointPair<Integer> dpp : dataPoints) {
                int pos = Collections.binarySearch(tmpBoundries, dpp.getVector().get(attribute));
                pos = pos < 0 ? -pos - 1 : pos;
                aSplit.get(tmpOwners.get(pos)).add(dpp);
            }
            return tmp;
        }
        if (this.numericHandlingC == NumericHandlingC.BINARY_BEST_GAIN) {
            int i;
            double[] vals = new double[dataPoints.size()];
            for (int i2 = 0; i2 < dataPoints.size(); ++i2) {
                vals[i2] = dataPoints.get(i2).getVector().get(attribute);
            }
            List<List<?>> paired = Arrays.asList(dataPoints);
            QuickSort.sort(vals, 0, vals.length, paired);
            double bestGain = Double.NEGATIVE_INFINITY;
            double bestSplit = Double.NEGATIVE_INFINITY;
            int splitIndex = -1;
            ImpurityScore rightSide = origScore.clone();
            ImpurityScore leftSide = new ImpurityScore(N, this.gainMethod);
            for (i = 0; i < this.minResultSplitSize; ++i) {
                double weight = dataPoints.get(i).getDataPoint().getWeight();
                int truth = dataPoints.get(i).getPair();
                leftSide.addPoint(weight, truth);
                rightSide.removePoint(weight, truth);
            }
            for (i = this.minResultSplitSize; i < dataPoints.size() - this.minResultSplitSize - 1; ++i) {
                DataPointPair<Integer> dpp = dataPoints.get(i);
                rightSide.removePoint(dpp.getDataPoint(), (int)dpp.getPair());
                leftSide.addPoint(dpp.getDataPoint(), (int)dpp.getPair());
                double leftVal = vals[i];
                double rightVal = vals[i + 1];
                if (rightVal - leftVal < 1.0E-14) continue;
                ImpurityScore[] impurityScoreArray = new ImpurityScore[]{leftSide, rightSide};
                double curGain = ImpurityScore.gain(origScore, impurityScoreArray);
                if (!(curGain >= bestGain)) continue;
                double curSplit = (leftVal + rightVal) / 2.0;
                bestGain = curGain;
                bestSplit = curSplit;
                splitIndex = i + 1;
            }
            if (splitIndex == -1) {
                return null;
            }
            if (finalGain != null) {
                finalGain[0] = bestGain;
            }
            aSplit.set(0, new ArrayList<DataPointPair<Integer>>(dataPoints.subList(0, splitIndex)));
            aSplit.set(1, new ArrayList<DataPointPair<Integer>>(dataPoints.subList(splitIndex, dataPoints.size())));
            PairedReturn<List<Double>, List<Integer>> tmp = new PairedReturn<List<Double>, List<Integer>>(Arrays.asList(bestSplit, Double.POSITIVE_INFINITY), Arrays.asList(0, 1));
            return tmp;
        }
        return null;
    }

    public List<List<DataPointPair<Double>>> trainR(List<DataPointPair<Double>> dataPoints, Set<Integer> options) {
        this.catAttributes = dataPoints.get(0).getDataPoint().getCategoricalData();
        if (dataPoints.size() <= this.minResultSplitSize * 2) {
            this.splittingAttribute = this.catAttributes.length;
            this.regressionResults = new double[1];
            double avg = 0.0;
            double sum = 0.0;
            for (DataPointPair<Double> dpp : dataPoints) {
                double weight = dpp.getDataPoint().getWeight();
                avg += dpp.getPair() * weight;
                sum += weight;
            }
            this.regressionResults[0] = avg / sum;
            ArrayList<List<DataPointPair<Double>>> toRet = new ArrayList<List<DataPointPair<Double>>>(1);
            toRet.add(dataPoints);
            return toRet;
        }
        List<List<DataPointPair<Double>>> bestSplit = null;
        double lowestSplitSqrdError = Double.MAX_VALUE;
        for (int attribute : options) {
            List<List<DataPointPair<Double>>> thisSplit = null;
            double thisSplitSqrdErr = Double.MAX_VALUE;
            double[] thisMeans = null;
            if (attribute < this.catAttributes.length) {
                thisSplit = DecisionStump.listOfListsD(this.catAttributes[attribute].getNumOfCategories());
                OnLineStatistics[] stats = new OnLineStatistics[thisSplit.size()];
                for (int i = 0; i < thisSplit.size(); ++i) {
                    stats[i] = new OnLineStatistics();
                }
                for (DataPointPair<Double> dpp : dataPoints) {
                    int category = dpp.getDataPoint().getCategoricalValue(attribute);
                    thisSplit.get(category).add(dpp);
                    stats[category].add(dpp.getPair(), dpp.getDataPoint().getWeight());
                }
                thisMeans = new double[stats.length];
                thisSplitSqrdErr = 0.0;
                for (int i = 0; i < stats.length; ++i) {
                    thisSplitSqrdErr += stats[i].getVarance() * stats[i].getSumOfWeights();
                    thisMeans[i] = stats[i].getMean();
                }
            } else {
                final int numAttri = attribute - this.catAttributes.length;
                Comparator<DataPointPair<Double>> dppDoubleSorter = new Comparator<DataPointPair<Double>>(){

                    @Override
                    public int compare(DataPointPair<Double> o1, DataPointPair<Double> o2) {
                        return Double.compare(o1.getVector().get(numAttri), o2.getVector().get(numAttri));
                    }
                };
                Collections.sort(dataPoints, dppDoubleSorter);
                OnLineStatistics rightSide = new OnLineStatistics();
                OnLineStatistics leftSide = new OnLineStatistics();
                for (DataPointPair<Double> dpp : dataPoints) {
                    rightSide.add(dpp.getPair(), dpp.getDataPoint().getWeight());
                }
                int bestS = 0;
                thisSplitSqrdErr = Double.POSITIVE_INFINITY;
                thisMeans = new double[3];
                for (int i = 0; i < dataPoints.size(); ++i) {
                    DataPointPair<Double> dpp = dataPoints.get(i);
                    double weight = dpp.getDataPoint().getWeight();
                    double val = dpp.getPair();
                    rightSide.remove(val, weight);
                    leftSide.add(val, weight);
                    if (i < this.minResultSplitSize) continue;
                    if (i > dataPoints.size() - this.minResultSplitSize) break;
                    double tmpSVariance = rightSide.getVarance() * rightSide.getSumOfWeights() + leftSide.getVarance() * leftSide.getSumOfWeights();
                    if (!(tmpSVariance < thisSplitSqrdErr) || Double.isInfinite(tmpSVariance)) continue;
                    thisSplitSqrdErr = tmpSVariance;
                    bestS = i;
                    thisMeans[0] = leftSide.getMean();
                    thisMeans[1] = rightSide.getMean();
                    thisMeans[2] = (dataPoints.get(bestS).getVector().get(numAttri) + dataPoints.get(bestS + 1).getVector().get(numAttri)) / 2.0;
                }
                thisSplit = DecisionStump.listOfListsD(2);
                thisSplit.get(0).addAll(dataPoints.subList(0, bestS + 1));
                thisSplit.get(1).addAll(dataPoints.subList(bestS + 1, dataPoints.size()));
            }
            if (!(thisSplitSqrdErr < lowestSplitSqrdError)) continue;
            lowestSplitSqrdError = thisSplitSqrdErr;
            bestSplit = thisSplit;
            this.splittingAttribute = attribute;
            this.regressionResults = thisMeans;
        }
        if (this.splittingAttribute < this.catAttributes.length || this.removeContinuousAttributes) {
            options.remove(this.splittingAttribute);
        }
        return bestSplit;
    }

    private static List<List<DataPointPair<Integer>>> listOfLists(int n) {
        ArrayList<List<DataPointPair<Integer>>> aSplit = new ArrayList<List<DataPointPair<Integer>>>(n);
        for (int i = 0; i < n; ++i) {
            aSplit.add(new ArrayList());
        }
        return aSplit;
    }

    private static List<List<DataPointPair<Double>>> listOfListsD(int n) {
        ArrayList<List<DataPointPair<Double>>> aSplit = new ArrayList<List<DataPointPair<Double>>>(n);
        for (int i = 0; i < n; ++i) {
            aSplit.add(new ArrayList());
        }
        return aSplit;
    }

    @Override
    public boolean supportsWeightedData() {
        return true;
    }

    private ImpurityScore getClassGainScore(List<DataPointPair<Integer>> dataPoints) {
        ImpurityScore cgs = new ImpurityScore(this.predicting.getNumOfCategories(), this.gainMethod);
        for (DataPointPair<Integer> dpp : dataPoints) {
            cgs.addPoint(dpp.getDataPoint(), (int)dpp.getPair());
        }
        return cgs;
    }

    @Override
    public DecisionStump clone() {
        DecisionStump copy = new DecisionStump();
        if (this.catAttributes != null) {
            copy.catAttributes = CategoricalData.copyOf(this.catAttributes);
        }
        if (this.results != null) {
            copy.results = new CategoricalResults[this.results.length];
            for (int i = 0; i < this.results.length; ++i) {
                copy.results[i] = this.results[i].clone();
            }
        }
        copy.removeContinuousAttributes = this.removeContinuousAttributes;
        copy.splittingAttribute = this.splittingAttribute;
        if (this.boundries != null) {
            copy.boundries = new DoubleList(this.boundries);
        }
        if (this.owners != null) {
            copy.owners = new IntList(this.owners);
        }
        if (this.predicting != null) {
            copy.predicting = this.predicting.clone();
        }
        if (this.regressionResults != null) {
            copy.regressionResults = Arrays.copyOf(this.regressionResults, this.regressionResults.length);
        }
        copy.minResultSplitSize = this.minResultSplitSize;
        copy.numericHandlingC = this.numericHandlingC;
        copy.gainMethod = this.gainMethod;
        return copy;
    }

    @Override
    public List<Parameter> getParameters() {
        return Parameter.getParamsFromMethods(this);
    }

    @Override
    public Parameter getParameter(String paramName) {
        return Parameter.toParameterMap(this.getParameters()).get(paramName);
    }

    public static enum NumericHandlingC {
        PDF_INTERSECTIONS,
        BINARY_BEST_GAIN;

    }
}

