/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.svm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jsat.distributions.kernels.KernelTrick;
import jsat.distributions.kernels.LinearKernel;
import jsat.linear.Vec;
import jsat.parameters.Parameter;
import jsat.utils.DoubleList;
import jsat.utils.ListUtils;

public abstract class SupportVectorLearner {
    @Parameter.ParameterHolder
    private KernelTrick kernel;
    protected List<Vec> vecs;
    protected double[] alphas;
    private CacheMode cacheMode;
    protected List<Double> accelCache = null;
    private double[][] fullCache;
    private LinkedHashMap<Integer, double[]> partialCache;
    private double[] availableRow;
    private int cacheConst = 500;
    protected int evalCount = 0;
    protected int cacheEvictions = 0;

    protected void setAlphas(double[] alphas) {
        this.alphas = alphas;
        this.accelCache = this.kernel.getAccelerationCache(this.vecs);
    }

    protected SupportVectorLearner() {
        this(new LinearKernel(), CacheMode.NONE);
    }

    public SupportVectorLearner(KernelTrick kernel, CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        this.setKernel(kernel);
    }

    public SupportVectorLearner(SupportVectorLearner toCopy) {
        if (toCopy.kernel != null) {
            this.kernel = toCopy.kernel.clone();
        }
        if (toCopy.vecs != null) {
            this.vecs = new ArrayList<Vec>(toCopy.vecs.size());
            for (Vec v : toCopy.vecs) {
                this.vecs.add(v.clone());
            }
        }
        if (toCopy.alphas != null) {
            this.alphas = Arrays.copyOf(toCopy.alphas, toCopy.alphas.length);
        }
        this.cacheMode = toCopy.cacheMode;
        if (toCopy.accelCache != null) {
            this.accelCache = new DoubleList(toCopy.accelCache);
        }
        if (toCopy.fullCache != null) {
            this.fullCache = new double[toCopy.fullCache.length][];
            for (int i = 0; i < toCopy.fullCache.length; ++i) {
                this.fullCache[i] = Arrays.copyOf(toCopy.fullCache[i], toCopy.fullCache[i].length);
            }
        }
        if (toCopy.partialCache != null) {
            this.setCacheMode(this.cacheMode);
        }
        this.cacheConst = toCopy.cacheConst;
    }

    public void setKernel(KernelTrick kernel) {
        this.kernel = kernel;
    }

    public void setCacheValue(int cacheValue) {
        this.cacheConst = cacheValue;
    }

    public void setCacheSize(long N, long bytes) {
        int DS = 8;
        if ((bytes /= (long)DS) > N * N / 2L) {
            this.setCacheMode(CacheMode.FULL);
        } else {
            long bytesPerRow = N * (long)DS + 24L;
            this.setCacheValue((int)Math.min(Math.max(1L, bytes / bytesPerRow), Integer.MAX_VALUE));
        }
    }

    public int getCacheValue() {
        return this.cacheConst;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        int N;
        if (cacheMode == null) {
            this.fullCache = null;
            this.partialCache = null;
            this.availableRow = null;
            this.accelCache = null;
            return;
        }
        this.cacheMode = cacheMode;
        if (this.vecs != null) {
            this.accelCache = this.kernel.getAccelerationCache(this.vecs);
        }
        this.evalCount = 0;
        this.cacheEvictions = 0;
        int n = N = this.vecs == null ? 0 : this.vecs.size();
        if (cacheMode == CacheMode.FULL && this.vecs != null) {
            int i;
            this.fullCache = new double[N][];
            for (i = 0; i < N; ++i) {
                this.fullCache[i] = new double[N - i];
            }
            for (i = 0; i < N; ++i) {
                for (int j = i; j < N; ++j) {
                    this.fullCache[i][j - i] = this.k(i, j);
                }
            }
        } else if (cacheMode == CacheMode.ROWS && this.vecs != null) {
            this.partialCache = new LinkedHashMap<Integer, double[]>(N, 0.75f, true){
                private static final long serialVersionUID = 1553368345126287610L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<Integer, double[]> eldest) {
                    boolean removeEldest;
                    boolean bl = removeEldest = this.size() > SupportVectorLearner.this.cacheConst;
                    if (removeEldest) {
                        SupportVectorLearner.access$102(SupportVectorLearner.this, eldest.getValue());
                        for (int i = 0; i < SupportVectorLearner.this.availableRow.length; ++i) {
                            if (Double.isNaN(SupportVectorLearner.this.availableRow[i])) continue;
                            ((SupportVectorLearner)SupportVectorLearner.this).availableRow[i] = Double.NaN;
                        }
                        ++SupportVectorLearner.this.cacheEvictions;
                    }
                    return removeEldest;
                }
            };
        } else if (cacheMode == CacheMode.NONE) {
            this.fullCache = null;
        }
    }

    public KernelTrick getKernel() {
        return this.kernel;
    }

    protected double kEvalSum(Vec y) {
        if (this.alphas == null) {
            throw new RuntimeException("alphas have not been set");
        }
        return this.kernel.evalSum(this.vecs, this.accelCache, this.alphas, y, 0, this.alphas.length);
    }

    protected double kEval(Vec a, Vec b) {
        return this.kernel.eval(a, b);
    }

    protected double kEval(int a, int b) {
        if (this.cacheMode == CacheMode.FULL) {
            if (a > b) {
                int tmp = a;
                a = b;
                b = tmp;
            }
            return this.fullCache[a][b - a];
        }
        if (this.cacheMode == CacheMode.ROWS) {
            double[] b_cache;
            double[] cache = this.partialCache.get(a);
            if (cache == null && (b_cache = this.partialCache.get(b)) != null) {
                if (Double.isNaN(b_cache[a])) {
                    b_cache[a] = this.k(a, b);
                    return b_cache[a];
                }
                return b_cache[a];
            }
            if (cache == null) {
                if (this.availableRow != null) {
                    cache = this.availableRow;
                    this.availableRow = null;
                } else {
                    cache = new double[this.vecs.size()];
                    Arrays.fill(cache, Double.NaN);
                }
                this.partialCache.put(a, cache);
                if (Double.isNaN(cache[a])) {
                    cache[a] = this.k(a, b);
                    return cache[a];
                }
                return cache[a];
            }
        }
        return this.k(a, b);
    }

    private double k(int a, int b) {
        ++this.evalCount;
        return this.kernel.eval(a, b, this.vecs, this.accelCache);
    }

    protected void sparsify() {
        int N = this.vecs.size();
        int accSize = this.accelCache == null ? 0 : this.accelCache.size() / N;
        int svCount = 0;
        for (int i = 0; i < N; ++i) {
            if (this.alphas[i] == 0.0) continue;
            ListUtils.swap(this.vecs, svCount, i);
            if (this.accelCache != null) {
                for (int j = i * accSize; j < (i + 1) * accSize; ++j) {
                    ListUtils.swap(this.accelCache, svCount * accSize + j - i * accSize, j);
                }
            }
            this.alphas[svCount++] = this.alphas[i];
        }
        this.vecs = new ArrayList<Vec>(this.vecs.subList(0, svCount));
        this.alphas = Arrays.copyOfRange(this.alphas, 0, svCount);
    }

    static /* synthetic */ double[] access$102(SupportVectorLearner x0, double[] x1) {
        x0.availableRow = x1;
        return x1;
    }

    public static enum CacheMode {
        NONE,
        FULL,
        ROWS;

    }
}

