/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.boosting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.classifiers.DataPointPair;
import jsat.classifiers.calibration.BinaryScoreClassifier;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;
import jsat.utils.DoubleList;
import jsat.utils.FakeExecutor;

public class ModestAdaBoost
implements Classifier,
Parameterized,
BinaryScoreClassifier {
    private static final long serialVersionUID = 8223388561185098909L;
    private Classifier weakLearner;
    private int maxIterations;
    protected List<Classifier> hypoths;
    protected List<Double> hypWeights;
    protected CategoricalData predicting;

    public ModestAdaBoost(Classifier weakLearner, int maxIterations) {
        this.setWeakLearner(weakLearner);
        this.setMaxIterations(maxIterations);
    }

    protected ModestAdaBoost(ModestAdaBoost toClone) {
        this(toClone.weakLearner.clone(), toClone.maxIterations);
        if (toClone.hypWeights != null) {
            this.hypWeights = new DoubleList(toClone.hypWeights);
            this.hypoths = new ArrayList<Classifier>(toClone.maxIterations);
            for (Classifier weak : toClone.hypoths) {
                this.hypoths.add(weak.clone());
            }
            this.predicting = toClone.predicting.clone();
        }
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        if (maxIterations < 1) {
            throw new IllegalArgumentException("Iterations must be positive, not " + maxIterations);
        }
        this.maxIterations = maxIterations;
    }

    public Classifier getWeakLearner() {
        return this.weakLearner;
    }

    public void setWeakLearner(Classifier weakLearner) {
        if (!weakLearner.supportsWeightedData()) {
            throw new IllegalArgumentException("WeakLearner must support weighted data to be boosted");
        }
        this.weakLearner = weakLearner;
    }

    @Override
    public double getScore(DataPoint dp) {
        double score = 0.0;
        for (int i = 0; i < this.hypoths.size(); ++i) {
            score += (this.hypoths.get(i).classify(dp).getProb(1) * 2.0 - 1.0) * this.hypWeights.get(i);
        }
        return score;
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        if (this.predicting == null) {
            throw new RuntimeException("Classifier has not been trained yet");
        }
        CategoricalResults cr = new CategoricalResults(this.predicting.getNumOfCategories());
        double score = this.getScore(data);
        if (score < 0.0) {
            cr.setProb(0, 1.0);
        } else {
            cr.setProb(1, 1.0);
        }
        return cr;
    }

    @Override
    public void trainC(ClassificationDataSet dataSet, ExecutorService threadPool) {
        this.predicting = dataSet.getPredicting();
        this.hypWeights = new DoubleList(this.maxIterations);
        this.hypoths = new ArrayList<Classifier>(this.maxIterations);
        int N = dataSet.getSampleSize();
        double[] D_inv = new double[N];
        double[] D = new double[N];
        List<DataPointPair<Integer>> dataPoints = dataSet.getTwiceShallowClone().getAsDPPList();
        Arrays.fill(D, 1.0 / (double)N);
        for (DataPointPair<Integer> dpp : dataPoints) {
            dpp.getDataPoint().setWeight(D[0]);
        }
        double weightSum = 1.0;
        double[] H_cur = new double[N];
        for (int t = 0; t < this.maxIterations; ++t) {
            DataPoint dp;
            int i;
            int i2;
            Classifier weak = this.weakLearner.clone();
            if (threadPool == null || threadPool instanceof FakeExecutor) {
                weak.trainC(new ClassificationDataSet(dataPoints, this.predicting));
            } else {
                weak.trainC(new ClassificationDataSet(dataPoints, this.predicting), threadPool);
            }
            double invSum = 0.0;
            for (i2 = 0; i2 < N; ++i2) {
                D_inv[i2] = 1.0 - D[i2];
                invSum += D_inv[i2];
            }
            i2 = 0;
            while (i2 < N) {
                int n = i2++;
                D_inv[n] = D_inv[n] / invSum;
            }
            double p_d = 0.0;
            double p_id = 0.0;
            double n_d = 0.0;
            double n_id = 0.0;
            for (int i3 = 0; i3 < N; ++i3) {
                DataPointPair<Integer> dpp = dataPoints.get(i3);
                H_cur[i3] = weak.classify(dpp.getDataPoint()).getProb(1) * 2.0 - 1.0;
                double outPut = Math.signum(H_cur[i3]);
                int c = dpp.getPair();
                if (c == 1) {
                    p_d += outPut * D[i3];
                    p_id += outPut * D_inv[i3];
                    continue;
                }
                n_d += outPut * D[i3];
                n_id += outPut * D_inv[i3];
            }
            double alpha_m = p_d * (1.0 - p_id) - n_d * (1.0 - n_id);
            if (Math.signum(alpha_m) != Math.signum(p_d - n_d) || Math.abs(p_d - n_d) < 1.0E-6 || alpha_m <= 0.0) {
                return;
            }
            weightSum = 0.0;
            for (i = 0; i < N; ++i) {
                dp = dataPoints.get(i).getDataPoint();
                double w_i = dp.getWeight();
                int y_i = dataPoints.get(i).getPair() * 2 - 1;
                if (Double.isInfinite(w_i *= Math.exp((double)(-y_i) * alpha_m * H_cur[i]))) {
                    w_i = 1.0;
                } else if (w_i <= 0.0) {
                    w_i = 0.001 / (double)N;
                }
                weightSum += w_i;
                dp.setWeight(w_i);
            }
            for (i = 0; i < N; ++i) {
                dp = dataPoints.get(i).getDataPoint();
                double w_i = dp.getWeight();
                dp.setWeight(Math.max(w_i / weightSum, 1.0E-10));
            }
            this.hypWeights.add(alpha_m);
            this.hypoths.add(weak);
        }
    }

    @Override
    public void trainC(ClassificationDataSet dataSet) {
        this.trainC(dataSet, null);
    }

    @Override
    public boolean supportsWeightedData() {
        return false;
    }

    @Override
    public ModestAdaBoost clone() {
        return new ModestAdaBoost(this);
    }

    @Override
    public List<Parameter> getParameters() {
        return Parameter.getParamsFromMethods(this);
    }

    @Override
    public Parameter getParameter(String paramName) {
        return Parameter.toParameterMap(this.getParameters()).get(paramName);
    }
}

