/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.bayesian;

import java.util.Arrays;
import jsat.classifiers.BaseUpdateableClassifier;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.DataPoint;
import jsat.exceptions.FailedToFitException;

public class ODE
extends BaseUpdateableClassifier {
    private static final long serialVersionUID = -7732070257669428977L;
    protected int dependent;
    protected int predTargets;
    protected int depTargets;
    protected double[][][][] counts;
    protected double[][] priors;
    protected double priorSum;

    public ODE(int dependent) {
        this.dependent = dependent;
    }

    protected ODE(ODE toClone) {
        this(toClone.dependent);
        this.predTargets = toClone.predTargets;
        this.depTargets = toClone.depTargets;
        if (toClone.counts != null) {
            int i;
            this.counts = new double[toClone.counts.length][][][];
            for (i = 0; i < this.counts.length; ++i) {
                this.counts[i] = new double[i][][];
                for (int j = 0; j < this.counts[i].length; ++j) {
                    this.counts[i][j] = new double[toClone.counts[i][j].length][];
                    for (int z = 0; z < this.counts[i][j].length; ++z) {
                        this.counts[i][j][z] = Arrays.copyOf(toClone.counts[i][j][z], toClone.counts[i][j][z].length);
                    }
                }
            }
            this.priors = new double[toClone.priors.length][];
            for (i = 0; i < this.priors.length; ++i) {
                this.priors[i] = Arrays.copyOf(toClone.priors[i], toClone.priors[i].length);
            }
            this.priorSum = toClone.priorSum;
        }
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        CategoricalResults cr = new CategoricalResults(this.predTargets);
        int[] catVals = data.getCategoricalValues();
        for (int c = 0; c < this.predTargets; ++c) {
            double logProb = this.getLogPrb(catVals, c);
            cr.setProb(c, Math.exp(logProb));
        }
        cr.normalize();
        return cr;
    }

    @Override
    public boolean supportsWeightedData() {
        return true;
    }

    @Override
    public ODE clone() {
        return new ODE(this);
    }

    @Override
    public void setUp(CategoricalData[] categoricalAttributes, int numericAttributes, CategoricalData predicting) {
        int i;
        if (categoricalAttributes.length < 1) {
            throw new FailedToFitException("At least 2 categorical varaibles are needed for ODE");
        }
        CategoricalData[] catData = categoricalAttributes;
        this.predTargets = predicting.getNumOfCategories();
        this.depTargets = catData[this.dependent].getNumOfCategories();
        this.counts = new double[this.predTargets][this.depTargets][catData.length][];
        for (i = 0; i < this.counts.length; ++i) {
            for (int j = 0; j < this.counts[i].length; ++j) {
                for (int z = 0; z < this.counts[i][j].length; ++z) {
                    this.counts[i][j][z] = new double[catData[z].getNumOfCategories()];
                    Arrays.fill(this.counts[i][j][z], 1.0);
                }
            }
        }
        this.priors = new double[this.predTargets][this.depTargets];
        for (i = 0; i < this.priors.length; ++i) {
            Arrays.fill(this.priors[i], 1.0);
            this.priorSum += (double)this.priors[i].length;
        }
    }

    @Override
    public void update(DataPoint dataPoint, int targetClass) {
        int[] catVals = dataPoint.getCategoricalValues();
        double weight = dataPoint.getWeight();
        for (int j = 0; j < catVals.length; ++j) {
            if (j == this.dependent) continue;
            double[] dArray = this.counts[targetClass][catVals[this.dependent]][j];
            int n = catVals[j];
            dArray[n] = dArray[n] + weight;
        }
        double[] dArray = this.priors[targetClass];
        int n = catVals[this.dependent];
        dArray[n] = dArray[n] + weight;
        this.priorSum += weight;
    }

    protected double getLogPrb(int[] catVals, int c) {
        double logProb = 0.0;
        int xi = catVals[this.dependent];
        for (int j = 0; j < catVals.length; ++j) {
            if (j == this.dependent) continue;
            double sum = 0.0;
            for (int z = 0; z < this.counts[c][xi][j].length; ++z) {
                sum += this.counts[c][xi][j][z];
            }
            logProb += Math.log(this.counts[c][xi][j][catVals[j]] / sum);
        }
        return logProb + Math.log(this.priors[c][xi] / this.priorSum);
    }
}

