/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;
import jsat.utils.FakeExecutor;

public class OneVSOne
implements Classifier,
Parameterized {
    private static final long serialVersionUID = 733202830281869416L;
    @Parameter.ParameterHolder
    protected Classifier baseClassifier;
    protected Classifier[][] oneVone;
    private boolean concurrentTrain;
    protected CategoricalData predicting;

    public OneVSOne(Classifier baseClassifier) {
        this(baseClassifier, false);
    }

    public OneVSOne(Classifier baseClassifier, boolean concurrentTrain) {
        this.baseClassifier = baseClassifier;
        this.concurrentTrain = concurrentTrain;
    }

    public void setConcurrentTraining(boolean concurrentTrain) {
        this.concurrentTrain = concurrentTrain;
    }

    public boolean isConcurrentTraining() {
        return this.concurrentTrain;
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        CategoricalResults cr = new CategoricalResults(this.predicting.getNumOfCategories());
        for (int i = 0; i < this.oneVone.length; ++i) {
            for (int j = 0; j < this.oneVone[i].length; ++j) {
                CategoricalResults subRes = this.oneVone[i][j].classify(data);
                int mostLikely = subRes.mostLikely();
                if (mostLikely == 0) {
                    cr.incProb(i, 1.0);
                    continue;
                }
                cr.incProb(i + j + 1, 1.0);
            }
        }
        cr.normalize();
        return cr;
    }

    @Override
    public void trainC(ClassificationDataSet dataSet, ExecutorService threadPool) {
        this.oneVone = new Classifier[dataSet.getClassSize()][];
        ArrayList<List<DataPoint>> dataByCategory = new ArrayList<List<DataPoint>>(dataSet.getClassSize());
        for (int i = 0; i < dataSet.getClassSize(); ++i) {
            dataByCategory.add(dataSet.getSamples(i));
        }
        final CountDownLatch latch = new CountDownLatch(this.oneVone.length * (this.oneVone.length - 1) / 2);
        for (int i = 0; i < this.oneVone.length; ++i) {
            this.oneVone[i] = new Classifier[this.oneVone.length - i - 1];
            for (int j = 0; j < this.oneVone.length - i - 1; ++j) {
                Classifier curClassifier;
                this.oneVone[i][j] = curClassifier = this.baseClassifier.clone();
                int otherClass = j + i + 1;
                CategoricalData subPred = new CategoricalData(2);
                subPred.setOptionName(dataSet.getPredicting().getOptionName(i), 0);
                subPred.setOptionName(dataSet.getPredicting().getOptionName(otherClass), 1);
                final ClassificationDataSet subDataSet = new ClassificationDataSet(dataSet.getNumNumericalVars(), dataSet.getCategories(), subPred);
                for (DataPoint dp : (List)dataByCategory.get(i)) {
                    subDataSet.addDataPoint(dp.getNumericalValues(), dp.getCategoricalValues(), 0);
                }
                for (DataPoint dp : (List)dataByCategory.get(otherClass)) {
                    subDataSet.addDataPoint(dp.getNumericalValues(), dp.getCategoricalValues(), 1);
                }
                if (!this.concurrentTrain) {
                    if (threadPool != null && !(threadPool instanceof FakeExecutor)) {
                        curClassifier.trainC(subDataSet, threadPool);
                        continue;
                    }
                    curClassifier.trainC(subDataSet);
                    continue;
                }
                threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        curClassifier.trainC(subDataSet);
                        latch.countDown();
                    }
                });
            }
        }
        if (this.concurrentTrain) {
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(OneVSOne.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.predicting = dataSet.getPredicting();
    }

    @Override
    public void trainC(ClassificationDataSet dataSet) {
        this.trainC(dataSet, new FakeExecutor());
    }

    @Override
    public boolean supportsWeightedData() {
        return this.baseClassifier.supportsWeightedData();
    }

    @Override
    public OneVSOne clone() {
        OneVSOne clone = new OneVSOne(this.baseClassifier.clone(), this.concurrentTrain);
        if (this.oneVone != null) {
            clone.oneVone = new Classifier[this.oneVone.length][];
            for (int i = 0; i < this.oneVone.length; ++i) {
                clone.oneVone[i] = new Classifier[this.oneVone[i].length];
                for (int j = 0; j < this.oneVone[i].length; ++j) {
                    clone.oneVone[i][j] = this.oneVone[i][j].clone();
                }
            }
        }
        if (this.predicting != null) {
            clone.predicting = this.predicting.clone();
        }
        return clone;
    }

    @Override
    public List<Parameter> getParameters() {
        return Parameter.getParamsFromMethods(this);
    }

    @Override
    public Parameter getParameter(String paramName) {
        return Parameter.toParameterMap(this.getParameters()).get(paramName);
    }
}

