/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers;

import java.io.Serializable;
import java.util.Arrays;
import jsat.classifiers.CategoricalData;
import jsat.linear.Vec;

public class DataPoint
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1363327591317639955L;
    private double weight;
    protected Vec numericalValues;
    protected int[] categoricalValues;
    protected CategoricalData[] categoricalData;
    private static final int[] emptyInt = new int[0];
    private static final CategoricalData[] emptyData = new CategoricalData[0];

    public DataPoint(Vec numericalValues, int[] categoricalValues, CategoricalData[] categoricalData) {
        this(numericalValues, categoricalValues, categoricalData, 1.0);
    }

    public DataPoint(Vec numericalValues, int[] categoricalValues, CategoricalData[] categoricalData, double weight) {
        this.numericalValues = numericalValues;
        this.categoricalValues = categoricalValues;
        this.categoricalData = categoricalData;
        this.weight = weight;
    }

    public DataPoint(Vec numericalValues, double weight) {
        this(numericalValues, emptyInt, emptyData, weight);
    }

    public DataPoint(Vec numericalValues) {
        this(numericalValues, emptyInt, emptyData);
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        if (Double.isNaN(weight) || Double.isInfinite(weight) || weight <= 0.0) {
            throw new ArithmeticException("Invalid weight assignment of  " + weight);
        }
        this.weight = weight;
    }

    public boolean containsCategoricalData() {
        return this.categoricalValues.length > 0;
    }

    public Vec getNumericalValues() {
        return this.numericalValues;
    }

    public boolean containsNumericalData() {
        return this.numericalValues != null && this.numericalValues.length() > 0;
    }

    public int numNumericalValues() {
        return this.numericalValues == null ? 0 : this.numericalValues.length();
    }

    public int[] getCategoricalValues() {
        return this.categoricalValues;
    }

    public int numCategoricalValues() {
        return this.categoricalValues.length;
    }

    public int getCategoricalValue(int i) {
        return this.categoricalValues[i];
    }

    public CategoricalData[] getCategoricalData() {
        return this.categoricalData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.containsNumericalData()) {
            sb.append("Numerical: ");
            sb.append(this.numericalValues.toString());
        }
        if (this.containsCategoricalData()) {
            sb.append(" Categorical: ");
            for (int i = 0; i < this.categoricalValues.length; ++i) {
                sb.append(this.categoricalData[i].getOptionName(this.categoricalValues[i]));
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public DataPoint clone() {
        return new DataPoint(this.numericalValues.clone(), Arrays.copyOf(this.categoricalValues, this.categoricalValues.length), CategoricalData.copyOf(this.categoricalData), this.weight);
    }
}

