/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import jsat.DataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;
import jsat.classifiers.DataPointPair;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.utils.IntList;
import jsat.utils.ListUtils;

public class ClassificationDataSet
extends DataSet<ClassificationDataSet> {
    protected CategoricalData predicting;
    protected List<DataPoint> datapoints;
    protected IntList category;
    private static final int[] emptyInt = new int[0];

    public ClassificationDataSet(DataSet dataSet, int predicting) {
        this(dataSet.getDataPoints(), predicting);
        if (this.numericalVariableNames == null) {
            this.numericalVariableNames = new ArrayList();
            String s = "";
            for (int i = 0; i < this.getNumNumericalVars(); ++i) {
                this.numericalVariableNames.add(s);
            }
        }
        for (int i = 0; i < this.getNumNumericalVars(); ++i) {
            this.numericalVariableNames.set(i, dataSet.getNumericName(i));
        }
    }

    public ClassificationDataSet(List<DataPoint> data, int predicting) {
        DataPoint tmp = data.get(0);
        this.categories = new CategoricalData[tmp.numCategoricalValues() - 1];
        for (int i = 0; i < this.categories.length; ++i) {
            this.categories[i] = i >= predicting ? tmp.getCategoricalData()[i + 1] : tmp.getCategoricalData()[i];
        }
        this.numNumerVals = tmp.numNumericalValues();
        this.predicting = tmp.getCategoricalData()[predicting];
        this.datapoints = new ArrayList<DataPoint>(data.size());
        this.category = new IntList(data.size());
        for (DataPoint dp : data) {
            int[] newCats = new int[dp.numCategoricalValues() - 1];
            int[] prevCats = dp.getCategoricalValues();
            int k = 0;
            for (int i = 0; i < prevCats.length; ++i) {
                if (i == predicting) continue;
                newCats[k++] = prevCats[i];
            }
            DataPoint newPoint = new DataPoint(dp.getNumericalValues(), newCats, this.categories);
            this.datapoints.add(newPoint);
            this.category.add(prevCats[predicting]);
        }
        this.generateGenericNumericNames();
    }

    public ClassificationDataSet(List<DataPointPair<Integer>> data, CategoricalData predicting) {
        this.predicting = predicting;
        this.numNumerVals = data.get(0).getVector().length();
        this.categories = CategoricalData.copyOf(data.get(0).getDataPoint().getCategoricalData());
        this.datapoints = new ArrayList<DataPoint>(data.size());
        this.category = new IntList(data.size());
        for (DataPointPair<Integer> dpp : data) {
            this.datapoints.add(dpp.getDataPoint());
            this.category.add(dpp.getPair());
        }
        this.generateGenericNumericNames();
    }

    public ClassificationDataSet(int numerical, CategoricalData[] categories, CategoricalData predicting) {
        this.predicting = predicting;
        this.categories = categories;
        this.numNumerVals = numerical;
        this.datapoints = new ArrayList<DataPoint>();
        this.category = new IntList();
        this.generateGenericNumericNames();
    }

    private void generateGenericNumericNames() {
        if (this.getNumNumericalVars() > 100) {
            return;
        }
        this.numericalVariableNames = new ArrayList(this.getNumNumericalVars());
        for (int i = 0; i < this.getNumNumericalVars(); ++i) {
            this.numericalVariableNames.add("Numeric Input " + (i + 1));
        }
    }

    public int getClassSize() {
        return this.predicting.getNumOfCategories();
    }

    public static ClassificationDataSet comineAllBut(List<ClassificationDataSet> list, int exception) {
        int numer = list.get(exception).getNumNumericalVars();
        CategoricalData[] categories = list.get(exception).getCategories();
        CategoricalData predicting = list.get(exception).getPredicting();
        ClassificationDataSet cds = new ClassificationDataSet(numer, categories, predicting);
        for (int i = 0; i < list.size(); ++i) {
            if (i == exception) continue;
            cds.datapoints.addAll(list.get((int)i).datapoints);
            cds.category.addAll(list.get((int)i).category);
        }
        return cds;
    }

    @Override
    public DataPoint getDataPoint(int i) {
        return this.getDataPointPair(i).getDataPoint();
    }

    public DataPointPair<Integer> getDataPointPair(int i) {
        if (i >= this.getSampleSize()) {
            throw new IndexOutOfBoundsException("There are not that many samples in the data set");
        }
        return new DataPointPair<Integer>(this.datapoints.get(i), this.category.get(i));
    }

    @Override
    public void setDataPoint(int i, DataPoint dp) {
        if (i >= this.getSampleSize()) {
            throw new IndexOutOfBoundsException("There are not that many samples in the data set");
        }
        this.datapoints.set(i, dp);
        this.columnVecCache.clear();
    }

    public int getDataPointCategory(int i) {
        if (i >= this.getSampleSize()) {
            throw new IndexOutOfBoundsException("There are not that many samples in the data set: " + i);
        }
        if (i < 0) {
            throw new IndexOutOfBoundsException("Can not specify negative index " + i);
        }
        return this.category.get(i);
    }

    @Override
    protected ClassificationDataSet getSubset(List<Integer> indicies) {
        ClassificationDataSet newData = new ClassificationDataSet(this.numNumerVals, this.categories, this.predicting);
        for (int i : indicies) {
            newData.addDataPoint(this.getDataPoint(i), this.getDataPointCategory(i));
        }
        return newData;
    }

    public List<ClassificationDataSet> stratSet(int folds, Random rnd) {
        ArrayList<ClassificationDataSet> cvList = new ArrayList<ClassificationDataSet>();
        IntList rndOrder = new IntList();
        int curFold = 0;
        for (int c = 0; c < this.getClassSize(); ++c) {
            List<DataPoint> subPoints = this.getSamples(c);
            rndOrder.clear();
            ListUtils.addRange(rndOrder, 0, subPoints.size(), 1);
            Collections.shuffle(rndOrder, rnd);
            Iterator i$ = rndOrder.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                cvList.get((int)curFold).datapoints.add(subPoints.get(i));
                cvList.get((int)curFold).category.add(c);
                curFold = (curFold + 1) % folds;
            }
        }
        return cvList;
    }

    public void addDataPoint(Vec v, int[] classes, int classification) {
        this.addDataPoint(v, classes, classification, 1.0);
    }

    public void addDataPoint(Vec v, int classification) {
        this.addDataPoint(v, emptyInt, classification, 1.0);
    }

    public void addDataPoint(Vec v, int classification, double weight) {
        this.addDataPoint(v, emptyInt, classification, weight);
    }

    public void addDataPoint(Vec v, int[] classes, int classification, double weight) {
        if (v.length() != this.numNumerVals) {
            throw new RuntimeException("Data point does not contain enough numerical data points");
        }
        if (classes.length != this.categories.length) {
            throw new RuntimeException("Data point does not contain enough categorical data points");
        }
        for (int i = 0; i < classes.length; ++i) {
            if (this.categories[i].isValidCategory(classes[i])) continue;
            throw new IllegalArgumentException("Categoriy value given is invalid");
        }
        this.datapoints.add(new DataPoint(v, classes, this.categories, weight));
        this.category.add(classification);
        this.columnVecCache.clear();
    }

    public void addDataPoint(DataPoint dp, int classification) {
        if (dp.getNumericalValues().length() != this.numNumerVals) {
            throw new RuntimeException("Data point does not contain enough numerical data points");
        }
        if (dp.getCategoricalValues().length != this.categories.length) {
            throw new RuntimeException("Data point does not contain enough categorical data points");
        }
        for (int i = 0; i < dp.getCategoricalValues().length; ++i) {
            if (this.categories[i].isValidCategory(dp.getCategoricalValues()[i])) continue;
            throw new RuntimeException("Categoriy value given is invalid");
        }
        this.datapoints.add(dp);
        this.category.add(classification);
        this.columnVecCache.clear();
    }

    public List<DataPoint> getSamples(int category) {
        ArrayList<DataPoint> subSet = new ArrayList<DataPoint>();
        for (int i = 0; i < this.category.size(); ++i) {
            if (this.category.getI(i) != category) continue;
            subSet.add(this.datapoints.get(i));
        }
        return subSet;
    }

    public Vec getSampleVariableVector(int category, int n) {
        List<DataPoint> categoryList = this.getSamples(category);
        DenseVector vec = new DenseVector(categoryList.size());
        for (int i = 0; i < vec.length(); ++i) {
            vec.set(i, categoryList.get(i).getNumericalValues().get(n));
        }
        return vec;
    }

    public CategoricalData getPredicting() {
        return this.predicting;
    }

    public List<DataPointPair<Integer>> getAsDPPList() {
        ArrayList<DataPointPair<Integer>> dataPoints = new ArrayList<DataPointPair<Integer>>(this.getSampleSize());
        for (int i = 0; i < this.getSampleSize(); ++i) {
            dataPoints.add(new DataPointPair<Integer>(this.datapoints.get(i), this.category.get(i)));
        }
        return dataPoints;
    }

    public List<DataPointPair<Double>> getAsFloatDPPList() {
        ArrayList<DataPointPair<Double>> dataPoints = new ArrayList<DataPointPair<Double>>(this.getSampleSize());
        for (int i = 0; i < this.getSampleSize(); ++i) {
            dataPoints.add(new DataPointPair<Double>(this.datapoints.get(i), Double.valueOf(this.category.getI(i))));
        }
        return dataPoints;
    }

    public double[] getPriors() {
        int i;
        double[] priors = new double[this.getClassSize()];
        double sum = 0.0;
        for (i = 0; i < this.getSampleSize(); ++i) {
            double w = this.datapoints.get(i).getWeight();
            int n = this.category.getI(i);
            priors[n] = priors[n] + w;
            sum += w;
        }
        i = 0;
        while (i < priors.length) {
            int n = i++;
            priors[n] = priors[n] / sum;
        }
        return priors;
    }

    public int classSampleCount(int targetClass) {
        int count = 0;
        Iterator i$ = this.category.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            if (i != targetClass) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getSampleSize() {
        return this.datapoints.size();
    }

    @Override
    public ClassificationDataSet shallowClone() {
        ClassificationDataSet clone = new ClassificationDataSet(this.numNumerVals, this.categories, this.predicting.clone());
        clone.datapoints.addAll(this.datapoints);
        clone.category.addAll(this.category);
        clone.columnVecCache.putAll(this.columnVecCache);
        return clone;
    }

    @Override
    public ClassificationDataSet getTwiceShallowClone() {
        return (ClassificationDataSet)super.getTwiceShallowClone();
    }
}

