/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers;

import java.util.Arrays;
import jsat.linear.DenseVector;
import jsat.linear.Vec;

public class CategoricalResults
implements Cloneable {
    private int n;
    private double[] probabilities;

    public CategoricalResults(int numCategories) {
        this.n = numCategories;
        this.probabilities = new double[numCategories];
    }

    public CategoricalResults(double[] probabilities) {
        this.probabilities = probabilities;
        this.n = probabilities.length;
    }

    public int size() {
        return this.probabilities.length;
    }

    public void setProb(int cat, double prob) {
        if (cat > this.probabilities.length) {
            throw new IndexOutOfBoundsException("There are only " + this.probabilities.length + " posibilties, " + cat + " is invalid");
        }
        if (prob < 0.0 || Double.isInfinite(prob) || Double.isNaN(prob)) {
            throw new ArithmeticException("Only zero and positive values are valid, not " + prob);
        }
        this.probabilities[cat] = prob;
    }

    public void incProb(int cat, double prob) {
        if (cat > this.probabilities.length) {
            throw new IndexOutOfBoundsException("There are only " + this.probabilities.length + " posibilties, " + cat + " is invalid");
        }
        if (prob < 0.0 || Double.isInfinite(prob) || Double.isNaN(prob)) {
            throw new ArithmeticException("Only zero and positive values are valid, not " + prob);
        }
        int n = cat;
        this.probabilities[n] = this.probabilities[n] + prob;
    }

    public int mostLikely() {
        int top = 0;
        for (int i = 1; i < this.probabilities.length; ++i) {
            if (!(this.probabilities[i] > this.probabilities[top])) continue;
            top = i;
        }
        return top;
    }

    public void divideConst(double c) {
        int i = 0;
        while (i < this.probabilities.length) {
            int n = i++;
            this.probabilities[n] = this.probabilities[n] / c;
        }
    }

    public void normalize() {
        double sum = 0.0;
        for (double d : this.probabilities) {
            sum += d;
        }
        if (sum != 0.0) {
            this.divideConst(sum);
        }
    }

    public Vec getVecView() {
        return DenseVector.toDenseVec(this.probabilities);
    }

    public double getProb(int cat) {
        return this.probabilities[cat];
    }

    public CategoricalResults clone() {
        CategoricalResults copy = new CategoricalResults(this.n);
        copy.probabilities = Arrays.copyOf(this.probabilities, this.probabilities.length);
        return copy;
    }

    public String toString() {
        return Arrays.toString(this.probabilities);
    }
}

