/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.UpdateableClassifier;
import jsat.utils.IntList;
import jsat.utils.ListUtils;

public abstract class BaseUpdateableClassifier
implements UpdateableClassifier {
    private static final long serialVersionUID = 3138493999362400767L;
    private int epochs = 1;

    public void setEpochs(int epochs) {
        if (epochs < 1) {
            throw new IllegalArgumentException("epochs must be a positive value");
        }
        this.epochs = epochs;
    }

    public int getEpochs() {
        return this.epochs;
    }

    @Override
    public void trainC(ClassificationDataSet dataSet, ExecutorService threadPool) {
        this.trainC(dataSet);
    }

    @Override
    public void trainC(ClassificationDataSet dataSet) {
        BaseUpdateableClassifier.trainEpochs(dataSet, this, this.epochs);
    }

    public static void trainEpochs(ClassificationDataSet dataSet, UpdateableClassifier toTrain, int epochs) {
        if (epochs < 1) {
            throw new IllegalArgumentException("epochs must be positive");
        }
        toTrain.setUp(dataSet.getCategories(), dataSet.getNumNumericalVars(), dataSet.getPredicting());
        IntList randomOrder = new IntList(dataSet.getSampleSize());
        ListUtils.addRange(randomOrder, 0, dataSet.getSampleSize(), 1);
        for (int epoch = 0; epoch < epochs; ++epoch) {
            Collections.shuffle(randomOrder);
            Iterator i$ = randomOrder.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                toTrain.update(dataSet.getDataPoint(i), dataSet.getDataPointCategory(i));
            }
        }
    }

    @Override
    public abstract UpdateableClassifier clone();
}

