/*
 * Decompiled with CFR 0.152.
 */
package jsat;

import java.util.ArrayList;
import java.util.List;
import jsat.DataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;

public class SimpleDataSet
extends DataSet<SimpleDataSet> {
    protected List<DataPoint> dataPoints;

    public SimpleDataSet(List<DataPoint> dataPoints) {
        if (dataPoints.isEmpty()) {
            throw new RuntimeException("Can not create empty data set");
        }
        this.dataPoints = dataPoints;
        this.categories = dataPoints.get(0).getCategoricalData();
        this.numNumerVals = dataPoints.get(0).numNumericalValues();
        this.numericalVariableNames = new ArrayList(this.numNumerVals);
        for (int i = 0; i < this.getNumNumericalVars(); ++i) {
            this.numericalVariableNames.add("Numeric Input " + (i + 1));
        }
    }

    public SimpleDataSet(CategoricalData[] categories, int numNumericalValues) {
        this.categories = categories;
        this.numNumerVals = numNumericalValues;
        this.dataPoints = new ArrayList<DataPoint>();
    }

    @Override
    public DataPoint getDataPoint(int i) {
        return this.dataPoints.get(i);
    }

    @Override
    public void setDataPoint(int i, DataPoint dp) {
        this.dataPoints.set(i, dp);
        this.columnVecCache.clear();
    }

    public void add(DataPoint dp) {
        this.dataPoints.add(dp);
        this.columnVecCache.clear();
    }

    @Override
    public int getSampleSize() {
        return this.dataPoints.size();
    }

    @Override
    protected SimpleDataSet getSubset(List<Integer> indicies) {
        SimpleDataSet newData = new SimpleDataSet(this.categories, this.numNumerVals);
        for (int i : indicies) {
            newData.add(this.getDataPoint(i));
        }
        return newData;
    }

    public List<DataPoint> getBackingList() {
        return this.dataPoints;
    }

    @Override
    public SimpleDataSet shallowClone() {
        return new SimpleDataSet(new ArrayList<DataPoint>(this.dataPoints));
    }

    @Override
    public SimpleDataSet getTwiceShallowClone() {
        return (SimpleDataSet)super.getTwiceShallowClone();
    }
}

