/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.AbstractMetadata;
import com.twelvemonkeys.imageio.plugins.pnm.PNMHeader;
import com.twelvemonkeys.imageio.plugins.pnm.TupleType;
import java.nio.ByteOrder;
import javax.imageio.metadata.IIOMetadataNode;

final class PNMMetadata
extends AbstractMetadata {
    private final PNMHeader header;

    PNMMetadata(PNMHeader pNMHeader) {
        this.header = pNMHeader;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        switch (this.header.getTupleType()) {
            case BLACKANDWHITE: 
            case BLACKANDWHITE_ALPHA: 
            case BLACKANDWHITE_WHITE_IS_ZERO: 
            case GRAYSCALE: 
            case GRAYSCALE_ALPHA: {
                iIOMetadataNode2.setAttribute("name", "GRAY");
                break;
            }
            case RGB: 
            case RGB_ALPHA: {
                iIOMetadataNode2.setAttribute("name", "RGB");
                break;
            }
            case CMYK: 
            case CMYK_ALPHA: {
                iIOMetadataNode2.setAttribute("name", "CMYK");
            }
        }
        if (iIOMetadataNode2.getAttribute("name") != null) {
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode3.setAttribute("value", Integer.toString(this.header.getSamplesPerPixel()));
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode4.setAttribute("value", this.header.getTupleType() == TupleType.BLACKANDWHITE_WHITE_IS_ZERO ? "FALSE" : "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode2.setAttribute("value", this.header.getTransferType() == 4 ? "Real" : "UnsignedIntegral");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode3.setAttribute("value", this.createListValue(this.header.getSamplesPerPixel(), Integer.toString(this.header.getBitsPerSample())));
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("SignificantBitsPerSample");
        iIOMetadataNode4.setAttribute("value", this.createListValue(this.header.getSamplesPerPixel(), Integer.toString(this.computeSignificantBits())));
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        String string = this.header.getByteOrder() == ByteOrder.BIG_ENDIAN ? "0" : Integer.toString(this.header.getBitsPerSample() - 1);
        IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("SampleMSB");
        iIOMetadataNode5.setAttribute("value", this.createListValue(this.header.getSamplesPerPixel(), string));
        return iIOMetadataNode;
    }

    private int computeSignificantBits() {
        if (this.header.getTransferType() == 4) {
            return this.header.getBitsPerSample();
        }
        int n = 0;
        int n2 = this.header.getMaxSample();
        while (n2 > 0) {
            n2 >>>= 1;
            ++n;
        }
        return n;
    }

    private String createListValue(int n, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[i % stringArray.length]);
        }
        return stringBuilder.toString();
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", this.header.getFileType() == 20582 || this.header.getFileType() == 20550 ? "FlipH" : "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardTextNode() {
        if (!this.header.getComments().isEmpty()) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
            for (String string : this.header.getComments()) {
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
                iIOMetadataNode2.setAttribute("keyword", "comment");
                iIOMetadataNode2.setAttribute("value", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            return iIOMetadataNode;
        }
        return null;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        iIOMetadataNode2.setAttribute("value", this.header.getTransparency() == 1 ? "none" : "nonpremultiplied");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }
}

