/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.util;

import javax.media.jai.Interpolation;

public class InterpAverage
extends Interpolation {
    public InterpAverage(int n, int n2) {
        super(n, n2, 0, n - 1, 0, n2 - 1, 32, 32);
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("blockX <= 0 || blockY <= 0");
        }
    }

    public int interpolateH(int[] nArray, int n) {
        int n2 = nArray.length;
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            d += (double)(nArray[i] / n2);
        }
        return (int)(d + 0.5);
    }

    public float interpolateH(float[] fArray, float f) {
        int n = fArray.length;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f2 += fArray[i] / (float)n;
        }
        return f2;
    }

    public double interpolateH(double[] dArray, float f) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] / (double)n;
        }
        return d;
    }
}

