/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.util;

import com.sun.media.jai.codecimpl.util.JaiI18N;
import java.io.Serializable;
import java.util.Hashtable;
import javax.media.jai.util.CaselessStringKey;

public class CaselessStringArrayTable
implements Serializable {
    private CaselessStringKey[] keys;
    private Hashtable indices;

    public CaselessStringArrayTable() {
        this((CaselessStringKey[])null);
    }

    public CaselessStringArrayTable(CaselessStringKey[] caselessStringKeyArray) {
        this.keys = caselessStringKeyArray;
        this.indices = new Hashtable();
        if (caselessStringKeyArray != null) {
            for (int i = 0; i < caselessStringKeyArray.length; ++i) {
                this.indices.put(caselessStringKeyArray[i], new Integer(i));
            }
        }
    }

    public CaselessStringArrayTable(String[] stringArray) {
        this(CaselessStringArrayTable.toCaselessStringKey(stringArray));
    }

    private static CaselessStringKey[] toCaselessStringKey(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        CaselessStringKey[] caselessStringKeyArray = new CaselessStringKey[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            caselessStringKeyArray[i] = new CaselessStringKey(stringArray[i]);
        }
        return caselessStringKeyArray;
    }

    public int indexOf(CaselessStringKey caselessStringKey) {
        if (caselessStringKey == null) {
            throw new IllegalArgumentException(JaiI18N.getString("CaselessStringArrayTable0"));
        }
        Integer n = (Integer)this.indices.get(caselessStringKey);
        if (n == null) {
            throw new IllegalArgumentException(caselessStringKey.getName() + " - " + JaiI18N.getString("CaselessStringArrayTable1"));
        }
        return n;
    }

    public int indexOf(String string) {
        return this.indexOf(new CaselessStringKey(string));
    }

    public String getName(int n) {
        if (this.keys == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.keys[n].getName();
    }

    public CaselessStringKey get(int n) {
        if (this.keys == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.keys[n];
    }

    public boolean contains(CaselessStringKey caselessStringKey) {
        if (caselessStringKey == null) {
            throw new IllegalArgumentException(JaiI18N.getString("CaselessStringArrayTable0"));
        }
        return this.indices.get(caselessStringKey) != null;
    }

    public boolean contains(String string) {
        return this.contains(new CaselessStringKey(string));
    }
}

