/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.JPEGDecodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.JPEGImageDecoder;
import com.sun.media.jai.codecimpl.JPEGImageEncoder;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JPEGCodec
extends ImageCodec {
    public String getFormatName() {
        return "jpeg";
    }

    public Class getEncodeParamClass() {
        return JPEGEncodeParam.class;
    }

    public Class getDecodeParamClass() {
        return JPEGDecodeParam.class;
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        JPEGEncodeParam jPEGEncodeParam = null;
        if (imageEncodeParam != null) {
            jPEGEncodeParam = (JPEGEncodeParam)imageEncodeParam;
        }
        return new JPEGImageEncoder(outputStream, jPEGEncodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        return new JPEGImageDecoder(inputStream, imageDecodeParam);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return new JPEGImageDecoder(new FileInputStream(file), imageDecodeParam);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new JPEGImageDecoder((InputStream)seekableStream, imageDecodeParam);
    }

    public int getNumHeaderBytes() {
        return 3;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == -1 && byArray[1] == -40 && byArray[2] == -1;
    }
}

