/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.util.ImagingException;
import java.awt.Point;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;

class GIFImage
extends SimpleRenderedImage {
    private static final int[] INTERLACE_INCREMENT = new int[]{8, 8, 4, 2, -1};
    private static final int[] INTERLACE_OFFSET = new int[]{0, 4, 2, 1, -1};
    private SeekableStream input;
    private boolean interlaceFlag;
    private byte[] block;
    private int blockLength;
    private int bitPos;
    private int nextByte;
    private int initCodeSize;
    private int clearCode;
    private int eofCode;
    private int bitsLeft;
    private int next32Bits;
    private boolean lastBlockFound;
    private int interlacePass;
    private WritableRaster theTile;

    private void skipBlocks() throws IOException {
        int n;
        while ((n = this.input.readUnsignedByte()) != 0) {
            this.input.skipBytes(n);
        }
    }

    GIFImage(SeekableStream seekableStream, byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3;
        boolean bl;
        byte[] byArray2;
        block12: {
            this.interlaceFlag = false;
            this.block = new byte[255];
            this.blockLength = 0;
            this.bitPos = 0;
            this.nextByte = 0;
            this.next32Bits = 0;
            this.lastBlockFound = false;
            this.interlacePass = 0;
            this.theTile = null;
            this.input = seekableStream;
            byArray2 = null;
            bl = false;
            n3 = 0;
            try {
                long l = seekableStream.getFilePointer();
                while (true) {
                    int n4;
                    if ((n2 = seekableStream.readUnsignedByte()) == 44) {
                        seekableStream.skipBytes(4);
                        this.width = seekableStream.readUnsignedShortLE();
                        this.height = seekableStream.readUnsignedShortLE();
                        n = seekableStream.readUnsignedByte();
                        n4 = (n & 0x80) != 0 ? 1 : 0;
                        this.interlaceFlag = (n & 0x40) != 0;
                        int n5 = 1 << (n & 7) + 1;
                        if (n4 != 0) {
                            byArray2 = new byte[3 * n5];
                            seekableStream.readFully(byArray2);
                        } else {
                            byArray2 = null;
                        }
                        break block12;
                    }
                    if (n2 != 33) break;
                    n = seekableStream.readUnsignedByte();
                    if (n == 249) {
                        seekableStream.read();
                        n4 = seekableStream.readUnsignedByte();
                        bl = (n4 & 1) != 0;
                        seekableStream.skipBytes(2);
                        n3 = seekableStream.readUnsignedByte();
                        seekableStream.read();
                        continue;
                    }
                    if (n == 1) {
                        seekableStream.skipBytes(13);
                        this.skipBlocks();
                        continue;
                    }
                    if (n == 254) {
                        this.skipBlocks();
                        continue;
                    }
                    if (n == 255) {
                        seekableStream.skipBytes(12);
                        this.skipBlocks();
                        continue;
                    }
                    n4 = 0;
                    do {
                        n4 = seekableStream.readUnsignedByte();
                        seekableStream.skipBytes(n4);
                    } while (n4 > 0);
                }
                throw new IOException(JaiI18N.getString("GIFImage0") + " " + n2 + "!");
            }
            catch (IOException iOException) {
                throw new IOException(JaiI18N.getString("GIFImage1"));
            }
        }
        this.tileGridYOffset = 0;
        this.tileGridXOffset = 0;
        this.minY = 0;
        this.minX = 0;
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        byte[] byArray3 = byArray2 != null ? byArray2 : byArray;
        int n6 = byArray3.length / 3;
        n2 = n6 == 2 ? 1 : (n6 == 4 ? 2 : (n6 == 8 || n6 == 16 ? 4 : 8));
        n = 1 << n2;
        byte[] byArray4 = new byte[n];
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        int n7 = 0;
        for (int i = 0; i < n6; ++i) {
            byArray4[i] = byArray3[n7++];
            byArray5[i] = byArray3[n7++];
            byArray6[i] = byArray3[n7++];
        }
        int[] nArray = new int[]{n2};
        this.sampleModel = new PixelInterleavedSampleModel(0, this.width, this.height, 1, this.width, new int[]{0});
        this.colorModel = !bl ? (ImageCodec.isIndicesForGrayscale(byArray4, byArray5, byArray6) ? ImageCodec.createComponentColorModel(this.sampleModel) : new IndexColorModel(n2, byArray4.length, byArray4, byArray5, byArray6)) : new IndexColorModel(n2, byArray4.length, byArray4, byArray5, byArray6, n3);
    }

    private void initNext32Bits() {
        this.next32Bits = this.block[0] & 0xFF;
        this.next32Bits |= (this.block[1] & 0xFF) << 8;
        this.next32Bits |= (this.block[2] & 0xFF) << 16;
        this.next32Bits |= this.block[3] << 24;
        this.nextByte = 4;
    }

    private int getCode(int n, int n2) throws IOException {
        if (this.bitsLeft <= 0) {
            return this.eofCode;
        }
        int n3 = this.next32Bits >> this.bitPos & n2;
        this.bitPos += n;
        this.bitsLeft -= n;
        while (this.bitPos >= 8 && !this.lastBlockFound) {
            this.next32Bits >>>= 8;
            this.bitPos -= 8;
            if (this.nextByte >= this.blockLength) {
                int n4;
                this.blockLength = this.input.readUnsignedByte();
                if (this.blockLength == 0) {
                    this.lastBlockFound = true;
                    if (this.bitsLeft < 0) {
                        return this.eofCode;
                    }
                    return n3;
                }
                int n5 = 0;
                for (int i = this.blockLength; i > 0; i -= n4) {
                    n4 = this.input.read(this.block, n5, i);
                    n5 += n4;
                }
                this.bitsLeft += this.blockLength << 3;
                this.nextByte = 0;
            }
            this.next32Bits |= this.block[this.nextByte++] << 24;
        }
        return n3;
    }

    private void initializeStringTable(int[] nArray, byte[] byArray, byte[] byArray2, int[] nArray2) {
        int n;
        int n2 = 1 << this.initCodeSize;
        for (n = 0; n < n2; ++n) {
            nArray[n] = -1;
            byArray[n] = (byte)n;
            byArray2[n] = (byte)n;
            nArray2[n] = 1;
        }
        for (n = n2; n < 4096; ++n) {
            nArray[n] = -1;
            nArray2[n] = 1;
        }
    }

    private Point outputPixels(byte[] byArray, int n, Point point, byte[] byArray2) {
        if (this.interlacePass < 0 || this.interlacePass > 3) {
            return point;
        }
        for (int i = 0; i < n; ++i) {
            if (point.x >= this.minX) {
                byArray2[point.x - this.minX] = byArray[i];
            }
            ++point.x;
            if (point.x != this.width) continue;
            this.theTile.setDataElements(this.minX, point.y, this.width, 1, byArray2);
            point.x = 0;
            if (this.interlaceFlag) {
                point.y += INTERLACE_INCREMENT[this.interlacePass];
                if (point.y < this.height) continue;
                ++this.interlacePass;
                if (this.interlacePass > 3) {
                    return point;
                }
                point.y = INTERLACE_OFFSET[this.interlacePass];
                continue;
            }
            ++point.y;
        }
        return point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized Raster getTile(int var1_1, int var2_2) {
        if (var1_1 != 0 || var2_2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("GIFImage2"));
        }
        if (this.theTile != null) {
            return this.theTile;
        }
        this.theTile = WritableRaster.createWritableRaster(this.sampleModel, this.sampleModel.createDataBuffer(), null);
        var3_3 = new Point(0, 0);
        var4_4 = new byte[this.width];
        try {
            this.initCodeSize = this.input.readUnsignedByte();
            var5_5 = this.blockLength = this.input.readUnsignedByte();
            var6_7 = 0;
            while (var5_5 > 0) {
                var7_9 = this.input.read(this.block, var6_7, var5_5);
                var5_5 -= var7_9;
                var6_7 += var7_9;
            }
            this.bitPos = 0;
            this.nextByte = 0;
            this.lastBlockFound = false;
            this.bitsLeft = this.blockLength << 3;
            this.initNext32Bits();
            this.clearCode = 1 << this.initCodeSize;
            this.eofCode = this.clearCode + 1;
            var8_10 = 0;
            var9_11 = new int[4096];
            var10_12 = new byte[4096];
            var11_13 = new byte[4096];
            var12_14 = new int[4096];
            var13_15 = new byte[4096];
            this.initializeStringTable(var9_11, var10_12, var11_13, var12_14);
            var14_16 = (1 << this.initCodeSize) + 2;
            var15_17 = this.initCodeSize + 1;
            var16_18 = (1 << var15_17) - 1;
            while (true) {
                block15: {
                    if ((var7_9 = this.getCode(var15_17, var16_18)) != this.clearCode) break block15;
                    this.initializeStringTable(var9_11, var10_12, var11_13, var12_14);
                    var14_16 = (1 << this.initCodeSize) + 2;
                    var15_17 = this.initCodeSize + 1;
                    var16_18 = (1 << var15_17) - 1;
                    var7_9 = this.getCode(var15_17, var16_18);
                    if (var7_9 == this.eofCode) {
                        var17_20 = this.theTile;
                        return var17_20;
                    }
                    ** GOTO lbl58
                }
                if (var7_9 == this.eofCode) {
                    var17_21 = this.theTile;
                    return var17_21;
                }
                var17_19 = var7_9 < var14_16 ? var7_9 : var8_10;
                var18_22 = var14_16++;
                var9_11[var18_22] = var19_23 = var8_10;
                var10_12[var18_22] = var11_13[var17_19];
                var11_13[var18_22] = var11_13[var19_23];
                var12_14[var18_22] = var12_14[var19_23] + 1;
                if (var14_16 == 1 << var15_17 && var14_16 < 4096) {
                    var16_18 = (1 << ++var15_17) - 1;
                }
lbl58:
                // 4 sources

                var17_19 = var7_9;
                var18_22 = var12_14[var17_19];
                for (var19_23 = var18_22 - 1; var19_23 >= 0; --var19_23) {
                    var13_15[var19_23] = var10_12[var17_19];
                    var17_19 = var9_11[var17_19];
                }
                this.outputPixels(var13_15, var18_22, var3_3, var4_4);
                var8_10 = var7_9;
                continue;
                break;
            }
            catch (IOException var5_6) {
                var6_8 = JaiI18N.getString("GIFImage3");
                ImagingListenerProxy.errorOccurred(var6_8, new ImagingException(var6_8, var5_6), this, false);
            }
        }
        finally {
            return this.theTile;
        }
    }
}

