/*
 * Decompiled with CFR 0.152.
 */
package flanagan.plot;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.io.FileOutput;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;

public class PlotPoleZero {
    private ComplexPoly numerPoly = null;
    private ComplexPoly denomPoly = null;
    private Complex[] numerRoots = null;
    private Complex[] denomRoots = null;
    private double[][] data = null;
    private int nDeg = 0;
    private int dDeg = 0;
    private int mDeg = 0;
    private int sORz = 0;
    private boolean zerosSet = false;
    private boolean polesSet = false;
    private boolean zCircle = false;
    private boolean noImag = true;
    private boolean noReal = true;
    private boolean noZeros = true;
    private boolean noPoles = true;
    private boolean setUnitAxes = false;
    private boolean setEqualAxes = false;
    private double scaleFactor = 1.0;

    public PlotPoleZero() {
    }

    public PlotPoleZero(ComplexPoly complexPoly, ComplexPoly complexPoly2) {
        if (complexPoly != null) {
            this.nDeg = complexPoly.getDeg();
            if (this.nDeg > 0) {
                this.numerPoly = ComplexPoly.copy(complexPoly);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = this.nDeg;
                this.noZeros = false;
            }
        }
        if (complexPoly2 != null) {
            this.dDeg = complexPoly2.getDeg();
            if (this.dDeg > 0) {
                this.denomPoly = ComplexPoly.copy(complexPoly2);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
        }
        if (this.noZeros && this.noPoles) {
            throw new IllegalArgumentException("No poles or zeros entered");
        }
    }

    public PlotPoleZero(Complex[] complexArray, Complex[] complexArray2) {
        if (complexArray != null) {
            this.nDeg = complexArray.length - 1;
            if (this.nDeg > 0) {
                this.numerPoly = new ComplexPoly(complexArray);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = this.nDeg;
                this.noZeros = false;
            }
        }
        if (complexArray2 != null) {
            this.dDeg = complexArray2.length - 1;
            if (this.dDeg > 0) {
                this.denomPoly = new ComplexPoly(complexArray2);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
            if (this.noZeros && this.noPoles) {
                throw new IllegalArgumentException("No poles or zeros entered");
            }
        }
    }

    public PlotPoleZero(double[] dArray, double[] dArray2) {
        if (dArray != null) {
            this.nDeg = dArray.length - 1;
            if (this.nDeg > 0) {
                this.numerPoly = new ComplexPoly(dArray);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = this.nDeg;
                this.noZeros = false;
            }
        }
        if (dArray2 != null) {
            this.dDeg = dArray2.length - 1;
            if (this.dDeg > 0) {
                this.denomPoly = new ComplexPoly(dArray2);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
            if (this.noZeros && this.noPoles) {
                throw new IllegalArgumentException("No poles or zeros entered");
            }
        }
    }

    public void setNumerator(ComplexPoly complexPoly) {
        if (complexPoly != null) {
            this.nDeg = complexPoly.getDeg();
            if (this.nDeg > 0) {
                this.numerPoly = ComplexPoly.copy(complexPoly);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = !this.noPoles ? Math.max(this.nDeg, this.dDeg) : this.nDeg;
                this.noZeros = false;
            }
        } else {
            this.noZeros = true;
        }
    }

    public void setNumerator(Complex[] complexArray) {
        if (complexArray != null) {
            this.nDeg = complexArray.length - 1;
            if (this.nDeg > 0) {
                this.numerPoly = new ComplexPoly(complexArray);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = !this.noPoles ? Math.max(this.nDeg, this.dDeg) : this.nDeg;
                this.noZeros = false;
            }
        } else {
            this.noZeros = true;
        }
    }

    public void setNumerator(double[] dArray) {
        if (dArray != null) {
            this.nDeg = dArray.length - 1;
            if (this.nDeg > 0) {
                this.numerPoly = new ComplexPoly(dArray);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = !this.noPoles ? Math.max(this.nDeg, this.dDeg) : this.nDeg;
                this.noZeros = false;
            }
        } else {
            this.noZeros = true;
        }
    }

    public void setZeros(Complex[] complexArray) {
        if (complexArray != null) {
            this.nDeg = complexArray.length;
            if (this.nDeg > 0) {
                this.numerRoots = complexArray;
                this.numerPoly = ComplexPoly.rootsToPoly(complexArray);
                this.mDeg = !this.noPoles ? Math.max(this.nDeg, this.dDeg) : this.nDeg;
                this.noZeros = false;
            }
            this.zerosSet = true;
        } else {
            this.noZeros = true;
        }
    }

    public void setZeros(double[] dArray) {
        int n = dArray.length;
        Complex[] complexArray = Complex.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            complexArray[i] = new Complex(dArray[i], 0.0);
        }
        this.setZeros(complexArray);
    }

    public void setDenominator(ComplexPoly complexPoly) {
        if (complexPoly != null) {
            this.dDeg = complexPoly.getDeg();
            if (this.dDeg > 0) {
                this.denomPoly = ComplexPoly.copy(complexPoly);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
        } else {
            this.noPoles = true;
        }
    }

    public void setDenominator(Complex[] complexArray) {
        if (complexArray != null) {
            this.dDeg = complexArray.length - 1;
            if (this.dDeg > 0) {
                this.denomPoly = new ComplexPoly(complexArray);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
        } else {
            this.noPoles = true;
        }
    }

    public void setDenominator(double[] dArray) {
        if (dArray != null) {
            this.dDeg = dArray.length - 1;
            if (this.dDeg > 0) {
                this.denomPoly = new ComplexPoly(dArray);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
        } else {
            this.noPoles = true;
        }
    }

    public void setPoles(Complex[] complexArray) {
        if (complexArray != null) {
            this.dDeg = complexArray.length;
            if (this.dDeg > 0) {
                this.denomRoots = complexArray;
                this.denomPoly = ComplexPoly.rootsToPoly(complexArray);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
            this.polesSet = true;
        } else {
            this.noPoles = true;
        }
    }

    public void setPoles(double[] dArray) {
        int n = dArray.length;
        Complex[] complexArray = Complex.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            complexArray[i] = new Complex(dArray[i], 0.0);
        }
        this.setPoles(complexArray);
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setS() {
        this.sORz = 1;
    }

    public void setZ() {
        this.sORz = 2;
        this.zCircle = true;
    }

    public void setUnitAxes() {
        this.setUnitAxes = true;
        this.setEqualAxes = false;
    }

    public void setEqualAxes() {
        this.setEqualAxes = true;
        this.setUnitAxes = false;
    }

    public void setCircle() {
        this.zCircle = true;
        if (this.sORz != 2) {
            this.sORz = 2;
        }
    }

    public void unsetCircle() {
        this.zCircle = false;
    }

    public Complex[][] pzPlot(String string) {
        int n;
        int n2;
        if (this.noPoles && this.noZeros) {
            throw new IllegalArgumentException("No poles or zeros have been entered");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0E-5;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = 600;
        double d6 = 2.0 / (double)(n3 - 1);
        int n4 = 0;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[] dArray5 = null;
        double[] dArray6 = null;
        double[] dArray7 = null;
        double[] dArray8 = null;
        double[] dArray9 = new double[n3];
        double[] dArray10 = new double[n3];
        double[] dArray11 = new double[n3];
        double[] dArray12 = new double[n3];
        Complex[][] complexArray = new Complex[][]{null, null};
        int n5 = 0;
        if (this.nDeg > 0) {
            ++n5;
            dArray = new double[this.nDeg];
            dArray2 = new double[this.nDeg];
            if (!this.zerosSet) {
                this.numerRoots = this.numerPoly.roots();
            }
            complexArray[0] = this.numerRoots;
            for (n2 = 0; n2 < this.nDeg; ++n2) {
                dArray[n2] = this.numerRoots[n2].getReal();
                dArray2[n2] = this.numerRoots[n2].getImag();
                if (!this.numerRoots[n2].isZero()) {
                    d = Math.abs(dArray[n2]);
                    if (d > (d2 = Math.abs(dArray2[n2]))) {
                        if (d2 < d3 * d) {
                            dArray2[n2] = 0.0;
                        }
                    } else if (d < d3 * d2) {
                        dArray[n2] = 0.0;
                    }
                }
                if (dArray[n2] != 0.0) {
                    this.noReal = false;
                }
                if (dArray2[n2] == 0.0) continue;
                this.noImag = false;
            }
            n4 = this.nDeg;
        }
        if (this.dDeg > 0) {
            ++n5;
            dArray3 = new double[this.dDeg];
            dArray4 = new double[this.dDeg];
            if (!this.polesSet) {
                this.denomRoots = this.denomPoly.roots();
            }
            complexArray[1] = this.denomRoots;
            for (n2 = 0; n2 < this.dDeg; ++n2) {
                dArray3[n2] = this.denomRoots[n2].getReal();
                dArray4[n2] = this.denomRoots[n2].getImag();
                if (!this.denomRoots[n2].isZero()) {
                    d = Math.abs(dArray3[n2]);
                    if (d > (d2 = Math.abs(dArray4[n2]))) {
                        if (d2 < d3 * d) {
                            dArray4[n2] = 0.0;
                        }
                    } else if (d < d3 * d2) {
                        dArray3[n2] = 0.0;
                    }
                }
                if (dArray3[n2] != 0.0) {
                    this.noReal = false;
                }
                if (dArray4[n2] == 0.0) continue;
                this.noImag = false;
            }
            if (this.dDeg > n4) {
                n4 = this.dDeg;
            }
        }
        if (this.noReal) {
            ++n5;
            dArray5 = new double[]{1.0, -1.0};
            dArray6 = new double[]{0.0, 0.0};
            if (2 > n4) {
                n4 = 2;
            }
        }
        if (this.noImag) {
            ++n5;
            dArray7 = new double[]{0.0, 0.0};
            dArray8 = new double[]{1.0, -1.0};
            if (2 > n4) {
                n4 = 2;
            }
        }
        if (this.zCircle) {
            n5 += 2;
            dArray9[0] = -1.0;
            dArray10[0] = 0.0;
            dArray11[0] = -1.0;
            dArray12[0] = 0.0;
            for (n2 = 1; n2 < n3; ++n2) {
                dArray9[n2] = dArray9[n2 - 1] + d6;
                dArray10[n2] = Math.sqrt(1.0 - dArray9[n2] * dArray9[n2]);
                dArray11[n2] = dArray11[n2 - 1] + d6;
                dArray12[n2] = -dArray10[n2];
            }
            if (n3 > n4) {
                n4 = n3;
            }
        }
        if (this.setEqualAxes) {
            ++n5;
            double d7 = Fmath.maximum(dArray3);
            double d8 = Fmath.maximum(dArray);
            double d9 = Math.max(d7, d8);
            double d10 = Fmath.maximum(dArray4);
            double d11 = Fmath.maximum(dArray2);
            double d12 = Math.max(d10, d11);
            d5 = Math.max(d9, d12);
            double d13 = Fmath.minimum(dArray3);
            double d14 = Fmath.minimum(dArray);
            double d15 = Math.min(d13, d14);
            double d16 = Fmath.minimum(dArray4);
            double d17 = Fmath.minimum(dArray2);
            double d18 = Math.min(d16, d17);
            d4 = Math.min(d15, d18);
        }
        int n6 = 0;
        double[][] dArray13 = PlotGraph.data(n5, n4);
        boolean[] blArray = new boolean[n5];
        boolean[] blArray2 = new boolean[n5];
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        n6 = 0;
        if (this.nDeg > 0) {
            nArray[n6] = 0;
            nArray2[n6] = 1;
            blArray[n6] = false;
            blArray2[n6] = true;
            for (int i = 0; i < this.nDeg; ++i) {
                dArray13[2 * n6][i] = dArray[i];
                dArray13[2 * n6 + 1][i] = dArray2[i];
            }
            ++n6;
        }
        if (this.dDeg > 0) {
            nArray[n6] = 0;
            nArray2[n6] = 7;
            blArray[n6] = false;
            blArray2[n6] = true;
            for (int i = 0; i < this.dDeg; ++i) {
                dArray13[2 * n6][i] = dArray3[i];
                dArray13[2 * n6 + 1][i] = dArray4[i];
            }
            ++n6;
        }
        if (this.zCircle) {
            int n7;
            nArray[n6] = 3;
            nArray2[n6] = 0;
            blArray[n6] = true;
            blArray2[n6] = false;
            if (this.setUnitAxes) {
                blArray2[n6] = true;
            }
            for (n7 = 0; n7 < n3; ++n7) {
                dArray13[2 * n6][n7] = dArray9[n7];
                dArray13[2 * n6 + 1][n7] = dArray10[n7];
            }
            nArray[++n6] = 3;
            nArray2[n6] = 0;
            blArray[n6] = true;
            blArray2[n6] = false;
            if (this.setUnitAxes) {
                blArray2[n6] = true;
            }
            for (n7 = 0; n7 < n3; ++n7) {
                dArray13[2 * n6][n7] = dArray11[n7];
                dArray13[2 * n6 + 1][n7] = dArray12[n7];
            }
            ++n6;
        }
        if (this.noReal) {
            nArray[n6] = 0;
            nArray2[n6] = 0;
            blArray[n6] = false;
            blArray2[n6] = true;
            for (int i = 0; i < 2; ++i) {
                dArray13[2 * n6][i] = dArray5[i];
                dArray13[2 * n6 + 1][i] = dArray6[i];
            }
            ++n6;
        }
        if (this.noImag) {
            nArray[n6] = 0;
            nArray2[n6] = 0;
            blArray[n6] = false;
            blArray2[n6] = true;
            for (int i = 0; i < 2; ++i) {
                dArray13[2 * n6][i] = dArray7[i];
                dArray13[2 * n6 + 1][i] = dArray8[i];
            }
            ++n6;
        }
        if (this.setEqualAxes) {
            nArray[n6] = 0;
            nArray2[n6] = 0;
            blArray[n6] = false;
            blArray2[n6] = true;
            dArray13[2 * n6][0] = d4;
            dArray13[2 * n6 + 1][0] = d4;
            dArray13[2 * n6][1] = d5;
            dArray13[2 * n6 + 1][1] = d5;
            ++n6;
        }
        PlotGraph plotGraph = new PlotGraph(dArray13);
        plotGraph.setLine(nArray);
        plotGraph.setPoint(nArray2);
        plotGraph.setTrimOpt(blArray);
        plotGraph.setMinMaxOpt(blArray2);
        plotGraph.setXlowFac(0.0);
        plotGraph.setYlowFac(0.0);
        plotGraph.setGraphWidth((int)(this.scaleFactor * 760.0));
        plotGraph.setGraphHeight((int)(this.scaleFactor * 700.0));
        plotGraph.setXaxisLen((int)(this.scaleFactor * 560.0));
        plotGraph.setYaxisLen((int)(this.scaleFactor * 560.0));
        plotGraph.setYhigh((int)(this.scaleFactor * 80.0));
        plotGraph.setNoOffset(true);
        switch (this.sORz) {
            case 0: {
                plotGraph.setGraphTitle("Pole Zero Plot: " + string);
                plotGraph.setXaxisLegend("Real part of s or z");
                plotGraph.setYaxisLegend("Imaginary part of s or z");
                break;
            }
            case 1: {
                plotGraph.setGraphTitle("Pole Zero Plot (s-plane): " + string);
                plotGraph.setXaxisLegend("Real part of s");
                plotGraph.setYaxisLegend("Imaginary part of s");
                break;
            }
            case 2: {
                plotGraph.setGraphTitle("Pole Zero Plot (z-plane): " + string);
                plotGraph.setXaxisLegend("Real part of z");
                plotGraph.setYaxisLegend("Imaginary part of z");
            }
        }
        plotGraph.plot();
        Complex[] complexArray2 = null;
        Complex[] complexArray3 = null;
        FileOutput fileOutput = new FileOutput("PoleZeroOutput.txt");
        fileOutput.println("Output File for Program PlotPoleZero");
        if (this.sORz == 1) {
            fileOutput.println("An s-plane plot");
        }
        if (this.sORz == 2) {
            fileOutput.println("A z-plane plot");
        }
        fileOutput.dateAndTimeln(string);
        fileOutput.println();
        if (!this.noZeros) {
            complexArray2 = this.numerPoly.polyNomCopy();
            fileOutput.println("Numerator polynomial coefficients");
            for (int i = 0; i <= this.nDeg; ++i) {
                fileOutput.print(complexArray2[i].toString());
                if (i >= this.nDeg) continue;
                fileOutput.printcomma();
                fileOutput.printsp();
            }
            fileOutput.println();
            fileOutput.println();
        }
        if (!this.noPoles) {
            complexArray3 = this.denomPoly.polyNomCopy();
            fileOutput.println("Denominator polynomial coefficients");
            for (int i = 0; i <= this.dDeg; ++i) {
                fileOutput.print(complexArray3[i].toString());
                if (i >= this.dDeg) continue;
                fileOutput.printcomma();
                fileOutput.printsp();
            }
            fileOutput.println();
            fileOutput.println();
        }
        fileOutput.println("Numerator roots (zeros)");
        if (this.nDeg < 1) {
            fileOutput.println("No zeros");
        } else {
            for (int i = 0; i < this.nDeg; ++i) {
                fileOutput.print(Complex.truncate(this.numerRoots[i], 6));
                if (i >= this.nDeg - 1) continue;
                fileOutput.printcomma();
                fileOutput.printsp();
            }
            fileOutput.println();
            fileOutput.println();
        }
        fileOutput.println("Denominator roots (poles)");
        if (this.dDeg < 1) {
            fileOutput.println("No poles");
        } else {
            for (int i = 0; i < this.dDeg; ++i) {
                fileOutput.print(Complex.truncate(this.denomRoots[i], 6));
                if (i >= this.dDeg - 1) continue;
                fileOutput.printcomma();
                fileOutput.printsp();
            }
            fileOutput.println();
            fileOutput.println();
        }
        if (this.sORz == 2) {
            fileOutput.println("Denominator pole radial distances on the z-plane");
            if (this.dDeg < 1) {
                fileOutput.println("No poles");
            } else {
                for (int i = 0; i < this.dDeg; ++i) {
                    fileOutput.print(Fmath.truncate(this.denomRoots[i].abs(), 6));
                    if (i >= this.dDeg - 1) continue;
                    fileOutput.printcomma();
                    fileOutput.printsp();
                }
            }
            fileOutput.println();
            fileOutput.println();
        }
        boolean bl = true;
        if (this.sORz == 1) {
            for (n = 0; n < this.dDeg; ++n) {
                if (!(this.denomRoots[n].getReal() > 0.0)) continue;
                bl = false;
            }
            if (bl) {
                fileOutput.println("All pole real parts are less than or equal to zero - stable system");
            } else {
                fileOutput.println("At least one pole real part is greater than zero - unstable system");
            }
        }
        if (this.sORz == 2) {
            for (n = 0; n < this.dDeg; ++n) {
                if (!(Fmath.truncate(this.denomRoots[n].abs(), 6) > 1.0)) continue;
                bl = false;
            }
            if (bl) {
                fileOutput.println("All pole distances from the z-plane zero are less than or equal to one - stable system");
            } else {
                fileOutput.println("At least one pole distance from the z-plane zero is greater than one - unstable system");
            }
        }
        fileOutput.println();
        fileOutput.println("End of file");
        fileOutput.close();
        return complexArray;
    }

    public Complex[][] pzPlot() {
        String string = "no file title provided";
        return this.pzPlot(string);
    }
}

