/*
 * Decompiled with CFR 0.152.
 */
package flanagan.plot;

import flanagan.plot.Plot;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class PlotGraph
extends Plot
implements Serializable {
    protected static final long serialVersionUID = 1L;
    protected int graphWidth = 800;
    protected int graphHeight = 600;
    protected int closeChoice = 1;
    protected JFrame window = new JFrame("Michael T Flanagan's plotting program - PlotGraph");

    public PlotGraph(double[][] dArray) {
        super(dArray);
    }

    public PlotGraph(double[] dArray, double[] dArray2) {
        super(dArray, dArray2);
    }

    public void rescaleY(double d) {
        this.graphHeight = (int)Math.round((double)this.graphHeight * d);
        this.yLen = (int)Math.round((double)this.yLen * d);
        this.yTop = (int)Math.round((double)this.yTop * d);
        this.yBot = this.yTop + this.yLen;
    }

    public void rescaleX(double d) {
        this.graphWidth = (int)Math.round((double)this.graphWidth * d);
        this.xLen = (int)Math.round((double)this.xLen * d);
        this.xBot = (int)Math.round((double)this.xBot * d);
        this.xTop = this.xBot + this.xLen;
    }

    public int getGraphWidth() {
        return this.graphWidth;
    }

    public int getGraphHeight() {
        return this.graphHeight;
    }

    public void setGraphHeight(int n) {
        this.graphHeight = n;
    }

    public void setGraphWidth(int n) {
        this.graphWidth = n;
    }

    public int getCloseChoice() {
        return this.closeChoice;
    }

    public void setCloseChoice(int n) {
        this.closeChoice = n;
    }

    @Override
    public void paint(Graphics graphics) {
        double d = this.getSize().width;
        double d2 = this.getSize().height;
        double d3 = d / (double)this.graphWidth;
        double d4 = d2 / (double)this.graphHeight;
        this.rescaleX(d3);
        this.rescaleY(d4);
        this.graph(graphics);
    }

    public void plot() {
        this.setSize(this.graphWidth, this.graphHeight);
        this.window.getContentPane().setBackground(Color.white);
        if (this.closeChoice == 1) {
            this.window.setDefaultCloseOperation(3);
        } else {
            this.window.setDefaultCloseOperation(1);
        }
        this.window.getContentPane().add("Center", this);
        this.window.pack();
        this.window.setResizable(true);
        this.window.toFront();
        this.window.setVisible(true);
    }

    public void endProgram() {
        int n = JOptionPane.showConfirmDialog(null, "Do you wish to end the program\nThis will also close the graph window or windows", "End Program", 0, 3);
        if (n == 0) {
            System.exit(0);
        } else {
            String string = "Now you must press the appropriate escape key/s, e.g. Ctrl C, to exit this program\n";
            if (this.closeChoice == 1) {
                string = string + "or close a graph window";
            }
            JOptionPane.showMessageDialog(null, string);
        }
    }

    public static long getSerialVersionUID() {
        return 1L;
    }
}

