/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physprop;

import flanagan.interpolation.BiCubicSpline;
import flanagan.interpolation.CubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.physprop.RefrIndex;

public class Sucrose {
    public static final double MOLWEIGHT = 342.3;

    public static double viscosity(double d, double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Temperature, " + d2 + ", out of range");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Concentration, " + d + " g/l, out of range");
        }
        double[] dArray = new double[]{1.0, 1.013, 1.026, 1.039, 1.053, 1.067, 1.082, 1.097, 1.112, 1.128, 1.144, 1.16, 1.177, 1.195, 1.213, 1.232, 1.251, 1.271, 1.291, 1.312, 1.333, 1.378, 1.426, 1.477, 1.531, 1.589, 1.65, 1.716, 1.786, 1.861, 1.941, 2.12, 2.326, 2.568, 2.849, 3.181, 3.754, 4.044, 4.612, 5.304, 6.15, 7.22, 8.579, 10.28, 12.49, 15.4, 19.3, 24.63, 32.06, 42.69, 58.37, 82.26, 119.9, 181.7, 287.9, 480.6, 853.2, 1628.0};
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] * 1.005;
        }
        double[] dArray2 = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 22.0, 24.0, 26.0, 28.0, 30.0, 32.0, 34.0, 36.0, 38.0, 40.0, 42.0, 44.0, 46.0, 48.0, 50.0, 52.0, 54.0, 56.0, 58.0, 60.0, 62.0, 64.0, 66.0, 68.0, 70.0, 72.0, 74.0, 76.0, 78.0, 80.0, 82.0, 84.0};
        double[] dArray3 = new double[]{0.0, 5.0, 10.0, 15.1, 20.1, 25.2, 30.3, 35.4, 40.6, 45.7, 50.9, 56.1, 61.3, 66.5, 71.8, 77.1, 82.4, 87.7, 93.1, 98.4, 103.8, 114.7, 125.6, 136.6, 147.7, 158.9, 170.2, 181.5, 193.0, 204.5, 216.2, 239.8, 263.8, 288.1, 312.9, 338.1, 363.7, 389.8, 416.2, 443.2, 470.6, 498.4, 526.8, 555.6, 584.9, 614.8, 645.1, 676.0, 707.4, 739.3, 771.9, 804.9, 838.6, 872.8, 907.6, 943.1, 979.1, 1015.7, 1053.0, 1090.9, 1129.4, 1168.5, 1208.2};
        ArrayMaths arrayMaths = new ArrayMaths(dArray3);
        double[] dArray4 = new double[]{1.7921, 1.5188, 1.3077, 1.1404, 1.005, 0.8937, 0.8007, 0.7225, 0.656, 0.5988, 0.5454, 0.5064, 0.4688, 0.4355, 0.4061, 0.3799, 0.3565, 0.3355, 0.3165, 0.2994, 0.2838};
        int n4 = dArray4.length;
        double[] dArray5 = new double[]{3.804, 3.154, 2.652, 2.267, 1.96, 1.704, 1.504, 1.331, 1.193, 1.07, 0.97, 0.884, 0.808, 0.742, 0.685, 0.635, 0.59, 0.55};
        int n5 = dArray5.length;
        double[] dArray6 = new double[]{14.77, 11.56, 9.794, 7.468, 6.2, 5.187, 4.382, 3.762, 3.249, 2.847, 2.497, 2.219, 1.982, 1.778, 1.608, 1.462, 1.334, 1.221, 1.123, 1.037, 0.96};
        int n6 = dArray6.length;
        double[] dArray7 = new double[]{238.0, 156.0, 109.8, 74.6, 56.5, 43.86, 33.78, 26.52, 21.28, 17.18, 14.01, 11.67, 9.83, 8.34, 7.15, 6.2, 5.4, 4.73, 4.15, 3.72, 3.34};
        int n7 = dArray7.length;
        double[] dArray8 = new double[n4];
        dArray8[0] = 0.0;
        for (int i = 1; i < n7; ++i) {
            dArray8[i] = dArray8[i - 1] + 5.0;
        }
        ArrayMaths arrayMaths2 = new ArrayMaths(dArray4);
        ArrayMaths arrayMaths3 = new ArrayMaths(dArray5);
        ArrayMaths arrayMaths4 = new ArrayMaths(dArray6);
        ArrayMaths arrayMaths5 = new ArrayMaths(dArray7);
        ArrayMaths arrayMaths6 = new ArrayMaths(dArray8);
        double[] dArray9 = new double[]{0.0, 216.2, 470.6, 771.9};
        double[] dArray10 = new double[]{0.0, 470.6, 771.9};
        double d3 = Double.NaN;
        if (d <= 771.9) {
            if (d2 <= 85.0) {
                int n8 = n5;
                int n9 = arrayMaths.indexOf(771.9);
                double[] dArray11 = arrayMaths6.subarray_as_double(0, n5 - 1);
                double[] dArray12 = arrayMaths.subarray_as_double(0, n9);
                double[][] dArray13 = new double[n8][++n9];
                for (int i = 0; i < n8; ++i) {
                    double[] dArray14 = new double[]{Math.log(dArray4[i]), Math.log(dArray5[i]), Math.log(dArray6[i]), Math.log(dArray7[i])};
                    CubicSpline cubicSpline = new CubicSpline(dArray9, dArray14);
                    for (int j = 0; j < n9; ++j) {
                        dArray13[i][j] = cubicSpline.interpolate(dArray12[j]);
                    }
                }
                BiCubicSpline biCubicSpline = new BiCubicSpline(dArray11, dArray12, dArray13);
                d3 = Math.exp(biCubicSpline.interpolate(d2, d));
            } else {
                if (d2 > 100.0) {
                    throw new IllegalArgumentException("Temperature, " + d2 + ", out of range");
                }
                int n10 = n7;
                int n11 = arrayMaths.indexOf(771.9);
                double[] dArray15 = arrayMaths6.subarray_as_double(0, n10 - 1);
                double[] dArray16 = arrayMaths.subarray_as_double(0, n11);
                double[][] dArray17 = new double[n10][++n11];
                for (int i = 0; i < n10; ++i) {
                    double[] dArray18 = new double[]{Math.log(dArray4[i]), Math.log(dArray6[i]), Math.log(dArray7[i])};
                    CubicSpline cubicSpline = new CubicSpline(dArray10, dArray18);
                    for (int j = 0; j < n11; ++j) {
                        dArray17[i][j] = cubicSpline.interpolate(dArray16[j]);
                    }
                }
                BiCubicSpline biCubicSpline = new BiCubicSpline(dArray15, dArray16, dArray17);
                d3 = Math.exp(biCubicSpline.interpolate(d2, d));
            }
        } else if (d2 == 20.0 && d <= 1208.2) {
            double[] dArray19 = arrayMaths.subarray_as_double(0, n - 1);
            CubicSpline cubicSpline = new CubicSpline(dArray19, dArray);
            d3 = cubicSpline.interpolate(d);
        } else {
            throw new IllegalArgumentException("Concentration, " + d + " g/l,  for this temperature, " + d2 + " C,is out of range");
        }
        return d3;
    }

    public static double refractIndex(double d, double d2) {
        return RefrIndex.sucrose(d, d2);
    }

    public static double solubility(double d) {
        double[] dArray = new double[]{0.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 60.0, 65.0, 70.0, 75.0, 80.0, 85.0, 90.0, 95.0, 100.0};
        double[] dArray2 = new double[]{64.18, 64.87, 65.58, 66.53, 67.09, 67.89, 68.8, 69.55, 70.42, 71.32, 72.25, 73.2, 74.18, 75.88, 76.22, 77.27, 78.36, 79.46, 80.61, 81.77, 82.97};
        double[] dArray3 = new double[]{0.0, -0.00489357, 0.0243743, -0.0350036, 0.0220399, 0.00444386, -0.0134154, 0.0108176, -0.00105492, 6.02123E-4, 0.00584643, -0.0191879, 0.078105, -0.120432, 0.0772233, -0.0180611, 0.00462116, 0.00197648, -5.2706E-4, 0.00253177, 0.0};
        int n = dArray.length;
        if (!(d >= dArray[0]) || !(d <= dArray[n - 1])) {
            throw new IllegalArgumentException("The temperatue is outside the experimental data limits");
        }
        double d2 = CubicSpline.interpolate(d, dArray, dArray2, dArray3);
        d2 = Sucrose.weightpercentToGperl(d2, d);
        return d2;
    }

    public static double density(double d, double d2) {
        double[] dArray = new double[]{0.0, 5.0, 10.0, 15.1, 20.1, 25.2, 30.3, 35.4, 40.6, 45.7, 50.9, 56.1, 61.3, 66.5, 71.8, 77.1, 82.4, 87.7, 93.1, 98.4, 103.8, 114.7, 125.6, 136.6, 147.7, 158.9, 170.2, 181.5, 193.0, 204.5, 216.2, 239.8, 263.8, 288.1, 312.9, 338.1, 363.7, 389.8, 416.2, 443.2, 470.6, 498.4, 526.8, 555.6, 584.9, 614.8, 645.1, 676.0, 707.4, 739.3, 771.9, 804.9, 838.6, 872.8, 907.6, 943.1, 979.1, 1015.7, 1053.0, 1090.9, 1129.4, 1168.5, 1208.2};
        double[] dArray2 = new double[]{998.2, 1000.2, 1002.1, 1004.0, 1006.0, 1007.9, 1009.9, 1011.9, 1013.9, 1015.8, 1017.8, 1019.8, 1021.8, 1023.8, 1025.9, 1027.9, 1029.9, 1032.0, 1034.0, 1036.1, 1038.1, 1042.3, 1046.5, 1050.7, 1054.9, 1059.2, 1063.5, 1067.8, 1072.2, 1076.6, 1081.0, 1089.9, 1099.0, 1108.2, 1117.5, 1127.0, 1136.6, 1146.4, 1156.2, 1166.3, 1176.5, 1186.8, 1197.2, 1207.9, 1218.6, 1229.5, 1240.6, 1251.8, 1263.2, 1274.7, 1286.4, 1298.3, 1310.3, 1322.4, 1334.8, 1347.2, 1359.9, 1372.6, 1385.5, 1398.6, 1411.7, 1425.0, 1438.3};
        double[] dArray3 = new double[]{0.0, -0.00495764, -0.00416945, 0.0126089, -0.0137458, 0.00978735, -0.00233552, -4.45268E-4, -0.00464715, 0.00502912, -0.00144255, 7.41061E-4, -0.0015217, 0.00534573, -0.00654364, -5.311E-4, 0.00866803, -0.0127811, 0.0134147, -0.0118716, 0.00515152, -0.0012962, 3.32699E-5, -7.58744E-4, 0.00112898, -7.70477E-4, 1.45246E-4, 1.89494E-4, 1.89925E-4, -9.49193E-4, 2.23635E-4, 6.85836E-5, 2.005E-5, -2.87156E-4, 2.46234E-4, -2.22108E-4, 1.74076E-4, -3.61684E-4, 2.96689E-4, -1.83935E-4, 4.13755E-5, -3.62702E-4, 4.85174E-4, -4.59014E-4, 4.51875E-5, 1.42595E-4, -2.5712E-4, 1.25835E-4, -1.32083E-4, -8.03786E-5, 1.51752E-4, -2.12951E-4, -1.10921E-4, 2.4994E-4, -4.47536E-4, 3.3998E-4, -3.2882E-4, 2.20206E-5, 5.04017E-5, -2.53039E-4, 1.15168E-4, -2.24291E-4, 0.0};
        double[] dArray4 = new double[]{0.0, 200.0, 400.0, 600.0, 800.0, 1000.0, 1200.0};
        double[] dArray5 = new double[]{9.98363E-4, 9.26078E-4, 8.64741E-4, 8.12717E-4, 7.66724E-4, 7.27182E-4, 6.92587E-4};
        double[] dArray6 = new double[]{0.0, 3.53118E-10, 2.29729E-10, 1.24915E-10, 1.75259E-10, 1.41698E-10, 0.0};
        double[] dArray7 = new double[]{2.42825E-7, 2.60851E-7, 2.61522E-7, 1.52504E-7, 2.35274E-7, 2.1465E-7, 1.91079E-7};
        double[] dArray8 = new double[]{0.0, 1.11593E-12, -7.06697E-12, 1.06986E-11, -6.95925E-12, 1.6293E-12, 0.0};
        int n = dArray4.length;
        if (!(d >= dArray4[0] && d <= dArray4[n - 1] && d2 >= 0.0 && d2 <= 50.0)) {
            throw new IllegalArgumentException("Either Temperature or Concentration is outside the experimental data limits");
        }
        double d3 = CubicSpline.interpolate(d, dArray4, dArray5, dArray6);
        double d4 = CubicSpline.interpolate(d, dArray4, dArray7, dArray8);
        double d5 = 1.0 / (d3 + d4 * d2);
        return d5;
    }

    public static double specificVolume(double d) {
        double[] dArray = new double[]{0.0, 5.0, 10.0, 15.1, 20.1, 25.2, 30.3, 35.4, 40.6, 45.7, 50.9, 56.1, 61.3, 66.5, 71.8, 77.1, 82.4, 87.7, 93.1, 98.4, 103.8, 114.7, 125.6, 136.6, 147.7, 158.9, 170.2, 181.5, 193.0, 204.5, 216.2, 239.8, 263.8, 288.1, 312.9, 338.1, 363.7, 389.8, 416.2, 443.2, 470.6, 498.4, 526.8, 555.6, 584.9, 614.8, 645.1, 676.0, 707.4, 739.3, 771.9, 804.9, 838.6, 872.8, 907.6, 943.1, 979.1, 1015.7, 1053.0, 1090.9, 1129.4, 1168.5, 1208.2};
        double[] dArray2 = new double[]{6.21118E-4, 6.21118E-4, 6.21118E-4, 6.17005E-4, 6.18028E-4, 6.16189E-4, 6.14968E-4, 6.1693E-4, 6.14406E-4, 6.15988E-4, 6.1604E-4, 6.16082E-4, 6.16117E-4, 6.16147E-4, 6.16709E-4, 6.15895E-4, 6.16401E-4, 6.16846E-4, 6.16577E-4, 6.16964E-4, 6.16717E-4, 6.16629E-4, 6.17353E-4, 6.1751E-4, 6.17225E-4, 6.17222E-4, 6.17445E-4, 6.18193E-4, 6.18211E-4, 6.18228E-4, 6.18597E-4, 6.18712E-4, 6.19007E-4, 6.19651E-4, 6.19844E-4, 6.20164E-4, 6.20584E-4, 6.20923E-4, 6.21494E-4, 6.21832E-4, 6.22455E-4, 6.22911E-4, 6.2337E-4, 6.23873E-4, 6.24478E-4, 6.24905E-4, 6.2537E-4, 6.25979E-4, 6.26516E-4, 6.27126E-4, 6.27766E-4, 6.28414E-4, 6.28964E-4, 6.29685E-4, 6.30377E-4, 6.3108E-4, 6.31819E-4, 6.32624E-4, 6.33334E-4, 6.34105E-4, 6.35019E-4, 6.3589E-4, 6.36886E-4};
        double[] dArray3 = new double[]{0.0, 9.54239E-8, -3.81696E-7, 4.69472E-7, -2.94053E-7, 3.9486E-8, 2.78669E-7, -4.19907E-7, 3.86217E-7, -1.95897E-7, 5.08841E-8, -9.858E-9, -1.30053E-8, 6.07699E-8, -1.14515E-7, 1.03377E-7, -1.70413E-8, -4.82412E-8, 5.92625E-8, -5.10779E-8, 1.22998E-8, 9.25257E-9, -8.30337E-9, -4.55102E-9, 4.7569E-9, -8.20925E-10, 9.1751E-9, -1.12103E-8, 1.71621E-9, 4.30015E-9, -3.32497E-9, 1.03549E-9, 1.01682E-9, -1.55614E-9, 6.3652E-10, 1.76082E-10, -4.56375E-10, 8.49619E-10, -9.64276E-10, 9.59006E-10, -6.2015E-10, 1.50421E-10, -3.91772E-11, 2.78811E-10, -4.15371E-10, 9.3832E-11, 2.48046E-10, -2.27533E-10, 1.60667E-10, -3.36646E-11, 6.9795E-11, -2.4342E-10, 3.04857E-10, -1.35319E-10, 3.06608E-11, -2.68355E-12, 1.01252E-10, -1.58595E-10, 5.29862E-11, 1.52913E-10, -1.29603E-10, 1.39208E-10, 0.0};
        double d2 = 6.21903E-4;
        int n = dArray.length;
        double d3 = d >= dArray[0] && d <= dArray[n - 1] ? CubicSpline.interpolate(d, dArray, dArray2, dArray3) : d2;
        return d3;
    }

    public static double diffCoeff(double d, double d2) {
        double d3 = d2 - -273.15;
        double d4 = Sucrose.viscosity(d, d2);
        double d5 = Sucrose.specificVolume(d);
        double d6 = 342.3 * d5 / 6.0221419947E26;
        double d7 = Math.pow(3.0 * d6 / (Math.PI * 4), 0.3333333333333333);
        double d8 = Math.PI * 6 * d4 * d7;
        double d9 = 1.380650324E-23 * d3 / d8;
        return d9;
    }

    public static double moleFraction(double d, double d2) {
        double d3 = d * 1000.0;
        double d4 = d3 / 342.3;
        double d5 = Sucrose.density(d, d2) * 1000.0;
        double d6 = (d5 - d3) / 18.02;
        return d4 / (d6 + d4);
    }

    public static double molarToGperl(double d) {
        return d * 342.3;
    }

    public static double molarToWeightpercent(double d, double d2) {
        double d3 = Sucrose.molarToGperl(d);
        d3 = Sucrose.gperlToWeightpercent(d3, d2);
        return d3;
    }

    public static double gperlToMolar(double d) {
        return d / 342.3;
    }

    public static double gperlToWeightpercent(double d, double d2) {
        double[] dArray = new double[]{0.0, 5.0, 10.0, 15.1, 20.1, 25.2, 30.3, 35.4, 40.6, 45.7, 50.9, 56.1, 61.3, 66.5, 71.8, 77.1, 82.4, 87.7, 93.1, 98.4, 103.8, 114.7, 125.6, 136.6, 147.7, 158.9, 170.2, 181.5, 193.0, 204.5, 216.2, 239.8, 263.8, 288.1, 312.9, 338.1, 363.7, 389.8, 416.2, 443.2, 470.6, 498.4, 526.8, 555.6, 584.9, 614.8, 645.1, 676.0, 707.4, 739.3, 771.9, 804.9, 838.6, 872.8, 907.6, 943.1, 979.1, 1015.7, 1053.0, 1090.9, 1129.4, 1168.5, 1208.2};
        double[] dArray2 = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 22.0, 24.0, 26.0, 28.0, 30.0, 32.0, 34.0, 36.0, 38.0, 40.0, 42.0, 44.0, 46.0, 48.0, 50.0, 52.0, 54.0, 56.0, 58.0, 60.0, 62.0, 64.0, 66.0, 68.0, 70.0, 72.0, 74.0, 76.0, 78.0, 80.0, 82.0, 84.0};
        double[] dArray3 = new double[]{0.0, 2.24325E-4, -8.973E-4, 0.00102728, -8.82025E-4, 1.7957E-4, 1.63747E-4, -8.34558E-4, 9.70111E-4, -8.49482E-4, 2.38375E-4, -1.04019E-4, 1.77701E-4, -6.06786E-4, 1.76058E-4, -9.74476E-5, 2.13732E-4, -7.5748E-4, 8.50948E-4, -6.86359E-4, -5.6318E-5, 4.08684E-5, -1.07156E-4, -6.87474E-5, -6.27622E-5, -1.12854E-4, 9.20828E-5, -2.55477E-4, 1.19556E-4, -2.22749E-4, 3.59124E-6, -8.44627E-5, -2.16033E-5, -8.47265E-5, -4.4802E-5, -4.36141E-5, -7.34483E-5, -1.02994E-5, -8.43266E-5, -3.04826E-5, -3.26613E-5, -6.69242E-5, -2.42674E-5, -4.13785E-5, -5.47191E-5, -1.76386E-5, -5.07722E-5, -3.04569E-5, -2.61186E-5, -5.41411E-5, -7.97549E-6, -5.00124E-5, -1.83509E-5, -3.00707E-5, -3.65588E-5, -1.72617E-5, -2.57937E-5, -2.9995E-5, -2.0797E-5, -2.23338E-5, -1.90539E-5, -2.47041E-5, 0.0};
        double d3 = d * 0.1 / (Sucrose.density(d, d2) / 1000.0);
        return d3;
    }

    public static double weightpercentToMolar(double d, double d2) {
        double d3 = Sucrose.weightpercentToGperl(d, d2);
        d3 = Sucrose.gperlToMolar(d3);
        return d3;
    }

    public static double weightpercentToGperl(double d, double d2) {
        double[] dArray = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 22.0, 24.0, 26.0, 28.0, 30.0, 32.0, 34.0, 36.0, 38.0, 40.0, 42.0, 44.0, 46.0, 48.0, 50.0, 52.0, 54.0, 56.0, 58.0, 60.0, 62.0, 64.0, 66.0, 68.0, 70.0, 72.0, 74.0, 76.0, 78.0, 80.0, 82.0, 84.0};
        double[] dArray2 = new double[]{0.0, 5.0, 10.0, 15.1, 20.1, 25.2, 30.3, 35.4, 40.6, 45.7, 50.9, 56.1, 61.3, 66.5, 71.8, 77.1, 82.4, 87.7, 93.1, 98.4, 103.8, 114.7, 125.6, 136.6, 147.7, 158.9, 170.2, 181.5, 193.0, 204.5, 216.2, 239.8, 263.8, 288.1, 312.9, 338.1, 363.7, 389.8, 416.2, 443.2, 470.6, 498.4, 526.8, 555.6, 584.9, 614.8, 645.1, 676.0, 707.4, 739.3, 771.9, 804.9, 838.6, 872.8, 907.6, 943.1, 979.1, 1015.7, 1053.0, 1090.9, 1129.4, 1168.5, 1208.2};
        double[] dArray3 = new double[]{0.0, -0.230536, 0.922143, -1.05804, 0.909999, -0.181959, -0.182163, 0.910611, -1.06028, 0.930517, -0.261788, 0.116633, -0.204746, 0.702351, -0.204657, 0.116276, -0.260447, 0.925512, -1.0416, 0.840888, 0.078047, -0.0545852, 0.140294, 0.0934103, 0.0860649, 0.16233, -0.135385, 0.37921, -0.181457, 0.346616, -0.00500719, 0.141714, 0.0381529, 0.155675, 0.0891471, 0.0877366, 0.159906, 0.0226375, 0.199544, 0.0791879, 0.0837046, 0.185994, 0.0723209, 0.124723, 0.178788, 0.0601258, 0.180709, 0.117039, 0.101137, 0.228414, 0.0352078, 0.230755, 0.0917725, 0.152155, 0.199608, 0.0994148, 0.152733, 0.189652, 0.138658, 0.155717, 0.138476, 0.190381, 0.0};
        double d3 = 0.0;
        int n = dArray.length;
        int n2 = -1;
        int n3 = 1000;
        boolean bl = true;
        if (d < dArray[0] || d > dArray[n - 1]) {
            throw new IllegalArgumentException("concentration is outside the experimental data limits");
        }
        double d4 = d * 1.0E-4;
        double d5 = 0.0;
        double d6 = 1200.0;
        double d7 = d5 - d * Sucrose.density(d5, d2) / 100.0;
        double d8 = d6 - d * Sucrose.density(d6, d2) / 100.0;
        if (d7 > 0.0 && d8 > 0.0 || d7 < 0.0 && d8 < 0.0) {
            throw new IllegalArgumentException("Root must be bracketed in the bisection");
        }
        bl = true;
        while (bl) {
            if (d7 == 0.0) {
                d3 = d5;
                bl = false;
            }
            if (d8 == 0.0) {
                d3 = d6;
                bl = false;
            }
            if (!bl) continue;
            double d9 = 0.5 * (d5 + d6);
            double d10 = d9 - d * Sucrose.density(d9, d2) / 100.0;
            if (d10 == 0.0) {
                d3 = d9;
                bl = false;
            } else {
                if (d10 * d7 > 0.0) {
                    d5 = d9;
                } else {
                    d6 = d9;
                }
                d7 = d5 - d * Sucrose.density(d5, d2) / 100.0;
                d8 = d6 - d * Sucrose.density(d6, d2) / 100.0;
                if (Math.abs(d5 - d6) < d4) {
                    d3 = 0.5 * (d5 + d6);
                    bl = false;
                }
            }
            if (++n2 <= n3) continue;
            throw new IllegalArgumentException("number of iteractions in bisection exceeded");
        }
        return d3;
    }
}

