/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physprop;

import flanagan.physprop.Water;

public class Pva {
    public static double viscosity(double d, double d2, double d3) {
        double d4 = 4.53E-4 * Math.pow(d2, 0.64);
        double d5 = d4 * 1.07;
        double d6 = d5 * Math.pow(1.07, -(d3 - 20.0) / 10.0);
        double d7 = d / 10.0;
        double d8 = d7 * (d6 + 0.201 * d7 * Math.pow(d6, 2.28));
        double d9 = Water.viscosity(d3);
        double d10 = (d8 + 1.0) * d9;
        return d10;
    }

    public static double density(double d, double d2) {
        double d3 = 1000.0 * (0.99565 + (0.00248 - 1.09 / d2) * (d /= 10.0) + (6.4E-5 - 0.39 / d2) * d * d);
        return d3;
    }

    public static double specificVolume() {
        return 7.65E-4;
    }

    public static double diffCoeff(double d, double d2, double d3) {
        double d4 = d3 - -273.15;
        double d5 = Pva.viscosity(d, d2, d3);
        double d6 = Pva.specificVolume();
        double d7 = d2 * d6 / 6.0221419947E26;
        double d8 = Math.pow(3.0 * d7 / (Math.PI * 4), 0.3333333333333333);
        double d9 = Math.PI * 6 * d5 * d8;
        double d10 = 1.380650324E-23 * d4 / d9;
        return d10;
    }

    public static double refractIndex(double d, double d2, double d3) {
        double d4 = -0.998419;
        double d5 = -1.87778E-17;
        double d6 = Water.refractIndex(d2, d3);
        double d7 = 1.0 + d4 * (1.0 + d5 / Math.pow(d2, 2.0));
        double d8 = d6 + d7 * d / 10.0;
        return d8;
    }
}

