/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.analysis.Stat;

public class ImmunoChemistry {
    private static double molecularWeightIgG1 = 146000.0;
    private static double molecularWeightIgG2 = 146000.0;
    private static double molecularWeightIgG3 = 170000.0;
    private static double molecularWeightIgG4 = 146000.0;
    private static double molecularWeightIgM = 970000.0;
    private static double molecularWeightIgA1 = 160000.0;
    private static double molecularWeightIgA2 = 160000.0;
    private static double molecularWeightIgD = 184000.0;
    private static double molecularWeightIgE = 188000.0;

    public static double diffusionCoefficient(double d, double d2, double d3) {
        double d4 = d3 - -273.15;
        double d5 = Math.PI * 6 * d2 * d;
        return 1.380650324E-23 * d4 / d5;
    }

    public static double diffusionCoefficient(double d, double d2, double d3, double d4) {
        double d5 = d4 - -273.15;
        double d6 = d * d2 / 6.0221419947E26;
        double d7 = Math.pow(3.0 * d6 / (Math.PI * 4), 0.3333333333333333);
        double d8 = Math.PI * 6 * d3 * d7;
        return 1.380650324E-23 * d5 / d8;
    }

    public static double oneDimensionalDiffusion(double d, double d2, double d3, double d4) {
        double d5 = d3 / (2.0 * Math.sqrt(d * d4));
        return d2 * Stat.erfc(d5);
    }

    public static double diffusionControlledRate(double d, double d2, double d3, double d4, double d5, double d6) {
        return 7.567646819769641E24 * d5 * d6 * (d + d2) * (d3 + d4) * 0.001;
    }

    public static double molecularRadius(double d, double d2) {
        double d3 = d / 6.0221419947E23;
        double d4 = d3 * 0.001 * d2;
        return Math.pow(d4 * 3.0 / (Math.PI * 4), 0.3333333333333333);
    }

    public static double molecularRadius(double d) {
        return ImmunoChemistry.molecularRadius(d, 7.4E-4);
    }

    public static double effectiveRadius(double d, double d2, double d3) {
        double d4 = d3 - -273.15;
        double d5 = Math.PI * 6 * d2 * d;
        return 1.380650324E-23 * d4 / d5;
    }

    public static double surfaceNumberConcn(double d) {
        double d2 = 2.0 * d * Math.sqrt(3.0);
        double d3 = 1.0 / d2;
        return d3;
    }

    public static double surfaceNumberConcn(double d, double d2) {
        double d3 = d / 6.0221419947E23;
        double d4 = d3 * 0.001 * d2;
        double d5 = Math.pow(d4 * 3.0 / (Math.PI * 4), 0.3333333333333333);
        double d6 = 2.0 * d5 * Math.sqrt(3.0);
        double d7 = 1.0 / d6;
        return d7;
    }

    public static double surfaceMolarConcn(double d) {
        double d2 = ImmunoChemistry.surfaceNumberConcn(d);
        return d2 / 6.0221419947E23;
    }

    public static double surfaceMolarConcn(double d, double d2) {
        double d3 = ImmunoChemistry.surfaceNumberConcn(d, d2);
        return d3 / 6.0221419947E23;
    }

    public static double convertSurfaceToVolumeConcn(double d, double d2, double d3) {
        return d * d2 * 0.001 / d3;
    }

    public static double equivalentVolumeConcn(double d, double d2, double d3) {
        double d4 = ImmunoChemistry.surfaceMolarConcn(d);
        return d4 * d2 * 0.001 / d3;
    }

    public static double equivalentVolumeConcn(double d, double d2, double d3, double d4) {
        double d5 = ImmunoChemistry.surfaceMolarConcn(d, d4);
        return d5 * d2 * 0.001 / d3;
    }

    public static double getMolWeightIgG1() {
        return molecularWeightIgG1;
    }

    public static double getMolWeightIgG2() {
        return molecularWeightIgG2;
    }

    public static double getMolWeightIgG3() {
        return molecularWeightIgG3;
    }

    public static double getMolWeightIgG4() {
        return molecularWeightIgG4;
    }

    public static double getMolWeightIgM() {
        return molecularWeightIgM;
    }

    public static double getMolWeightIgA1() {
        return molecularWeightIgA1;
    }

    public static double getMolWeightIgA2() {
        return molecularWeightIgA2;
    }

    public static double getMolWeightIgD() {
        return molecularWeightIgD;
    }

    public static double getMolWeightIgE() {
        return molecularWeightIgE;
    }
}

