/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.integration.Integration;
import flanagan.io.Db;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.math.Minimisation;
import flanagan.math.MinimisationFunction;
import flanagan.physchem.FunctionPatX;
import flanagan.physchem.GCSminim;
import flanagan.physprop.IonicRadii;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class GouyChapmanStern {
    private ArrayList<Object> vec = new ArrayList();
    private boolean unpackArrayList = false;
    private int numOfIons = 0;
    private int numOfAnions = 0;
    private int numOfCations = 0;
    private String[] ionNames = null;
    private double[] initConcnM = null;
    private double[] initConcn = null;
    private double[] siteConcn = null;
    private double[] sternConcn = null;
    private double[] bulkConcn = null;
    private double electrolyteConcn = 0.0;
    private double ionicStrength = 0.0;
    private int[] indexK = null;
    private int nonZeroAssocK = 0;
    private double[] radii = null;
    private boolean radiusType = true;
    private double[] charges = null;
    private double tolNeutral = 1.0E-6;
    private double[] assocConstsM = null;
    private double[] assocConsts = null;
    private double surfaceSiteDensity = 0.0;
    private double freeSurfaceSiteDensity = 0.0;
    private boolean surfaceDensitySet = false;
    private double epsilon = 0.0;
    private double epsilonStern = 0.0;
    private boolean epsilonSet = false;
    private double temp = 25.0;
    private double tempK = 298.15;
    private boolean tempSet = false;
    private double surfacePotential = 0.0;
    private boolean psi0set = false;
    private double diffPotential = 0.0;
    private double sternPotential = 0.0;
    private double surfaceArea = 1.0;
    private boolean surfaceAreaSet = false;
    private double volume = 1.0;
    private boolean volumeSet = false;
    private double sternCap = 0.0;
    private double diffCap = 0.0;
    private double totalCap = 0.0;
    private double sternDelta = 0.0;
    private double chargeValue = 0.0;
    private boolean chargeSame = true;
    private double averageCharge = 0.0;
    private double surfaceChargeDensity = 0.0;
    private double adsorbedChargeDensity = 0.0;
    private double diffuseChargeDensity = 0.0;
    private boolean sigmaSet = false;
    private double surfaceCharge = 0.0;
    private boolean chargeSet = false;
    private double recipKappa = 0.0;
    private boolean sternOption = true;
    private double expTerm = 0.0;
    private double expTermOver2 = 0.0;
    private double twoTerm = 0.0;
    private double eightTerm = 0.0;

    public void setHydratedRadii() {
        this.radiusType = true;
    }

    public void setBareRadii() {
        this.radiusType = false;
    }

    public void ignoreStern() {
        this.sternOption = false;
    }

    public void includeStern() {
        this.sternOption = true;
    }

    public void setIon(String string, double d, double d2, int n, double d3) {
        this.vec.add(string);
        this.vec.add(new Double(d));
        this.vec.add(new Double(d2));
        this.vec.add(new Integer(n));
        this.vec.add(new Double(d3));
        if (d3 != 0.0) {
            ++this.nonZeroAssocK;
        }
        ++this.numOfIons;
        this.unpackArrayList = false;
    }

    public void setIon(String string, double d, double d2, int n) {
        this.vec.add(string);
        this.vec.add(new Double(d));
        this.vec.add(new Double(d2));
        this.vec.add(new Integer(n));
        this.vec.add(new Double(0.0));
        ++this.numOfIons;
        this.unpackArrayList = false;
    }

    public void setIon(String string, double d, double d2) {
        String string2;
        IonicRadii ionicRadii = new IonicRadii();
        this.vec.add(string);
        this.vec.add(new Double(d));
        double d3 = 0.0;
        d3 = this.radiusType ? IonicRadii.hydratedRadius(string) : IonicRadii.radius(string);
        if (d3 == 0.0) {
            String string3 = string + " radius is not in the IonicRadii list\n";
            string2 = "Please enter radius in metres\n";
            d3 = Db.readDouble(string3 + string2);
        }
        this.vec.add(new Double(d3));
        int n = 0;
        n = IonicRadii.charge(string);
        if (n == 0) {
            string2 = string + " charge is not in the IonicRadii list\n";
            String string4 = "Please enter charge as, e.g +2";
            n = Db.readInt(string2 + string4);
        }
        this.vec.add(new Integer(n));
        this.vec.add(new Double(d2));
        if (d2 != 0.0) {
            ++this.nonZeroAssocK;
        }
        ++this.numOfIons;
        this.unpackArrayList = false;
    }

    public void setIon(String string, double d) {
        String string2;
        IonicRadii ionicRadii = new IonicRadii();
        this.vec.add(string);
        this.vec.add(new Double(d));
        double d2 = 0.0;
        d2 = this.radiusType ? IonicRadii.hydratedRadius(string) : IonicRadii.radius(string);
        if (d2 == 0.0) {
            String string3 = string + " radius is not in the IonicRadii list\n";
            string2 = "Please enter radius in metres\n";
            d2 = Db.readDouble(string3 + string2);
        }
        this.vec.add(new Double(d2));
        int n = 0;
        n = IonicRadii.charge(string);
        if (n == 0) {
            string2 = string + " charge is not in the IonicRadii list\n";
            String string4 = "Please enter charge as, e.g +2";
            n = Db.readInt(string2 + string4);
        }
        this.vec.add(new Integer(n));
        this.vec.add(new Double(0.0));
        ++this.numOfIons;
        this.unpackArrayList = false;
    }

    public void setSurfaceSiteDensity(double d) {
        this.surfaceSiteDensity = d / 6.0221419947E23;
        this.surfaceDensitySet = true;
    }

    public void setSurfaceArea(double d) {
        this.surfaceArea = d;
        this.surfaceAreaSet = true;
    }

    public void setVolume(double d) {
        this.volume = d;
        this.volumeSet = true;
    }

    public void setRelPerm(double d, double d2) {
        this.epsilon = d;
        this.epsilonStern = d2;
        this.epsilonSet = true;
    }

    public void setRelPerm(double d) {
        this.epsilon = d;
        this.epsilonSet = true;
    }

    public void setTemp(double d) {
        this.tempK = d - -273.15;
        this.tempSet = true;
    }

    public void setSurfaceChargeDensity(double d) {
        if (this.psi0set) {
            System.out.println("You have already entered a surface potential");
            System.out.println("This class allows the calculation of a surface charge density for a given surface potential");
            System.out.println("or the calculation of a surface potential for a given surface charge density");
            System.out.println("The previously entered surface potential will now be ignored");
            this.psi0set = false;
        }
        this.surfaceChargeDensity = d;
        this.sigmaSet = true;
        if (this.surfaceAreaSet) {
            this.surfaceCharge = d * this.surfaceArea;
            this.chargeSet = true;
        }
    }

    public void setSurfaceCharge(double d, double d2) {
        if (this.psi0set) {
            System.out.println("You have already entered a surface potential");
            System.out.println("This class allows the calculation of a surface charge density for a given surface potential");
            System.out.println("or the calculation of a surface potential for a given surface charge density");
            System.out.println("The previously entered surface potential will now be ignored");
            this.psi0set = false;
        }
        this.surfaceCharge = d;
        this.chargeSet = true;
        this.surfaceArea = d2;
        this.surfaceAreaSet = true;
        this.surfaceChargeDensity = d / this.surfaceArea;
        this.sigmaSet = true;
    }

    public void setSurfaceCharge(double d) {
        if (this.psi0set) {
            System.out.println("You have already entered a surface potential");
            System.out.println("This class allows the calculation of a surface charge density for a given surface potential");
            System.out.println("or the calculation of a surface potential for a given surface charge density");
            System.out.println("The previously entered surface potential will now be ignored");
            this.psi0set = false;
        }
        this.surfaceCharge = d;
        this.chargeSet = true;
        if (this.surfaceAreaSet) {
            this.surfaceChargeDensity = d / this.surfaceArea;
            this.sigmaSet = true;
        }
    }

    public void setSurfacePotential(double d) {
        if (this.sigmaSet) {
            System.out.println("You have already entered a surface charge density");
            System.out.println("This class allows the calculation of a surface potential for a given surface charge density");
            System.out.println("or the calculation of a surface charge density for a given surface potential");
            System.out.println("The previously entered surface charge density will now be ignored");
            this.sigmaSet = false;
        }
        this.surfacePotential = d;
        this.psi0set = true;
    }

    public double getDiffuseLayerPotential() {
        if (!this.sternOption) {
            System.out.println("Class: GouyChapmanStern\nMethod: getDiffuseLayerPotential\nThe Stern modification was not included");
            System.out.println("The value of the diffuse layer potential has been set equal to the surface potential");
            return this.getSurfacePotential();
        }
        if (this.psi0set && this.sigmaSet) {
            return this.diffPotential;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.diffPotential;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.diffPotential;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getDiffuseLayerPotential\nThe value of the diffuse layer potential has not been calculated\nzero returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return 0.0;
    }

    public double getSternLayerPotential() {
        if (!this.sternOption) {
            System.out.println("Class: GouyChapmanStern\nMethod: getSternLayerPotential\nThe Stern modification has not been included");
            System.out.println("The value of zero has been returned");
            return 0.0;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.sternPotential;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.sternPotential;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.sternPotential;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getSternLayerPotential\nThe value of the Stern layer potential has not been calculated\nzero returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return 0.0;
    }

    public double getSternCapPerSquareMetre() {
        if (!this.sternOption) {
            System.out.println("Class: GouyChapmanStern\nMethod: getSternCapacitance\nThe Stern modification has not been included");
            System.out.println("A value of infinity has been returned");
            return Double.POSITIVE_INFINITY;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.sternCap;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.sternCap;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.sternCap;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getSternCap\nThe value of the Stern capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getSternCapacitance() {
        if (!this.sternOption) {
            System.out.println("Class: GouyChapmanStern\nMethod: getSternCapacitance\nThe Stern modification has not been included");
            System.out.println("A value of infinity has been returned");
            return Double.POSITIVE_INFINITY;
        }
        if (!this.surfaceAreaSet) {
            System.out.println("Class: GouyChapmanStern\nMethod: getSternCapacitance\nThe surface area has not bee included");
            System.out.println("A value per square metre has been returned");
            return this.sternCap;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.sternCap * this.surfaceArea;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.sternCap * this.surfaceArea;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.sternCap * this.surfaceArea;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getSternCapacitance\nThe value of the Stern capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getDiffuseLayerCapPerSquareMetre() {
        if (this.psi0set && this.sigmaSet) {
            return this.diffCap;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.diffCap;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.diffCap;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getDiffuseLayerCapPerSquareMetre\nThe value of the diffuse layer capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getDiffuseLayerCapacitance() {
        if (!this.surfaceAreaSet) {
            System.out.println("Class: GouyChapmanStern\nMethod: getDiffuseLayerCapacitance\nThe surface area has not bee included");
            System.out.println("A value per square metre has been returned");
            return this.diffCap;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.diffCap * this.surfaceArea;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.diffCap * this.surfaceArea;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.diffCap * this.surfaceArea;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getDiffuseLayerCap\nThe value of the diffuse layer capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getTotalCapPerSquareMetre() {
        if (this.psi0set && this.sigmaSet) {
            return this.totalCap;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.totalCap;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.totalCap;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getTotalCapPerSquareMetre\nThe value of the total capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getTotalCapacitance() {
        if (!this.surfaceAreaSet) {
            System.out.println("Class: GouyChapmanStern\nMethod: getTotalCapacitance\nThe surface area has not bee included");
            System.out.println("A value per square metre has been returned");
            return this.diffCap;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.totalCap * this.surfaceArea;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.totalCap * this.surfaceArea;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.totalCap * this.surfaceArea;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getTotalCapacitance\nThe value of the total capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getSternThickness() {
        if (!this.sternOption) {
            System.out.println("Class: GouyChapmanStern\nMethod: getSternThickness");
            System.out.println("The Stern modification has not been included");
            System.out.println("A value of zero has been returned");
            return 0.0;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.sternDelta;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.sternDelta;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.sternDelta;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getSternThickness\nThe value of the Stern thickness has not been calculated\nzero returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return 0.0;
    }

    public double getDebyeLength() {
        if (!this.unpackArrayList) {
            this.unpack();
        }
        return this.calcDebyeLength();
    }

    private double calcDebyeLength() {
        if (!this.epsilonSet) {
            throw new IllegalArgumentException("The relative permittivitie/s have not been entered");
        }
        if (!this.tempSet) {
            System.out.println("The temperature has not been entered\na value of 25 degrees Celsius has been used");
        }
        double d = 2.0 * Fmath.square(-1.60217646263E-19) * 6.0221419947E23 / (8.854187817E-12 * this.epsilon * 1.380650324E-23 * this.tempK);
        this.recipKappa = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            this.recipKappa += this.bulkConcn[i] * this.charges[i] * this.charges[i];
        }
        this.recipKappa = 1.0 / Math.sqrt(this.recipKappa * d);
        return this.recipKappa;
    }

    public double getIonicStrength() {
        if (!this.unpackArrayList) {
            this.unpack();
        }
        return this.ionicStrength;
    }

    private void unpack() {
        int n;
        if (this.numOfIons == 0) {
            throw new IllegalArgumentException("No ions have been entered");
        }
        this.ionNames = new String[this.numOfIons];
        this.siteConcn = new double[this.numOfIons];
        this.sternConcn = new double[this.numOfIons];
        this.initConcnM = new double[this.numOfIons];
        this.initConcn = new double[this.numOfIons];
        this.bulkConcn = new double[this.numOfIons];
        this.radii = new double[this.numOfIons];
        this.charges = new double[this.numOfIons];
        this.assocConsts = new double[this.numOfIons];
        this.assocConstsM = new double[this.numOfIons];
        this.indexK = new int[this.nonZeroAssocK];
        Double d = null;
        Integer n2 = null;
        int n3 = 0;
        this.chargeValue = 0.0;
        this.chargeSame = true;
        for (int i = 0; i < this.numOfIons; ++i) {
            this.ionNames[i] = (String)this.vec.get(0 + i * 5);
            d = (Double)this.vec.get(1 + i * 5);
            this.initConcnM[i] = d;
            this.initConcn[i] = this.initConcnM[i] * 1000.0;
            d = (Double)this.vec.get(2 + i * 5);
            this.radii[i] = d;
            n2 = (Integer)this.vec.get(3 + i * 5);
            this.charges[i] = n2.intValue();
            d = (Double)this.vec.get(4 + i * 5);
            this.assocConstsM[i] = d;
            this.assocConsts[i] = this.assocConstsM[i] * 0.001;
            if (this.assocConsts[i] > 0.0) {
                this.indexK[n3] = i;
                ++n3;
            }
            if (i == 0) {
                this.chargeValue = Math.abs(this.charges[0]);
            } else if (Math.abs(this.charges[i]) != this.chargeValue) {
                this.chargeSame = false;
            }
            if (this.charges[i] < 0.0) {
                ++this.numOfAnions;
            } else {
                ++this.numOfCations;
            }
            if (this.surfaceSiteDensity != 0.0) continue;
            this.nonZeroAssocK = 0;
        }
        this.averageCharge = 0.0;
        this.ionicStrength = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            if (this.charges[i] > 0.0) {
                d3 += this.initConcn[i] * this.charges[i];
            } else {
                d4 += this.initConcn[i] * this.charges[i];
            }
            d2 = d3 + d4;
        }
        if (Math.abs(d2) > d3 * this.tolNeutral) {
            String string = "Class: GouyChapmanStern, method: unpack()\n";
            String string2 = "Total charge = " + d2 + " mol/dm, i.e. is not equal to zero\n";
            String string3 = "Positive charge = " + d3 + " mol/dm\n";
            String string4 = "Do you wish to continue?";
            String string5 = string + string2 + string3 + string4;
            int n4 = JOptionPane.showConfirmDialog(null, string5, "Neutrality check", 0, 3);
            if (n4 == 1) {
                System.exit(0);
            }
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        for (n = 0; n < this.numOfIons; ++n) {
            this.ionicStrength += this.initConcn[n] * this.charges[n] * this.charges[n];
            if (this.charges[n] > 0.0) {
                d8 += this.initConcn[n];
            } else {
                d7 += this.initConcn[n];
            }
            if (!(this.initConcn[n] > 0.0)) continue;
            d5 += this.initConcn[n] * Math.abs(this.charges[n]);
            d6 += this.initConcn[n];
        }
        this.ionicStrength = this.ionicStrength * 0.001 / 2.0;
        this.averageCharge = d5 / d6;
        this.electrolyteConcn = (d7 + d8) / 2.0;
        for (n = 0; n < this.numOfIons; ++n) {
            this.bulkConcn[n] = this.initConcn[n];
            this.siteConcn[n] = 0.0;
            this.sternConcn[n] = 0.0;
        }
        this.expTerm = 1.60217646263E-19 / (1.380650324E-23 * this.tempK);
        this.expTermOver2 = this.expTerm / 2.0;
        this.twoTerm = 1.4723579861882691E-10 * this.epsilon * this.tempK;
        this.eightTerm = 4.0 * this.twoTerm;
        this.unpackArrayList = true;
    }

    public double getSurfaceChargeDensity() {
        if (this.sigmaSet && this.psi0set) {
            return this.surfaceChargeDensity;
        }
        if (!this.psi0set) {
            throw new IllegalArgumentException("No surface potential has been entered");
        }
        return this.getSurfaceChargeDensity(this.surfacePotential);
    }

    public double getSurfaceChargeDensity(double d) {
        this.surfaceChargeDensity = this.calcSurfaceChargeDensity(d);
        this.sigmaSet = true;
        if (this.surfaceAreaSet) {
            this.surfaceCharge = this.surfaceChargeDensity * this.surfaceArea;
            this.chargeSet = true;
        }
        return this.surfaceChargeDensity;
    }

    private double calcSurfaceChargeDensity(double d) {
        double d2 = 0.0;
        if (!this.epsilonSet) {
            throw new IllegalArgumentException("The relative permittivitie/s have not been entered");
        }
        if (!this.tempSet) {
            System.out.println("The temperature has not been entered\na value of 25 degrees Celsius has been used");
        }
        if (!this.unpackArrayList) {
            this.unpack();
        }
        if (this.sternOption) {
            if (!this.surfaceAreaSet) {
                throw new IllegalArgumentException("The surface area has not been entered");
            }
            if (!this.volumeSet) {
                throw new IllegalArgumentException("The electrolyte volume has not been entered");
            }
            d2 = this.nonZeroAssocK == 0 ? (this.chargeSame ? this.surfaceChargeDensity0(d) : this.surfaceChargeDensity1(d)) : (this.chargeSame ? this.surfaceChargeDensity2(d) : this.surfaceChargeDensity3(d));
        } else if (this.chargeSame) {
            d2 = Math.sqrt(this.eightTerm * this.electrolyteConcn) * Fmath.sinh(this.chargeValue * this.expTermOver2 * d);
        } else {
            double d3 = 0.0;
            for (int i = 0; i < this.numOfIons; ++i) {
                d3 += this.bulkConcn[i] * (Math.exp(-this.expTerm * d * this.charges[i]) - 1.0);
            }
            d2 = Fmath.sign(d) * Math.sqrt(this.twoTerm * d3);
        }
        this.totalCap = d2 / d;
        if (!this.sternOption) {
            this.diffPotential = d;
            this.sternCap = Double.POSITIVE_INFINITY;
            this.sternPotential = 0.0;
            this.diffCap = this.totalCap;
        } else {
            this.diffPotential = d - d2 / this.sternCap;
            this.sternPotential = d - this.diffPotential;
            this.diffCap = (d2 + this.adsorbedChargeDensity) / this.diffPotential;
        }
        return d2;
    }

    public double getSurfaceCharge() {
        return this.getSurfaceCharge(this.surfacePotential);
    }

    public double getSurfaceCharge(double d) {
        if (!this.surfaceAreaSet) {
            throw new IllegalArgumentException("No surface area has been entered");
        }
        if (this.sigmaSet) {
            this.surfaceCharge = this.surfaceChargeDensity * this.surfaceArea;
        } else {
            if (!this.psi0set) {
                throw new IllegalArgumentException("No surface potential has been entered");
            }
            this.surfaceCharge = this.getSurfaceChargeDensity(d) * this.surfaceArea;
        }
        return this.surfaceCharge;
    }

    private double surfaceChargeDensity0(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            if (!(this.charges[i] > 0.0)) continue;
            d3 += this.bulkConcn[i];
        }
        double d4 = 0.0;
        double d5 = this.sigmaFunction0(d4, d);
        double d6 = Math.sqrt(this.eightTerm * d3) * Fmath.sinh(this.chargeValue * this.expTermOver2 * d);
        double d7 = this.sigmaFunction0(d6, d);
        if (d7 * d5 > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double d8 = Math.abs(d6) * 1.0E-6;
        boolean bl = true;
        double d9 = 0.0;
        double d10 = 0.0;
        int n = 0;
        while (bl) {
            d9 = (d4 + d6) / 2.0;
            d10 = this.sigmaFunction0(d9, d);
            if (Math.abs(d10) <= d8) {
                d2 = d9;
                bl = false;
                continue;
            }
            if (++n > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfaceChargeDensity0\nnumber of iterations exceeded in bisection\ncurrent value of sigma returned");
                d2 = d9;
                bl = false;
                continue;
            }
            if (d10 * d5 > 0.0) {
                d4 = d9;
                d5 = d10;
                continue;
            }
            d6 = d9;
            d7 = d10;
        }
        return d2;
    }

    private double sigmaFunction0(double d, double d2) {
        this.calcSurfacePotential(d);
        return this.diffPotential - d2 + d / this.sternCap;
    }

    private double surfaceChargeDensity1(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.sigmaFunction0(d3, d);
        double d5 = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            d5 += this.bulkConcn[i] * this.twoTerm * (Math.exp(-this.expTerm * this.charges[i] * d) - 1.0);
        }
        d5 = Fmath.sign(d) * Math.sqrt(this.twoTerm * d5);
        double d6 = this.sigmaFunction0(d5, d);
        if (d6 * d4 > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double d7 = Math.abs(d5) * 1.0E-6;
        boolean bl = true;
        double d8 = 0.0;
        double d9 = 0.0;
        int n = 0;
        while (bl) {
            d8 = (d3 + d5) / 2.0;
            d9 = this.sigmaFunction0(d8, d);
            if (Math.abs(d9) <= d7) {
                d2 = d8;
                bl = false;
                continue;
            }
            if (++n > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfaceChargeDensity1\nnumber of iterations exceeded in outer bisection\ncurrent value of sigma returned");
                d2 = d8;
                bl = false;
                continue;
            }
            if (d4 * d9 > 0.0) {
                d3 = d8;
                d4 = d9;
                continue;
            }
            d5 = d8;
            d6 = d9;
        }
        return d2;
    }

    private double calcDelta(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            this.sternConcn[i] = this.bulkConcn[i] * Math.exp(-this.charges[i] * this.expTerm);
            d2 += this.sternConcn[i] * this.radii[i];
            d3 += this.sternConcn[i];
        }
        this.sternDelta = d2 / d3;
        return this.sternDelta;
    }

    private double surfaceChargeDensity2(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.nonZeroAssocK; ++i) {
            if (this.charges[this.indexK[i]] > 0.0) {
                d3 = this.surfaceSiteDensity;
                continue;
            }
            d4 = -this.surfaceSiteDensity;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            d7 += this.bulkConcn[i];
        }
        d6 = Math.sqrt((d7 /= 2.0) * this.eightTerm) * Fmath.sinh(this.expTermOver2 * d * this.chargeValue);
        if (d6 > 0.0) {
            d6 += d3;
            d5 -= d4;
        } else {
            d6 -= d4;
            d5 += d3;
        }
        double d8 = this.sigmaFunction2(d5, d);
        double d9 = this.sigmaFunction2(d6, d);
        if (d9 * d8 > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double d10 = Math.abs(d6) * 1.0E-6;
        boolean bl = true;
        double d11 = 0.0;
        double d12 = 0.0;
        int n = 0;
        while (bl) {
            d11 = (d5 + d6) / 2.0;
            d12 = this.sigmaFunction2(d11, d);
            if (Math.abs(d12) <= d10) {
                d2 = d11;
                bl = false;
                continue;
            }
            if (++n > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfaceChargeDensity2\nnumber of iterations exceeded in outer bisection\ncurrent value of sigma returned");
                d2 = d11;
                bl = false;
                continue;
            }
            if (d8 * d12 > 0.0) {
                d5 = d11;
                d8 = d12;
                continue;
            }
            d6 = d11;
            d9 = d12;
        }
        return d2;
    }

    private double sigmaFunction2(double d, double d2) {
        double d3 = -10.0 * d2;
        double d4 = this.psiFunctionQ(d3, d2, d);
        double d5 = 10.0 * d2;
        double d6 = this.psiFunctionQ(d5, d2, d);
        if (d6 * d4 > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double d7 = Math.abs(d2) * 1.0E-6;
        boolean bl = true;
        double d8 = 0.0;
        double d9 = 0.0;
        int n = 0;
        while (bl) {
            d8 = (d3 + d5) / 2.0;
            d9 = this.psiFunctionQ(d8, d2, d);
            if (Math.abs(d9) <= d7) {
                bl = false;
                continue;
            }
            if (++n > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfaceChargeDensity3\nnumber of iterations exceeded in inner bisection\ncurrent value of sigma returned");
                bl = false;
            }
            if (d9 * d6 > 0.0) {
                d5 = d8;
                d6 = d9;
                continue;
            }
            d3 = d8;
            d4 = d9;
        }
        double d10 = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            d10 += this.bulkConcn[i];
        }
        d10 = Math.sqrt(this.eightTerm * d10 / 2.0) * Fmath.sinh(this.expTermOver2 * d2 * this.chargeValue);
        return d + this.adsorbedChargeDensity - d10;
    }

    private double surfaceChargeDensity3(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.nonZeroAssocK; ++i) {
            if (this.charges[this.indexK[i]] > 0.0) {
                d3 = this.surfaceSiteDensity;
                continue;
            }
            d4 = -this.surfaceSiteDensity;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            d6 += this.bulkConcn[i] * this.twoTerm * (Math.exp(-this.expTerm * this.charges[i] * d) - 1.0);
        }
        d6 = Fmath.sign(d) * Math.sqrt(d6);
        if (d6 > 0.0) {
            d6 += d3;
            d5 -= d4;
        } else {
            d6 -= d4;
            d5 += d3;
        }
        double d7 = this.sigmaFunction3(d5, d);
        double d8 = this.sigmaFunction3(d6, d);
        if (d8 * d7 > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double d9 = Math.abs(d6) * 1.0E-6;
        boolean bl = true;
        double d10 = 0.0;
        double d11 = 0.0;
        int n = 0;
        while (bl) {
            d10 = (d5 + d6) / 2.0;
            d11 = this.sigmaFunction3(d10, d);
            if (Math.abs(d11) <= d9) {
                d2 = d10;
                bl = false;
                continue;
            }
            if (++n > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfaceChargeDensity3\nnumber of iterations exceeded in outer bisection\ncurrent value of sigma returned");
                d2 = d10;
                bl = false;
                continue;
            }
            if (d7 * d11 > 0.0) {
                d5 = d10;
                d7 = d11;
                continue;
            }
            d6 = d10;
            d8 = d11;
        }
        return d2;
    }

    private double sigmaFunction3(double d, double d2) {
        double d3 = 0.0;
        double d4 = this.psiFunctionQ(d3, d2, d);
        double d5 = d2;
        double d6 = this.psiFunctionQ(d5, d2, d);
        if (d6 * d4 > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double d7 = Math.abs(d2) * 1.0E-6;
        boolean bl = true;
        double d8 = 0.0;
        double d9 = 0.0;
        int n = 0;
        while (bl) {
            d8 = (d3 + d5) / 2.0;
            d9 = this.psiFunctionQ(d8, d2, d);
            if (Math.abs(d9) <= d7) {
                bl = false;
                continue;
            }
            if (++n > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: sigmaFunction3\nnumber of iterations exceeded in inner bisection\ncurrent value of sigma returned");
                bl = false;
            }
            if (d9 * d6 > 0.0) {
                d5 = d8;
                d6 = d9;
                continue;
            }
            d3 = d8;
            d4 = d9;
        }
        double d10 = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            d10 += this.bulkConcn[i] * this.twoTerm * (Math.exp(-this.expTerm * this.charges[i] * d8) - 1.0);
        }
        d10 = Fmath.sign(d8) * Math.sqrt(d10);
        return d + this.adsorbedChargeDensity - d10;
    }

    private double psiFunctionQ(double d, double d2, double d3) {
        this.sternDelta = this.calcDeltaQ(d);
        this.diffPotential = d;
        this.sternCap = this.epsilonStern * 8.854187817E-12 / this.sternDelta;
        return d - d2 + d3 / this.sternCap;
    }

    private double calcDeltaQ(double d) {
        Object object;
        double d2;
        double d3;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.surfaceArea / this.volume;
        int n = 0;
        if (this.nonZeroAssocK == 1) {
            double d7;
            n = this.indexK[0];
            double d8 = this.assocConsts[n] * Math.exp(-this.charges[n] * d * this.expTerm);
            double d9 = -(1.0 + this.initConcn[n] * d8 + this.surfaceSiteDensity * d8 * d6);
            double d10 = d9 * d9 - 4.0 * (d3 = d8 * d6) * (d7 = this.initConcn[n] * this.surfaceSiteDensity * d8);
            if (d10 < 0.0) {
                System.out.println("Class: GouyChapmanStern\nMethod: calcDeltaQ\nthe square root term (b2-4ac) of the quadratic = " + d10);
                System.out.println("this term was set to zero as the negative value MAY have arisen from rounding errors");
                d10 = 0.0;
            }
            d2 = -0.5 * (d9 + Fmath.sign(d9) * Math.sqrt(d10));
            double d11 = d2 / d3;
            double d12 = d7 / d2;
            double d13 = this.surfaceSiteDensity * 1.001;
            if (d11 >= 0.0 && d11 <= d13) {
                if (d12 < 0.0 || d12 > d13) {
                    this.siteConcn[this.indexK[0]] = d11;
                    this.bulkConcn[this.indexK[0]] = this.initConcn[this.indexK[0]] - this.siteConcn[this.indexK[0]] * this.surfaceArea / this.volume;
                } else {
                    System.out.println("Class: GouyChapmanStern\nMethod: ionConcns");
                    System.out.println("error1: no physically meaningfull root");
                    System.out.println("root1 = " + d11 + " root2 = " + d12 + " limit = " + d13);
                    System.exit(0);
                }
            } else if (d12 >= 0.0 && d12 <= d13) {
                if (d11 < 0.0 || d11 > d13) {
                    this.siteConcn[this.indexK[0]] = d12;
                    this.bulkConcn[this.indexK[0]] = this.initConcn[this.indexK[0]] - this.siteConcn[this.indexK[0]] * this.surfaceArea / this.volume;
                } else {
                    System.out.println("Class: GouyChapmanStern\nMethod: ionConcns");
                    System.out.println("error2: no physically meaningfull root");
                    System.out.println("root1 = " + d11 + " root2 = " + d12 + " limit = " + d13);
                    System.exit(0);
                }
            } else {
                System.out.println("Class: GouyChapmanStern\nMethod: ionConcns");
                System.out.println("error3: no physically meaningfull root");
                System.out.println("root1 = " + d11 + " root2 = " + d12 + " limit = " + d13);
                System.exit(0);
            }
        } else {
            int n2;
            double[] dArray = new double[this.nonZeroAssocK];
            object = new double[this.nonZeroAssocK][this.nonZeroAssocK];
            d3 = -d * this.expTerm;
            for (int i = 0; i < this.nonZeroAssocK; ++i) {
                n = this.indexK[i];
                dArray[i] = this.assocConsts[n] * this.initConcn[n] * this.surfaceSiteDensity * Math.exp(this.charges[n] * d3);
                for (n2 = 0; n2 < this.nonZeroAssocK; ++n2) {
                    object[i][n2] = this.assocConsts[n] * this.initConcn[n] * Math.exp(this.charges[n] * d3);
                    if (i != n2) continue;
                    double[] dArray2 = object[i];
                    int n3 = n2;
                    dArray2[n3] = dArray2[n3] + 1.0;
                }
            }
            Matrix matrix = new Matrix((double[][])object);
            dArray = matrix.solveLinearSet(dArray);
            for (n2 = 0; n2 < this.nonZeroAssocK; ++n2) {
                this.siteConcn[this.indexK[n2]] = dArray[n2];
            }
        }
        Minimisation minimisation = new Minimisation();
        object = new GCSminim();
        object.psiDelta = d;
        object.tempK = this.tempK;
        object.surfaceSiteDensity = this.surfaceSiteDensity;
        object.surfaceArea = this.surfaceArea;
        object.volume = this.volume;
        object.nonZeroAssocK = this.nonZeroAssocK;
        object.assocK = this.assocConsts;
        object.initConcn = this.initConcn;
        object.charges = this.charges;
        object.indexK = this.indexK;
        double[] dArray = new double[this.nonZeroAssocK];
        double[] dArray3 = new double[this.nonZeroAssocK];
        for (int i = 0; i < this.nonZeroAssocK; ++i) {
            dArray[i] = this.surfaceSiteDensity / (double)this.nonZeroAssocK;
            dArray3[i] = dArray[i] * 0.05;
        }
        double d14 = this.surfaceSiteDensity * 1.0E-8;
        int n4 = 100000;
        minimisation.nelderMead((MinimisationFunction)object, dArray, dArray3, d14, n4);
        double[] dArray4 = minimisation.getParamValues();
        for (int i = 0; i < this.nonZeroAssocK; ++i) {
            n = this.indexK[i];
            this.siteConcn[n] = dArray4[i];
            this.bulkConcn[n] = this.initConcn[n] - dArray4[i] * this.surfaceArea / this.volume;
        }
        this.adsorbedChargeDensity = 0.0;
        double d15 = 96485.34158524018;
        d2 = this.surfaceArea / this.volume;
        for (int i = 0; i < this.numOfIons; ++i) {
            this.sternConcn[i] = this.bulkConcn[i] * Math.exp(-this.charges[i] * this.expTerm);
            this.adsorbedChargeDensity += this.siteConcn[i] * this.charges[i] * d15;
            d4 += (this.sternConcn[i] + this.siteConcn[i] * d2) * this.radii[i];
            d5 += this.sternConcn[i] + this.siteConcn[i] * d2;
        }
        double d16 = d4 / d5;
        return d16;
    }

    public double getAdsorbedChargeDensity() {
        if (!this.sternOption || this.nonZeroAssocK == 0) {
            return 0.0;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.adsorbedChargeDensity;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.sternPotential;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.adsorbedChargeDensity;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getAdsorbedChargeDensity\nThe value of the adsorbed ion charge density has not been calculated\nzero returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return 0.0;
    }

    public double getDiffuseChargeDensity() {
        double d = this.getAdsorbedChargeDensity();
        this.diffuseChargeDensity = -(this.surfaceChargeDensity + d);
        return this.diffuseChargeDensity;
    }

    public double getSurfacePotential(double d) {
        this.surfacePotential = this.calcSurfacePotential(d);
        this.psi0set = true;
        return this.surfacePotential;
    }

    private double calcSurfacePotential(double d) {
        double d2 = 0.0;
        if (!this.epsilonSet) {
            throw new IllegalArgumentException("The relative permittivitie/s have not been entered");
        }
        if (!this.tempSet) {
            System.out.println("The temperature has not been entered\na value of 25 degrees Celsius has been used");
        }
        if (this.psi0set && this.sigmaSet) {
            return this.surfacePotential;
        }
        if (!this.unpackArrayList) {
            this.unpack();
        }
        if (this.sternOption) {
            if (this.nonZeroAssocK == 0) {
                this.diffPotential = this.chargeSame ? Fmath.asinh(d / Math.sqrt(this.eightTerm * this.electrolyteConcn)) / (this.chargeValue * this.expTermOver2) : this.surfacePotential1(d);
                this.sternCap = 8.854187817E-12 * this.epsilonStern / this.calcDelta(this.diffPotential);
                d2 = this.diffPotential + d / this.sternCap;
                this.totalCap = d / this.surfacePotential;
                this.diffCap = d / this.diffPotential;
            } else {
                d2 = this.chargeSame ? this.surfacePotential2(d) : this.surfacePotential3(d);
            }
        } else {
            if (this.chargeSame) {
                double d3 = Math.sqrt(this.eightTerm * this.electrolyteConcn);
                this.surfacePotential = Fmath.asinh(this.surfaceChargeDensity / d3) / (this.chargeValue * this.expTermOver2);
            } else {
                d2 = this.surfacePotential4(d);
            }
            this.diffPotential = d2;
            this.sternPotential = 0.0;
            this.totalCap = d / d2;
            this.diffCap = d / this.diffPotential;
            this.sternCap = Double.POSITIVE_INFINITY;
        }
        return d2;
    }

    public double getSurfacePotential() {
        if (!this.sigmaSet) {
            throw new IllegalArgumentException("No surface charge density has been entered");
        }
        return this.getSurfacePotential(this.surfaceChargeDensity);
    }

    private double surfacePotential4(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.psiFunction4(d3, d);
        double d5 = Math.sqrt(this.eightTerm * this.electrolyteConcn);
        double d6 = 10.0 / (this.averageCharge * this.expTerm) * Fmath.asinh(d / d5);
        double d7 = this.psiFunction4(d6, d);
        if (d7 * d4 > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double d8 = Math.abs(d6) * 1.0E-6;
        boolean bl = true;
        double d9 = 0.0;
        double d10 = 0.0;
        int n = 0;
        while (bl) {
            d9 = (d3 + d6) / 2.0;
            d10 = this.psiFunction4(d9, d);
            if (Math.abs(d10) <= d8) {
                d2 = d9;
                bl = false;
                continue;
            }
            if (++n > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: getSurfacePotential\nnumber of iterations exceeded in outer bisection\ncurrent value of sigma returned");
                d2 = d9;
                bl = false;
                continue;
            }
            if (d4 * d10 > 0.0) {
                d3 = d9;
                d4 = d10;
                continue;
            }
            d6 = d9;
            d7 = d10;
        }
        return d2;
    }

    private double psiFunction4(double d, double d2) {
        double d3 = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            d3 += this.bulkConcn[i] * this.twoTerm * (Math.exp(-this.expTerm * this.charges[i] * d) - 1.0);
        }
        d3 = Fmath.sign(d2) * Math.sqrt(d3);
        return d2 - d3;
    }

    private double surfacePotential1(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.psiFunction1(d3, d);
        double d5 = 5.0 / (this.expTerm * this.chargeValue) * Fmath.asinh(d / Math.sqrt(this.eightTerm * this.electrolyteConcn));
        double d6 = this.psiFunction1(d5, d);
        if (d6 * d4 > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double d7 = Math.abs(d5) * 1.0E-6;
        boolean bl = true;
        double d8 = 0.0;
        double d9 = 0.0;
        int n = 0;
        while (bl) {
            d8 = (d3 + d5) / 2.0;
            d9 = this.psiFunction1(d8, d);
            if (Math.abs(d9) <= d7) {
                this.diffPotential = d8;
                bl = false;
                continue;
            }
            if (++n > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: getSurfacePotential\nnumber of iterations exceeded in outer bisection\ncurrent value of sigma returned");
                this.diffPotential = d8;
                bl = false;
                continue;
            }
            if (d4 * d9 > 0.0) {
                d3 = d8;
                d4 = d9;
                continue;
            }
            d5 = d8;
            d6 = d9;
        }
        return d2;
    }

    private double psiFunction1(double d, double d2) {
        double d3 = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            d3 += this.twoTerm * this.bulkConcn[i] * (Math.exp(-this.charges[i] * d * this.expTerm) - 1.0);
        }
        return d2 - Fmath.sign(d2) * Math.sqrt(d3);
    }

    public double getPotentialAtX(double d) {
        if (!this.psi0set && !this.sigmaSet) {
            throw new IllegalArgumentException("Neither a surface potential nor a surface charge/density have been entered");
        }
        if (this.sigmaSet && !this.psi0set) {
            this.getSurfacePotential();
        }
        if (this.psi0set && !this.sigmaSet) {
            this.getSurfaceChargeDensity();
        }
        double d2 = 0.0;
        d2 = d == 0.0 ? this.surfacePotential : (this.sternOption ? (d == this.sternDelta ? this.diffPotential : (d < this.sternDelta ? this.surfacePotential - d / this.sternDelta * (this.surfacePotential - this.diffPotential) : this.calcPotAtX(this.diffPotential, d))) : this.calcPotAtX(this.surfacePotential, d));
        return d2;
    }

    private double calcPotAtX(double d, double d2) {
        double d3 = 0.0;
        if (this.chargeSame) {
            double d4 = Math.sqrt(2.0 * Fmath.square(-1.60217646263E-19 * this.chargeValue) * 6.0221419947E23 * this.electrolyteConcn / (8.854187817E-12 * this.epsilon * 1.380650324E-23 * this.tempK));
            double d5 = Math.exp(this.expTerm * this.chargeValue * d / 2.0);
            double d6 = (d5 - 1.0) / (d5 + 1.0);
            double d7 = d6 * Math.exp(-d4 * d2);
            d3 = 2.0 * Math.log((1.0 + d7) / (1.0 - d7)) / (this.expTerm * this.chargeValue);
        } else {
            FunctionPatX functionPatX = new FunctionPatX();
            functionPatX.numOfIons = this.numOfIons;
            functionPatX.termOne = 16.628944592313125 * this.tempK / (8.854187817E-12 * this.epsilon);
            functionPatX.expTerm = this.expTerm;
            functionPatX.bulkConcn = this.bulkConcn;
            functionPatX.charges = this.charges;
            int n = 2000;
            double d8 = 0.0;
            double d9 = d2 - Integration.trapezium(functionPatX, d8, d, n);
            double d10 = d;
            double d11 = d2 - Integration.trapezium(functionPatX, d10, d, n);
            if (d11 * d9 > 0.0) {
                throw new IllegalArgumentException("root not bounded");
            }
            double d12 = Math.abs(d2) * 0.01;
            boolean bl = true;
            double d13 = 0.0;
            double d14 = 0.0;
            int n2 = 0;
            while (bl) {
                d13 = (d8 + d10) / 2.0;
                d14 = d2 - Integration.trapezium(functionPatX, d13, d, n);
                if (Math.abs(d14) <= d12) {
                    d3 = d13;
                    bl = false;
                    continue;
                }
                if (++n2 > 10000) {
                    System.out.println("Class: GouyChapmanStern\nMethod: getPotentialAtX\nnumber of iterations exceeded in outer bisection\ncurrent value of psi(x) returned");
                    d3 = d13;
                    bl = false;
                    continue;
                }
                if (d9 * d14 > 0.0) {
                    d8 = d13;
                    d9 = d14;
                    continue;
                }
                d10 = d13;
                d11 = d14;
            }
        }
        return d3;
    }

    public double[] getConcnsAtX(double d) {
        if (!this.psi0set && !this.sigmaSet) {
            throw new IllegalArgumentException("Neither a surface potential nor a surface charge/density have been entered");
        }
        if (this.sigmaSet && !this.psi0set) {
            this.getSurfacePotential();
        }
        if (this.psi0set && !this.sigmaSet) {
            this.getSurfaceChargeDensity();
        }
        double[] dArray = new double[this.numOfIons];
        if (this.sternOption && d < this.sternDelta) {
            for (int i = 0; i < this.numOfIons; ++i) {
                dArray[i] = 0.0;
            }
        } else {
            double d2 = this.getPotentialAtX(d);
            for (int i = 0; i < this.numOfIons; ++i) {
                dArray[i] = this.bulkConcn[i] * Math.exp(-this.expTerm * this.charges[i] * d2);
            }
        }
        return dArray;
    }

    public double[] getInitConcns() {
        if (!this.psi0set && !this.sigmaSet) {
            this.unpack();
        }
        double[] dArray = Conv.copy(this.initConcn);
        int n = 0;
        while (n < this.numOfIons) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * 0.001;
        }
        return dArray;
    }

    public double[] getBulkConcns() {
        if (!this.psi0set && !this.sigmaSet) {
            throw new IllegalArgumentException("Neither a surface potential nor a surface charge/density have been entered");
        }
        if (this.sigmaSet && !this.psi0set) {
            this.getSurfacePotential();
        }
        if (this.psi0set && !this.sigmaSet) {
            this.getSurfaceChargeDensity();
        }
        double[] dArray = Conv.copy(this.bulkConcn);
        int n = 0;
        while (n < this.numOfIons) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * 0.001;
        }
        return dArray;
    }

    public double[] getSiteConcns() {
        if (!this.psi0set && !this.sigmaSet) {
            throw new IllegalArgumentException("Neither a surface potential nor a surface charge/density have been entered");
        }
        if (this.sigmaSet && !this.psi0set) {
            this.getSurfacePotential();
        }
        if (this.psi0set && !this.sigmaSet) {
            this.getSurfaceChargeDensity();
        }
        return this.siteConcn;
    }

    private double surfacePotential2(double d) {
        double d2 = 0.0;
        double d3 = Fmath.asinh(d / Math.sqrt(this.eightTerm * this.electrolyteConcn)) / (this.chargeValue * this.expTermOver2);
        double d4 = 0.0;
        double d5 = 0.0;
        if (d3 > 0.0) {
            d5 = 2.0 * d3;
        } else {
            d4 = 2.0 * d3;
        }
        d2 = this.surfacePotentialBisection(d4, d5, d, 2);
        return d2;
    }

    private double surfacePotentialBisection(double d, double d2, double d3, int n) {
        double d4 = 0.0;
        boolean bl = true;
        int n2 = 0;
        int n3 = 10;
        double d5 = d2 - d;
        double d6 = this.cFunction(d, d3);
        double d7 = this.cFunction(d2, d3);
        while (bl) {
            if (d2 * d > 0.0) {
                if (++n2 > n3) {
                    throw new IllegalArgumentException("root not bounded after " + n2 + "expansions");
                }
                d6 = this.cFunction(d -= d5, d3);
                d7 = this.cFunction(d2 += d5, d3);
                continue;
            }
            bl = false;
        }
        double d8 = Math.abs(d3) * 1.0E-6;
        boolean bl2 = true;
        double d9 = 0.0;
        int n4 = 0;
        while (bl2) {
            d4 = (d + d2) / 2.0;
            d9 = this.cFunction(d4, d3);
            if (Math.abs(d9) <= d8) {
                bl2 = false;
                continue;
            }
            if (++n4 > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfacePotential" + n + "\nnumber of iterations exceeded in bisection\ncurrent value of sigma returned");
                bl2 = false;
            }
            if (d9 * d7 > 0.0) {
                d2 = d4;
                d7 = d9;
                continue;
            }
            d = d4;
            d6 = d9;
        }
        return d4;
    }

    private double cFunction(double d, double d2) {
        double d3 = this.calcSurfaceChargeDensity(d);
        return d3 - d2;
    }

    private double surfacePotential3(double d) {
        double d2 = 0.0;
        double d3 = Fmath.asinh(d / Math.sqrt(this.eightTerm * this.electrolyteConcn)) / (this.chargeValue * this.expTermOver2);
        double d4 = 0.0;
        double d5 = 0.0;
        if (d3 > 0.0) {
            d5 = 2.0 * d3;
        } else {
            d4 = 2.0 * d3;
        }
        d2 = this.surfacePotentialBisection(d4, d5, d, 3);
        return d2;
    }
}

