/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.math.MinimisationFunction;

class GCSminim
implements MinimisationFunction {
    public double psiDelta = 0.0;
    public double tempK = 298.15;
    public double surfaceSiteDensity = 0.0;
    public double surfaceArea = 0.0;
    public double volume = 0.0;
    public int nonZeroAssocK = 0;
    public double[] assocK = null;
    public double[] initConcn = null;
    public double[] charges = null;
    public int[] indexK = null;

    @Override
    public double function(double[] dArray) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        double d3 = this.surfaceArea / this.volume;
        double d4 = this.psiDelta * -1.60217646263E-19 / (1.380650324E-23 * this.tempK);
        double d5 = 0.0;
        for (n = 0; n < this.nonZeroAssocK; ++n) {
            d5 += dArray[0];
        }
        d5 = this.surfaceSiteDensity - d5;
        for (n = 0; n < this.nonZeroAssocK; ++n) {
            n2 = this.indexK[n];
            d2 = this.assocK[n2] * (this.initConcn[n2] - dArray[n] * d3) * Math.exp(d4 * this.charges[n2]) * d5 - dArray[0];
            d += d2 * d2;
        }
        return d;
    }
}

