/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.math.MinimisationFunction;

class DonnanConcn
implements MinimisationFunction {
    public int numOfIons = 0;
    public double[] concnA = null;
    public double[] concnB = null;
    public double[] molesT = null;
    public double[] complex = null;
    public double[] excessConcnA = null;
    public double[] excessConcnB = null;
    public double[] excessComplex = null;
    public double[] assocConsts = null;
    public double[] partCoeffPot = null;
    public int[] indexK = null;
    public int nonZeroAssocK = 0;
    public double[] radii = null;
    public double[] charges = null;
    public double ionophoreConcn = 0.0;
    public double ionophoreRad = 0.0;
    public double volumeA = 0.0;
    public double volumeB = 0.0;
    public double interfacialArea = 0.0;
    public double epsilonA = 0.0;
    public double epsilonB = 0.0;
    public double epsilonSternA = 0.0;
    public double epsilonSternB = 0.0;
    public double temp = 298.15;
    public double diffPotentialA = 0.0;
    public double diffPotentialB = 0.0;
    public double sternPotential = 0.0;
    public double sternCap = 0.0;
    public double sternDeltaA = 0.0;
    public double sternDeltaB = 0.0;
    public double chargeValue = 0.0;
    public boolean chargeSame = true;
    public double interfacialChargeDensity = 0.0;
    public double interfacialCharge = 0.0;
    public boolean includeIc = true;
    public double potential = 0.0;
    private double penalty = 1.0E50;

    DonnanConcn() {
    }

    @Override
    public double function(double[] dArray) {
        double d = 0.0;
        if (this.nonZeroAssocK > 0 && this.ionophoreConcn > 0.0) {
            if (this.nonZeroAssocK == 1) {
                this.complex[this.indexK[0]] = this.assocConsts[this.indexK[0]] * dArray[this.indexK[0]] * this.ionophoreConcn / (1.0 + this.assocConsts[this.indexK[0]] * dArray[this.indexK[0]]);
            } else {
                int n;
                double[] dArray2 = new double[this.nonZeroAssocK];
                double[][] dArray3 = new double[this.nonZeroAssocK][this.nonZeroAssocK];
                for (int i = 0; i < this.nonZeroAssocK; ++i) {
                    dArray2[i] = this.assocConsts[this.indexK[i]] * dArray[this.indexK[i]] * this.ionophoreConcn;
                    for (n = 0; n < this.nonZeroAssocK; ++n) {
                        dArray3[i][n] = this.assocConsts[this.indexK[i]] * dArray[this.indexK[i]];
                        if (i != n) continue;
                        double[] dArray4 = dArray3[i];
                        int n2 = n;
                        dArray4[n2] = dArray4[n2] + 1.0;
                    }
                }
                Matrix matrix = new Matrix(dArray3);
                dArray2 = matrix.solveLinearSet(dArray2);
                for (n = 0; n < this.nonZeroAssocK; ++n) {
                    this.complex[this.indexK[n]] = dArray2[n];
                }
            }
        }
        if (this.includeIc) {
            double d2 = Math.abs(this.interfaceCharge(dArray, this.potential));
            this.excessConcentrations(dArray, d2, this.potential);
            for (int i = 0; i < this.numOfIons; ++i) {
                double d3 = dArray[i] * (this.volumeB + this.partCoeffPot[i] * this.volumeA) + this.excessConcnA[i] * this.volumeA + (this.excessConcnB[i] + this.complex[i] + this.excessComplex[i]) * this.volumeB - this.molesT[i];
                d += d3 * d3;
                if (!(dArray[i] < 0.0)) continue;
                d += dArray[i] * dArray[i] * this.penalty;
            }
        } else {
            for (int i = 0; i < this.numOfIons; ++i) {
                double d4 = dArray[i] * (this.volumeB + this.partCoeffPot[i] * this.volumeA) + this.complex[i] * this.volumeB - this.molesT[i];
                d += d4 * d4;
                if (!(dArray[i] < 0.0)) continue;
                d += dArray[i] * dArray[i] * this.penalty;
            }
        }
        return d;
    }

    public void excessConcentrations(double[] dArray, double d, double d2) {
        if (d2 == 0.0) {
            for (int i = 0; i < this.numOfIons; ++i) {
                this.excessConcnA[i] = 0.0;
                this.excessConcnB[i] = 0.0;
                this.excessComplex[i] = 0.0;
            }
        } else {
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i = 0; i < this.numOfIons; ++i) {
                if (d2 > 0.0) {
                    if (this.charges[i] > 0.0) {
                        d4 += dArray[i] * Math.abs(this.charges[i]);
                        d5 += this.complex[i] * Math.abs(this.charges[i]);
                        continue;
                    }
                    d3 += dArray[i] * this.partCoeffPot[i] * Math.abs(this.charges[i]);
                    continue;
                }
                if (this.charges[i] < 0.0) {
                    d4 += dArray[i] * Math.abs(this.charges[i]);
                    d5 += this.complex[i] * Math.abs(this.charges[i]);
                    continue;
                }
                d3 += dArray[i] * this.partCoeffPot[i] * Math.abs(this.charges[i]);
            }
            double d6 = d / (d3 * this.volumeA);
            double d7 = d / ((d4 + d5) * this.volumeB);
            for (int i = 0; i < this.numOfIons; ++i) {
                if (d2 > 0.0) {
                    if (this.charges[i] > 0.0) {
                        this.excessConcnB[i] = Math.abs(this.concnB[i] * d7);
                        this.excessComplex[i] = Math.abs(this.complex[i] * d7);
                        continue;
                    }
                    this.excessConcnA[i] = Math.abs(this.concnA[i] * d6);
                    continue;
                }
                if (this.charges[i] < 0.0) {
                    this.excessConcnB[i] = Math.abs(this.concnB[i] * d7);
                    this.excessComplex[i] = Math.abs(this.complex[i] * d7);
                    continue;
                }
                this.excessConcnA[i] = Math.abs(this.concnA[i] * d6);
            }
        }
    }

    public double interfaceCharge(double[] dArray, double d) {
        if (d == 0.0) {
            this.interfacialCharge = 0.0;
            this.interfacialChargeDensity = 0.0;
            this.diffPotentialA = 0.0;
            this.diffPotentialB = 0.0;
            this.sternPotential = 0.0;
        } else {
            double d2;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            for (int i = 0; i < this.numOfIons; ++i) {
                d8 += Math.abs(dArray[i] * this.charges[i]);
                d7 += Math.abs(dArray[i] * this.charges[i] * this.partCoeffPot[i]);
                d9 += Math.abs(this.charges[i]);
            }
            d7 /= 2.0 * d9;
            double d10 = d2 = 1.2 * Math.sqrt(4.81771359576E24 * (d8 /= 2.0 * (d9 /= (double)this.numOfIons)) * 1.380650324E-23 * this.temp * 8.854187817E-12 * this.epsilonB) * Fmath.sinh(-d9 * -1.60217646263E-19 * Math.abs(d) / (2.761300648E-23 * this.temp));
            double d11 = 0.0;
            double d12 = Math.abs(d) * 1.0E-8;
            int n = 10000;
            boolean bl = true;
            int n2 = 0;
            int n3 = 0;
            double d13 = 0.0;
            while (bl) {
                d6 = this.icFunct(d5, d, dArray);
                d11 = this.icFunct(d10, d, dArray);
                if (d11 * d6 > 0.0) {
                    if (++n2 > 10) {
                        throw new IllegalArgumentException("iExpandQ has reached its limit");
                    }
                    d13 = d10 - d5;
                    d10 += d13;
                    continue;
                }
                bl = false;
            }
            if (Math.abs(d6) <= d12) {
                d3 = d5;
            } else if (Math.abs(d11) <= d12) {
                d3 = d10;
            } else {
                bl = true;
                while (bl) {
                    d3 = (d5 + d10) / 2.0;
                    d4 = this.icFunct(d3, d, dArray);
                    if (Math.abs(d4) <= d12) {
                        bl = false;
                    } else if (d6 * d4 > 0.0) {
                        d6 = d4;
                        d5 = d3;
                    } else {
                        d11 = d4;
                        d10 = d3;
                    }
                    if (++n3 <= n) continue;
                    System.out.println("Class: DonnanConcn\nMethod: interfaceCharge");
                    System.out.println("Maximum iterations in bisection procedure exceeded\nCurrent value of interface charge returned");
                    bl = false;
                }
            }
            this.interfacialCharge = d3;
            this.interfacialChargeDensity = d3 / this.interfacialArea;
        }
        return this.interfacialCharge / 96485.34158524018;
    }

    public double icFunct(double d, double d2, double[] dArray) {
        double d3 = Math.abs(d);
        double d4 = Fmath.sign(d2);
        if (this.chargeSame) {
            double d5 = 0.0;
            double d6 = 0.0;
            for (int i = 0; i < this.numOfIons; ++i) {
                d5 += this.concnA[i];
                d6 += this.concnB[i] + this.complex[i];
            }
            double d7 = 2.761300648E-23 * this.temp / (-this.chargeValue * -1.60217646263E-19);
            this.diffPotentialA = d4 * d7 * Fmath.asinh(d3 / Math.sqrt(4.81771359576E24 * (d5 /= 2.0) * 1.380650324E-23 * this.temp * 8.854187817E-12 * this.epsilonA));
            this.diffPotentialB = d4 * d7 * Fmath.asinh(d3 / Math.sqrt(4.81771359576E24 * (d6 /= 2.0) * 1.380650324E-23 * this.temp * 8.854187817E-12 * this.epsilonB));
        } else {
            double d8;
            double d9;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            double d14 = d9 = 1.1 * d2;
            double d15 = 0.0;
            double d16 = Math.abs(d) * 0.1;
            int n = 1000;
            boolean bl = true;
            int n2 = 0;
            int n3 = 0;
            double d17 = 0.0;
            while (bl) {
                d13 = this.phiAfunct(d, d12, dArray);
                d15 = this.phiAfunct(d, d14, dArray);
                if (d15 * d13 > 0.0) {
                    if (++n2 > 10) {
                        throw new IllegalArgumentException("iExpandP (partition A) has reached its limit");
                    }
                    d17 = d14 - d12;
                    d14 += d17;
                    continue;
                }
                bl = false;
            }
            bl = true;
            while (bl) {
                d10 = (d12 + d14) / 2.0;
                d11 = this.phiAfunct(d, d10, dArray);
                if (Math.abs(d11) <= d16) {
                    this.diffPotentialA = d4 * d10;
                    bl = false;
                } else if (d13 * d11 > 0.0) {
                    d13 = d11;
                    d12 = d10;
                } else {
                    d15 = d11;
                    d14 = d10;
                }
                if (++n3 <= n) continue;
                System.out.println("phiA = " + d10 + " sigma = " + d + " funcM = " + d11 + " tol = " + d16);
                this.diffPotentialA = d4 * d10;
                bl = false;
            }
            double d18 = 0.0;
            double d19 = 0.0;
            double d20 = d8 = -1.1 * d2;
            d16 = Math.abs(d2) * 1.0E-5;
            if (d16 == 0.0) {
                d16 = 1.0E-6;
            }
            n = 100000;
            bl = true;
            n2 = 0;
            n3 = 0;
            d17 = 0.0;
            while (bl) {
                d13 = this.phiAfunct(d, d19, dArray);
                d15 = this.phiAfunct(d, d20, dArray);
                if (d15 * d13 > 0.0) {
                    if (++n2 > 10) {
                        throw new IllegalArgumentException("iExpandP (partition B) has reached its limit");
                    }
                    d17 = d20 - d19;
                    d20 += d17;
                    continue;
                }
                bl = false;
            }
            if (Math.abs(d15) <= d16) {
                d18 = d20;
            } else {
                bl = true;
                while (bl) {
                    d18 = (d19 + d20) / 2.0;
                    d11 = this.phiAfunct(d, d18, dArray);
                    if (Math.abs(d11) <= d16) {
                        bl = false;
                    } else if (d13 * d11 > 0.0) {
                        d13 = d11;
                        d19 = d18;
                    } else {
                        d15 = d11;
                        d20 = d18;
                    }
                    if (++n3 <= n) continue;
                    System.out.println("Class: DonnanConcn\nMethod: icFunct");
                    System.out.println("Maximum iterations in bisection B procedure exceeded\nCurrent value of interface charge returned");
                    System.out.println("phiB = " + d18 + " maxPhiB = " + d8 + " funcM = " + d11 + " tol = " + d16);
                    bl = false;
                }
            }
            this.diffPotentialB = d4 * d18;
        }
        this.sternCapacitance(dArray, d, this.diffPotentialA, -this.diffPotentialB);
        this.sternPotential = d4 * d3 / this.sternCap;
        return d2 - (this.diffPotentialA + this.diffPotentialB + this.sternPotential);
    }

    public double phiAfunct(double d, double d2, double[] dArray) {
        double d3 = 0.0;
        double d4 = Fmath.sign(d);
        double d5 = 1.7708375634E-11 * this.epsilonA * 1.380650324E-23 * this.temp * 6.0221419947E23;
        double d6 = d2 * -1.60217646263E-19 / (1.380650324E-23 * this.temp);
        for (int i = 0; i < this.numOfIons; ++i) {
            d3 += d5 * dArray[i] * this.partCoeffPot[i] * (Math.exp(this.charges[i] * d6) - 1.0);
        }
        if (d3 < 0.0) {
            d4 = -d4;
            d3 = -d3;
        }
        double d7 = d - d4 * Math.sqrt(d3);
        return d7;
    }

    public double phiBfunct(double d, double d2, double[] dArray) {
        double d3 = 0.0;
        double d4 = Fmath.sign(d);
        double d5 = 1.7708375634E-11 * this.epsilonB * 1.380650324E-23 * this.temp * 6.0221419947E23;
        double d6 = d2 * -1.60217646263E-19 / (1.380650324E-23 * this.temp);
        for (int i = 0; i < this.numOfIons; ++i) {
            d3 += d5 * (dArray[i] + this.complex[i]) * (Math.exp(this.charges[i] * d6) - 1.0);
        }
        if (d3 < 0.0) {
            d4 = -d4;
            d3 = -d3;
        }
        double d7 = d - d4 * Math.sqrt(d3);
        return d7;
    }

    public void sternCapacitance(double[] dArray, double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        this.sternDeltaA = 0.0;
        this.sternDeltaB = 0.0;
        double d6 = 1.60217646263E-19 / (1.380650324E-23 * this.temp);
        for (int i = 0; i < this.numOfIons; ++i) {
            this.sternDeltaA += this.radii[i] * dArray[i] * this.partCoeffPot[i] * Math.exp(d6 * d2 * this.charges[i]);
            this.sternDeltaB += (this.radii[i] * dArray[i] + this.ionophoreRad * this.complex[i]) * Math.exp(-d6 * d3 * this.charges[i]);
            d4 += dArray[i] * this.partCoeffPot[i] * Math.exp(d6 * d2 * this.charges[i]);
            d5 += (dArray[i] + this.complex[i]) * Math.exp(-d6 * d3 * this.charges[i]);
        }
        this.sternDeltaA /= d4;
        this.sternDeltaB /= d5;
        this.sternCap = 8.854187817E-12 * this.epsilonSternA * this.epsilonSternB / (this.sternDeltaA * this.epsilonSternB + this.sternDeltaB * this.epsilonSternA);
    }
}

