/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.io.Db;
import flanagan.io.FileOutput;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Minimisation;
import flanagan.physchem.DonnanConcn;
import flanagan.physchem.DonnanMinim;
import flanagan.physprop.IonicRadii;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class Donnan {
    private ArrayList<Object> arrayl = new ArrayList();
    private int numOfIons = 0;
    private int numOfAnions = 0;
    private int numOfCations = 0;
    private String[] ionNames = null;
    private double[] concnA = null;
    private double[] concnB = null;
    private double[] molesT = null;
    private double[] complex = null;
    private double[] excessConcnA = null;
    private double[] excessConcnB = null;
    private double[] excessComplex = null;
    private int[] indexC = null;
    private int nonZeroConcns = 0;
    private double[] assocConsts = null;
    private int[] indexK = null;
    private int nonZeroAssocK = 0;
    private double[] radii = null;
    private boolean radiusType = true;
    private double[] charges = null;
    private double tol = 1.0E-6;
    private String ionophore = "ionophore";
    private double ionophoreConcn = 0.0;
    private double freeIonophoreConcn = 0.0;
    private double ionophoreRad = 0.0;
    private boolean ionophoreSet = false;
    private double volumeA = 0.0;
    private double volumeB = 0.0;
    private double interfacialArea = 0.0;
    private boolean volumeSet = false;
    private double epsilonA = 0.0;
    private double epsilonB = 0.0;
    private double epsilonSternA = 0.0;
    private double epsilonSternB = 0.0;
    private boolean epsilonSet = false;
    private double temp = 298.15;
    private boolean tempSet = false;
    private double[] deltaMu0 = null;
    private double[] partCoeff = null;
    private double[] partCoeffPot = null;
    private boolean[] indexPC = null;
    private double donnanPotential = 0.0;
    private double diffPotentialA = 0.0;
    private double diffPotentialB = 0.0;
    private double sternPotential = 0.0;
    private double estimate = 0.0;
    private double step = 0.0;
    private double tolerance = 1.0E-20;
    private int nMaxIter = 10000;
    private int numIterations = 0;
    private double minimum = 1.0E300;
    private double sternCap = 0.0;
    private double diffCapA = 0.0;
    private double diffCapB = 0.0;
    private double donnanCap = 0.0;
    private double sternDeltaA = 0.0;
    private double sternDeltaB = 0.0;
    private double chargeValue = 0.0;
    private boolean chargeSame = true;
    private double interfacialChargeDensity = 0.0;
    private double interfacialCharge = 0.0;
    private boolean includeIc = true;
    private double[] ratioA = null;
    private double[] ratioB = null;
    private double[] ratioC = null;
    private double recipKappaA = 0.0;
    private double recipKappaB = 0.0;

    public void setHydratedRadii() {
        this.radiusType = true;
    }

    public void setBareRadii() {
        this.radiusType = false;
    }

    public void ignoreInterfaceCharge() {
        this.includeIc = false;
    }

    public void includeInterfaceCharge() {
        this.includeIc = true;
    }

    public void setIon(String string, double d, double d2, double d3, double d4, int n) {
        this.arrayl.add(string);
        this.arrayl.add(new Double(d));
        this.arrayl.add(new Double(d2));
        if (d > 0.0 || d2 > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(d3));
        if (d3 != 0.0) {
            ++this.nonZeroAssocK;
        }
        this.arrayl.add(new Double(d4));
        this.arrayl.add(new Integer(n));
        this.arrayl.add(new Double(-1.0));
        ++this.numOfIons;
    }

    public void setIon(double d, String string, double d2, double d3, double d4, double d5, int n) {
        this.arrayl.add(string);
        this.arrayl.add(new Double(d2));
        this.arrayl.add(new Double(d3));
        if (d2 > 0.0 || d3 > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(d4));
        if (d4 != 0.0) {
            ++this.nonZeroAssocK;
        }
        this.arrayl.add(new Double(d5));
        this.arrayl.add(new Integer(n));
        this.arrayl.add(new Double(d));
        ++this.numOfIons;
    }

    public void setIon(String string, double d, double d2, double d3, int n) {
        this.arrayl.add(string);
        this.arrayl.add(new Double(d));
        this.arrayl.add(new Double(d2));
        if (d > 0.0 || d2 > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(0.0));
        this.arrayl.add(new Double(d3));
        this.arrayl.add(new Integer(n));
        this.arrayl.add(new Double(-1.0));
        ++this.numOfIons;
    }

    public void setIon(double d, String string, double d2, double d3, double d4, int n) {
        this.arrayl.add(string);
        this.arrayl.add(new Double(d2));
        this.arrayl.add(new Double(d3));
        if (d2 > 0.0 || d3 > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(0.0));
        this.arrayl.add(new Double(d4));
        this.arrayl.add(new Integer(n));
        this.arrayl.add(new Double(d));
        ++this.numOfIons;
    }

    public void setIon(String string, double d, double d2, double d3) {
        String string2;
        IonicRadii ionicRadii = new IonicRadii();
        this.arrayl.add(string);
        this.arrayl.add(new Double(d));
        this.arrayl.add(new Double(d2));
        if (d > 0.0 || d2 > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(d3));
        if (d3 != 0.0) {
            ++this.nonZeroAssocK;
        }
        double d4 = 0.0;
        d4 = this.radiusType ? IonicRadii.hydratedRadius(string) : IonicRadii.radius(string);
        if (d4 == 0.0) {
            String string3 = string + " radius is not in the IonicRadii list\n";
            string2 = "Please enter radius in metres\n";
            d4 = Db.readDouble(string3 + string2);
        }
        this.arrayl.add(new Double(d4));
        int n = 0;
        n = IonicRadii.charge(string);
        if (n == 0) {
            string2 = string + " charge is not in the IonicRadii list\n";
            String string4 = "Please enter charge, e.g +2";
            n = Db.readInt(string2 + string4);
        }
        this.arrayl.add(new Integer(n));
        this.arrayl.add(new Double(-1.0));
        ++this.numOfIons;
    }

    public void setIon(double d, String string, double d2, double d3, double d4) {
        String string2;
        String string3;
        IonicRadii ionicRadii = new IonicRadii();
        this.arrayl.add(string);
        this.arrayl.add(new Double(d2));
        this.arrayl.add(new Double(d3));
        if (d2 > 0.0 || d3 > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(d4));
        if (d4 != 0.0) {
            ++this.nonZeroAssocK;
        }
        double d5 = 0.0;
        if (this.includeIc) {
            d5 = this.radiusType ? IonicRadii.hydratedRadius(string) : IonicRadii.radius(string);
            if (d5 == 0.0) {
                String string4 = string + " radius is not in the IonicRadii list\n";
                string3 = "Please enter radius in metres\n";
                string2 = "Enter 0.0 if you wish interfacial charge to be neglected";
                d5 = Db.readDouble(string4 + string3 + string2);
                if (d5 == 0.0) {
                    this.includeIc = false;
                }
            }
        }
        this.arrayl.add(new Double(d5));
        int n = 0;
        n = IonicRadii.charge(string);
        if (n == 0) {
            string3 = string + " charge is not in the IonicRadii list\n";
            string2 = "Please enter charge, e.g +2";
            n = Db.readInt(string3 + string2);
        }
        this.arrayl.add(new Integer(n));
        this.arrayl.add(new Double(d));
        ++this.numOfIons;
    }

    public void setIon(String string, double d, double d2) {
        String string2;
        IonicRadii ionicRadii = new IonicRadii();
        this.arrayl.add(string);
        this.arrayl.add(new Double(d));
        this.arrayl.add(new Double(d2));
        if (d > 0.0 || d2 > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(0.0));
        double d3 = 0.0;
        d3 = this.radiusType ? IonicRadii.hydratedRadius(string) : IonicRadii.radius(string);
        if (d3 == 0.0) {
            String string3 = string + " radius is not in the IonicRadii list\n";
            string2 = "Please enter radius in metres\n";
            d3 = Db.readDouble(string3 + string2);
            if (d3 == 0.0) {
                this.includeIc = false;
            }
        }
        this.arrayl.add(new Double(d3));
        int n = 0;
        n = IonicRadii.charge(string);
        if (n == 0) {
            string2 = string + " charge is not in the IonicRadii list\n";
            String string4 = "Please enter charge, e.g +2";
            n = Db.readInt(string2 + string4);
        }
        this.arrayl.add(new Integer(n));
        this.arrayl.add(new Double(-1.0));
        ++this.numOfIons;
    }

    public void setIon(double d, String string, double d2, double d3) {
        String string2;
        String string3;
        IonicRadii ionicRadii = new IonicRadii();
        this.arrayl.add(string);
        this.arrayl.add(new Double(d2));
        this.arrayl.add(new Double(d3));
        if (d2 > 0.0 || d3 > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(0.0));
        double d4 = 0.0;
        if (this.includeIc) {
            d4 = this.radiusType ? IonicRadii.hydratedRadius(string) : IonicRadii.radius(string);
            if (d4 == 0.0) {
                String string4 = string + " radius is not in the IonicRadii list\n";
                string3 = "Please enter radius in metres\n";
                string2 = "Enter 0.0 if you wish interfacial charge to be neglected";
                d4 = Db.readDouble(string4 + string3 + string2);
                if (d4 == 0.0) {
                    this.includeIc = false;
                }
            }
        }
        this.arrayl.add(new Double(d4));
        int n = 0;
        n = IonicRadii.charge(string);
        if (n == 0) {
            string3 = string + " charge is not in the IonicRadii list\n";
            string2 = "Please enter charge, e.g +2";
            n = Db.readInt(string3 + string2);
        }
        this.arrayl.add(new Integer(n));
        this.arrayl.add(new Double(d));
        ++this.numOfIons;
    }

    public void setIonophore(double d, double d2) {
        this.ionophoreConcn = d * 1000.0;
        this.ionophoreRad = d2;
        this.ionophoreSet = true;
    }

    public void setIonophore(String string, double d, double d2) {
        this.ionophore = string;
        this.ionophoreConcn = d * 1000.0;
        this.ionophoreRad = d2;
        this.ionophoreSet = true;
    }

    public void setIonophore(String string, double d) {
        this.ionophore = string;
        this.ionophoreConcn = d * 1000.0;
        this.includeIc = false;
        this.ionophoreSet = true;
    }

    public void setIonophore(double d) {
        this.ionophoreConcn = d * 1000.0;
        this.includeIc = false;
        this.ionophoreSet = true;
    }

    public void setVolumes(double d, double d2, double d3) {
        this.volumeA = d;
        this.volumeB = d2;
        this.interfacialArea = d3;
        this.volumeSet = true;
    }

    public void setVolumes(double d, double d2) {
        this.volumeA = d;
        this.volumeB = d2;
        this.includeIc = false;
        this.volumeSet = true;
    }

    public void setRelPerm(double d, double d2, double d3, double d4) {
        this.epsilonA = d;
        this.epsilonB = d2;
        this.epsilonSternA = d3;
        this.epsilonSternB = d4;
        this.epsilonSet = true;
    }

    public void setRelPerm(double d, double d2) {
        this.epsilonA = d;
        this.epsilonB = d2;
        this.includeIc = false;
        this.epsilonSet = true;
    }

    public void setTemp(double d) {
        this.temp = d - -273.15;
        this.tempSet = true;
    }

    public void setEstimate(double d) {
        this.estimate = d;
    }

    public void setStep(double d) {
        this.step = d;
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }

    public void setMaxIterations(int n) {
        this.nMaxIter = n;
    }

    public double getDonnanPotential() {
        return this.donnanPotential;
    }

    public double getDiffuseLayerPotentialA() {
        return this.diffPotentialA;
    }

    public double getDiffuseLayerPotentialB() {
        return this.diffPotentialB;
    }

    public double getSternLayerPotential() {
        return this.sternPotential;
    }

    public double[] getConcnA() {
        double[] dArray = Conv.copy(this.concnA);
        int n = 0;
        while (n < this.numOfIons) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * 0.001;
        }
        return dArray;
    }

    public double[] getConcnB() {
        double[] dArray = Conv.copy(this.concnB);
        int n = 0;
        while (n < this.numOfIons) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * 0.001;
        }
        return dArray;
    }

    public double[] getComplex() {
        double[] dArray = Conv.copy(this.complex);
        int n = 0;
        while (n < this.numOfIons) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * 0.001;
        }
        return dArray;
    }

    public double[] getExcessConcnA() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getExcessConcnA\nThe values of the excess concentrations have not been calculated\nzeros returned");
        }
        double[] dArray = Conv.copy(this.excessConcnA);
        int n = 0;
        while (n < this.numOfIons) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * 0.001;
        }
        return dArray;
    }

    public double[] getExcessConcnB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getExcessConcnA\nThe values of the excess concentrations have not been calculated\nzeros returned");
        }
        double[] dArray = Conv.copy(this.excessConcnB);
        int n = 0;
        while (n < this.numOfIons) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * 0.001;
        }
        return dArray;
    }

    public double[] getExcessComplex() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getExcessConcnA\nThe values of the excess concentrations have not been calculated\nzeros returned");
        }
        double[] dArray = Conv.copy(this.excessComplex);
        int n = 0;
        while (n < this.numOfIons) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * 0.001;
        }
        return dArray;
    }

    public double[] getRatioA() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getRatioA\nThe values of the excess to bulk concentrations have not been calculated\nzeros returned");
        }
        return this.ratioA;
    }

    public double[] getRatioB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getRatioB\nThe values of the excess to bulk concentrations have not been calculated\nzeros returned");
        }
        return this.ratioB;
    }

    public double[] getRatioComplex() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getRatioComplex\nThe values of the excess to bulk concentrations have not been calculated\nzeros returned");
        }
        return this.ratioC;
    }

    public double[] getPartitionCoefficients() {
        return this.partCoeffPot;
    }

    public double[] getPartitionCoefficientsZero() {
        return this.partCoeff;
    }

    public double[] getDeltaMu0() {
        return this.deltaMu0;
    }

    public double getInterfaceCharge() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getInterfaceCharge\nThe value of the interface charge has not been calculated\nzero returned");
        }
        return this.interfacialCharge;
    }

    public double getInterfaceChargeDensity() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getInterfaceChargeDensity\nThe value of the interface charge density has not been calculated\nzero returned");
        }
        return this.interfacialCharge;
    }

    public double getSternCapacitance() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getSternCapacitance\nThe value of the Stern capacitance has not been calculated\nzero returned");
        }
        return this.sternCap * this.interfacialArea;
    }

    public double getDiffuseLayerCapacitanceA() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getDiffuseLayerCapacitanceA\nThe values of the diffuse layer capacitances have not been calculated\nzero returned");
        }
        return this.diffCapA * this.interfacialArea;
    }

    public double getDiffuseLayerCapacitanceB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getDiffuseLayerCapacitanceB\nThe values of the diffuse layer capacitances have not been calculated\nzero returned");
        }
        return this.diffCapB * this.interfacialArea;
    }

    public double getDonnanCapacitanceB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getDonnanCapacitance\nThe value of the Donnan capacitance has not been calculated\nzero returned");
        }
        return this.donnanCap * this.interfacialArea;
    }

    public double getSternThicknessA() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getSternThicknessA\nThe values of the Stern layer thicknesses have not been calculated\nzero returned");
        }
        return this.sternDeltaA;
    }

    public double getSternThicknessB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getSternThicknessB\nThe values of the Stern layer thicknesses have not been calculated\nzero returned");
        }
        return this.sternDeltaB;
    }

    public double getDebyeLengthA() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getDebyeLengthA\nThe values of the Debye lengths have not been calculated\nzero returned");
        }
        return this.recipKappaA;
    }

    public double getDebyeLengthB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getDebyeLengthB\nThe values of the Debye lengths have not been calculated\nzero returned");
        }
        return this.recipKappaB;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double calcPotential() {
        int n;
        boolean bl;
        this.unpack();
        double d = this.numOfIons;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[] dArray5 = null;
        if (this.nonZeroConcns < this.numOfIons) {
            dArray = Conv.copy(this.assocConsts);
            dArray2 = Conv.copy(this.radii);
            dArray3 = Conv.copy(this.charges);
            dArray4 = Conv.copy(this.deltaMu0);
            dArray5 = Conv.copy(this.partCoeff);
            bl = true;
            int n2 = 0;
            while (bl) {
                if (this.indexC[n2] == 0) {
                    for (int i = n2 + 1; i < this.numOfIons; ++i) {
                        this.concnA[i - 1] = this.concnA[i];
                        this.concnB[i - 1] = this.concnB[i];
                        this.complex[i - 1] = this.complex[i];
                        this.molesT[i - 1] = this.molesT[i];
                        this.assocConsts[i - 1] = this.assocConsts[i];
                        this.radii[i - 1] = this.radii[i];
                        this.charges[i - 1] = this.charges[i];
                        this.deltaMu0[i - 1] = this.deltaMu0[i];
                        this.partCoeff[i - 1] = this.partCoeff[i];
                    }
                    --this.numOfIons;
                } else {
                    ++n2;
                }
                if (this.numOfIons != this.nonZeroConcns) continue;
                bl = false;
            }
        }
        bl = false;
        if (this.includeIc) {
            bl = true;
            this.includeIc = false;
        }
        Minimisation minimisation = new Minimisation();
        DonnanMinim donnanMinim = new DonnanMinim(this.numOfIons);
        donnanMinim.numOfIons = this.numOfIons;
        donnanMinim.concnA = this.concnA;
        donnanMinim.concnB = this.concnB;
        donnanMinim.molesT = this.molesT;
        donnanMinim.complex = this.complex;
        donnanMinim.excessConcnA = this.excessConcnA;
        donnanMinim.excessConcnB = this.excessConcnB;
        donnanMinim.excessComplex = this.excessComplex;
        donnanMinim.assocConsts = this.assocConsts;
        donnanMinim.indexK = this.indexK;
        donnanMinim.nonZeroAssocK = this.nonZeroAssocK;
        donnanMinim.radii = this.radii;
        donnanMinim.charges = this.charges;
        donnanMinim.ionophoreConcn = this.ionophoreConcn;
        donnanMinim.ionophoreRad = this.ionophoreRad;
        donnanMinim.volumeA = this.volumeA;
        donnanMinim.volumeB = this.volumeB;
        donnanMinim.interfacialArea = this.interfacialArea;
        donnanMinim.epsilonA = this.epsilonA;
        donnanMinim.epsilonB = this.epsilonB;
        donnanMinim.epsilonSternA = this.epsilonSternA;
        donnanMinim.epsilonSternB = this.epsilonSternB;
        donnanMinim.temp = this.temp;
        donnanMinim.partCoeff = this.partCoeff;
        donnanMinim.partCoeffPot = this.partCoeffPot;
        donnanMinim.sternCap = this.sternCap;
        donnanMinim.sternDeltaA = this.sternDeltaA;
        donnanMinim.sternDeltaB = this.sternDeltaB;
        donnanMinim.chargeValue = this.chargeValue;
        donnanMinim.chargeSame = this.chargeSame;
        donnanMinim.interfacialCharge = this.interfacialCharge;
        donnanMinim.interfacialChargeDensity = this.interfacialChargeDensity;
        donnanMinim.includeIc = this.includeIc;
        double[] dArray6 = new double[]{this.estimate};
        double[] dArray7 = new double[]{this.step};
        minimisation.nelderMead(donnanMinim, dArray6, dArray7, this.tolerance, this.nMaxIter);
        double[] dArray8 = minimisation.getParamValues();
        this.donnanPotential = dArray8[0];
        if (bl) {
            this.includeIc = true;
            dArray6[0] = this.donnanPotential;
            dArray7[0] = this.step;
            minimisation.nelderMead(donnanMinim, dArray6, dArray7, this.tolerance, this.nMaxIter);
            dArray8 = minimisation.getParamValues();
            this.donnanPotential = dArray8[0];
        }
        this.ionConcns(this.donnanPotential);
        if ((double)this.nonZeroConcns != d) {
            n = 1;
            int n3 = 0;
            while (n != 0) {
                if (this.indexC[n3] == 0) {
                    for (int i = n3; i < this.numOfIons; ++i) {
                        this.concnA[i + 1] = this.concnA[i];
                        this.concnB[i + 1] = this.concnB[i];
                        this.complex[i + 1] = this.complex[i];
                        this.excessConcnA[i + 1] = this.excessConcnA[i];
                        this.excessConcnB[i + 1] = this.excessConcnB[i];
                        this.excessComplex[i + 1] = this.excessComplex[i];
                        this.molesT[i + 1] = this.molesT[i];
                        this.assocConsts[i + 1] = this.assocConsts[i];
                        this.radii[i + 1] = this.radii[i];
                        this.charges[i + 1] = this.charges[i];
                        this.deltaMu0[i + 1] = this.deltaMu0[i];
                        this.partCoeff[i + 1] = this.partCoeff[i];
                        this.partCoeffPot[i + 1] = this.partCoeffPot[i];
                    }
                    ++this.numOfIons;
                    this.concnA[n3] = 0.0;
                    this.concnB[n3] = 0.0;
                    this.complex[n3] = 0.0;
                    this.excessConcnA[n3] = 0.0;
                    this.excessConcnB[n3] = 0.0;
                    this.excessComplex[n3] = 0.0;
                    this.molesT[n3] = 0.0;
                    this.assocConsts[n3] = dArray[n3];
                    this.radii[n3] = dArray2[n3];
                    this.charges[n3] = dArray3[n3];
                    this.deltaMu0[n3] = dArray4[n3];
                    this.partCoeff[n3] = dArray5[n3];
                } else {
                    ++n3;
                }
                if (this.numOfIons != this.nonZeroConcns) continue;
                n = 0;
            }
        }
        this.minimum = minimisation.getMinimum();
        this.numIterations = minimisation.getNiter();
        if (this.includeIc) {
            int n4;
            for (n = 0; n < this.numOfIons; ++n) {
                this.ratioA[n] = this.excessConcnA[n] / this.concnA[n];
                this.ratioB[n] = this.excessConcnB[n] / this.concnB[n];
                this.ratioC[n] = this.excessComplex[n] / this.complex[n];
            }
            this.diffCapA = Math.abs(this.interfacialCharge / this.diffPotentialA);
            this.diffCapB = Math.abs(this.interfacialCharge / this.diffPotentialB);
            this.donnanCap = Math.abs(this.interfacialCharge / this.donnanPotential);
            double d2 = 2.0 * Fmath.square(-1.60217646263E-19) * 6.0221419947E23 / (1.2224537278297904E-34 * this.temp);
            double d3 = d2 / this.epsilonA;
            double d4 = d2 / this.epsilonB;
            this.recipKappaA = 0.0;
            this.recipKappaB = 0.0;
            for (n4 = 0; n4 < this.numOfIons; ++n4) {
                this.recipKappaA += this.concnA[n4] * this.charges[n4] * this.charges[n4];
                this.recipKappaB += (this.concnB[n4] + this.complex[n4]) * this.charges[n4] * this.charges[n4];
            }
            this.recipKappaA = 1.0 / Math.sqrt(this.recipKappaA * d3);
            this.recipKappaB = 1.0 / Math.sqrt(this.recipKappaB * d4);
            for (n4 = 0; n4 < this.numOfIons; ++n4) {
                if (this.indexPC[n4]) {
                    this.deltaMu0[n4] = Math.log(this.partCoeff[n4]) * 8.314472296156563 * this.temp;
                    continue;
                }
                int n5 = n4;
                this.deltaMu0[n5] = this.deltaMu0[n5] * 6.0221419947E23;
            }
            for (n4 = 0; n4 < this.numOfIons; ++n4) {
                this.partCoeffPot[n4] = this.partCoeff[n4] * Math.exp(-this.donnanPotential * this.charges[n4] * -1.60217646263E-19 / (1.380650324E-23 * this.temp));
            }
        }
        return this.donnanPotential;
    }

    private void unpack() {
        if (!this.volumeSet) {
            throw new IllegalArgumentException("The volumes of the partitions have not been set");
        }
        if (this.numOfIons == 0) {
            throw new IllegalArgumentException("No ions have been entered");
        }
        if (this.nonZeroConcns == 0) {
            throw new IllegalArgumentException("No non-zero ionic concentrations have been entered");
        }
        if (!this.epsilonSet) {
            throw new IllegalArgumentException("The relative permittivities of the partitions have not been set");
        }
        if (!this.tempSet) {
            System.out.println("The temperature has not been entered\na value of 25 degrees Celsius has been used");
        }
        if (!this.ionophoreSet) {
            System.out.println("The ionophore has not been entered\na concentration value of zero has been used");
        }
        this.ionNames = new String[this.numOfIons];
        this.concnA = new double[this.numOfIons];
        this.concnB = new double[this.numOfIons];
        this.molesT = new double[this.numOfIons];
        this.complex = new double[this.numOfIons];
        this.excessConcnA = new double[this.numOfIons];
        this.excessConcnB = new double[this.numOfIons];
        this.excessComplex = new double[this.numOfIons];
        this.ratioA = new double[this.numOfIons];
        this.ratioB = new double[this.numOfIons];
        this.ratioC = new double[this.numOfIons];
        this.assocConsts = new double[this.numOfIons];
        this.radii = new double[this.numOfIons];
        this.charges = new double[this.numOfIons];
        this.deltaMu0 = new double[this.numOfIons];
        this.partCoeff = new double[this.numOfIons];
        this.partCoeffPot = new double[this.numOfIons];
        this.indexK = new int[this.nonZeroAssocK];
        this.indexC = new int[this.numOfIons];
        this.indexPC = new boolean[this.numOfIons];
        Double d = null;
        Integer n = null;
        int n2 = 0;
        this.chargeValue = 0.0;
        this.chargeSame = true;
        for (int i = 0; i < this.numOfIons; ++i) {
            this.ionNames[i] = (String)this.arrayl.get(0 + i * 7);
            d = (Double)this.arrayl.get(1 + i * 7);
            this.concnA[i] = d * 1000.0;
            d = (Double)this.arrayl.get(2 + i * 7);
            this.concnB[i] = d * 1000.0;
            this.molesT[i] = this.concnA[i] * this.volumeA + this.concnB[i] * this.volumeB;
            this.indexC[i] = this.molesT[i] > 0.0 ? 1 : 0;
            d = (Double)this.arrayl.get(3 + i * 7);
            this.assocConsts[i] = d * 0.001;
            if (this.assocConsts[i] > 0.0) {
                this.indexK[n2] = i;
                ++n2;
            }
            d = (Double)this.arrayl.get(4 + i * 7);
            this.radii[i] = d;
            n = (Integer)this.arrayl.get(5 + i * 7);
            this.charges[i] = n.intValue();
            if (i == 0) {
                this.chargeValue = Math.abs(this.charges[0]);
            } else if (Math.abs(this.charges[i]) != this.chargeValue) {
                this.chargeSame = false;
            }
            d = (Double)this.arrayl.get(6 + i * 7);
            this.partCoeff[i] = d;
            this.indexPC[i] = true;
            if (this.partCoeff[i] == -1.0) {
                this.indexPC[i] = false;
                this.deltaMu0[i] = this.BornChargingEnergy(this.radii[i], this.charges[i], this.epsilonB) - this.BornChargingEnergy(this.radii[i], this.charges[i], this.epsilonA);
                this.partCoeff[i] = Math.exp(this.deltaMu0[i] / (1.380650324E-23 * this.temp));
            }
            if (this.charges[i] < 0.0) {
                ++this.numOfAnions;
            } else {
                ++this.numOfCations;
            }
            if (this.ionophoreConcn != 0.0) continue;
            this.nonZeroAssocK = 0;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            if (this.charges[i] > 0.0) {
                d3 += this.molesT[i] * this.charges[i];
            } else {
                d4 += this.molesT[i] * this.charges[i];
            }
            d2 = d3 + d4;
        }
        if (Math.abs(d2) > d3 * this.tol) {
            String string = "Class: Donnan, method: unpack()\n";
            String string2 = "Total charge = " + d2 + " mol/dm, i.e. is not equal to zero\n";
            String string3 = "Positive charge = " + d3 + " mol/dm\n";
            String string4 = "Do you wish to continue?";
            String string5 = string + string2 + string3 + string4;
            int n3 = JOptionPane.showConfirmDialog(null, string5, "Neutrality check", 0, 3);
            if (n3 == 1) {
                System.exit(0);
            }
        }
    }

    public double BornChargingEnergy(double d, double d2, double d3) {
        return Fmath.square(-1.60217646263E-19 * d2) / (Math.PI * 8 * d * 8.854187817E-12 * d3);
    }

    public void ionConcns(double d) {
        for (int i = 0; i < this.numOfIons; ++i) {
            this.partCoeffPot[i] = this.partCoeff[i] * Math.exp(-d * this.charges[i] * -1.60217646263E-19 / (1.380650324E-23 * this.temp));
        }
        if (!this.includeIc) {
            if (this.nonZeroAssocK < 2) {
                this.calcConcnsSingleK(d);
            } else {
                this.calcConcnsMultiK(d);
            }
        } else {
            this.calcConcnsMultiK(d);
        }
    }

    public void calcConcnsSingleK(double d) {
        for (int i = 0; i < this.numOfIons; ++i) {
            if (this.assocConsts[i] == 0.0 || this.ionophoreConcn == 0.0) {
                if (this.molesT[i] == 0.0) {
                    this.concnB[i] = 0.0;
                    this.concnA[i] = 0.0;
                    this.complex[i] = 0.0;
                    continue;
                }
                this.concnB[i] = this.molesT[i] / (this.volumeA * this.partCoeffPot[i] + this.volumeB);
                this.concnA[i] = this.concnB[i] * this.partCoeffPot[i];
                this.complex[i] = 0.0;
                continue;
            }
            double d2 = this.volumeB + this.volumeA * this.partCoeffPot[i] + this.volumeB * this.assocConsts[i] * this.ionophoreConcn - this.assocConsts[i] * this.molesT[i];
            double d3 = this.assocConsts[i] * (this.volumeB + this.volumeA * this.partCoeffPot[i]);
            double d4 = -this.molesT[i];
            double d5 = d2 * d2 - 4.0 * d3 * d4;
            if (d5 < 0.0) {
                System.out.println("Class: DonnanMinim\nMethod: ionConcns\nthe square root term (b2-4ac) of the quadratic = " + d5);
                System.out.println("this term was set to zero as the negative value MAY have arisen from rounding errors");
                d5 = 0.0;
            }
            double d6 = -0.5 * (d2 + Fmath.sign(d2) * Math.sqrt(d5));
            double d7 = d6 / d3;
            double d8 = d4 / d6;
            double d9 = this.molesT[i] / (this.volumeA * this.partCoeffPot[i] + this.volumeB);
            if (d7 >= 0.0 && d7 <= d9) {
                if (d8 < 0.0 || d8 > d9) {
                    this.concnB[i] = d7;
                    this.concnA[i] = this.concnB[i] * this.partCoeffPot[i];
                    this.complex[i] = this.assocConsts[i] * this.ionophoreConcn * this.concnB[i] / (1.0 + this.assocConsts[i] * this.concnB[i]);
                    continue;
                }
                System.out.println("Class: DonnanMinim\nMethod: ionConcns");
                System.out.println("error1: no physically meaningfull root");
                System.out.println("root1 = " + d7 + " root2 = " + d8 + " limit = " + d9);
                System.exit(0);
                continue;
            }
            if (d8 >= 0.0 && d8 <= d9) {
                if (d7 < 0.0 || d7 > d9) {
                    this.concnB[i] = d8;
                    this.concnA[i] = this.concnB[i] * this.partCoeffPot[i];
                    this.complex[i] = this.assocConsts[i] * this.ionophoreConcn * this.concnB[i] / (1.0 + this.assocConsts[i] * this.concnB[i]);
                    continue;
                }
                System.out.println("Class: DonnanMinim\nMethod: ionConcns");
                System.out.println("error2: no physically meaningfull root");
                System.out.println("root1 = " + d7 + " root2 = " + d8 + " limit = " + d9);
                System.exit(0);
                continue;
            }
            System.out.println("Class: DonnanMinim\nMethod: ionConcns");
            System.out.println("error3: no physically meaningfull root");
            System.out.println("root1 = " + d7 + " root2 = " + d8 + " limit = " + d9);
            System.exit(0);
        }
    }

    public void calcConcnsMultiK(double d) {
        double[] dArray = new double[this.numOfIons];
        double[] dArray2 = new double[this.numOfIons];
        for (int i = 0; i < this.numOfIons; ++i) {
            if (this.molesT[i] == 0.0) {
                this.concnB[i] = 0.0;
                this.concnA[i] = 0.0;
                this.complex[i] = 0.0;
                this.excessConcnA[i] = 0.0;
                this.excessConcnB[i] = 0.0;
                this.excessComplex[i] = 0.0;
            } else {
                this.concnB[i] = this.molesT[i] / (this.volumeA * this.partCoeffPot[i] + this.volumeB);
                this.concnA[i] = this.concnB[i] * this.partCoeffPot[i];
                this.complex[i] = 0.0;
                this.excessConcnA[i] = 0.0;
                this.excessConcnB[i] = 0.0;
                this.excessComplex[i] = 0.0;
            }
            dArray[i] = this.concnB[i];
            dArray2[i] = 0.05 * dArray[i];
        }
        Minimisation minimisation = new Minimisation();
        DonnanConcn donnanConcn = new DonnanConcn();
        donnanConcn.numOfIons = this.numOfIons;
        donnanConcn.concnA = this.concnA;
        donnanConcn.concnB = this.concnB;
        donnanConcn.molesT = this.molesT;
        donnanConcn.complex = this.complex;
        donnanConcn.excessConcnA = this.excessConcnA;
        donnanConcn.excessConcnB = this.excessConcnB;
        donnanConcn.excessComplex = this.excessComplex;
        donnanConcn.assocConsts = this.assocConsts;
        donnanConcn.indexK = this.indexK;
        donnanConcn.nonZeroAssocK = this.nonZeroAssocK;
        donnanConcn.radii = this.radii;
        donnanConcn.charges = this.charges;
        donnanConcn.ionophoreConcn = this.ionophoreConcn;
        donnanConcn.ionophoreRad = this.ionophoreRad;
        donnanConcn.volumeA = this.volumeA;
        donnanConcn.volumeB = this.volumeB;
        donnanConcn.interfacialArea = this.interfacialArea;
        donnanConcn.epsilonA = this.epsilonA;
        donnanConcn.epsilonB = this.epsilonB;
        donnanConcn.epsilonSternA = this.epsilonSternA;
        donnanConcn.epsilonSternB = this.epsilonSternB;
        donnanConcn.temp = this.temp;
        donnanConcn.partCoeffPot = this.partCoeffPot;
        donnanConcn.sternCap = this.sternCap;
        donnanConcn.sternDeltaA = this.sternDeltaA;
        donnanConcn.sternDeltaB = this.sternDeltaB;
        donnanConcn.chargeValue = this.chargeValue;
        donnanConcn.chargeSame = this.chargeSame;
        donnanConcn.interfacialCharge = this.interfacialCharge;
        donnanConcn.interfacialChargeDensity = this.interfacialChargeDensity;
        donnanConcn.potential = d;
        donnanConcn.includeIc = this.includeIc;
        minimisation.nelderMead(donnanConcn, dArray, dArray2, 1.0E-20, 10000);
        double[] dArray3 = minimisation.getParamValues();
        this.freeIonophoreConcn = this.ionophoreConcn;
        for (int i = 0; i < this.numOfIons; ++i) {
            this.concnB[i] = dArray3[i];
            this.concnA[i] = this.concnB[i] * this.partCoeffPot[i];
            this.freeIonophoreConcn -= this.complex[i];
        }
        this.interfacialCharge = donnanConcn.interfacialCharge;
        this.interfacialChargeDensity = donnanConcn.interfacialChargeDensity;
        this.sternCap = donnanConcn.sternCap;
        this.sternDeltaA = donnanConcn.sternDeltaA;
        this.sternDeltaB = donnanConcn.sternDeltaB;
        this.sternPotential = donnanConcn.sternPotential;
        this.diffPotentialA = donnanConcn.diffPotentialA;
        this.diffPotentialB = donnanConcn.diffPotentialB;
    }

    public void printToFile(String string) {
        int n;
        FileOutput fileOutput = new FileOutput(string);
        fileOutput.dateAndTimeln(string);
        fileOutput.println();
        fileOutput.print("Donnan potential = ");
        fileOutput.printsp(Fmath.truncate(this.donnanPotential, 7));
        fileOutput.println("volts");
        if (this.includeIc) {
            fileOutput.print("Compartment A double layer potential difference = ");
            fileOutput.printsp(Fmath.truncate(this.diffPotentialA, 7));
            fileOutput.println("volts");
            fileOutput.print("Compartment B double layer potential difference = ");
            fileOutput.printsp(Fmath.truncate(this.diffPotentialB, 7));
            fileOutput.println("volts");
            fileOutput.print("Stern potential difference = ");
            fileOutput.printsp(Fmath.truncate(this.sternPotential, 7));
            fileOutput.println("volts");
        }
        fileOutput.println();
        fileOutput.println("Ionic concentrations expressed as mol per cubic decimetre (M)");
        fileOutput.println("Total = equivalent concentration with all ions in compartment A");
        if (this.includeIc) {
            fileOutput.printtab("Ion");
            fileOutput.println("Bulk concentrations / M                         Excess concentrations / M                       total / M");
            fileOutput.printtab(" ");
            fileOutput.println("A               B               complex         A               B               complex         ");
            for (n = 0; n < this.numOfIons; ++n) {
                fileOutput.printtab(this.ionNames[n]);
                fileOutput.printtab(Fmath.truncate(this.concnA[n] * 0.001, 7));
                fileOutput.printtab(Fmath.truncate(this.concnB[n] * 0.001, 7));
                fileOutput.printtab(Fmath.truncate(this.complex[n] * 0.001, 7));
                fileOutput.printtab(Fmath.truncate(this.excessConcnA[n] * 0.001, 7));
                fileOutput.printtab(Fmath.truncate(this.excessConcnB[n] * 0.001, 7));
                fileOutput.printtab(Fmath.truncate(this.excessComplex[n] * 0.001, 7));
                fileOutput.println(Fmath.truncate(this.molesT[n] * 0.001 / this.volumeA, 7));
            }
        } else {
            fileOutput.printtab("Ion");
            fileOutput.println("A               B               complex         total");
            for (n = 0; n < this.numOfIons; ++n) {
                fileOutput.printtab(this.ionNames[n]);
                fileOutput.printtab(Fmath.truncate(this.concnA[n] * 0.001, 7));
                fileOutput.printtab(Fmath.truncate(this.concnB[n] * 0.001, 7));
                fileOutput.printtab(Fmath.truncate(this.complex[n] * 0.001, 7));
                fileOutput.println(Fmath.truncate(this.molesT[n] * 0.001 / this.volumeA, 7));
            }
        }
        fileOutput.println();
        fileOutput.println("mols of each ionic species");
        if (this.includeIc) {
            fileOutput.printtab("Ion");
            fileOutput.println("Bulk mols                                       Excess mols                                 total mols");
            fileOutput.printtab(" ");
            fileOutput.println("A               B               complex         A               B               complex         ");
            for (n = 0; n < this.numOfIons; ++n) {
                fileOutput.printtab(this.ionNames[n]);
                fileOutput.printtab(Fmath.truncate(this.concnA[n] * this.volumeA, 7));
                fileOutput.printtab(Fmath.truncate(this.concnB[n] * this.volumeB, 7));
                fileOutput.printtab(Fmath.truncate(this.complex[n] * this.volumeB, 7));
                fileOutput.printtab(Fmath.truncate(this.excessConcnA[n] * this.volumeA, 7));
                fileOutput.printtab(Fmath.truncate(this.excessConcnB[n] * this.volumeB, 7));
                fileOutput.printtab(Fmath.truncate(this.excessComplex[n] * this.volumeB, 7));
                fileOutput.println(Fmath.truncate(this.molesT[n], 7));
            }
        } else {
            fileOutput.printtab("Ion");
            fileOutput.println("A               B               complex         total mols");
            for (n = 0; n < this.numOfIons; ++n) {
                fileOutput.printtab(this.ionNames[n]);
                fileOutput.printtab(Fmath.truncate(this.concnA[n] * this.volumeA, 7));
                fileOutput.printtab(Fmath.truncate(this.concnB[n] * this.volumeB, 7));
                fileOutput.printtab(Fmath.truncate(this.complex[n] * this.volumeB, 7));
                fileOutput.println(Fmath.truncate(this.molesT[n], 7));
            }
        }
        fileOutput.println();
        if (this.includeIc) {
            fileOutput.println("Ratios of excess concentration over bulk concentration");
            fileOutput.printtab("Ion");
            fileOutput.println("A               B               complex");
            for (n = 0; n < this.numOfIons; ++n) {
                fileOutput.printtab(this.ionNames[n]);
                fileOutput.printtab(Fmath.truncate(this.ratioA[n], 7));
                fileOutput.printtab(Fmath.truncate(this.ratioB[n], 7));
                fileOutput.println(Fmath.truncate(this.ratioC[n], 7));
            }
            fileOutput.println();
        }
        fileOutput.print("Total ionophore concentration = ");
        fileOutput.printsp(Fmath.truncate(this.ionophoreConcn * 0.001, 7));
        fileOutput.println("M");
        fileOutput.print("Free ionophore concentration = ");
        fileOutput.printsp(Fmath.truncate(this.freeIonophoreConcn * 0.001, 7));
        fileOutput.println("M");
        fileOutput.print("Total ionophore moles = ");
        fileOutput.printsp(Fmath.truncate(this.ionophoreConcn * this.volumeB, 7));
        fileOutput.println("mol");
        fileOutput.print("Ionophore radius = ");
        fileOutput.printsp(Fmath.truncate(this.ionophoreRad, 7));
        fileOutput.println("m");
        fileOutput.println();
        if (this.includeIc) {
            fileOutput.print("Interface charge density = ");
            fileOutput.printsp(Fmath.truncate(this.interfacialChargeDensity, 7));
            fileOutput.printsp("C per square metre   ->   ");
            fileOutput.printsp(Fmath.truncate(this.interfacialChargeDensity / Math.abs(-1.60217646263E-19), 7));
            fileOutput.println("unit charges per square metre ");
            fileOutput.print("Total interface charge = ");
            fileOutput.printsp(Fmath.truncate(this.interfacialCharge, 7));
            fileOutput.printsp("unit charges   ->   ");
            fileOutput.printsp(Fmath.truncate(this.interfacialCharge / Math.abs(-1.60217646263E-19), 7));
            fileOutput.println("unit charges ");
            fileOutput.print("Overall interfacial capacitance = ");
            fileOutput.printsp(Fmath.truncate(this.donnanCap * this.interfacialArea, 7));
            fileOutput.printsp("F ");
            fileOutput.print("  ->  ");
            fileOutput.printsp(Fmath.truncate(this.donnanCap, 7));
            fileOutput.println("Farads per square metre");
            fileOutput.print("Diffuse double layer capacitance (Compartment A) = ");
            fileOutput.printsp(Fmath.truncate(this.diffCapA * this.interfacialArea, 7));
            fileOutput.printsp("F ");
            fileOutput.print("  ->  ");
            fileOutput.printsp(Fmath.truncate(this.diffCapA, 7));
            fileOutput.println("Farads per square metre");
            fileOutput.print("Diffuse double layer capacitance (Compartment B) = ");
            fileOutput.printsp(Fmath.truncate(this.diffCapB * this.interfacialArea, 7));
            fileOutput.printsp("F ");
            fileOutput.print("  ->  ");
            fileOutput.printsp(Fmath.truncate(this.diffCapB, 7));
            fileOutput.println("Farads per square metre");
            fileOutput.print("Stern capacitance = ");
            fileOutput.printsp(Fmath.truncate(this.sternCap * this.interfacialArea, 7));
            fileOutput.printsp("F ");
            fileOutput.print("  ->  ");
            fileOutput.printsp(Fmath.truncate(this.sternCap, 7));
            fileOutput.println("Farads per square metre");
            fileOutput.print("Stern thickness (Compartment A) = ");
            fileOutput.printsp(Fmath.truncate(this.sternDeltaA, 7));
            fileOutput.println("m");
            fileOutput.print("Stern thickness (Compartment B) = ");
            fileOutput.printsp(Fmath.truncate(this.sternDeltaB, 7));
            fileOutput.println("m");
            fileOutput.print("Debye length (Compartment A) = ");
            fileOutput.printsp(Fmath.truncate(this.recipKappaA, 7));
            fileOutput.println("m");
            fileOutput.print("Debye length (Compartment B) = ");
            fileOutput.printsp(Fmath.truncate(this.recipKappaB, 7));
            fileOutput.println("m");
            fileOutput.println("Compartment thicknesses assuming cubes with one side equal to the interfacial area");
            fileOutput.print("Compartment A thickness = ");
            fileOutput.printsp(Fmath.truncate(this.volumeA / this.interfacialArea, 7));
            fileOutput.println("m");
            fileOutput.print("Compartment B thickness = ");
            fileOutput.printsp(Fmath.truncate(this.volumeB / this.interfacialArea, 7));
            fileOutput.println("m");
            fileOutput.println();
        }
        fileOutput.print("Volume of compartment A = ");
        fileOutput.printsp(this.volumeA);
        fileOutput.println("cubic metres");
        fileOutput.print("Volume of compartment B = ");
        fileOutput.printsp(this.volumeB);
        fileOutput.println("cubic metres");
        fileOutput.print("Interfacial area = ");
        fileOutput.printsp(this.interfacialArea);
        fileOutput.println("square metres");
        fileOutput.print("Relative electrical permittivity of compartment A = ");
        fileOutput.println(this.epsilonA);
        fileOutput.print("Relative electrical permittivity of compartment B = ");
        fileOutput.println(this.epsilonB);
        fileOutput.print("Relative electrical permittivity of compartment A Stern layer= ");
        fileOutput.println(this.epsilonSternA);
        fileOutput.print("Relative electrical permittivity of compartment B Stern layer= ");
        fileOutput.println(this.epsilonSternB);
        fileOutput.print("Temperature= ");
        fileOutput.printsp(this.temp + -273.15);
        fileOutput.println("degrees Celsius");
        fileOutput.println();
        fileOutput.printtab("Ion");
        fileOutput.printtab("Radius   ");
        fileOutput.printtab("Charge");
        fileOutput.printtab("Partition");
        fileOutput.printtab("Partition");
        fileOutput.printtab("Delta(mu0)");
        fileOutput.println("Ion-Ionophore ");
        fileOutput.printtab("  ");
        fileOutput.printtab(" m       ");
        fileOutput.printtab(" ");
        fileOutput.printtab("Coefficient ");
        fileOutput.printtab("Coefficient ");
        fileOutput.printtab("/ J per mol");
        fileOutput.println("associaion ");
        fileOutput.printtab("  ");
        fileOutput.printtab("         ");
        fileOutput.printtab(" ");
        fileOutput.printtab("at      ");
        fileOutput.printtab("at zero ");
        fileOutput.printtab("       ");
        fileOutput.println("constant");
        fileOutput.printtab("  ");
        fileOutput.printtab("          ");
        fileOutput.printtab(" ");
        fileOutput.printtab("equilibrium ");
        fileOutput.printtab("potential ");
        fileOutput.printtab("          ");
        fileOutput.println("mol per cubic dm");
        for (n = 0; n < this.numOfIons; ++n) {
            fileOutput.printtab(this.ionNames[n]);
            fileOutput.printtab(Fmath.truncate(this.radii[n], 4));
            fileOutput.printtab(this.charges[n]);
            fileOutput.printtab(Fmath.truncate(this.partCoeffPot[n], 4));
            fileOutput.printtab(Fmath.truncate(this.partCoeff[n], 4));
            fileOutput.printtab(Fmath.truncate(this.deltaMu0[n], 4));
            fileOutput.println(Fmath.truncate(this.assocConsts[n] * 1000.0, 4));
        }
        fileOutput.close();
    }

    public void printToFile() {
        String string = "DonnanOutputFile.txt";
        this.printToFile(string);
    }
}

