/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.analysis.RegressionFunction3;
import flanagan.math.Fmath;

class AmershamDual
implements RegressionFunction3 {
    private double[][] xErrors = null;
    private double[] yErrors = null;

    AmershamDual() {
    }

    @Override
    public double[] function(double[] dArray, double[] dArray2, int n) {
        double[] dArray3 = new double[2];
        dArray3[0] = this.calcResponse(dArray[0], dArray[1], dArray[2], dArray[3], dArray2[0], dArray[4]);
        if (n >= 0) {
            dArray3[1] = this.calcSquareWeight(dArray[0], dArray[1], dArray[2], dArray[3], dArray2[0], dArray[4], this.xErrors[0][n], this.yErrors[n]);
        }
        return dArray3;
    }

    public double calcResponse(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d + d2 + d5;
        double d8 = 2.0 * d3 * (d2 - d4) / d2;
        double d9 = d7 + d3 + Math.sqrt(Fmath.square(d7 - d3) + 4.0 * d * d3);
        double d10 = d6 * (d8 / d9 + d4 / d2);
        return d10;
    }

    public double calcSquareWeight(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = 2.0 * d3 * (d2 - d4) / d2;
        double d10 = d + d2 + d5;
        double d11 = Math.sqrt(Fmath.square(d10 - d3) + 4.0 * d * d3);
        double d12 = 1.0 + (d10 - d3) / d11;
        double d13 = d6 * d9 * d12;
        double d14 = d10 + d3 + d11;
        d14 *= d14;
        double d15 = d13 / d14;
        return d8 * d8 + d15 * d15 * d7 * d7;
    }

    public void setXerrors(double[][] dArray) {
        this.xErrors = dArray;
    }

    public void setYerrors(double[] dArray) {
        this.yErrors = dArray;
    }
}

