/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.analysis.RegressionFunction;
import flanagan.complex.Complex;
import flanagan.optics.Reflectivity;

class RegressFunct
implements RegressionFunction {
    public int numberOfLayers = 0;
    public String mode = null;
    public double eVectorAngleDeg = 0.0;
    public double[] thicknesses = null;
    public double[] incidentAnglesDeg = null;
    public Complex[][] refractiveIndices = null;
    public Complex[][] relativeMagneticPermeabilities = null;
    public int regressionOption = 0;
    public int[] thicknessEstimateIndices = null;
    public int[] refractIndexRealEstimateIndices = null;
    public int[] refractIndexImagEstimateIndices = null;
    public int[] magneticPermRealEstimateIndices = null;
    public int[] magneticPermImagEstimateIndices = null;

    RegressFunct() {
    }

    @Override
    public double function(double[] dArray, double[] dArray2) {
        int n;
        Reflectivity reflectivity = new Reflectivity(this.numberOfLayers);
        if (this.mode.equals("mixed")) {
            reflectivity.setMode(this.eVectorAngleDeg);
        } else {
            reflectivity.setMode(this.mode);
        }
        int n2 = 0;
        int n3 = this.thicknessEstimateIndices.length;
        for (n = 0; n < n3; ++n) {
            this.thicknesses[this.thicknessEstimateIndices[n]] = dArray[n2];
            ++n2;
        }
        reflectivity.setThicknesses(this.thicknesses);
        n3 = this.refractIndexRealEstimateIndices.length;
        for (n = 0; n < n3; ++n) {
            this.refractiveIndices[0][this.refractIndexRealEstimateIndices[n]].setReal(dArray[n2]);
            ++n2;
        }
        n3 = this.refractIndexImagEstimateIndices.length;
        for (n = 0; n < n3; ++n) {
            this.refractiveIndices[0][this.refractIndexImagEstimateIndices[n]].setImag(dArray[n2]);
            ++n2;
        }
        reflectivity.setRefractiveIndices(this.refractiveIndices);
        n3 = this.magneticPermRealEstimateIndices.length;
        for (n = 0; n < n3; ++n) {
            this.relativeMagneticPermeabilities[0][this.magneticPermRealEstimateIndices[n]].setReal(dArray[n2]);
            ++n2;
        }
        n3 = this.magneticPermImagEstimateIndices.length;
        for (n = 0; n < n3; ++n) {
            this.relativeMagneticPermeabilities[0][this.magneticPermImagEstimateIndices[n]].setImag(dArray[n2]);
            ++n2;
        }
        reflectivity.setRelativeMagneticPermeabilities(this.relativeMagneticPermeabilities);
        reflectivity.setIncidentAngle(dArray2[0]);
        double d = 0.0;
        switch (this.regressionOption) {
            case 1: {
                d = ((double[])reflectivity.getReflectivities())[0];
                break;
            }
            case 2: {
                d = ((double[])reflectivity.getTransmissivities())[0];
                break;
            }
            case 3: {
                d = dArray[n2] * ((double[])reflectivity.getEvanescentFields())[0];
                break;
            }
            default: {
                throw new IllegalArgumentException("Regresion option " + this.regressionOption + " does not exist");
            }
        }
        return d;
    }
}

