/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.analysis.Stat;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.optics.FunctTE;
import flanagan.optics.FunctTEplot;
import flanagan.optics.FunctTEsuper;
import flanagan.optics.FunctTM;
import flanagan.optics.FunctTMplot;
import flanagan.optics.FunctTMsuper;
import flanagan.optics.RefractiveIndex;
import flanagan.plot.PlotGraph;
import flanagan.roots.RealRoot;
import java.util.ArrayList;

public class PlanarWaveguide {
    protected double[][] measurementsTE = null;
    protected int numberOfTEmeasurements = 0;
    protected double[] thicknessesUsedTE = null;
    protected double[] calcEffectRefrIndicesTE = null;
    protected boolean setMeasurementsTE = false;
    protected boolean setErrorsTE = false;
    protected double maximumTEmodeEffectiveRefractiveIndex = 0.0;
    protected double minimumTEmodeEffectiveRefractiveIndex = 0.0;
    protected double[][] measurementsTM = null;
    protected int numberOfTMmeasurements = 0;
    protected double[] thicknessesUsedTM = null;
    protected double[] calcEffectRefrIndicesTM = null;
    protected boolean setMeasurementsTM = false;
    protected boolean setErrorsTM = false;
    protected double maximumTMmodeEffectiveRefractiveIndex = 0.0;
    protected double minimumTMmodeEffectiveRefractiveIndex = 0.0;
    protected double maximumEffectiveRefractiveIndex = 0.0;
    protected double minimumEffectiveRefractiveIndex = 0.0;
    protected int numberOfMeasurements = 0;
    protected boolean setMeasurements = false;
    protected boolean setWeights = false;
    protected boolean[] eliminatedTE = null;
    protected boolean[] eliminatedTM = null;
    protected double wavelength = 0.0;
    protected boolean setWavelength = false;
    protected double ko = 0.0;
    protected double superstrateRefractiveIndex = 0.0;
    protected double superstrateRefractiveIndex2 = 0.0;
    protected double[] calcSuperstrateTEmodeRI = null;
    protected double[] calcSuperstrateTMmodeRI = null;
    protected double meanTEmodeSuperstrateRefractiveIndex = Double.NaN;
    protected double meanTMmodeSuperstrateRefractiveIndex = Double.NaN;
    protected double sdTEmodeSuperstrateRefractiveIndex = Double.NaN;
    protected double sdTMmodeSuperstrateRefractiveIndex = Double.NaN;
    protected double sdSuperstrateRefractiveIndex = Double.NaN;
    protected boolean setSuperstrate = false;
    protected boolean superCalculationDone = false;
    protected double substrateRefractiveIndex = 0.0;
    protected double substrateRefractiveIndex2 = 0.0;
    protected boolean setSubstrate = false;
    protected double coreFilmRefractiveIndex = 0.0;
    protected double coreFilmRefractiveIndex2 = 0.0;
    protected boolean setCore = false;
    protected double[] coreFilmTEmodeRefractiveIndices = null;
    protected double[] coreFilmTMmodeRefractiveIndices = null;
    protected double meanTEmodeCoreFilmRefractiveIndex = Double.NaN;
    protected double meanTMmodeCoreFilmRefractiveIndex = Double.NaN;
    protected double meanCoreFilmRefractiveIndex = Double.NaN;
    protected double meanCoreFilmRefractiveIndex2 = Double.NaN;
    protected double sdTEmodeCoreFilmRefractiveIndex = Double.NaN;
    protected double sdTMmodeCoreFilmRefractiveIndex = Double.NaN;
    protected double sdCoreFilmRefractiveIndex = Double.NaN;
    protected double lowerBound = 0.0;
    protected double upperBound = 0.0;
    protected double tolerance = 1.0E-9;
    protected boolean calculationDone = false;
    protected double prismToWaveguideGap = Double.POSITIVE_INFINITY;
    protected boolean setPrismToWaveguideGap = false;
    protected boolean fixedPrismToWaveguideGap = true;
    protected double prismRefractiveIndex = 0.0;
    protected double prismRefractiveIndex2 = 0.0;

    public void enterTEmodeData(double d, double d2, double d3) {
        if (this.setMeasurementsTE) {
            if (this.setErrorsTE) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n = this.numberOfTEmeasurements + 1;
            double[][] dArray = new double[n][4];
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    dArray[i][j] = this.measurementsTE[i][j];
                }
            }
            dArray[this.numberOfTEmeasurements][0] = d;
            dArray[this.numberOfTEmeasurements][1] = d2;
            dArray[this.numberOfTEmeasurements][2] = 1.0;
            dArray[this.numberOfTEmeasurements][3] = d3;
            this.measurementsTE = dArray;
            this.numberOfTEmeasurements = n;
        } else {
            this.measurementsTE = new double[1][4];
            this.measurementsTE[0][0] = d;
            this.measurementsTE[0][1] = d2;
            this.measurementsTE[0][2] = 1.0;
            this.measurementsTE[0][3] = d3;
            this.numberOfTEmeasurements = 1;
        }
        this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTE = true;
        this.setMeasurements = true;
    }

    public void enterTEmodeData(double d, double d2, double d3, double d4) {
        if (this.setMeasurementsTE) {
            if (!this.setErrorsTE) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n = this.numberOfTEmeasurements + 1;
            double[][] dArray = new double[n][4];
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    dArray[i][j] = this.measurementsTE[i][j];
                }
            }
            dArray[this.numberOfTEmeasurements][0] = d;
            dArray[this.numberOfTEmeasurements][1] = d2;
            dArray[this.numberOfTEmeasurements][2] = d3;
            dArray[this.numberOfTEmeasurements][3] = d4;
            this.measurementsTE = dArray;
            this.numberOfTEmeasurements = n;
        } else {
            this.measurementsTE = new double[1][4];
            this.measurementsTE[0][0] = d;
            this.measurementsTE[0][1] = d2;
            this.measurementsTE[0][2] = d3;
            this.measurementsTE[0][3] = d4;
            this.numberOfTEmeasurements = 1;
        }
        this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTE = true;
        this.setMeasurements = true;
        this.setErrorsTE = true;
    }

    public void enterTEmodeData(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of effective refractive indices, " + n);
        }
        int n3 = dArray3.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTE) {
            int n4;
            if (this.setErrorsTE) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTEmeasurements + n2;
            double[][] dArray4 = new double[n5][4];
            for (n4 = 0; n4 < this.numberOfTEmeasurements; ++n4) {
                for (int i = 0; i < 4; ++i) {
                    dArray4[n4][i] = this.measurementsTE[n4][i];
                }
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTEmeasurements + n4][0] = dArray[n4];
                dArray4[this.numberOfTEmeasurements + n4][1] = dArray2[n4];
                dArray4[this.numberOfTEmeasurements + n4][2] = 1.0;
                dArray4[this.numberOfTEmeasurements + n4][3] = dArray3[n4];
            }
            this.measurementsTE = dArray4;
            this.numberOfTEmeasurements = n5;
        } else {
            this.numberOfTEmeasurements = n2;
            this.measurementsTE = new double[this.numberOfTEmeasurements][4];
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                this.measurementsTE[i][0] = dArray[i];
                this.measurementsTE[i][1] = dArray2[i];
                this.measurementsTE[i][2] = 1.0;
                this.measurementsTE[i][3] = dArray3[i];
            }
        }
        this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTE = true;
        this.setMeasurements = true;
    }

    public void enterTEmodeData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of effective refractive indices, " + n);
        }
        int n3 = dArray4.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTE) {
            int n4;
            if (!this.setErrorsTE) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTEmeasurements + n2;
            double[][] dArray5 = new double[n5][4];
            for (n4 = 0; n4 < this.numberOfTEmeasurements; ++n4) {
                for (int i = 0; i < 4; ++i) {
                    dArray5[n4][i] = this.measurementsTE[n4][i];
                }
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTEmeasurements + n4][0] = dArray[n4];
                dArray5[this.numberOfTEmeasurements + n4][1] = dArray2[n4];
                dArray5[this.numberOfTEmeasurements + n4][2] = dArray3[n4];
                dArray5[this.numberOfTEmeasurements + n4][3] = dArray4[n4];
            }
            this.measurementsTE = dArray5;
            this.numberOfTEmeasurements = n5;
        } else {
            this.numberOfTEmeasurements = n2;
            this.measurementsTE = new double[this.numberOfTEmeasurements][4];
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                this.measurementsTE[i][0] = dArray[i];
                this.measurementsTE[i][1] = dArray2[i];
                this.measurementsTE[i][2] = dArray3[i];
                this.measurementsTE[i][3] = dArray4[i];
            }
        }
        this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTE = true;
        this.setMeasurements = true;
        this.setErrorsTE = true;
    }

    public void enterTMmodeData(double d, double d2, double d3) {
        if (this.setMeasurementsTM) {
            if (this.setErrorsTM) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n = this.numberOfTMmeasurements + 1;
            double[][] dArray = new double[n][4];
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    dArray[i][j] = this.measurementsTM[i][j];
                }
            }
            dArray[this.numberOfTMmeasurements][0] = d;
            dArray[this.numberOfTMmeasurements][1] = d2;
            dArray[this.numberOfTMmeasurements][2] = 1.0;
            dArray[this.numberOfTMmeasurements][3] = d3;
            this.measurementsTM = dArray;
            this.numberOfTMmeasurements = n;
        } else {
            this.measurementsTM = new double[1][4];
            this.measurementsTM[0][0] = d;
            this.measurementsTM[0][1] = d2;
            this.measurementsTM[0][2] = 1.0;
            this.measurementsTM[0][3] = d3;
            this.numberOfTMmeasurements = 1;
        }
        this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTM = true;
        this.setMeasurements = true;
    }

    public void enterTMmodeData(double d, double d2, double d3, double d4) {
        if (this.setMeasurementsTM) {
            if (!this.setErrorsTM) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n = this.numberOfTMmeasurements + 1;
            double[][] dArray = new double[n][4];
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    dArray[i][j] = this.measurementsTM[i][j];
                }
            }
            dArray[this.numberOfTMmeasurements][0] = d;
            dArray[this.numberOfTMmeasurements][1] = d2;
            dArray[this.numberOfTMmeasurements][2] = d3;
            dArray[this.numberOfTMmeasurements][3] = d4;
            this.measurementsTM = dArray;
            this.numberOfTMmeasurements = n;
        } else {
            this.measurementsTM = new double[1][4];
            this.measurementsTM[0][0] = d;
            this.measurementsTM[0][1] = d2;
            this.measurementsTM[0][2] = d3;
            this.measurementsTM[0][3] = d4;
            this.numberOfTMmeasurements = 1;
        }
        this.numberOfMeasurements = this.numberOfTMmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTM = true;
        this.setMeasurements = true;
        this.setErrorsTM = true;
    }

    public void enterTMmodeData(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of effective refractive indices, " + n);
        }
        int n3 = dArray3.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTM) {
            int n4;
            if (this.setErrorsTM) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTMmeasurements + n2;
            double[][] dArray4 = new double[n5][4];
            for (n4 = 0; n4 < this.numberOfTMmeasurements; ++n4) {
                for (int i = 0; i < 4; ++i) {
                    dArray4[n4][i] = this.measurementsTM[n4][i];
                }
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTMmeasurements + n4][0] = dArray[n4];
                dArray4[this.numberOfTMmeasurements + n4][1] = dArray2[n4];
                dArray4[this.numberOfTMmeasurements + n4][2] = 1.0;
                dArray4[this.numberOfTMmeasurements + n4][3] = dArray3[n4];
            }
            this.measurementsTM = dArray4;
            this.numberOfTMmeasurements = n5;
        } else {
            this.numberOfTMmeasurements = n2;
            this.measurementsTM = new double[this.numberOfTMmeasurements][4];
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                this.measurementsTM[i][0] = dArray[i];
                this.measurementsTM[i][1] = dArray2[i];
                this.measurementsTM[i][2] = 1.0;
                this.measurementsTM[i][3] = dArray3[i];
            }
        }
        this.numberOfMeasurements = this.numberOfTMmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTM = true;
        this.setMeasurements = true;
    }

    public void enterTMmodeData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of effective refractive indices, " + n);
        }
        int n3 = dArray4.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTM) {
            int n4;
            if (!this.setErrorsTM) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTMmeasurements + n2;
            double[][] dArray5 = new double[n5][4];
            for (n4 = 0; n4 < this.numberOfTMmeasurements; ++n4) {
                for (int i = 0; i < 4; ++i) {
                    dArray5[n4][i] = this.measurementsTM[n4][i];
                }
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTMmeasurements + n4][0] = dArray[n4];
                dArray5[this.numberOfTMmeasurements + n4][1] = dArray2[n4];
                dArray5[this.numberOfTMmeasurements + n4][2] = dArray3[n4];
                dArray5[this.numberOfTMmeasurements + n4][3] = dArray4[n4];
            }
            this.measurementsTM = dArray5;
            this.numberOfTMmeasurements = n5;
        } else {
            this.numberOfTMmeasurements = n2;
            this.measurementsTM = new double[this.numberOfTMmeasurements][4];
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                this.measurementsTM[i][0] = dArray[i];
                this.measurementsTM[i][1] = dArray2[i];
                this.measurementsTM[i][2] = dArray3[i];
                this.measurementsTM[i][3] = dArray4[i];
            }
        }
        this.numberOfMeasurements = this.numberOfTMmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTM = true;
        this.setMeasurements = true;
        this.setErrorsTM = true;
    }

    public void clearData() {
        this.numberOfMeasurements = 0;
        this.setMeasurements = false;
        this.setWeights = false;
        this.numberOfTEmeasurements = 0;
        this.setMeasurementsTE = false;
        this.setErrorsTE = false;
        this.numberOfTMmeasurements = 0;
        this.setMeasurementsTM = false;
        this.setErrorsTM = false;
    }

    public void setWavelength(double d) {
        this.wavelength = d;
        this.setWavelength = true;
        this.ko = Math.PI * 2 / this.wavelength;
        if (!this.setSuperstrate) {
            this.superstrateRefractiveIndex = RefractiveIndex.air(this.wavelength);
        }
    }

    public void setSubstrateRefractiveIndex(double d) {
        this.substrateRefractiveIndex = d;
        this.substrateRefractiveIndex2 = d * d;
        this.setSubstrate = true;
    }

    public void setSuperstrateRefractiveIndex(double d) {
        this.superstrateRefractiveIndex = d;
        this.superstrateRefractiveIndex2 = d * d;
        this.setSuperstrate = true;
    }

    public double getSuperstrateRefractiveIndex() {
        if (!this.superCalculationDone && this.setCore) {
            this.calcSuperstrateRefractiveIndex();
        }
        return this.superstrateRefractiveIndex;
    }

    public double getStandardDeviationSuperstrateRefractiveIndex() {
        if (!this.superCalculationDone && this.setCore) {
            this.calcSuperstrateRefractiveIndex();
        }
        if (this.setCore) {
            if (this.numberOfTMmeasurements + this.numberOfTEmeasurements == 1) {
                System.out.println("Method: getStandardDeviationSuperstrateRefractiveIndex - Only one measurement entered - NO standard deviation returned");
            }
        } else {
            System.out.println("Method: getStandardDeviationSuperstrateRefractiveIndex - Superstrate refractive index was entered and NOT calculated - NO standard deviation returned");
        }
        return this.sdCoreFilmRefractiveIndex;
    }

    public void setCoreLayerRefractiveIndex(double d) {
        this.coreFilmRefractiveIndex = d;
        this.coreFilmRefractiveIndex2 = d * d;
        this.setCore = true;
    }

    public double[] getTEmodeCoreFilmRefractiveIndices() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getTEmodeCoreFilmRefractiveIndices - NO TE mode data entered - NO refractive indices returned");
        }
        return this.coreFilmTEmodeRefractiveIndices;
    }

    public double[] getTMmodeCoreFilmRefractiveIndices() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getTMmodeCoreFilmRefractiveIndices - NO TM mode data entered - NO refractive indices returned");
        }
        return this.coreFilmTMmodeRefractiveIndices;
    }

    public double getMeanTEmodeCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getMeanTEmodeCoreFilmRefractiveIndices - NO TE mode data entered - NO refractive index returned");
        }
        return this.meanTEmodeCoreFilmRefractiveIndex;
    }

    public double getMeanTMmodeCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getMeanTMmodeCoreFilmRefractiveIndices - NO TM mode data entered - NO refractive index returned");
        }
        return this.meanTMmodeCoreFilmRefractiveIndex;
    }

    public double getMeanCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        return this.meanCoreFilmRefractiveIndex;
    }

    public double getCoreFilmRefractiveIndex() {
        if (!this.calculationDone && !this.setCore) {
            this.calcCoreFilmRefractiveIndices();
        }
        return this.coreFilmRefractiveIndex;
    }

    public double getStandardDeviationTEmodeCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getStandardDeviationTEmodeCoreFilmRefractiveIndex - NO TE mode data entered - NO standard deviation returned");
        }
        if (this.numberOfTEmeasurements == 1) {
            System.out.println("Method: getStandardDeviationTEmodeCoreFilmRefractiveIndex - Only one measurement entered - NO standard deviation returned");
        }
        return this.sdTEmodeCoreFilmRefractiveIndex;
    }

    public double getStandardDeviationTMmodeCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getStandardDeviationTMmodeCoreFilmRefractiveIndex - NO TM mode data entered - NO standard deviation returned");
        }
        if (this.numberOfTMmeasurements == 1) {
            System.out.println("Method: getStandardDeviationTMmodeCoreFilmRefractiveIndex - Only one measurement entered - NO standard deviation returned");
        }
        return this.sdTMmodeCoreFilmRefractiveIndex;
    }

    public double getStandardDeviationCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements + this.numberOfTEmeasurements == 1) {
            System.out.println("Method: getStandardDeviationCoreFilmRefractiveIndex - Only one measurement entered - NO standard deviation returned");
        }
        return this.sdCoreFilmRefractiveIndex;
    }

    public double[][] getTEmodeExperimentalEffectiveRefractiveIndices() {
        double[][] dArray = null;
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getTEmodeExperimentalEffectiveRefractiveIndices - NO TE mode data entered - NO effective refractive indices returned");
        } else {
            dArray = new double[2][this.numberOfTEmeasurements];
            dArray[0] = this.thicknessesUsedTE;
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                dArray[1][i] = this.measurementsTE[i][1];
            }
        }
        return dArray;
    }

    public double[][] getTEmodeEffectiveRefractiveIndicesErrors() {
        double[][] dArray = null;
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getTEmodeExperimentalEffectiveRefractiveIndices - NO TE mode data entered - NO errors returned");
        } else if (!this.setErrorsTE) {
            System.out.println("Method: getTEmodeExperimentalEffectiveRefractiveIndices - NO TE mode errors entered - NO errors returned");
        } else {
            dArray = new double[2][this.numberOfTEmeasurements];
            dArray[0] = this.thicknessesUsedTE;
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                dArray[1][i] = this.measurementsTE[i][2];
            }
        }
        return dArray;
    }

    public double[][] getTMmodeExperimentalEffectiveRefractiveIndices() {
        double[][] dArray = null;
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getTMmodeExperimentalEffectiveRefractiveIndices - NO TM mode data entered - NO effective refractive indices returned");
        } else {
            dArray = new double[2][this.numberOfTMmeasurements];
            dArray[0] = this.thicknessesUsedTM;
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                dArray[1][i] = this.measurementsTM[i][1];
            }
        }
        return dArray;
    }

    public double[][] getTMmodeEffectiveRefractiveIndicesErrors() {
        double[][] dArray = null;
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getTMmodeExperimentalEffectiveRefractiveIndices - NO TM mode data entered - NO errors returned");
        } else if (!this.setErrorsTM) {
            System.out.println("Method: getTMmodeExperimentalEffectiveRefractiveIndices - NO TM mode errors entered - NO errors returned");
        } else {
            dArray = new double[2][this.numberOfTMmeasurements];
            dArray[0] = this.thicknessesUsedTM;
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                dArray[1][i] = this.measurementsTM[i][2];
            }
        }
        return dArray;
    }

    public double[][] getTEmodeCalculatedEffectiveRefractiveIndices() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getStandardDeviationTEmodeCoreFilmRefractiveIndices - NO TE mode data entered - NO effective refractive indices returned");
        }
        double[][] dArray = new double[2][this.numberOfTEmeasurements];
        FunctTEplot functTEplot = new FunctTEplot();
        functTEplot.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        functTEplot.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        functTEplot.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        functTEplot.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        functTEplot.prismToWaveguideGap = this.prismToWaveguideGap;
        functTEplot.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        functTEplot.ko = this.ko;
        this.lowerBound = Math.max(this.substrateRefractiveIndex, this.superstrateRefractiveIndex);
        this.upperBound = Math.min(this.coreFilmRefractiveIndex, this.prismRefractiveIndex);
        for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
            functTEplot.thickness = this.measurementsTE[i][0];
            functTEplot.modeNumber = this.measurementsTE[i][3];
            RealRoot realRoot = new RealRoot();
            realRoot.noBoundsExtensions();
            realRoot.setTolerance(this.tolerance);
            this.calcEffectRefrIndicesTE[i] = realRoot.bisect(functTEplot, this.lowerBound, this.upperBound);
        }
        dArray[0] = this.thicknessesUsedTE;
        dArray[1] = this.calcEffectRefrIndicesTE;
        return dArray;
    }

    public double[][] getTMmodeCalculatedEffectiveRefractiveIndices() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getStandardDeviationTMmodeCoreFilmRefractiveIndices - NO TM mode data entered - NO effective refractive indices returned");
        }
        double[][] dArray = new double[2][this.numberOfTMmeasurements];
        FunctTMplot functTMplot = new FunctTMplot();
        functTMplot.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        functTMplot.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        functTMplot.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        functTMplot.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        functTMplot.prismToWaveguideGap = this.prismToWaveguideGap;
        functTMplot.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        functTMplot.ko = this.ko;
        this.lowerBound = Math.max(this.substrateRefractiveIndex, this.superstrateRefractiveIndex);
        this.upperBound = Math.min(this.coreFilmRefractiveIndex, this.prismRefractiveIndex);
        for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
            functTMplot.thickness = this.measurementsTM[i][0];
            functTMplot.modeNumber = this.measurementsTM[i][3];
            RealRoot realRoot = new RealRoot();
            realRoot.noBoundsExtensions();
            realRoot.setTolerance(this.tolerance);
            this.calcEffectRefrIndicesTM[i] = realRoot.bisect(functTMplot, this.lowerBound, this.upperBound);
        }
        dArray[0] = this.thicknessesUsedTM;
        dArray[1] = this.calcEffectRefrIndicesTM;
        return dArray;
    }

    public void calcCoreFilmRefractiveIndices() {
        int n;
        int n2;
        int n3;
        if (!this.setMeasurements) {
            throw new IllegalArgumentException("Either no thickness, angle/effective refractive index, mode number data has been entered or a key subclass variable, e.g. coupling prism corner angle has not been entered");
        }
        if (!this.setWavelength) {
            throw new IllegalArgumentException("No wavelength has been entered");
        }
        if (!this.setSubstrate) {
            throw new IllegalArgumentException("No substrate refractive index has been entered");
        }
        this.lowerBound = Math.max(this.substrateRefractiveIndex, this.superstrateRefractiveIndex);
        this.upperBound = 0.0;
        if (this.numberOfTEmeasurements > 0) {
            this.eliminatedTE = new boolean[this.numberOfTEmeasurements];
        }
        int n4 = 0;
        for (n3 = 0; n3 < this.numberOfTEmeasurements; ++n3) {
            this.eliminatedTE[n3] = false;
            if (this.measurementsTE[n3][1] < this.lowerBound) {
                System.out.println("TE mode measurement point, " + n3 + ", eliminated as the effective refractive index, " + this.measurementsTE[n3][1] + ", lies below the physical limit, " + this.lowerBound);
                this.eliminatedTE[n3] = true;
                ++n4;
                continue;
            }
            if (!(this.upperBound < this.measurementsTE[n3][1])) continue;
            this.upperBound = this.measurementsTE[n3][1];
        }
        if (n4 > 0) {
            n3 = this.numberOfTEmeasurements - n4;
            if (n3 == 0) {
                this.numberOfTEmeasurements = 0;
            } else {
                double[][] dArray = new double[n3][3];
                int n5 = 0;
                for (n2 = 0; n2 < this.numberOfTEmeasurements; ++n2) {
                    if (this.eliminatedTE[n2]) continue;
                    dArray[n5][0] = this.measurementsTE[n2][0];
                    dArray[n5][1] = this.measurementsTE[n2][1];
                    dArray[n5][2] = this.measurementsTE[n2][2];
                    dArray[n5][3] = this.measurementsTE[n2][3];
                    ++n5;
                }
                this.measurementsTE = dArray;
                this.numberOfTEmeasurements = n3;
                this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
            }
        }
        this.thicknessesUsedTE = new double[this.numberOfTEmeasurements];
        this.calcEffectRefrIndicesTE = new double[this.numberOfTEmeasurements];
        for (n3 = 0; n3 < this.numberOfTEmeasurements; ++n3) {
            this.thicknessesUsedTE[n3] = this.measurementsTE[n3][0];
        }
        this.maximumTEmodeEffectiveRefractiveIndex = this.upperBound;
        this.upperBound = 0.0;
        if (this.numberOfTMmeasurements > 0) {
            this.eliminatedTM = new boolean[this.numberOfTMmeasurements];
        }
        n3 = 0;
        for (n = 0; n < this.numberOfTMmeasurements; ++n) {
            this.eliminatedTM[n] = false;
            if (this.measurementsTM[n][1] < this.lowerBound) {
                System.out.println("TM mode measurement point, " + n + ", eliminated as the effective refractive index, " + this.measurementsTM[n][1] + ", lies below the physical limit, " + this.lowerBound);
                this.eliminatedTM[n] = true;
                ++n3;
                continue;
            }
            if (!(this.upperBound < this.measurementsTM[n][1])) continue;
            this.upperBound = this.measurementsTM[n][1];
        }
        if (n3 > 0) {
            n = this.numberOfTMmeasurements - n3;
            if (n == 0) {
                this.numberOfTMmeasurements = 0;
            } else {
                double[][] dArray = new double[n][3];
                n2 = 0;
                for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                    if (this.eliminatedTM[i]) continue;
                    dArray[n2][0] = this.measurementsTM[i][0];
                    dArray[n2][1] = this.measurementsTM[i][1];
                    dArray[n2][2] = this.measurementsTM[i][2];
                    dArray[n2][3] = this.measurementsTM[i][3];
                    ++n2;
                }
                this.measurementsTM = dArray;
                this.numberOfTMmeasurements = n;
                this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
            }
        }
        this.thicknessesUsedTM = new double[this.numberOfTMmeasurements];
        this.calcEffectRefrIndicesTM = new double[this.numberOfTMmeasurements];
        for (n = 0; n < this.numberOfTMmeasurements; ++n) {
            this.thicknessesUsedTM[n] = this.measurementsTM[n][0];
        }
        this.maximumTMmodeEffectiveRefractiveIndex = this.upperBound;
        if (this.numberOfMeasurements == 0) {
            throw new IllegalArgumentException("All data points rejected as lying outside the physically meaningful bounds");
        }
        if (this.fixedPrismToWaveguideGap) {
            this.calcCoreFilmRefractiveIndicesFixedGap();
        } else {
            this.calcCoreFilmRefractiveIndicesEstimatedGap();
        }
    }

    public void calcCoreFilmRefractiveIndicesEstimatedGap() {
        int n;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        this.prismToWaveguideGap = 10.0;
        this.fixedPrismToWaveguideGap = true;
        double[] dArray = new double[this.numberOfMeasurements];
        double[] dArray2 = new double[this.numberOfMeasurements];
        for (n = 0; n < this.numberOfTEmeasurements; ++n) {
            dArray[n] = this.measurementsTE[n][1];
        }
        for (n = 0; n < this.numberOfTMmeasurements; ++n) {
            dArray[n + this.numberOfTEmeasurements] = this.measurementsTM[n][1];
        }
        double d = 0.0;
        double d2 = Double.POSITIVE_INFINITY;
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            int n3;
            this.setCore = false;
            this.calculationDone = false;
            this.fixedPrismToWaveguideGap = true;
            this.setPrismToWaveguideGap = true;
            double d3 = this.getMeanCoreFilmRefractiveIndex();
            if (d3 != d3) {
                System.out.println("NaN");
                bl = false;
                continue;
            }
            double[][] dArray3 = this.getTEmodeCalculatedEffectiveRefractiveIndices();
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                dArray2[i] = dArray3[1][i];
            }
            double[][] dArray4 = this.getTMmodeCalculatedEffectiveRefractiveIndices();
            for (n3 = 0; n3 < this.numberOfTMmeasurements; ++n3) {
                dArray2[n3 + this.numberOfTEmeasurements] = dArray4[1][n3];
            }
            d = 0.0;
            for (n3 = 0; n3 < this.numberOfMeasurements; ++n3) {
                d += Fmath.square(dArray[n3] - dArray2[n3]);
            }
            System.out.println(this.prismToWaveguideGap + " " + d3 + " " + d);
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d));
            ++n2;
            this.prismToWaveguideGap /= 2.0;
            if (!(this.prismToWaveguideGap < 1.0E-10)) continue;
            bl = false;
        }
    }

    public void calcCoreFilmRefractiveIndicesFixedGap() {
        if (this.numberOfTEmeasurements > 0) {
            this.calcTEmodeCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements > 0) {
            this.calcTMmodeCoreFilmRefractiveIndices();
        }
        if (this.numberOfTEmeasurements > 0 && this.numberOfTMmeasurements == 0) {
            this.coreFilmRefractiveIndex = this.meanCoreFilmRefractiveIndex = this.meanTEmodeCoreFilmRefractiveIndex;
            this.sdCoreFilmRefractiveIndex = this.sdTEmodeCoreFilmRefractiveIndex;
        } else if (this.numberOfTMmeasurements > 0 && this.numberOfTEmeasurements == 0) {
            this.coreFilmRefractiveIndex = this.meanCoreFilmRefractiveIndex = this.meanTMmodeCoreFilmRefractiveIndex;
            this.sdCoreFilmRefractiveIndex = this.sdTMmodeCoreFilmRefractiveIndex;
        } else {
            int n;
            double[] dArray = new double[this.numberOfMeasurements];
            double[] dArray2 = new double[this.numberOfMeasurements];
            for (n = 0; n < this.numberOfTEmeasurements; ++n) {
                dArray[n] = this.coreFilmTEmodeRefractiveIndices[n];
                dArray2[n] = this.measurementsTE[n][2];
            }
            for (n = 0; n < this.numberOfTMmeasurements; ++n) {
                dArray[n + this.numberOfTEmeasurements] = this.coreFilmTMmodeRefractiveIndices[n];
                dArray2[n + this.numberOfTEmeasurements] = this.measurementsTM[n][2];
            }
            this.meanCoreFilmRefractiveIndex = Stat.mean(dArray, dArray2);
            this.sdCoreFilmRefractiveIndex = Stat.standardDeviation(dArray, dArray2);
            this.coreFilmRefractiveIndex = this.meanCoreFilmRefractiveIndex;
        }
        this.coreFilmRefractiveIndex2 = this.meanCoreFilmRefractiveIndex2 = this.meanCoreFilmRefractiveIndex * this.meanCoreFilmRefractiveIndex;
        this.maximumEffectiveRefractiveIndex = Math.max(this.maximumTEmodeEffectiveRefractiveIndex, this.maximumTMmodeEffectiveRefractiveIndex);
        this.setCore = true;
        this.calculationDone = true;
    }

    public void calcTEmodeCoreFilmRefractiveIndices() {
        this.coreFilmTEmodeRefractiveIndices = new double[this.numberOfTEmeasurements];
        FunctTE functTE = new FunctTE();
        functTE.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        functTE.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        functTE.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        functTE.prismToWaveguideGap = this.prismToWaveguideGap;
        functTE.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        functTE.ko = this.ko;
        double[] dArray = new double[this.numberOfTEmeasurements];
        this.lowerBound = this.maximumTEmodeEffectiveRefractiveIndex;
        this.upperBound = 2.0 * this.lowerBound;
        for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
            dArray[i] = this.measurementsTE[i][2];
            functTE.thickness = this.measurementsTE[i][0];
            functTE.effectiveRefractiveIndex2 = this.measurementsTE[i][1] * this.measurementsTE[i][1];
            functTE.modeNumber = this.measurementsTE[i][3];
            RealRoot realRoot = new RealRoot();
            realRoot.noLowerBoundExtension();
            realRoot.setTolerance(this.tolerance);
            this.coreFilmTEmodeRefractiveIndices[i] = realRoot.bisect(functTE, this.lowerBound, this.upperBound);
        }
        if (this.numberOfTEmeasurements > 1) {
            this.meanTEmodeCoreFilmRefractiveIndex = Stat.mean(this.coreFilmTEmodeRefractiveIndices, dArray);
            this.sdTEmodeCoreFilmRefractiveIndex = Stat.standardDeviation(this.coreFilmTEmodeRefractiveIndices, dArray);
        } else {
            this.meanTEmodeCoreFilmRefractiveIndex = this.coreFilmTEmodeRefractiveIndices[0];
        }
    }

    public void calcTMmodeCoreFilmRefractiveIndices() {
        this.coreFilmTMmodeRefractiveIndices = new double[this.numberOfTMmeasurements];
        FunctTM functTM = new FunctTM();
        functTM.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        functTM.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        functTM.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        functTM.prismToWaveguideGap = this.prismToWaveguideGap;
        functTM.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        functTM.ko = this.ko;
        double[] dArray = new double[this.numberOfTMmeasurements];
        this.lowerBound = this.maximumTMmodeEffectiveRefractiveIndex;
        this.upperBound = 2.0 * this.lowerBound;
        for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
            dArray[i] = this.measurementsTM[i][2];
            functTM.thickness = this.measurementsTM[i][0];
            functTM.effectiveRefractiveIndex2 = this.measurementsTM[i][1] * this.measurementsTM[i][1];
            functTM.modeNumber = this.measurementsTM[i][3];
            RealRoot realRoot = new RealRoot();
            realRoot.noLowerBoundExtension();
            realRoot.setTolerance(this.tolerance);
            this.coreFilmTMmodeRefractiveIndices[i] = realRoot.bisect(functTM, this.lowerBound, this.upperBound);
        }
        if (this.numberOfTMmeasurements > 1) {
            this.meanTMmodeCoreFilmRefractiveIndex = Stat.mean(this.coreFilmTMmodeRefractiveIndices, dArray);
            this.sdTMmodeCoreFilmRefractiveIndex = Stat.standardDeviation(this.coreFilmTMmodeRefractiveIndices, dArray);
        } else {
            this.meanTMmodeCoreFilmRefractiveIndex = this.coreFilmTMmodeRefractiveIndices[0];
        }
    }

    public double[][] dispersionCurveTE(double d, double d2, int n, double d3) {
        if (!this.setWavelength) {
            throw new IllegalArgumentException("No wavelength has been entered");
        }
        if (!this.setSubstrate) {
            throw new IllegalArgumentException("No substrate refractive index has been entered");
        }
        if (!this.setCore) {
            throw new IllegalArgumentException("No core film refractive index has been calculated or entered");
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[][] dArray3 = new double[2][n];
        double d4 = (Fmath.log10(d2) - Fmath.log10(d)) / (double)(n - 1);
        dArray[0] = Fmath.log10(d);
        dArray[n - 1] = Fmath.log10(d2);
        for (int i = 1; i < n - 1; ++i) {
            dArray[i] = dArray[i - 1] + d4;
        }
        dArray3[0] = dArray;
        FunctTEplot functTEplot = new FunctTEplot();
        functTEplot.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        functTEplot.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        functTEplot.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        functTEplot.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        functTEplot.prismToWaveguideGap = this.prismToWaveguideGap;
        functTEplot.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        functTEplot.ko = this.ko;
        functTEplot.modeNumber = d3;
        this.lowerBound = Math.max(this.substrateRefractiveIndex, this.superstrateRefractiveIndex);
        this.upperBound = Math.min(this.coreFilmRefractiveIndex, this.prismRefractiveIndex);
        for (int i = 0; i < n; ++i) {
            functTEplot.thickness = Math.pow(10.0, dArray[i]);
            RealRoot realRoot = new RealRoot();
            realRoot.noBoundsExtensions();
            realRoot.setTolerance(this.tolerance);
            dArray2[i] = realRoot.bisect(functTEplot, this.lowerBound, this.upperBound);
        }
        dArray3[1] = dArray2;
        return dArray3;
    }

    public double[][] dispersionCurveTM(double d, double d2, int n, double d3) {
        if (!this.setWavelength) {
            throw new IllegalArgumentException("No wavelength has been entered");
        }
        if (!this.setSubstrate) {
            throw new IllegalArgumentException("No substrate refractive index has been entered");
        }
        if (!this.setCore) {
            throw new IllegalArgumentException("No core film refractive index has been calculated or entered");
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[][] dArray3 = new double[2][n];
        double d4 = (Fmath.log10(d2) - Fmath.log10(d)) / (double)(n - 1);
        dArray[0] = Fmath.log10(d);
        dArray[n - 1] = Fmath.log10(d2);
        for (int i = 1; i < n - 1; ++i) {
            dArray[i] = dArray[i - 1] + d4;
        }
        dArray3[0] = dArray;
        FunctTMplot functTMplot = new FunctTMplot();
        functTMplot.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        functTMplot.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        functTMplot.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        functTMplot.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        functTMplot.prismToWaveguideGap = this.prismToWaveguideGap;
        functTMplot.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        functTMplot.ko = this.ko;
        functTMplot.modeNumber = d3;
        this.lowerBound = Math.max(this.substrateRefractiveIndex, this.superstrateRefractiveIndex);
        this.upperBound = Math.min(this.coreFilmRefractiveIndex, this.prismRefractiveIndex);
        for (int i = 0; i < n; ++i) {
            functTMplot.thickness = Math.pow(10.0, dArray[i]);
            RealRoot realRoot = new RealRoot();
            realRoot.noBoundsExtensions();
            realRoot.setTolerance(this.tolerance);
            dArray2[i] = realRoot.bisect(functTMplot, this.lowerBound, this.upperBound);
        }
        dArray3[1] = dArray2;
        return dArray3;
    }

    public double[][] plotDispersionCurveTE(double d, double d2, int n, double d3) {
        String string = " ";
        return this.plotDispersionCurveTE(d, d2, n, d3, string);
    }

    public double[][] plotDispersionCurveTE(double d, double d2, int n, double d3, String string) {
        double[][] dArray = this.dispersionCurveTE(d, d2, n, d3);
        PlotGraph plotGraph = new PlotGraph(dArray);
        int n2 = 3;
        if (n < 100) {
            n2 = 1;
        }
        plotGraph.setLine(n2);
        plotGraph.setPoint(0);
        String string2 = "Dispersion curve: TE mode  -  mode number " + (int)d3;
        plotGraph.setGraphTitle(string2);
        plotGraph.setGraphTitle2(string);
        plotGraph.setXaxisLegend("Log10( Core Film Thickness / metres )");
        plotGraph.setYaxisLegend("Effective Refractive Index (kz/ko)");
        plotGraph.plot();
        return dArray;
    }

    public double[][] plotDispersionCurveTM(double d, double d2, int n, double d3) {
        String string = " ";
        return this.plotDispersionCurveTM(d, d2, n, d3, string);
    }

    public double[][] plotDispersionCurveTM(double d, double d2, int n, double d3, String string) {
        double[][] dArray = this.dispersionCurveTM(d, d2, n, d3);
        PlotGraph plotGraph = new PlotGraph(dArray);
        int n2 = 3;
        if (n < 100) {
            n2 = 1;
        }
        plotGraph.setLine(n2);
        plotGraph.setPoint(0);
        String string2 = "Dispersion curve: TM mode  -  mode number " + (int)d3;
        plotGraph.setGraphTitle(string2);
        plotGraph.setGraphTitle2(string);
        plotGraph.setXaxisLegend("Log10( Core Film Thickness / metres )");
        plotGraph.setYaxisLegend("Effective Refractive Index (kz/ko)");
        plotGraph.plot();
        return dArray;
    }

    public void plotFittedDispersionCurves() {
        String string = "PlanarWaveguide.plotDispersion - Dispersion Plot";
        this.plotFittedDispersionCurve(string);
    }

    public void plotFittedDispersionCurve(String string) {
        double[][] dArray;
        double[] dArray2;
        double[] dArray3;
        double[] dArray4;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        ArrayList<Number> arrayList = null;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (this.numberOfTEmeasurements > 0) {
            arrayList = new ArrayList<Number>();
            n8 = 1;
            int n12 = 0;
            n7 = 0;
            while (n8 != 0) {
                n6 = 0;
                for (n5 = 0; n5 < this.numberOfTEmeasurements; ++n5) {
                    if (this.measurementsTE[n5][3] != (double)n12) continue;
                    ++n6;
                    ++n7;
                    arrayList.add(new Double(this.measurementsTE[n5][0]));
                    arrayList.add(new Double(this.measurementsTE[n5][1]));
                }
                arrayList.add(2 * n12, new Integer(n12));
                arrayList.add(2 * n12 + 1, new Integer(n6));
                if (n6 > 0) {
                    ++n9;
                }
                if (n6 > n11) {
                    n11 = n6;
                }
                if (n7 == this.numberOfTEmeasurements) {
                    n8 = 0;
                    continue;
                }
                ++n12;
            }
            n10 = n12;
        }
        n8 = n9;
        ArrayList<Number> arrayList2 = null;
        n7 = 0;
        n6 = 0;
        if (this.numberOfTMmeasurements > 0) {
            arrayList2 = new ArrayList<Number>();
            n5 = 1;
            int n13 = 0;
            int n14 = 0;
            while (n5 != 0) {
                n4 = 0;
                for (n3 = 0; n3 < this.numberOfTMmeasurements; ++n3) {
                    if (this.measurementsTM[n3][3] != (double)n13) continue;
                    ++n4;
                    ++n14;
                    arrayList2.add(new Double(this.measurementsTM[n3][0]));
                    arrayList2.add(new Double(this.measurementsTM[n3][1]));
                }
                arrayList2.add(2 * n13, new Integer(n13));
                arrayList2.add(2 * n13 + 1, new Integer(n4));
                if (n4 > 0) {
                    ++n7;
                }
                if (n4 > n11) {
                    n11 = n4;
                }
                if (n14 == this.numberOfTMmeasurements) {
                    n5 = 0;
                    continue;
                }
                ++n13;
            }
            n6 = n13;
        }
        n8 += n7;
        n8 *= 2;
        if (n11 < 200) {
            n11 = 200;
        }
        double[][] dArray5 = PlotGraph.data(n8, n11);
        double[] dArray6 = new double[n8];
        String[] stringArray = new String[n8];
        n4 = 0;
        n3 = 0;
        int n15 = 2 * (n10 + 1);
        int n16 = 1;
        double d = 0.0;
        int n17 = 0;
        if (this.numberOfTEmeasurements > 0) {
            n2 = 0;
            n = arrayList.size();
            while (n2 < n) {
                n17 = (Integer)arrayList.get(n16);
                ++n2;
                if (n17 > 0) {
                    stringArray[n4] = "TE";
                    stringArray[n4 + 1] = "TE";
                    dArray6[n4] = ((Integer)arrayList.get(n16 - 1)).intValue();
                    dArray6[n4 + 1] = dArray6[n4];
                    ++n2;
                    dArray4 = new double[n17];
                    dArray3 = new double[n17];
                    for (int i = 0; i < n17; ++i) {
                        dArray4[i] = (Double)arrayList.get(n15++);
                        dArray3[i] = (Double)arrayList.get(n15++);
                        n2 += 2;
                    }
                    dArray2 = Conv.copy(dArray4);
                    for (int i = 0; i < n17; ++i) {
                        dArray2[i] = Fmath.log10(dArray4[i]);
                    }
                    dArray5[n3++] = dArray2;
                    dArray5[n3++] = dArray3;
                    Fmath.selectionSort(dArray4, dArray3, dArray4, dArray3);
                    dArray = this.dispersionCurveTE(dArray4[0], dArray4[n17 - 1], n11, dArray6[n4]);
                    dArray5[n3++] = dArray[0];
                    dArray5[n3++] = dArray[1];
                    n4 += 2;
                }
                n16 = 2;
            }
        }
        n15 = 2 * (n6 + 1);
        n16 = 1;
        d = 0.0;
        n17 = 0;
        if (this.numberOfTMmeasurements > 0) {
            n2 = 0;
            n = arrayList2.size();
            while (n2 < n) {
                n17 = (Integer)arrayList2.get(n16);
                ++n2;
                if (n17 > 0) {
                    stringArray[n4] = "TM";
                    stringArray[n4 + 1] = "TM";
                    dArray6[n4] = ((Integer)arrayList2.get(n16 - 1)).intValue();
                    ++n2;
                    dArray6[n4 + 1] = dArray6[n4];
                    dArray4 = new double[n17];
                    dArray3 = new double[n17];
                    for (int i = 0; i < n17; ++i) {
                        dArray4[i] = (Double)arrayList2.get(n15++);
                        dArray3[i] = (Double)arrayList2.get(n15++);
                        n2 += 2;
                    }
                    dArray2 = Conv.copy(dArray4);
                    for (int i = 0; i < n17; ++i) {
                        dArray2[i] = Fmath.log10(dArray4[i]);
                    }
                    dArray5[n3++] = dArray2;
                    dArray5[n3++] = dArray3;
                    Fmath.selectionSort(dArray4, dArray3, dArray4, dArray3);
                    dArray = this.dispersionCurveTM(dArray4[0], dArray4[n17 - 1], n11, dArray6[n4]);
                    dArray5[n3++] = dArray[0];
                    dArray5[n3++] = dArray[1];
                    n4 += 2;
                }
                n16 = 2;
            }
        }
        PlotGraph plotGraph = new PlotGraph(dArray5);
        int[] nArray = new int[n8];
        for (int i = 0; i < n8; i += 2) {
            nArray[i] = 0;
            nArray[i + 1] = 3;
            if (n11 >= 100) continue;
            nArray[i + 1] = 1;
        }
        plotGraph.setLine(nArray);
        int[] nArray2 = new int[n8];
        int n18 = 1;
        for (int i = 0; i < n8; i += 2) {
            nArray2[i] = n18++;
            nArray2[i + 1] = 0;
        }
        plotGraph.setPoint(nArray2);
        plotGraph.setGraphTitle(string);
        plotGraph.setXaxisLegend("Log10( Core Film Thickness / metres )");
        plotGraph.setYaxisLegend("Effective Refractive Index (kz/ko)");
        plotGraph.plot();
    }

    public void calcSuperstrateRefractiveIndex() {
        int n;
        int n2;
        int n3;
        if (!this.setMeasurements) {
            throw new IllegalArgumentException("Either no thickness, angle/effective refractive index, mode number data has been entered or a key subclass variable, e.g. coupling prism corner angle has not been entered");
        }
        if (!this.setWavelength) {
            throw new IllegalArgumentException("No wavelength has been entered");
        }
        if (!this.setSubstrate) {
            throw new IllegalArgumentException("No substrate refractive index has been entered");
        }
        if (!this.setCore) {
            throw new IllegalArgumentException("No core layer refractive index has been entered");
        }
        this.lowerBound = 1.0;
        this.upperBound = this.coreFilmRefractiveIndex;
        if (this.numberOfTEmeasurements > 0) {
            this.eliminatedTE = new boolean[this.numberOfTEmeasurements];
        }
        int n4 = 0;
        for (n3 = 0; n3 < this.numberOfTEmeasurements; ++n3) {
            this.eliminatedTE[n3] = false;
            if (this.measurementsTE[n3][1] > this.coreFilmRefractiveIndex) {
                System.out.println("TE mode measurement point, " + n3 + ", eliminated as the effective refractive index, " + this.measurementsTE[n3][1] + ", lies above the physical limit, " + this.coreFilmRefractiveIndex);
                this.eliminatedTE[n3] = true;
                ++n4;
                continue;
            }
            if (!(this.upperBound > this.measurementsTE[n3][1])) continue;
            this.upperBound = this.measurementsTE[n3][1];
        }
        if (n4 > 0) {
            n3 = this.numberOfTEmeasurements - n4;
            if (n3 == 0) {
                this.numberOfTEmeasurements = 0;
            } else {
                double[][] dArray = new double[n3][3];
                int n5 = 0;
                for (n2 = 0; n2 < this.numberOfTEmeasurements; ++n2) {
                    if (this.eliminatedTE[n2]) continue;
                    dArray[n5][0] = this.measurementsTE[n2][0];
                    dArray[n5][1] = this.measurementsTE[n2][1];
                    dArray[n5][2] = this.measurementsTE[n2][2];
                    dArray[n5][3] = this.measurementsTE[n2][3];
                    ++n5;
                }
                this.measurementsTE = dArray;
                this.numberOfTEmeasurements = n3;
                this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
            }
        }
        this.thicknessesUsedTE = new double[this.numberOfTEmeasurements];
        this.calcEffectRefrIndicesTE = new double[this.numberOfTEmeasurements];
        for (n3 = 0; n3 < this.numberOfTEmeasurements; ++n3) {
            this.thicknessesUsedTE[n3] = this.measurementsTE[n3][0];
        }
        this.minimumTEmodeEffectiveRefractiveIndex = this.upperBound;
        this.upperBound = 0.0;
        if (this.numberOfTMmeasurements > 0) {
            this.eliminatedTM = new boolean[this.numberOfTMmeasurements];
        }
        n3 = 0;
        for (n = 0; n < this.numberOfTMmeasurements; ++n) {
            this.eliminatedTM[n] = false;
            if (this.measurementsTM[n][1] > this.coreFilmRefractiveIndex) {
                System.out.println("TM mode measurement point, " + n + ", eliminated as the effective refractive index, " + this.measurementsTM[n][1] + ", lies above the physical limit, " + this.coreFilmRefractiveIndex);
                this.eliminatedTM[n] = true;
                ++n3;
                continue;
            }
            if (!(this.upperBound > this.measurementsTM[n][1])) continue;
            this.upperBound = this.measurementsTM[n][1];
        }
        if (n3 > 0) {
            n = this.numberOfTMmeasurements - n3;
            if (n == 0) {
                this.numberOfTMmeasurements = 0;
            } else {
                double[][] dArray = new double[n][3];
                n2 = 0;
                for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                    if (this.eliminatedTM[i]) continue;
                    dArray[n2][0] = this.measurementsTM[i][0];
                    dArray[n2][1] = this.measurementsTM[i][1];
                    dArray[n2][2] = this.measurementsTM[i][2];
                    dArray[n2][3] = this.measurementsTM[i][3];
                    ++n2;
                }
                this.measurementsTM = dArray;
                this.numberOfTMmeasurements = n;
                this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
            }
        }
        this.thicknessesUsedTM = new double[this.numberOfTMmeasurements];
        this.calcEffectRefrIndicesTM = new double[this.numberOfTMmeasurements];
        for (n = 0; n < this.numberOfTMmeasurements; ++n) {
            this.thicknessesUsedTM[n] = this.measurementsTM[n][0];
        }
        this.minimumTMmodeEffectiveRefractiveIndex = this.upperBound;
        if (this.numberOfMeasurements == 0) {
            throw new IllegalArgumentException("All data points rejected as lying outside the physically meaningful bounds");
        }
        if (this.numberOfTEmeasurements > 0) {
            this.calcTEmodeSuperstrateRefractiveIndices();
        }
        if (this.numberOfTMmeasurements > 0) {
            this.calcTMmodeSuperstrateRefractiveIndices();
        }
        if (this.numberOfTEmeasurements > 0 && this.numberOfTMmeasurements == 0) {
            this.superstrateRefractiveIndex = this.meanTEmodeSuperstrateRefractiveIndex;
            this.sdSuperstrateRefractiveIndex = this.sdTEmodeSuperstrateRefractiveIndex;
        } else if (this.numberOfTMmeasurements > 0 && this.numberOfTEmeasurements == 0) {
            this.superstrateRefractiveIndex = this.meanTMmodeSuperstrateRefractiveIndex;
            this.sdSuperstrateRefractiveIndex = this.sdTMmodeSuperstrateRefractiveIndex;
        } else {
            double[] dArray = new double[this.numberOfMeasurements];
            double[] dArray2 = new double[this.numberOfMeasurements];
            for (n2 = 0; n2 < this.numberOfTEmeasurements; ++n2) {
                dArray[n2] = this.calcSuperstrateTEmodeRI[n2];
                dArray2[n2] = this.measurementsTE[n2][2];
            }
            for (n2 = 0; n2 < this.numberOfTMmeasurements; ++n2) {
                dArray[n2 + this.numberOfTEmeasurements] = this.calcSuperstrateTMmodeRI[n2];
                dArray2[n2 + this.numberOfTEmeasurements] = this.measurementsTM[n2][2];
            }
            this.superstrateRefractiveIndex = Stat.mean(dArray, dArray2);
            this.sdSuperstrateRefractiveIndex = Stat.standardDeviation(dArray, dArray2);
        }
        this.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex * this.superstrateRefractiveIndex;
        this.minimumEffectiveRefractiveIndex = Math.min(this.minimumTEmodeEffectiveRefractiveIndex, this.minimumTMmodeEffectiveRefractiveIndex);
        this.superCalculationDone = true;
    }

    public void calcTEmodeSuperstrateRefractiveIndices() {
        this.calcSuperstrateTEmodeRI = new double[this.numberOfTEmeasurements];
        FunctTEsuper functTEsuper = new FunctTEsuper();
        functTEsuper.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        functTEsuper.ko = this.ko;
        double[] dArray = new double[this.numberOfTEmeasurements];
        this.lowerBound = 1.0;
        this.upperBound = this.minimumTEmodeEffectiveRefractiveIndex;
        for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
            dArray[i] = this.measurementsTE[i][2];
            functTEsuper.thickness = this.measurementsTE[i][0];
            functTEsuper.effectiveRefractiveIndex2 = this.measurementsTE[i][1] * this.measurementsTE[i][1];
            functTEsuper.modeNumber = this.measurementsTE[i][3];
            RealRoot realRoot = new RealRoot();
            realRoot.noBoundsExtensions();
            realRoot.setTolerance(this.tolerance);
            this.calcSuperstrateTEmodeRI[i] = realRoot.bisect(functTEsuper, this.lowerBound, this.upperBound);
        }
        if (this.numberOfTEmeasurements > 1) {
            this.meanTEmodeSuperstrateRefractiveIndex = Stat.mean(this.calcSuperstrateTEmodeRI, dArray);
            this.sdTEmodeSuperstrateRefractiveIndex = Stat.standardDeviation(this.calcSuperstrateTEmodeRI, dArray);
        } else {
            this.meanTEmodeSuperstrateRefractiveIndex = this.calcSuperstrateTEmodeRI[0];
        }
    }

    public void calcTMmodeSuperstrateRefractiveIndices() {
        this.calcSuperstrateTMmodeRI = new double[this.numberOfTMmeasurements];
        FunctTMsuper functTMsuper = new FunctTMsuper();
        functTMsuper.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        functTMsuper.ko = this.ko;
        double[] dArray = new double[this.numberOfTMmeasurements];
        this.lowerBound = 1.0;
        this.upperBound = this.minimumTMmodeEffectiveRefractiveIndex;
        for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
            dArray[i] = this.measurementsTM[i][2];
            functTMsuper.thickness = this.measurementsTM[i][0];
            functTMsuper.effectiveRefractiveIndex2 = this.measurementsTM[i][1] * this.measurementsTM[i][1];
            functTMsuper.modeNumber = this.measurementsTM[i][3];
            RealRoot realRoot = new RealRoot();
            realRoot.noBoundsExtensions();
            realRoot.setTolerance(this.tolerance);
            this.calcSuperstrateTMmodeRI[i] = realRoot.bisect(functTMsuper, this.lowerBound, this.upperBound);
        }
        if (this.numberOfTMmeasurements > 1) {
            this.meanTMmodeSuperstrateRefractiveIndex = Stat.mean(this.calcSuperstrateTMmodeRI, dArray);
            this.sdTMmodeSuperstrateRefractiveIndex = Stat.standardDeviation(this.calcSuperstrateTMmodeRI, dArray);
        } else {
            this.meanTMmodeSuperstrateRefractiveIndex = this.calcSuperstrateTMmodeRI[0];
        }
    }
}

