/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.analysis.ErrorProp;
import flanagan.optics.PlanarWaveguide;
import flanagan.optics.RefractiveIndex;

public class GratingCoupler
extends PlanarWaveguide {
    private double[] thicknessesTE = null;
    private double[] anglesDegTE = null;
    private double[] anglesRadTE = null;
    private double[] errorsDegTE = null;
    private double[] errorsRadTE = null;
    private double[] modeNumbersTE = null;
    private double[] effectiveRefractiveIndicesTE = null;
    private double[] effectiveErrorsTE = null;
    private int numberOfTEmeasurementsGrating = 0;
    private boolean setMeasurementsTEgrating = false;
    private boolean setTEerrors = false;
    private boolean calcEffectiveDone = false;
    private double[] thicknessesTM = null;
    private double[] anglesDegTM = null;
    private double[] anglesRadTM = null;
    private double[] errorsDegTM = null;
    private double[] errorsRadTM = null;
    private double[] modeNumbersTM = null;
    private double[] effectiveRefractiveIndicesTM = null;
    private double[] effectiveErrorsTM = null;
    private int numberOfTMmeasurementsGrating = 0;
    private boolean setMeasurementsTMgrating = false;
    private boolean setTMerrors = false;
    private int numberOfMeasurementsGrating = 0;
    private boolean setMeasurementsGrating = false;
    private double gratingPitch = 0.0;
    private boolean setGratingPitch = false;
    private int[] gratingOrderTE = null;
    private boolean setGratingOrderTE = false;
    private int[] gratingOrderTM = null;
    private boolean setGratingOrderTM = false;
    private double superstrateRI = 0.0;
    private boolean setSuperstrateRI = false;

    public void setGratingPitch(double d) {
        this.gratingPitch = d;
        this.setGratingPitch = true;
        if (this.setMeasurementsGrating && this.setWavelength) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    public void setSetTEmodeGratingOrder(int[] nArray) {
        this.gratingOrderTE = nArray;
        int n = nArray.length;
        if (this.setMeasurementsTEgrating && n != this.numberOfTEmeasurementsGrating) {
            throw new IllegalArgumentException("Number of grating orders entered, " + n + ", is not equal to the number of measurements previously entered, " + this.numberOfTEmeasurementsGrating);
        }
        if (this.setMeasurementsGrating && this.setGratingPitch && this.setWavelength) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    public void setSetTMmodeGratingOrder(int[] nArray) {
        this.gratingOrderTM = nArray;
        int n = nArray.length;
        if (this.setMeasurementsTMgrating && n != this.numberOfTMmeasurementsGrating) {
            throw new IllegalArgumentException("Number of grating orders entered, " + n + ", is not equal to the number of measurements previously entered, " + this.numberOfTEmeasurementsGrating);
        }
        if (this.setMeasurementsGrating && this.setGratingPitch && this.setWavelength) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    @Override
    public void setSuperstrateRefractiveIndex(double d) {
        if (this.calcEffectiveDone) {
            this.clearData();
        }
        this.superstrateRI = d;
        this.superstrateRefractiveIndex = d;
        this.setSuperstrateRI = true;
        if (this.setMeasurementsGrating && this.setGratingPitch && this.setWavelength) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    public double getAnalyteSolutionRefractiveIndex() {
        return super.getSuperstrateRefractiveIndex();
    }

    public double getStandardDeviationAnalyteSolutionRefractiveIndex() {
        return super.getStandardDeviationSuperstrateRefractiveIndex();
    }

    @Override
    public void enterTEmodeData(double d, double d2, double d3) {
        if (this.setMeasurementsTEgrating) {
            int n;
            if (this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n2 = this.numberOfTEmeasurementsGrating + 1;
            double[] dArray = new double[n2];
            for (n = 0; n < this.numberOfTEmeasurementsGrating; ++n) {
                dArray[n] = this.thicknessesTE[n];
            }
            dArray[this.numberOfTEmeasurementsGrating] = d;
            this.thicknessesTE = dArray;
            for (n = 0; n < this.numberOfTEmeasurementsGrating; ++n) {
                dArray[n] = this.anglesDegTE[n];
            }
            dArray[this.numberOfTEmeasurementsGrating] = d2;
            this.anglesDegTE = dArray;
            this.anglesRadTE = dArray;
            this.errorsDegTE = dArray;
            this.errorsRadTE = dArray;
            for (n = 0; n < n2; ++n) {
                this.anglesRadTE[n] = Math.toRadians(this.anglesDegTE[n]);
                this.errorsDegTE[n] = 0.0;
                this.errorsRadTE[n] = 0.0;
            }
            for (n = 0; n < this.numberOfTEmeasurementsGrating; ++n) {
                dArray[n] = this.modeNumbersTE[n];
            }
            dArray[this.numberOfTEmeasurementsGrating] = d3;
            this.numberOfTEmeasurementsGrating = n2;
        } else {
            this.thicknessesTE = new double[1];
            this.thicknessesTE[0] = d;
            this.anglesDegTE = new double[1];
            this.anglesDegTE[0] = d2;
            this.anglesRadTE = new double[1];
            this.anglesRadTE[0] = Math.toRadians(d2);
            this.errorsDegTE = new double[1];
            this.errorsDegTE[0] = 0.0;
            this.errorsRadTE = new double[1];
            this.errorsRadTE[0] = 0.0;
            this.modeNumbersTE = new double[1];
            this.modeNumbersTE[0] = d3;
            this.numberOfTEmeasurementsGrating = 1;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTEgrating = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double d, double d2, double d3) {
        if (this.setMeasurementsTMgrating) {
            int n;
            if (this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n2 = this.numberOfTMmeasurementsGrating + 1;
            double[] dArray = new double[n2];
            for (n = 0; n < this.numberOfTMmeasurementsGrating; ++n) {
                dArray[n] = this.thicknessesTM[n];
            }
            dArray[this.numberOfTMmeasurementsGrating] = d;
            this.thicknessesTM = dArray;
            for (n = 0; n < this.numberOfTMmeasurementsGrating; ++n) {
                dArray[n] = this.anglesDegTM[n];
            }
            dArray[this.numberOfTMmeasurementsGrating] = d2;
            this.anglesDegTM = dArray;
            this.anglesRadTM = dArray;
            this.errorsDegTM = dArray;
            this.errorsRadTM = dArray;
            for (n = 0; n < n2; ++n) {
                this.anglesRadTM[n] = Math.toRadians(this.anglesDegTM[n]);
                this.errorsDegTM[n] = 0.0;
                this.errorsRadTM[n] = 0.0;
            }
            for (n = 0; n < this.numberOfTMmeasurementsGrating; ++n) {
                dArray[n] = this.modeNumbersTM[n];
            }
            dArray[this.numberOfTMmeasurementsGrating] = d3;
            this.numberOfTMmeasurementsGrating = n2;
        } else {
            this.thicknessesTM = new double[1];
            this.thicknessesTM[0] = d;
            this.anglesDegTM = new double[1];
            this.anglesDegTM[0] = d2;
            this.anglesRadTM = new double[1];
            this.anglesRadTM[0] = Math.toRadians(d2);
            this.errorsDegTM = new double[1];
            this.errorsDegTM[0] = 0.0;
            this.errorsRadTM = new double[1];
            this.errorsRadTM[0] = 0.0;
            this.modeNumbersTM = new double[1];
            this.modeNumbersTM[0] = d3;
            this.numberOfTMmeasurementsGrating = 1;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTMgrating = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of coupling angles, " + n);
        }
        int n3 = dArray3.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTEgrating) {
            int n4;
            if (this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTEmeasurementsGrating + n2;
            double[] dArray4 = new double[n5];
            for (n4 = 0; n4 < this.numberOfTEmeasurementsGrating; ++n4) {
                dArray4[n4] = this.thicknessesTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTEmeasurementsGrating + n4] = dArray[n4];
            }
            this.thicknessesTE = dArray4;
            for (n4 = 0; n4 < this.numberOfTEmeasurementsGrating; ++n4) {
                dArray4[n4] = this.anglesDegTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTEmeasurementsGrating + n4] = dArray2[n4];
            }
            this.anglesDegTE = dArray4;
            this.anglesRadTE = dArray4;
            this.errorsDegTE = dArray4;
            this.errorsRadTE = dArray4;
            for (n4 = 0; n4 < n5; ++n4) {
                this.anglesRadTE[n4] = Math.toRadians(this.anglesDegTE[n4]);
                this.errorsDegTE[n4] = 0.0;
                this.errorsRadTE[n4] = 0.0;
            }
            for (n4 = 0; n4 < this.numberOfTEmeasurementsGrating; ++n4) {
                dArray4[n4] = this.modeNumbersTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTEmeasurementsGrating + n4] = dArray3[n4];
            }
            this.numberOfTEmeasurementsGrating = n5;
        } else {
            this.numberOfTEmeasurementsGrating = n2;
            this.thicknessesTE = dArray;
            this.anglesDegTE = dArray2;
            this.anglesRadTE = new double[n2];
            this.errorsDegTE = new double[n2];
            this.errorsRadTE = new double[n2];
            for (int i = 0; i < n2; ++i) {
                this.anglesRadTE[i] = Math.toRadians(dArray2[i]);
                this.errorsDegTE[i] = 0.0;
                this.errorsRadTE[i] = 0.0;
            }
            this.modeNumbersTE = dArray3;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTEgrating = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of coupling angles, " + n);
        }
        int n3 = dArray3.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTMgrating) {
            int n4;
            if (this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTMmeasurementsGrating + n2;
            double[] dArray4 = new double[n5];
            for (n4 = 0; n4 < this.numberOfTMmeasurementsGrating; ++n4) {
                dArray4[n4] = this.thicknessesTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTMmeasurementsGrating + n4] = dArray[n4];
            }
            this.thicknessesTM = dArray4;
            for (n4 = 0; n4 < this.numberOfTMmeasurementsGrating; ++n4) {
                dArray4[n4] = this.anglesDegTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTMmeasurementsGrating + n4] = dArray2[n4];
            }
            this.anglesDegTM = dArray4;
            this.anglesRadTM = dArray4;
            this.errorsDegTM = dArray4;
            this.errorsRadTM = dArray4;
            for (n4 = 0; n4 < n5; ++n4) {
                this.anglesRadTM[n4] = Math.toRadians(this.anglesDegTM[n4]);
                this.errorsDegTM[n4] = 0.0;
                this.errorsRadTM[n4] = 0.0;
            }
            for (n4 = 0; n4 < this.numberOfTMmeasurementsGrating; ++n4) {
                dArray4[n4] = this.modeNumbersTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTMmeasurementsGrating + n4] = dArray3[n4];
            }
            this.numberOfTMmeasurementsGrating = n5;
        } else {
            this.numberOfTMmeasurementsGrating = n2;
            this.thicknessesTM = dArray;
            this.anglesDegTM = dArray2;
            this.anglesRadTM = new double[n2];
            this.errorsDegTM = new double[n2];
            this.errorsRadTM = new double[n2];
            for (int i = 0; i < n2; ++i) {
                this.anglesRadTM[i] = Math.toRadians(dArray2[i]);
                this.errorsDegTM[i] = 0.0;
                this.errorsRadTM[i] = 0.0;
            }
            this.modeNumbersTM = dArray3;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTMgrating = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double d, double d2, double d3, double d4) {
        if (this.setMeasurementsTEgrating) {
            int n;
            if (!this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n2 = this.numberOfTEmeasurementsGrating + 1;
            double[] dArray = new double[n2];
            for (n = 0; n < this.numberOfTEmeasurementsGrating; ++n) {
                dArray[n] = this.thicknessesTE[n];
            }
            dArray[this.numberOfTEmeasurementsGrating] = d;
            this.thicknessesTE = dArray;
            for (n = 0; n < this.numberOfTEmeasurementsGrating; ++n) {
                dArray[n] = this.anglesDegTE[n];
            }
            dArray[this.numberOfTEmeasurementsGrating] = d2;
            this.anglesDegTE = dArray;
            for (n = 0; n < this.numberOfTEmeasurementsGrating; ++n) {
                dArray[n] = this.errorsDegTE[n];
            }
            dArray[this.numberOfTEmeasurementsGrating] = d3;
            this.errorsDegTE = dArray;
            this.anglesRadTE = dArray;
            this.errorsRadTE = dArray;
            for (n = 0; n < n2; ++n) {
                this.anglesRadTE[n] = Math.toRadians(this.anglesDegTE[n]);
                this.errorsRadTE[n] = Math.toRadians(this.errorsDegTE[n]);
            }
            for (n = 0; n < this.numberOfTEmeasurementsGrating; ++n) {
                dArray[n] = this.modeNumbersTE[n];
            }
            dArray[this.numberOfTEmeasurementsGrating] = d4;
            this.numberOfTEmeasurementsGrating = n2;
        } else {
            this.thicknessesTE = new double[1];
            this.thicknessesTE[0] = d;
            this.anglesDegTE = new double[1];
            this.anglesDegTE[0] = d2;
            this.anglesRadTE = new double[1];
            this.anglesRadTE[0] = Math.toRadians(d2);
            this.errorsDegTE = new double[1];
            this.errorsDegTE[0] = d3;
            this.errorsRadTE = new double[1];
            this.errorsRadTE[0] = Math.toRadians(d3);
            this.modeNumbersTE = new double[1];
            this.modeNumbersTE[0] = d4;
            this.numberOfTEmeasurementsGrating = 1;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTEgrating = true;
        this.setTEerrors = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double d, double d2, double d3, double d4) {
        if (this.setMeasurementsTMgrating) {
            int n;
            if (!this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n2 = this.numberOfTMmeasurementsGrating + 1;
            double[] dArray = new double[n2];
            for (n = 0; n < this.numberOfTMmeasurementsGrating; ++n) {
                dArray[n] = this.thicknessesTM[n];
            }
            dArray[this.numberOfTMmeasurementsGrating] = d;
            this.thicknessesTM = dArray;
            for (n = 0; n < this.numberOfTMmeasurementsGrating; ++n) {
                dArray[n] = this.anglesDegTM[n];
            }
            dArray[this.numberOfTMmeasurementsGrating] = d2;
            this.anglesDegTM = dArray;
            for (n = 0; n < this.numberOfTMmeasurementsGrating; ++n) {
                dArray[n] = this.errorsDegTM[n];
            }
            dArray[this.numberOfTMmeasurementsGrating] = d3;
            this.errorsDegTM = dArray;
            this.anglesRadTM = dArray;
            this.errorsRadTM = dArray;
            for (n = 0; n < n2; ++n) {
                this.anglesRadTM[n] = Math.toRadians(this.anglesDegTM[n]);
                this.errorsRadTM[n] = Math.toRadians(this.errorsDegTM[n]);
            }
            for (n = 0; n < this.numberOfTMmeasurementsGrating; ++n) {
                dArray[n] = this.modeNumbersTM[n];
            }
            dArray[this.numberOfTMmeasurementsGrating] = d4;
            this.numberOfTMmeasurementsGrating = n2;
        } else {
            this.thicknessesTM = new double[1];
            this.thicknessesTM[0] = d;
            this.anglesDegTM = new double[1];
            this.anglesDegTM[0] = d2;
            this.anglesRadTM = new double[1];
            this.anglesDegTM[0] = Math.toRadians(d2);
            this.errorsDegTM = new double[1];
            this.errorsDegTM[0] = d3;
            this.errorsRadTM = new double[1];
            this.errorsDegTM[0] = Math.toRadians(d3);
            this.modeNumbersTM = new double[1];
            this.modeNumbersTM[0] = d4;
            this.numberOfTMmeasurementsGrating = 1;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTMgrating = true;
        this.setTMerrors = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of coupling angles, " + n);
        }
        int n3 = dArray4.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTEgrating) {
            int n4;
            if (!this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTEmeasurementsGrating + n2;
            double[] dArray5 = new double[n5];
            for (n4 = 0; n4 < this.numberOfTEmeasurementsGrating; ++n4) {
                dArray5[n4] = this.thicknessesTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTEmeasurementsGrating + n4] = dArray[n4];
            }
            this.thicknessesTE = dArray5;
            for (n4 = 0; n4 < this.numberOfTEmeasurementsGrating; ++n4) {
                dArray5[n4] = this.anglesDegTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTEmeasurementsGrating + n4] = dArray2[n4];
            }
            this.anglesDegTE = dArray5;
            for (n4 = 0; n4 < this.numberOfTEmeasurementsGrating; ++n4) {
                dArray5[n4] = this.errorsDegTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTEmeasurementsGrating + n4] = dArray3[n4];
            }
            this.errorsDegTE = dArray5;
            this.anglesRadTE = dArray5;
            this.errorsRadTE = dArray5;
            for (n4 = 0; n4 < n5; ++n4) {
                this.anglesRadTE[n4] = Math.toRadians(this.anglesDegTE[n4]);
                this.errorsRadTE[n4] = Math.toRadians(this.errorsDegTE[n4]);
            }
            for (n4 = 0; n4 < this.numberOfTEmeasurementsGrating; ++n4) {
                dArray5[n4] = this.modeNumbersTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTEmeasurementsGrating + n4] = dArray4[n4];
            }
            this.numberOfTEmeasurementsGrating = n5;
        } else {
            this.numberOfTEmeasurementsGrating = n2;
            this.thicknessesTE = dArray;
            this.anglesDegTE = dArray2;
            this.anglesRadTE = new double[n2];
            this.errorsDegTE = dArray3;
            this.errorsRadTE = new double[n2];
            for (int i = 0; i < n2; ++i) {
                this.anglesRadTE[i] = Math.toRadians(dArray2[i]);
                this.errorsRadTE[i] = Math.toRadians(dArray3[i]);
            }
            this.modeNumbersTE = dArray4;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTEgrating = true;
        this.setTEerrors = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of coupling angles, " + n);
        }
        int n3 = dArray4.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTMgrating) {
            int n4;
            if (!this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTMmeasurementsGrating + n2;
            double[] dArray5 = new double[n5];
            for (n4 = 0; n4 < this.numberOfTMmeasurementsGrating; ++n4) {
                dArray5[n4] = this.thicknessesTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTMmeasurementsGrating + n4] = dArray[n4];
            }
            this.thicknessesTM = dArray5;
            for (n4 = 0; n4 < this.numberOfTMmeasurementsGrating; ++n4) {
                dArray5[n4] = this.anglesDegTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTMmeasurementsGrating + n4] = dArray2[n4];
            }
            this.anglesDegTM = dArray5;
            for (n4 = 0; n4 < this.numberOfTMmeasurementsGrating; ++n4) {
                dArray5[n4] = this.errorsDegTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTMmeasurementsGrating + n4] = dArray3[n4];
            }
            this.errorsDegTM = dArray5;
            this.anglesRadTM = dArray5;
            this.errorsRadTM = dArray5;
            for (n4 = 0; n4 < n5; ++n4) {
                this.anglesRadTM[n4] = Math.toRadians(this.anglesDegTM[n4]);
                this.errorsRadTM[n4] = Math.toRadians(this.errorsDegTM[n4]);
            }
            for (n4 = 0; n4 < this.numberOfTMmeasurementsGrating; ++n4) {
                dArray5[n4] = this.modeNumbersTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTMmeasurementsGrating + n4] = dArray4[n4];
            }
            this.numberOfTMmeasurementsGrating = n5;
        } else {
            this.numberOfTMmeasurementsGrating = n2;
            this.thicknessesTM = dArray;
            this.anglesDegTM = dArray2;
            this.errorsDegTM = dArray3;
            this.anglesRadTM = new double[n2];
            this.errorsRadTM = new double[n2];
            for (int i = 0; i < n2; ++i) {
                this.anglesRadTM[i] = Math.toRadians(dArray2[i]);
                this.errorsRadTM[i] = Math.toRadians(dArray3[i]);
            }
            this.modeNumbersTM = dArray4;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTMgrating = true;
        this.setTMerrors = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void clearData() {
        this.numberOfTEmeasurementsGrating = 0;
        this.setMeasurementsTEgrating = false;
        this.numberOfTMmeasurementsGrating = 0;
        this.setMeasurementsTMgrating = false;
        this.numberOfMeasurements = 0;
        this.setMeasurements = false;
        this.setWeights = false;
        this.numberOfTEmeasurements = 0;
        this.setMeasurementsTE = false;
        this.numberOfTMmeasurements = 0;
        this.setMeasurementsTM = false;
    }

    public void calcEffectiveRefractiveIndices() {
        if (this.setMeasurementsTEgrating) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
        if (this.setMeasurementsTMgrating) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    public void calcTEmodeEffectiveRefractiveIndices() {
        this.effectiveRefractiveIndicesTE = new double[this.numberOfTEmeasurementsGrating];
        this.effectiveErrorsTE = new double[this.numberOfTEmeasurementsGrating];
        if (!this.setSuperstrateRI) {
            this.superstrateRI = RefractiveIndex.air(this.wavelength);
            this.superstrateRefractiveIndex = RefractiveIndex.air(this.wavelength);
        }
        if (this.setTEerrors) {
            ErrorProp errorProp = new ErrorProp(this.superstrateRefractiveIndex, 0.0);
            ErrorProp errorProp2 = new ErrorProp(this.gratingPitch, 0.0);
            ErrorProp errorProp3 = new ErrorProp(this.wavelength, 0.0);
            for (int i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                ErrorProp errorProp4 = new ErrorProp(this.anglesRadTM[i], this.errorsRadTM[i]);
                ErrorProp errorProp5 = new ErrorProp(this.gratingOrderTE[i], 0.0);
                ErrorProp errorProp6 = ErrorProp.sin(errorProp4);
                errorProp6 = errorProp6.times(errorProp);
                errorProp6 = errorProp6.plus(errorProp3.times(errorProp5).over(errorProp2));
                this.effectiveRefractiveIndicesTE[i] = errorProp6.getValue();
                this.effectiveErrorsTE[i] = errorProp6.getError();
            }
            super.enterTEmodeData(this.thicknessesTE, this.effectiveRefractiveIndicesTE, this.effectiveErrorsTE, this.modeNumbersTE);
        } else {
            for (int i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                this.effectiveRefractiveIndicesTE[i] = this.superstrateRI * Math.sin(this.anglesRadTE[i]) + this.wavelength * (double)this.gratingOrderTE[i] / this.gratingPitch;
            }
            super.enterTEmodeData(this.thicknessesTE, this.effectiveRefractiveIndicesTE, this.modeNumbersTE);
        }
        this.calcEffectiveDone = true;
    }

    public void calcTMmodeEffectiveRefractiveIndices() {
        this.effectiveRefractiveIndicesTM = new double[this.numberOfTMmeasurementsGrating];
        this.effectiveErrorsTM = new double[this.numberOfTMmeasurementsGrating];
        if (!this.setSuperstrateRI) {
            this.superstrateRI = RefractiveIndex.air(this.wavelength);
            this.superstrateRefractiveIndex = RefractiveIndex.air(this.wavelength);
        }
        if (this.setTMerrors) {
            ErrorProp errorProp = new ErrorProp(this.superstrateRefractiveIndex, 0.0);
            ErrorProp errorProp2 = new ErrorProp(this.gratingPitch, 0.0);
            ErrorProp errorProp3 = new ErrorProp(this.wavelength, 0.0);
            for (int i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                ErrorProp errorProp4 = new ErrorProp(this.anglesRadTM[i], this.errorsRadTM[i]);
                ErrorProp errorProp5 = new ErrorProp(this.gratingOrderTM[i], 0.0);
                ErrorProp errorProp6 = ErrorProp.sin(errorProp4);
                errorProp6 = errorProp6.times(errorProp);
                errorProp6 = errorProp6.plus(errorProp3.times(errorProp5).over(errorProp2));
                this.effectiveRefractiveIndicesTM[i] = errorProp6.getValue();
                this.effectiveErrorsTM[i] = errorProp6.getError();
            }
            super.enterTMmodeData(this.thicknessesTM, this.effectiveRefractiveIndicesTM, this.effectiveErrorsTM, this.modeNumbersTM);
        } else {
            for (int i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                this.effectiveRefractiveIndicesTM[i] = this.superstrateRI * Math.sin(this.anglesRadTM[i]) + this.wavelength * (double)this.gratingOrderTM[i] / this.gratingPitch;
            }
            super.enterTMmodeData(this.thicknessesTM, this.effectiveRefractiveIndicesTM, this.modeNumbersTM);
        }
        this.calcEffectiveDone = true;
    }
}

