/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.roots.RealRootFunction;

class FunctTMplot
implements RealRootFunction {
    public double substrateRefractiveIndex2 = 0.0;
    public double superstrateRefractiveIndex2 = 0.0;
    public double coreFilmRefractiveIndex2 = 0.0;
    public double prismRefractiveIndex2 = 0.0;
    public double ko = 0.0;
    public double prismToWaveguideGap = 0.0;
    public boolean setPrismToWaveguideGap = false;
    public double thickness = 0.0;
    public double modeNumber = 0.0;

    FunctTMplot() {
    }

    @Override
    public double function(double d) {
        double d2 = 0.0;
        double d3 = d * d;
        double d4 = Math.sqrt(d3 - this.substrateRefractiveIndex2);
        double d5 = Math.sqrt(d3 - this.superstrateRefractiveIndex2);
        double d6 = Math.sqrt(this.coreFilmRefractiveIndex2 - d3);
        double d7 = Math.sqrt(this.prismRefractiveIndex2 - d3);
        double d8 = Math.atan2(this.coreFilmRefractiveIndex2 * d5, this.superstrateRefractiveIndex2 * d6);
        d2 = Math.PI * this.modeNumber - this.thickness * this.ko * d6;
        d2 += d8 + Math.atan2(this.coreFilmRefractiveIndex2 * d4, this.substrateRefractiveIndex2 * d6);
        if (this.setPrismToWaveguideGap) {
            d2 += Math.sin(d8) * Math.cos(Math.atan2(d5 * this.prismRefractiveIndex2, d7 * this.superstrateRefractiveIndex2)) * Math.exp(-2.0 * this.prismToWaveguideGap * d5);
        }
        return d2;
    }
}

