/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.roots.RealRootFunction;

class FunctTE
implements RealRootFunction {
    public double substrateRefractiveIndex2 = 0.0;
    public double superstrateRefractiveIndex2 = 0.0;
    public double effectiveRefractiveIndex2 = 0.0;
    public double prismRefractiveIndex2 = 0.0;
    public double ko = 0.0;
    public double prismToWaveguideGap = 0.0;
    public boolean setPrismToWaveguideGap = false;
    public double thickness = 0.0;
    public double modeNumber = 0.0;

    FunctTE() {
    }

    @Override
    public double function(double d) {
        double d2 = 0.0;
        double d3 = d * d;
        double d4 = Math.sqrt(this.effectiveRefractiveIndex2 - this.substrateRefractiveIndex2);
        double d5 = Math.sqrt(this.effectiveRefractiveIndex2 - this.superstrateRefractiveIndex2);
        double d6 = Math.sqrt(d3 - this.effectiveRefractiveIndex2);
        double d7 = Math.sqrt(this.prismRefractiveIndex2 - this.effectiveRefractiveIndex2);
        double d8 = Math.atan2(d5, d6);
        d2 = Math.PI * this.modeNumber - this.thickness * this.ko * d6;
        d2 += d8 + Math.atan2(d4, d6);
        if (this.setPrismToWaveguideGap) {
            d2 += Math.sin(d8) * Math.cos(Math.atan2(d5, d7)) * Math.exp(-2.0 * this.prismToWaveguideGap * this.ko * d5);
        }
        return d2;
    }
}

