/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.io.Db;
import flanagan.math.Conv;
import java.util.Calendar;

public class TimeAndDate {
    private Calendar cal = Calendar.getInstance();
    private String dayOfTheWeek = null;
    private int dayOfTheMonth = 0;
    private String monthOfTheYear = null;
    private int monthAsInteger = 0;
    private int year = 0;
    private String fullDate = null;
    private String date = null;
    private String shortDateUK = null;
    private String shortDateUS = null;
    private String[] days = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private int[] monthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int[] monthDaysLeap = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int hour24 = -1;
    private String hour12 = null;
    private int minute = -1;
    private int second = -1;
    private int millisecond = -1;
    private String shortTime24 = null;
    private String shortTime12 = null;
    private String midTime24 = null;
    private String midTime12 = null;
    private String fullTime24 = null;
    private String fullTime12 = null;
    private long tStart = 0L;
    private boolean startCheck = false;
    private long tEnd = 0L;
    private boolean endCheck = false;
    private long totalTime = 0L;
    private String changeDate = null;
    private boolean backForw = true;
    private int easterMonth = 0;
    private int easterDay = 0;
    private String easterDayName = null;
    private int yearHold = 0;
    private int monthHold = 0;
    private int dayHold = 0;
    private String dayNameHold = null;

    public void waitFor(int n) {
        long l;
        long l2 = System.currentTimeMillis();
        while ((l = System.currentTimeMillis()) - l2 < (long)(n * 1000)) {
        }
    }

    public void waitFor(long l) {
        long l2;
        if (l > 9223372036854775L) {
            System.out.println("Class: TimeAndDate, method: wait(long nSeconds), nSeconds is too large for this method - the value has been replaced by 9223372036854775");
            l = 9223372036854775L;
        }
        long l3 = System.currentTimeMillis();
        while ((l2 = System.currentTimeMillis()) - l3 < l * 1000L) {
        }
    }

    public void waitFor(double d) {
        long l;
        long l2 = 0L;
        if (d > Math.pow(2.0, 63.0) - 1.0) {
            System.out.println("Class: TimeAndDate, method: wait(double nSeconds), nSeconds is too large for this method - the value has been replaced by 9223372036854775");
            l2 = Long.MAX_VALUE;
        } else {
            l2 = Conv.convert_double_to_long(d * 1000.0);
        }
        long l3 = System.currentTimeMillis();
        while ((l = System.currentTimeMillis()) - l3 < l2) {
        }
    }

    public void blocStart() {
        this.tStart = System.currentTimeMillis();
        this.startCheck = true;
    }

    public long blocEnd() {
        if (!this.startCheck) {
            throw new IllegalArgumentException("No start marker has been set");
        }
        this.tEnd = System.currentTimeMillis();
        this.totalTime = this.tEnd - this.tStart;
        this.endCheck = true;
        return this.totalTime;
    }

    public long blocTime() {
        if (this.endCheck) {
            return this.totalTime;
        }
        if (!this.startCheck) {
            System.out.println("Class Time: method totalTime:  No start marker has been set - -9999 rturned");
            return -9999L;
        }
        System.out.println("Class Time: method totalTime:  No end marker has been set - -8888 rturned");
        return -8888L;
    }

    public int getHour24() {
        this.hour24 = this.cal.get(11);
        return this.hour24;
    }

    public String getHour12() {
        int n = this.cal.get(10);
        int n2 = this.cal.get(9);
        this.hour12 = n2 == 0 ? new Integer(n).toString() + " AM" : new Integer(n).toString() + " PM";
        return this.hour12;
    }

    public int getMinute() {
        this.minute = this.cal.get(12);
        return this.minute;
    }

    public int getSecond() {
        this.second = this.cal.get(13);
        return this.second;
    }

    public int getMilliSecond() {
        this.millisecond = this.cal.get(14);
        return this.millisecond;
    }

    public String getShortTime24() {
        int n = this.getHour24();
        this.shortTime24 = new Integer(n).toString();
        int n2 = this.getMinute();
        this.shortTime24 = n2 < 10 ? this.shortTime24 + ".0" + n2 : this.shortTime24 + "." + n2;
        return this.shortTime24;
    }

    public String getShortTime12() {
        int n = this.cal.get(10);
        int n2 = this.cal.get(9);
        this.shortTime12 = new Integer(n).toString();
        int n3 = this.getMinute();
        this.shortTime12 = n3 < 10 ? this.shortTime12 + ".0" + n3 : this.shortTime12 + "." + n3;
        this.shortTime12 = n2 == 0 ? this.shortTime12 + " AM" : this.shortTime12 + " PM";
        return this.shortTime12;
    }

    public String getMidTime24() {
        int n = this.getHour24();
        this.midTime24 = new Integer(n).toString();
        int n2 = this.getMinute();
        this.midTime24 = n2 < 10 ? this.midTime24 + ".0" + n2 : this.midTime24 + "." + n2;
        int n3 = this.getSecond();
        this.midTime24 = n3 < 10 ? this.midTime24 + ".0" + n3 : this.midTime24 + "." + n3;
        return this.midTime24;
    }

    public String getMidTime12() {
        int n = this.cal.get(10);
        int n2 = this.cal.get(9);
        this.midTime12 = new Integer(n).toString();
        int n3 = this.getMinute();
        this.midTime12 = n3 < 10 ? this.midTime12 + ".0" + n3 : this.midTime12 + "." + n3;
        int n4 = this.getSecond();
        this.midTime12 = n4 < 10 ? this.midTime12 + ".0" + n4 : this.midTime12 + "." + n4;
        this.midTime12 = n2 == 0 ? this.midTime12 + " AM" : this.midTime12 + " PM";
        return this.midTime12;
    }

    public String getFullTime24() {
        int n = this.getHour24();
        this.fullTime24 = new Integer(n).toString();
        int n2 = this.getMinute();
        this.fullTime24 = n2 < 10 ? this.fullTime24 + ".0" + n2 : this.fullTime24 + "." + n2;
        int n3 = this.getSecond();
        this.fullTime24 = n3 < 10 ? this.fullTime24 + ".0" + n3 : this.fullTime24 + "." + n3;
        int n4 = this.getMilliSecond();
        this.fullTime24 = n4 < 10 ? this.fullTime24 + ".00" + n4 : (n4 < 100 ? this.fullTime24 + ".0" + n4 : this.fullTime24 + "." + n4);
        return this.fullTime24;
    }

    public String getFullTime12() {
        int n = this.cal.get(10);
        int n2 = this.cal.get(9);
        this.fullTime12 = new Integer(n).toString();
        int n3 = this.getMinute();
        this.fullTime12 = n3 < 10 ? this.fullTime12 + ".0" + n3 : this.fullTime12 + "." + n3;
        int n4 = this.getSecond();
        this.fullTime12 = n4 < 10 ? this.fullTime12 + ".0" + n4 : this.fullTime12 + "." + n4;
        int n5 = this.getMilliSecond();
        this.fullTime12 = n5 < 10 ? this.fullTime12 + ".00" + n5 : (n5 < 100 ? this.fullTime12 + ".0" + n5 : this.fullTime12 + "." + n5);
        this.fullTime12 = n2 == 0 ? this.fullTime12 + " AM" : this.fullTime12 + " PM";
        return this.fullTime12;
    }

    public long getComputerTime() {
        return System.currentTimeMillis();
    }

    public long dateToJavaMilliSecondsUK(int n, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        long l = 0L;
        int n8 = this.getDayOfTheWeekAsInteger(string);
        long l2 = 0L;
        this.backForw = this.checkBST(string, n3, n4, n2, n8);
        if (this.backForw) {
            l2 = 1L;
        }
        if (n >= 1970) {
            long l3 = 0L;
            for (int i = n - 1; i >= 1970; --i) {
                l3 += 365L;
                if (!this.leapYear(i)) continue;
                ++l3;
            }
            l3 *= 86400000L;
            long l4 = 0L;
            for (int i = n2; i > 0; --i) {
                l4 += (long)this.monthDays[i - 1];
                if (!this.leapYear(n) || i != 2) continue;
                ++l4;
            }
            long l5 = (long)(n3 - 1) * 24L * 60L * 60L * 1000L;
            l = l3 + (l4 *= 86400000L) + l5 + ((long)n4 - l2) * 60L * 60L * 1000L + (long)n5 * 60L * 1000L + (long)n6 * 1000L + (long)n7;
        } else {
            long l6 = 0L;
            for (int i = n + 1; i < 1970; ++i) {
                l6 += 365L;
                if (!this.leapYear(i)) continue;
                ++l6;
            }
            l6 *= 86400000L;
            long l7 = 0L;
            for (int i = n2 - 1; i > 0; --i) {
                l7 += (long)this.monthDays[i - 1];
                if (!this.leapYear(n) || i != 2) continue;
                ++l7;
            }
            l7 *= 86400000L;
            long l8 = (long)(n3 - 1) * 24L * 60L * 60L * 1000L;
            l7 = l7 + l8 + ((long)n4 - l2) * 60L * 60L * 1000L + (long)n5 * 60L * 1000L + (long)n6 * 1000L + (long)n7;
            long l9 = 365L;
            if (this.leapYear(n)) {
                ++l9;
            }
            l = (l9 *= 86400000L) - l7;
            l += l6;
            l = -l;
        }
        return l;
    }

    public boolean checkBST() {
        String string = this.getDayOfTheWeek();
        int n = this.getDayOfTheMonth();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getMonthAsInteger();
        int n4 = this.getDayOfTheWeekAsInteger(string);
        return this.checkBST(string, n, n2, n3, n4);
    }

    private boolean checkBST(String string, int n, int n2, int n3, int n4) {
        if (n3 > 3 && n3 < 10) {
            this.backForw = true;
        } else if (n3 == 3 && n > 24) {
            if (n4 == 0) {
                if (n2 >= 1) {
                    this.backForw = true;
                }
            } else if (n4 > 0 && n4 < n - 24) {
                this.backForw = true;
            }
        } else if (n3 == 10 && n > 24) {
            if (n4 == 0) {
                if (n2 <= 2) {
                    this.backForw = true;
                }
            } else {
                this.backForw = true;
                if (n4 > 0 && n4 < n - 24) {
                    this.backForw = false;
                }
            }
        }
        return this.backForw;
    }

    public int getDayOfTheWeekAsInteger() {
        String string = this.getDayOfTheWeek();
        return this.getDayOfTheWeekAsInteger(string) + 1;
    }

    private int getDayOfTheWeekAsInteger(String string) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            if (string.equals(this.days[n])) {
                n2 = n;
                bl = false;
                continue;
            }
            if (++n <= 6) continue;
            throw new IllegalArgumentException(string + " is not recognised as a day of the week");
        }
        return n2;
    }

    public String nextBstClockChange() {
        this.backForw = true;
        String string = this.getDayOfTheWeek();
        int n = this.getDayOfTheMonth();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getMonthAsInteger();
        int n4 = this.getDayOfTheWeekAsInteger(string);
        this.backForw = this.checkBST(string, n, n2, n3, n4);
        int n5 = 0;
        int n6 = n;
        int n7 = n3;
        int n8 = this.year;
        int n9 = n6;
        int n10 = n7;
        int n11 = n8;
        if (n4 != 0) {
            n5 = 7 - n4;
        }
        n6 = n + n5;
        int n12 = this.monthDays[n7 - 1];
        if (n7 == 2 && this.leapYear(n8)) {
            ++n12;
        }
        if (n6 > n12) {
            n6 -= n12;
            if (++n7 == 13) {
                n7 = 1;
                n8 = n11 + 1;
            }
        }
        if (!this.backForw) {
            boolean bl = true;
            while (bl) {
                if (n7 == 3 && n6 > 24) {
                    this.changeDate = "Sunday, " + n6 + " March " + this.year + ", one hour forward";
                    bl = false;
                    continue;
                }
                n6 += 7;
                n12 = this.monthDays[n7 - 1];
                if (n7 == 2 && this.leapYear(n8)) {
                    ++n12;
                }
                if (n6 <= n12) continue;
                n6 -= n12;
                if (++n7 != 13) continue;
                n7 = 1;
                ++n8;
            }
        } else {
            boolean bl = true;
            while (bl) {
                if (n7 == 10 && n6 > 24) {
                    this.changeDate = "Sunday, " + n6 + " October " + this.year + ", one hour back";
                    bl = false;
                    continue;
                }
                n6 += 7;
                n12 = this.monthDays[n7 - 1];
                if (n7 == 2 && this.leapYear(n8)) {
                    ++n12;
                }
                if (n6 <= n12) continue;
                n6 -= n12;
                if (++n7 != 13) continue;
                n7 = 1;
                ++n8;
            }
        }
        return this.changeDate;
    }

    public String getDayOfTheWeek() {
        int n = this.cal.get(7);
        this.dayOfTheWeek = this.days[n - 1];
        return this.dayOfTheWeek;
    }

    public int getDayOfTheMonth() {
        this.dayOfTheMonth = this.cal.get(5);
        return this.dayOfTheMonth;
    }

    public String getMonth() {
        int n = this.cal.get(2);
        this.monthOfTheYear = this.months[n];
        return this.monthOfTheYear;
    }

    public int getMonthAsInteger() {
        this.monthAsInteger = this.cal.get(2) + 1;
        return this.monthAsInteger;
    }

    public int getMonthAsInteger(String string) {
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (string.equals(this.months[n2])) {
                n = n2 + 1;
                bl = false;
                continue;
            }
            if (++n2 != 12) continue;
            throw new IllegalArgumentException(string + " is not recognised as a valid month name");
        }
        return n;
    }

    public int getYear() {
        this.year = this.cal.get(1);
        return this.year;
    }

    public String getDate() {
        this.date = new Integer(this.getDayOfTheMonth()).toString();
        this.date = this.date + " " + this.getMonth();
        this.date = this.date + " " + this.getYear();
        return this.date;
    }

    public String getFullDate() {
        this.fullDate = this.getDayOfTheWeek();
        this.fullDate = this.fullDate + ", " + this.getDayOfTheMonth();
        this.fullDate = this.fullDate + " " + this.getMonth();
        this.fullDate = this.fullDate + " " + this.getYear();
        return this.fullDate;
    }

    public String getShortDateUK() {
        int n;
        this.shortDateUK = new Integer(this.getDayOfTheMonth()).toString();
        if (this.shortDateUK.length() < 2) {
            this.shortDateUK = "0" + this.shortDateUK;
        }
        this.shortDateUK = (n = this.getMonthAsInteger()) < 10 ? this.shortDateUK + ".0" + n : this.shortDateUK + "." + n;
        String string = new Integer(this.getYear()).toString();
        this.shortDateUK = this.shortDateUK + "." + string.substring(2);
        return this.shortDateUK;
    }

    public String getShortDateUS() {
        int n;
        this.shortDateUS = new Integer(this.getMonthAsInteger()).toString();
        if (this.shortDateUS.length() < 2) {
            this.shortDateUS = "0" + this.shortDateUS;
        }
        this.shortDateUS = (n = this.getDayOfTheMonth()) < 10 ? this.shortDateUS + "/0" + n : this.shortDateUS + "/" + n;
        String string = new Integer(this.getYear()).toString();
        this.shortDateUS = this.shortDateUS + "/" + string.substring(2);
        return this.shortDateUS;
    }

    private boolean direction(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = true;
        boolean bl2 = false;
        bl2 = n6 > n3 ? true : (n6 < n3 ? false : (n5 > n2 ? true : (n5 < n2 ? false : n4 >= n)));
        return bl2;
    }

    public String getDayOfDate(int n, String string, int n2) {
        int n3 = this.getMonthAsInteger(string);
        return this.getDayOfDate(n, n3, n2);
    }

    public String getDayOfDate(int n, int n2, int n3) {
        String string = null;
        int n4 = this.getYear();
        int n5 = this.getMonthAsInteger();
        int n6 = this.getDayOfTheMonth();
        int n7 = this.getDayOfTheWeekAsInteger();
        int n8 = 0;
        boolean bl = this.direction(n6, n5, n4, n, n2, n3);
        if (bl) {
            boolean bl2 = true;
            while (bl2) {
                if (n4 == n3 && n5 == n2 && n6 == n) {
                    string = this.days[n7 - 1];
                    bl2 = false;
                    continue;
                }
                ++n6;
                n8 = this.monthDays[n5 - 1];
                if (this.leapYear(n4) && n5 == 2) {
                    ++n8;
                }
                if (n6 > n8) {
                    n6 -= n8;
                    ++n5;
                }
                if (n5 == 13) {
                    n5 = 1;
                    ++n4;
                }
                if (++n7 != 8) continue;
                n7 = 1;
            }
        } else {
            boolean bl3 = true;
            while (bl3) {
                if (n4 == n3 && n5 == n2 && n6 == n) {
                    string = this.days[n7 - 1];
                    bl3 = false;
                    continue;
                }
                --n6;
                int n9 = n5 - 2;
                if (n9 < 0) {
                    n9 = 11;
                }
                n8 = this.monthDays[n9];
                if (this.leapYear(n4) && n5 == 3) {
                    ++n8;
                }
                if (n6 == 0) {
                    n6 = n8;
                    --n5;
                }
                if (n5 == 0) {
                    n5 = 12;
                    --n4;
                }
                if (--n7 != 0) continue;
                n7 = 7;
            }
        }
        return string;
    }

    public String easterSunday() {
        int n = this.getYear();
        if (n > 2299) {
            System.out.println(n + " is outside the range for which this algorithm has been checked, 1700 - 2299");
        }
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        int n4 = n % 19;
        int n5 = n / 100;
        int n6 = n % 100;
        int n7 = n5 / 4;
        int n8 = n5 % 4;
        int n9 = n6 / 4;
        int n10 = n6 % 4;
        int n11 = (n5 + 8) / 25;
        int n12 = (n5 - n11 + 1) / 3;
        int n13 = (19 * n4 + n5 - n7 - n12 + 15) % 30;
        int n14 = (32 + 2 * n8 + 2 * n9 - n13 - n10) % 7;
        int n15 = (n4 + 11 * n13 + 22 * n14) / 451;
        int n16 = n13 + n14 - 7 * n15 + 114;
        this.easterMonth = n16 / 31;
        this.easterDay = n16 % 31 + 1;
        boolean bl = this.direction(n3, n2, n, this.easterDay, this.easterMonth, n);
        if (bl) {
            this.dayHold = this.easterDay;
            this.monthHold = this.easterMonth;
            this.yearHold = n;
            this.dayNameHold = "Sunday";
            this.easterDayName = this.getDayOfDate(this.easterDay, this.easterMonth, n);
            return this.easterDayName + ", " + this.easterDay + " " + this.months[this.easterMonth - 1] + " " + n;
        }
        return this.easterSunday(++n);
    }

    public String easterSunday(int n) {
        if (n < 1700 || n > 2299) {
            System.out.println(n + " is outside the range for which this algorithm has been checked, 1700 - 2299");
        }
        int n2 = n % 19;
        int n3 = n / 100;
        int n4 = n % 100;
        int n5 = n3 / 4;
        int n6 = n3 % 4;
        int n7 = n4 / 4;
        int n8 = n4 % 4;
        int n9 = (n3 + 8) / 25;
        int n10 = (n3 - n9 + 1) / 3;
        int n11 = (19 * n2 + n3 - n5 - n10 + 15) % 30;
        int n12 = (32 + 2 * n6 + 2 * n7 - n11 - n8) % 7;
        int n13 = (n2 + 11 * n11 + 22 * n12) / 451;
        int n14 = n11 + n12 - 7 * n13 + 114;
        this.easterMonth = n14 / 31;
        this.dayHold = this.easterDay = n14 % 31 + 1;
        this.monthHold = this.easterMonth;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        this.easterDayName = this.getDayOfDate(this.easterDay, this.easterMonth, n);
        return this.easterDayName + ", " + this.easterDay + " " + this.months[this.easterMonth - 1] + " " + n;
    }

    public String goodFriday() {
        int n;
        int n2 = this.getYear();
        int n3 = this.getMonthAsInteger();
        int n4 = this.getDayOfTheMonth();
        this.easterSunday(n2);
        int n5 = this.easterMonth;
        int n6 = this.easterDay - 2;
        if (n6 < 1) {
            n = this.monthDays[n5 - 2];
            if (this.leapYear(n2) && n5 == 3) {
                ++n;
            }
            n6 = n + n6;
            --n5;
        }
        if ((n = (int)(this.direction(n4, n3, n2, n6, n5, n2) ? 1 : 0)) == 0) {
            ++n2;
        }
        return this.goodFriday(n2);
    }

    public String goodFriday(int n) {
        this.easterSunday(n);
        int n2 = this.easterMonth;
        int n3 = this.easterDay - 2;
        if (n3 < 1) {
            int n4 = this.monthDays[n2 - 2];
            if (this.leapYear(n) && n2 == 3) {
                ++n4;
            }
            n3 = n4 + n3;
            --n2;
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Friday";
        return "Friday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String maundyThursday() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.maundyThursday(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.maundyThursday(n);
    }

    public String maundyThursday(int n) {
        this.goodFriday(n);
        int n2 = this.monthHold;
        int n3 = this.dayHold - 1;
        if (n3 < 1) {
            int n4 = this.monthDays[n2 - 2];
            if (this.leapYear(n) && n2 == 3) {
                ++n4;
            }
            n3 = n4 + n3;
            --n2;
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Friday";
        return "Thursday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String ashWednesday() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.ashWednesday(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.ashWednesday(n);
    }

    public String ashWednesday(int n) {
        this.easterSunday(n);
        int n2 = this.easterMonth;
        int n3 = this.easterDay;
        int n4 = 1;
        while (n4 <= 40) {
            if (--n3 < 1) {
                int n5 = this.monthDays[n2 - 2];
                if (this.leapYear(n) && n2 == 3) {
                    ++n5;
                }
                n3 = n5 + n3;
                --n2;
            }
            if (this.getDayOfDate(n3, n2, n).equals("Sunday")) continue;
            ++n4;
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Wednesday";
        return "Wednesday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String shroveTuesday() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.shroveTuesday(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.shroveTuesday(n);
    }

    public String shroveTuesday(int n) {
        this.ashWednesday(n);
        int n2 = this.monthHold;
        int n3 = this.dayHold - 1;
        if (n3 < 1) {
            int n4 = this.monthDays[n2 - 2];
            if (this.leapYear(n) && n2 == 3) {
                ++n4;
            }
            n3 = n4 + n3;
            --n2;
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Tuesday";
        return "Tuesday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String palmSunday() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.palmSunday(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.palmSunday(n);
    }

    public String palmSunday(int n) {
        this.easterSunday(n);
        int n2 = this.easterMonth;
        int n3 = this.easterDay - 7;
        if (n3 < 1) {
            int n4 = this.monthDays[n2 - 2];
            if (this.leapYear(n) && n2 == 3) {
                ++n4;
            }
            n3 = n4 + n3;
            --n2;
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        return "Sunday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String adventSunday() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.adventSunday(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.adventSunday(n);
    }

    public String adventSunday(int n) {
        this.saintAndrewsDay(n);
        int n2 = this.monthHold;
        int n3 = this.dayHold;
        String string = this.dayNameHold;
        int n4 = this.getDayOfTheWeekAsInteger(string);
        if (n4 < 4) {
            if ((n3 -= n4) < 1) {
                int n5 = this.monthDays[n2 - 2];
                if (this.leapYear(n) && n2 == 3) {
                    ++n5;
                }
                n3 = n5 + n3;
                --n2;
            }
        } else {
            n3 += 7 - n4;
            int n6 = this.monthDays[n2 - 1];
            if (this.leapYear(n) && n2 == 2) {
                ++n6;
            }
            if (n3 > n6) {
                n3 -= n6;
                ++n2;
            }
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        return "Sunday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String trinitySunday() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.trinitySunday(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.trinitySunday(n);
    }

    public String trinitySunday(int n) {
        this.whitSunday(n);
        int n2 = this.monthHold;
        int n3 = this.dayHold + 7;
        int n4 = this.monthDays[n2 - 1];
        if (this.leapYear(n) && n2 == 2) {
            ++n4;
        }
        if (n3 > n4) {
            n3 -= n4;
            ++n2;
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        return "Sunday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String corpusChristi() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.corpusChristi(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.corpusChristi(n);
    }

    public String corpusChristi(int n) {
        this.trinitySunday(n);
        int n2 = this.monthHold;
        int n3 = this.dayHold + 4;
        int n4 = this.monthDays[n2 - 1];
        if (this.leapYear(n) && n2 == 2) {
            ++n4;
        }
        if (n3 > n4) {
            n3 -= n4;
            ++n2;
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Thursday";
        return "Thursday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String sundayAfterCorpusChristi() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.sundayAfterCorpusChristi(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.sundayAfterCorpusChristi(n);
    }

    public String sundayAfterCorpusChristi(int n) {
        this.corpusChristi(n);
        int n2 = this.monthHold;
        int n3 = this.dayHold + 3;
        int n4 = this.monthDays[n2 - 1];
        if (this.leapYear(n) && n2 == 2) {
            ++n4;
        }
        if (n3 > n4) {
            n3 -= n4;
            ++n2;
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        return "Sunday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String ascensionThursday() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.ascensionThursday(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.ascensionThursday(n);
    }

    public String ascensionThursday(int n) {
        this.easterSunday(n);
        int n2 = this.easterMonth;
        int n3 = this.easterDay + 39;
        int n4 = this.monthDays[n2 - 1];
        if (this.leapYear(n) && n2 == 2) {
            ++n4;
        }
        int n5 = this.monthDays[n2];
        if (this.leapYear(n) && n2 == 1) {
            ++n5;
        }
        if (n3 > n4 + n5) {
            n3 -= n4 + n5;
            n2 += 2;
        } else if (n3 > n4) {
            n3 -= n4;
            ++n2;
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Thursday";
        return "Thursday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String sundayAfterAscension() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.sundayAfterAscension(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.sundayAfterAscension(n);
    }

    public String sundayAfterAscension(int n) {
        this.ascensionThursday(n);
        int n2 = this.monthHold;
        int n3 = this.dayHold + 3;
        int n4 = this.monthDays[n2 - 1];
        if (this.leapYear(n) && n2 == 2) {
            ++n4;
        }
        if (n3 > n4) {
            n3 -= n4;
            ++n2;
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        return "Sunday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String whitSunday() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.whitSunday(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.whitSunday(n);
    }

    public String whitSunday(int n) {
        this.easterSunday(n);
        int n2 = this.easterDay + 49;
        int n3 = this.easterMonth;
        int n4 = this.monthDays[n3 - 1];
        if (this.leapYear(n) && n3 == 2) {
            ++n4;
        }
        int n5 = this.monthDays[n3];
        if (this.leapYear(n) && n3 == 1) {
            ++n5;
        }
        if (n2 > n4 + n5) {
            n2 -= n4 + n5;
            n3 += 2;
        } else if (n2 > n4) {
            n2 -= n4;
            ++n3;
        }
        this.dayHold = n2;
        this.monthHold = n3;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        return "Sunday, " + n2 + " " + this.months[this.monthHold - 1] + " " + n;
    }

    public String mothersDayUK() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.mothersDayUK(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.mothersDayUK(n);
    }

    public String mothersDayUK(int n) {
        this.ashWednesday(n);
        int n2 = this.dayHold + 25;
        int n3 = this.monthHold;
        int n4 = this.monthDays[n3 - 1];
        if (this.leapYear(n) && n3 == 2) {
            ++n4;
        }
        if (n2 > n4) {
            n2 -= n4;
            ++n3;
        }
        this.dayHold = n2;
        this.monthHold = n3;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        return "Sunday, " + n2 + " " + this.months[this.monthHold - 1] + " " + n;
    }

    public String mothersDayUS() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.mothersDayUS(n);
        boolean bl = this.direction(n3, n2, n, this.dayHold, this.monthHold, n);
        if (!bl) {
            ++n;
        }
        return this.mothersDayUS(n);
    }

    public String mothersDayUS(int n) {
        String string = this.getDayOfDate(1, "May", n);
        int n2 = 5;
        int n3 = this.getDayOfTheWeekAsInteger(string) + 1;
        int n4 = 0;
        n4 = n3 == 1 ? n3 + 7 : 16 - n3;
        this.dayHold = n4;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        return "Sunday, " + n4 + " May " + n;
    }

    public String fathersDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.fathersDay(n);
        boolean bl = this.direction(n3, n2, n, this.dayHold, this.monthHold, n);
        if (!bl) {
            ++n;
        }
        return this.fathersDay(n);
    }

    public String fathersDay(int n) {
        String string = this.getDayOfDate(1, "June", n);
        int n2 = 6;
        int n3 = this.getDayOfTheWeekAsInteger(string) + 1;
        int n4 = 0;
        n4 = n3 == 1 ? n3 + 14 : 23 - n3;
        this.dayHold = n4;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        return "Sunday, " + n4 + " June " + n;
    }

    public String christmasDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 25, 12, n);
        if (!bl) {
            ++n;
        }
        return this.christmasDay(n);
    }

    public String christmasDay(int n) {
        String string = this.getDayOfDate(25, 12, n);
        this.dayHold = 25;
        this.monthHold = 12;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 25 December " + n;
    }

    public String newYearsDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 1, 1, n);
        if (!bl) {
            ++n;
        }
        return this.newYearsDay(n);
    }

    public String newYearsDay(int n) {
        String string = this.getDayOfDate(1, 1, n);
        this.dayHold = 1;
        this.monthHold = 1;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 1 January " + n;
    }

    public String epiphany() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 6, 1, n);
        if (!bl) {
            ++n;
        }
        return this.epiphany(n);
    }

    public String epiphany(int n) {
        String string = this.getDayOfDate(6, 1, n);
        this.dayHold = 6;
        this.monthHold = 1;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 6 January " + n;
    }

    public String sundayAfterEpiphany() {
        boolean bl;
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        String string = this.getDayOfDate(6, 1, n);
        int n4 = this.getDayOfTheWeekAsInteger(string);
        int n5 = 6;
        if (n4 > 0) {
            n5 += 7 - n4;
        }
        if (!(bl = this.direction(n3, n2, n, n5, 1, n))) {
            ++n;
        }
        return this.sundayAfterEpiphany(n);
    }

    public String sundayAfterEpiphany(int n) {
        String string = this.getDayOfDate(6, 1, n);
        int n2 = this.getDayOfTheWeekAsInteger(string);
        int n3 = 6;
        if (n2 > 0) {
            n3 += 7 - n2;
        }
        this.dayHold = n3;
        this.monthHold = 1;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        return "Sunday, " + n3 + " January " + n;
    }

    public String annunciation() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 25, 3, n);
        if (!bl) {
            ++n;
        }
        return this.annunciation(n);
    }

    public String annunciation(int n) {
        String string = this.getDayOfDate(25, 3, n);
        this.dayHold = 25;
        this.monthHold = 3;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 25 March " + n;
    }

    public String assumption() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 15, 8, n);
        if (!bl) {
            ++n;
        }
        return this.assumption(n);
    }

    public String assumption(int n) {
        String string = this.getDayOfDate(15, 8, n);
        this.dayHold = 15;
        this.monthHold = 8;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 15 August " + n;
    }

    public String nativityBlessedVirgin() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 8, 9, n);
        if (!bl) {
            ++n;
        }
        return this.nativityBlessedVirgin(n);
    }

    public String nativityBlessedVirgin(int n) {
        String string = this.getDayOfDate(8, 9, n);
        this.dayHold = 8;
        this.monthHold = 9;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 8 September " + n;
    }

    public String immaculateConception() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 8, 12, n);
        if (!bl) {
            ++n;
        }
        return this.immaculateConception(n);
    }

    public String immaculateConception(int n) {
        String string = this.getDayOfDate(8, 12, n);
        this.dayHold = 8;
        this.monthHold = 12;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 8 December " + n;
    }

    public String purification() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 2, 2, n);
        if (!bl) {
            ++n;
        }
        return this.purification(n);
    }

    public String presentation() {
        return this.purification();
    }

    public String candlemas() {
        return this.purification();
    }

    public String purification(int n) {
        String string = this.getDayOfDate(2, 2, n);
        this.dayHold = 2;
        this.monthHold = 2;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 2 February " + n;
    }

    public String presentation(int n) {
        return this.purification(n);
    }

    public String candlemas(int n) {
        return this.purification(n);
    }

    public String transfiguration() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 6, 8, n);
        if (!bl) {
            ++n;
        }
        return this.transfiguration(n);
    }

    public String transfiguration(int n) {
        String string = this.getDayOfDate(6, 8, n);
        this.dayHold = 6;
        this.monthHold = 8;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 6 August " + n;
    }

    public String remembranceSunday() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        this.remembranceSunday(n);
        int n4 = this.monthHold;
        int n5 = this.dayHold;
        boolean bl = this.direction(n3, n2, n, n5, n4, n);
        if (!bl) {
            ++n;
        }
        return this.remembranceSunday(n);
    }

    public String remembranceSunday(int n) {
        int n2 = 11;
        int n3 = 11;
        String string = this.getDayOfDate(11, 11, n);
        int n4 = this.getDayOfTheWeekAsInteger(string);
        if (n4 < 4) {
            if ((n3 -= n4) < 1) {
                int n5 = this.monthDays[n2 - 2];
                if (this.leapYear(n) && n2 == 3) {
                    ++n5;
                }
                n3 = n5 + n3;
                --n2;
            }
        } else {
            n3 += 7 - n4;
            int n6 = this.monthDays[n2 - 1];
            if (this.leapYear(n) && n2 == 2) {
                ++n6;
            }
            if (n3 > n6) {
                n3 -= n6;
                ++n2;
            }
        }
        this.dayHold = n3;
        this.monthHold = n2;
        this.yearHold = n;
        this.dayNameHold = "Sunday";
        return "Sunday, " + n3 + " " + this.months[n2 - 1] + " " + n;
    }

    public String holocaustMemorialDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 27, 1, n);
        if (!bl) {
            ++n;
        }
        return this.holocaustMemorialDay(n);
    }

    public String holocaustMemorialDay(int n) {
        String string = this.getDayOfDate(27, 1, n);
        this.dayHold = 25;
        this.monthHold = 12;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 27 January " + n;
    }

    public String saintPatricksDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 17, 3, n);
        if (!bl) {
            ++n;
        }
        return this.saintPatricksDay(n);
    }

    public String saintPatricksDay(int n) {
        String string = this.getDayOfDate(17, 3, n);
        this.dayHold = 17;
        this.monthHold = 3;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 17 March " + n;
    }

    public String saintBrigidsDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 1, 2, n);
        if (!bl) {
            ++n;
        }
        return this.saintBrigidsDay(n);
    }

    public String saintBrigidsDay(int n) {
        String string = this.getDayOfDate(1, 2, n);
        this.dayHold = 1;
        this.monthHold = 2;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 1 February " + n;
    }

    public String saintColmCillesDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 9, 6, n);
        if (!bl) {
            ++n;
        }
        return this.saintColmCillesDay(n);
    }

    public String saintColumbasDay() {
        return this.saintColmCillesDay();
    }

    public String saintColmcillesDay() {
        return this.saintColmCillesDay();
    }

    public String saintColmCillesDay(int n) {
        String string = this.getDayOfDate(9, 6, n);
        this.dayHold = 9;
        this.monthHold = 6;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 9 June " + n;
    }

    public String saintColumbasDay(int n) {
        return this.saintColmCillesDay(n);
    }

    public String saintColmcillesDay(int n) {
        return this.saintColmCillesDay(n);
    }

    public String saintGeorgesDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 23, 4, n);
        if (!bl) {
            ++n;
        }
        return this.saintGeorgesDay(n);
    }

    public String saintGeorgesDay(int n) {
        String string = this.getDayOfDate(23, 4, n);
        this.dayHold = 23;
        this.monthHold = 4;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 23 April " + n;
    }

    public String saintAndrewsDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 30, 11, n);
        if (!bl) {
            ++n;
        }
        return this.saintAndrewsDay(n);
    }

    public String saintAndrewsDay(int n) {
        String string = this.getDayOfDate(30, 11, n);
        this.dayHold = 30;
        this.monthHold = 11;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 30 November " + n;
    }

    public String saintDavidsDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 1, 3, n);
        if (!bl) {
            ++n;
        }
        return this.saintDavidsDay(n);
    }

    public String saintDavidsDay(int n) {
        String string = this.getDayOfDate(1, 3, n);
        this.dayHold = 1;
        this.monthHold = 3;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 1 March " + n;
    }

    public String saintStephensDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 26, 12, n);
        if (!bl) {
            ++n;
        }
        return this.saintStephensDay(n);
    }

    public String saintStephensDay(int n) {
        String string = this.getDayOfDate(26, 12, n);
        this.dayHold = 26;
        this.monthHold = 12;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 26 December " + n;
    }

    public String saintValentinesDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 14, 2, n);
        if (!bl) {
            ++n;
        }
        return this.saintValentinesDay(n);
    }

    public String saintValentinesDay(int n) {
        String string = this.getDayOfDate(14, 2, n);
        this.dayHold = 14;
        this.monthHold = 2;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 14 February " + n;
    }

    public String burnsNight() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 25, 1, n);
        if (!bl) {
            ++n;
        }
        return this.burnsNight(n);
    }

    public String burnsNight(int n) {
        String string = this.getDayOfDate(25, 1, n);
        this.dayHold = 25;
        this.monthHold = 1;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 25 January " + n;
    }

    public String twelfthJuly() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 12, 7, n);
        if (!bl) {
            ++n;
        }
        return this.twelfthJuly(n);
    }

    public String twelfthJuly(int n) {
        String string = this.getDayOfDate(12, 7, n);
        this.dayHold = 12;
        this.monthHold = 7;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 12 July " + n;
    }

    public String fourthJuly() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 12, 7, n);
        if (!bl) {
            ++n;
        }
        return this.fourthJuly(n);
    }

    public String fourthJuly(int n) {
        String string = this.getDayOfDate(4, 7, n);
        this.dayHold = 4;
        this.monthHold = 7;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 4 July " + n;
    }

    public String thanksgivingDay() {
        boolean bl;
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        String string = this.getDayOfDate(1, "November", n);
        int n4 = this.getDayOfTheWeekAsInteger(string) + 1;
        int n5 = 6 - n4;
        if (n5 <= 0) {
            n5 += 7;
        }
        if (bl = this.direction(n3, n2, n, n5 += 14, 11, n)) {
            return "Thursday, " + n5 + " November " + n;
        }
        return this.thanksgivingDay(++n);
    }

    public String thanksgivingDay(int n) {
        String string = this.getDayOfDate(1, "November", n);
        int n2 = this.getDayOfTheWeekAsInteger(string) + 1;
        int n3 = 6 - n2;
        if (n3 <= 0) {
            n3 += 7;
        }
        this.dayHold = n3 += 14;
        this.monthHold = 11;
        this.yearHold = n;
        this.dayNameHold = "Thursday";
        return "Thursday, " + n3 + " November " + n;
    }

    public String commonwealthDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        String string = this.getDayOfDate(1, "March", n);
        int n4 = this.getDayOfTheWeekAsInteger(string);
        int n5 = 0;
        n5 = n4 > 1 ? 15 - n4 : (n4 == 0 ? 8 : 9);
        boolean bl = this.direction(n3, n2, n, n5, 3, n);
        if (bl) {
            this.dayHold = n5;
            this.monthHold = 3;
            this.yearHold = n;
            this.dayNameHold = "Monday";
            return "Monday, " + n5 + " November " + n;
        }
        return this.commonwealthDay(++n);
    }

    public String commonwealthDay(int n) {
        String string = this.getDayOfDate(1, "March", n);
        int n2 = this.getDayOfTheWeekAsInteger(string);
        int n3 = 0;
        n3 = n2 > 1 ? 16 - n2 : (n2 == 0 ? 9 : 8);
        this.dayHold = n3;
        this.monthHold = 3;
        this.yearHold = n;
        this.dayNameHold = "Monday";
        return "Monday, " + n3 + " March " + n;
    }

    public String armedForcesDay() {
        int n = this.getYear();
        int n2 = this.getMonthAsInteger();
        int n3 = this.getDayOfTheMonth();
        boolean bl = this.direction(n3, n2, n, 27, 6, n);
        if (!bl) {
            ++n;
        }
        return this.armedForcesDay(n);
    }

    public String veteransDayUK() {
        return this.armedForcesDay();
    }

    public String armedForcesDay(int n) {
        String string = this.getDayOfDate(27, 6, n);
        this.dayHold = 27;
        this.monthHold = 6;
        this.yearHold = n;
        this.dayNameHold = string;
        return string + ", 27 June " + n;
    }

    public String veteransDayUK(int n) {
        return this.armedForcesDay(n);
    }

    public boolean leapYear(int n) {
        boolean bl = false;
        bl = n % 4 != 0 ? false : (n % 400 == 0 ? true : n % 100 != 0);
        return bl;
    }

    public int monthAsNumber(String string) {
        boolean bl = true;
        int n = 0;
        while (bl) {
            if (string.equalsIgnoreCase(this.months[n])) {
                bl = false;
                continue;
            }
            if (++n < 12) continue;
            throw new IllegalArgumentException("Entered month, " + string + ", not recognised");
        }
        return n + 1;
    }

    public String monthAsName(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("The month number, " + n + ", must be > 0 and < 13");
        }
        return this.months[n - 1];
    }

    public int getDaysInMonth(String string, int n) {
        int n2 = this.getDaysInNonLeapMonth(string);
        if (string.equalsIgnoreCase("February") && this.leapYear(n)) {
            ++n2;
        }
        return n2;
    }

    public int getDaysInMonth(int n, int n2) {
        String string = this.months[n - 1];
        int n3 = this.getDaysInNonLeapMonth(string);
        if (string.equalsIgnoreCase("February") && this.leapYear(n2)) {
            ++n3;
        }
        return n3;
    }

    public int getDaysInMonth(String string) {
        int n;
        int n2 = this.getDaysInNonLeapMonth(string);
        if (string.equalsIgnoreCase("February") && this.leapYear(n = Db.readInt("Enter the year"))) {
            ++n2;
        }
        return n2;
    }

    public int getDaysInMonth(int n) {
        String string = this.months[n - 1];
        return this.getDaysInMonth(string);
    }

    private int getDaysInNonLeapMonth(String string) {
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (string.equalsIgnoreCase(this.months[n2])) {
                n = this.monthDays[n2];
                bl = false;
                continue;
            }
            if (++n2 < 12) continue;
            throw new IllegalArgumentException("Entered month, " + string + ", not recognised");
        }
        return n;
    }

    public boolean isLessThan(int[] nArray, int[] nArray2) {
        boolean bl = false;
        return this.isLessThan(nArray[0], nArray[1], nArray[2], nArray2[0], nArray2[1], nArray2[2]);
    }

    public boolean isLessThan(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = false;
        bl = n3 == n6 ? (n2 == n5 ? n < n4 : n2 < n5) : n3 < n6;
        return bl;
    }
}

