/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.math.ArrayMaths;
import flanagan.math.VectorMaths;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Point {
    private double[] point = null;
    private int nDimensions = 0;

    public Point() {
        this.point = new double[3];
        this.point[0] = 0.0;
        this.point[1] = 0.0;
        this.point[2] = 0.0;
        this.nDimensions = 3;
    }

    public Point(double[] dArray) {
        this.setPoint(dArray);
    }

    public Point(float[] fArray) {
        this.setPoint(fArray);
    }

    public Point(long[] lArray) {
        this.setPoint(lArray);
    }

    public Point(int[] nArray) {
        this.setPoint(nArray);
    }

    public Point(short[] sArray) {
        this.setPoint(sArray);
    }

    public Point(BigDecimal[] bigDecimalArray) {
        this.setPoint(bigDecimalArray);
    }

    public Point(BigInteger[] bigIntegerArray) {
        this.setPoint(bigIntegerArray);
    }

    public Point(double d) {
        this.point = new double[1];
        this.point[0] = d;
        this.nDimensions = 1;
    }

    public Point(double d, double d2) {
        this.point = new double[2];
        this.point[0] = d;
        this.point[1] = d2;
        this.nDimensions = 2;
    }

    public Point(double d, double d2, double d3) {
        this.point = new double[3];
        this.point[0] = d;
        this.point[1] = d2;
        this.point[2] = d3;
        this.nDimensions = 3;
    }

    public final void setPoint(double[] dArray) {
        this.point = (double[])dArray.clone();
        this.nDimensions = this.point.length;
    }

    public final void setPoint(float[] fArray) {
        this.nDimensions = fArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(fArray);
        this.point = arrayMaths.array_as_double();
    }

    public final void setPoint(long[] lArray) {
        this.nDimensions = lArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(lArray);
        this.point = arrayMaths.array_as_double();
    }

    public final void setPoint(int[] nArray) {
        this.nDimensions = nArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(nArray);
        this.point = arrayMaths.array_as_double();
    }

    public final void setPoint(short[] sArray) {
        this.nDimensions = sArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(sArray);
        this.point = arrayMaths.array_as_double();
    }

    public final void setPoint(BigDecimal[] bigDecimalArray) {
        this.nDimensions = bigDecimalArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        this.point = arrayMaths.array_as_double();
    }

    public final void setPoint(BigInteger[] bigIntegerArray) {
        this.nDimensions = bigIntegerArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        this.point = arrayMaths.array_as_double();
    }

    public void setPoint(double d) {
        this.point = new double[1];
        this.point[0] = d;
        this.nDimensions = 1;
    }

    public void setPoint(double d, double d2) {
        this.point = new double[2];
        this.point[0] = d;
        this.point[1] = d2;
        this.nDimensions = 2;
    }

    public void setPoint(double d, double d2, double d3) {
        this.point = new double[3];
        this.point[0] = d;
        this.point[1] = d2;
        this.point[2] = d3;
        this.nDimensions = 3;
    }

    public static Point[] oneDarray(int n) {
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(0.0, 0.0, 0.0);
        }
        return pointArray;
    }

    public static Point[] oneDarray(double[] dArray) {
        int n = dArray.length;
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(dArray[i]);
        }
        return pointArray;
    }

    public static Point[] oneDarray(double[] dArray, double[] dArray2) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("the length of the xx array, " + n2 + ", and the lengh of the yy array, " + n + ", must be equal");
        }
        Point[] pointArray = new Point[n2];
        for (int i = 0; i < n2; ++i) {
            pointArray[i] = new Point(dArray[i], dArray2[i]);
        }
        return pointArray;
    }

    public static Point[] oneDarray(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = dArray3.length;
        if (n2 != n) {
            throw new IllegalArgumentException("the length of the xx array, " + n + ", and the lengh of the yy array, " + n2 + ", must be equal");
        }
        if (n != n3) {
            throw new IllegalArgumentException("the length of the xx array, " + n + ", and the lengh of the zz array, " + n3 + ", must be equal");
        }
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(dArray[i], dArray2[i], dArray3[i]);
        }
        return pointArray;
    }

    public static Point[] oneDarray(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 1; i < n; ++i) {
            if (n2 == dArray[i].length) continue;
            throw new IllegalArgumentException("the dimesions of all the points must be identical");
        }
        Point[] pointArray = new Point[n];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[j] = dArray[i][j];
            }
            pointArray[i] = new Point(dArray2);
        }
        return pointArray;
    }

    public static Point[] oneDarray(float[][] fArray) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        double[][] dArray = new double[n][n2];
        ArrayMaths arrayMaths = null;
        for (int i = 0; i < n; ++i) {
            arrayMaths = new ArrayMaths(fArray[i]);
            dArray[i] = arrayMaths.array_as_double();
        }
        return Point.oneDarray(dArray);
    }

    public static Point[] oneDarray(long[][] lArray) {
        int n = lArray.length;
        int n2 = lArray[0].length;
        double[][] dArray = new double[n][n2];
        ArrayMaths arrayMaths = null;
        for (int i = 0; i < n; ++i) {
            arrayMaths = new ArrayMaths(lArray[i]);
            dArray[i] = arrayMaths.array_as_double();
        }
        return Point.oneDarray(dArray);
    }

    public static Point[] oneDarray(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        double[][] dArray = new double[n][n2];
        ArrayMaths arrayMaths = null;
        for (int i = 0; i < n; ++i) {
            arrayMaths = new ArrayMaths(nArray[i]);
            dArray[i] = arrayMaths.array_as_double();
        }
        return Point.oneDarray(dArray);
    }

    public static Point[] oneDarray(short[][] sArray) {
        int n = sArray.length;
        int n2 = sArray[0].length;
        double[][] dArray = new double[n][n2];
        ArrayMaths arrayMaths = null;
        for (int i = 0; i < n; ++i) {
            arrayMaths = new ArrayMaths(sArray[i]);
            dArray[i] = arrayMaths.array_as_double();
        }
        return Point.oneDarray(dArray);
    }

    public static Point[] oneDarray(BigDecimal[][] bigDecimalArray) {
        int n = bigDecimalArray.length;
        int n2 = bigDecimalArray[0].length;
        double[][] dArray = new double[n][n2];
        ArrayMaths arrayMaths = null;
        for (int i = 0; i < n; ++i) {
            arrayMaths = new ArrayMaths(bigDecimalArray[i]);
            dArray[i] = arrayMaths.array_as_double();
        }
        return Point.oneDarray(dArray);
    }

    public static Point[] oneDarray(BigInteger[][] bigIntegerArray) {
        int n = bigIntegerArray.length;
        int n2 = bigIntegerArray[0].length;
        double[][] dArray = new double[n][n2];
        ArrayMaths arrayMaths = null;
        for (int i = 0; i < n; ++i) {
            arrayMaths = new ArrayMaths(bigIntegerArray[i]);
            dArray[i] = arrayMaths.array_as_double();
        }
        return Point.oneDarray(dArray);
    }

    public double[] getPointCoordinates() {
        return (double[])this.point.clone();
    }

    public static double[][] getArrayCoordinates(Point[] pointArray) {
        int n = pointArray.length;
        int n2 = pointArray[0].getPointDimensions();
        double[][] dArray = new double[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[j][i] = pointArray[i].getPointCoordinates()[j];
            }
        }
        return dArray;
    }

    public int getPointDimensions() {
        return this.nDimensions;
    }

    public static int[] getArrayDimensions(Point[] pointArray) {
        int[] nArray = new int[]{pointArray.length, pointArray[0].getPointDimensions()};
        return nArray;
    }

    public double distanceSquared(Point point) {
        int n = point.nDimensions;
        if (n != this.nDimensions) {
            throw new IllegalArgumentException("The dimensions of the two points, " + this.nDimensions + " and " + n + ", should be equal");
        }
        if (n > 3) {
            System.out.println("Methods distance and distanceSquared are only meaningful for dimensions of 3 or less");
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d = this.point[i] - point.point[i];
            d2 += d * d;
        }
        return d2;
    }

    public static double distanceSquared(Point point, Point point2) {
        int n = point2.nDimensions;
        int n2 = point.nDimensions;
        if (n != n2) {
            throw new IllegalArgumentException("The dimensions of the two points, " + n2 + " and " + n + ", should be equal");
        }
        if (n > 3) {
            System.out.println("Methods distance and distanceSquared are only meaningful for dimensions of 3 or less");
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d = point.point[i] - point2.point[i];
            d2 += d * d;
        }
        return d2;
    }

    public double distance(Point point) {
        double d = this.distanceSquared(point);
        return Math.sqrt(d);
    }

    public static double distance(Point point, Point point2) {
        double d = Point.distanceSquared(point, point2);
        return Math.sqrt(d);
    }

    public static Point centre(Point[] pointArray) {
        int n;
        int n2 = pointArray.length;
        int n3 = pointArray[0].nDimensions;
        int n4 = 0;
        for (int i = 1; i < n2; ++i) {
            n4 = pointArray[i].nDimensions;
            if (n4 == n3) continue;
            throw new IllegalArgumentException("All points must have the same number of dimensions");
        }
        double[] dArray = new double[n3];
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                int n5 = i;
                dArray[n5] = dArray[n5] + pointArray[n].point[i];
            }
        }
        n = 0;
        while (n < n3) {
            int n6 = n++;
            dArray[n6] = dArray[n6] / (double)n2;
        }
        return new Point(dArray);
    }

    public Point shift(double d) {
        Point point = new Point();
        for (int i = 0; i < this.nDimensions; ++i) {
            point.setPoint(this.point[i] + d);
        }
        return null;
    }

    public boolean isEqual(Point point) {
        boolean bl = true;
        int n = point.getPointDimensions();
        if (n != this.nDimensions) {
            bl = false;
        } else {
            double[] dArray = this.getPointCoordinates();
            double[] dArray2 = point.getPointCoordinates();
            for (int i = 0; i < this.nDimensions; ++i) {
                if (dArray[i] == dArray2[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean isEqual(Point point, Point point2) {
        int n;
        boolean bl = true;
        int n2 = point.getPointDimensions();
        if (n2 != (n = point2.getPointDimensions())) {
            bl = false;
        } else {
            double[] dArray = point.getPointCoordinates();
            double[] dArray2 = point2.getPointCoordinates();
            for (int i = 0; i < n2; ++i) {
                if (dArray[i] == dArray2[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public Point copy() {
        double[] dArray = new double[this.nDimensions];
        for (int i = 0; i < this.nDimensions; ++i) {
            dArray[i] = this.point[i];
        }
        Point point = new Point(dArray);
        return point;
    }

    public static Point copy(Point point) {
        int n = point.getPointDimensions();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point.point[i];
        }
        Point point2 = new Point(dArray);
        return point2;
    }

    public static Point[] copy(Point[] pointArray) {
        int n = pointArray.length;
        Point[] pointArray2 = Point.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            pointArray2[i] = pointArray[i].copy();
        }
        return pointArray2;
    }

    public void toThreeD() {
        double[] dArray = (double[])this.point.clone();
        double[] dArray2 = new double[3];
        if (this.nDimensions > 3) {
            System.out.println("Method toThreeD:  Dimensions are greater than three so instance cannot be convertd to a three D Point");
        } else if (this.nDimensions < 3) {
            int n;
            for (n = 0; n < this.nDimensions; ++n) {
                dArray2[n] = dArray[n];
            }
            for (n = this.nDimensions; n < 3; ++n) {
                dArray2[n] = 0.0;
            }
            this.point = dArray2;
            this.nDimensions = 3;
        }
    }

    public void toTwoD() {
        int n;
        double[] dArray = (double[])this.point.clone();
        double[] dArray2 = new double[2];
        boolean bl = true;
        for (n = 2; n < this.nDimensions; ++n) {
            if (dArray[n] == 0.0) continue;
            bl = false;
        }
        if (bl) {
            for (n = 0; n < 2; ++n) {
                dArray2[n] = dArray[n];
            }
        } else {
            throw new IllegalArgumentException("There are non-zero values in the coordinate positions greater than 2D");
        }
        this.point = dArray2;
        this.nDimensions = 2;
    }

    public VectorMaths toVectorMaths() {
        if (this.nDimensions > 3) {
            throw new IllegalArgumentException("VectorMaths is restricted to 2 or 3-dimensional space");
        }
        VectorMaths vectorMaths = new VectorMaths(this.point);
        return vectorMaths;
    }
}

