/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Fmath;
import flanagan.math.MaximisationFunction;
import flanagan.math.MaximizationFunction;
import java.util.ArrayList;

public class Maximisation {
    protected boolean iseOption = true;
    protected int nParam = 0;
    protected double[] paramValue = null;
    protected String[] paraName = null;
    protected double functValue = 0.0;
    protected double lastFunctValNoCnstrnt = 0.0;
    protected double maximum = 0.0;
    protected int prec = 4;
    protected int field = 13;
    protected boolean convStatus = false;
    protected boolean suppressNoConvergenceMessage = false;
    protected int scaleOpt = 0;
    protected double[] scale = null;
    protected boolean penalty = false;
    protected boolean sumPenalty = false;
    protected int nConstraints = 0;
    protected int nSumConstraints = 0;
    protected int maxConstraintIndex = -1;
    protected ArrayList<Object> penalties = new ArrayList();
    protected ArrayList<Object> sumPenalties = new ArrayList();
    protected int[] penaltyCheck = null;
    protected int[] sumPenaltyCheck = null;
    protected double penaltyWeight = 1.0E30;
    protected int[] penaltyParam = null;
    protected int[][] sumPenaltyParam = null;
    protected double[][] sumPlusOrMinus = null;
    protected int[] sumPenaltyNumber = null;
    protected double constraintTolerance = 1.0E-4;
    protected double[] constraints = null;
    protected double[] sumConstraints = null;
    protected int constraintMethod = 0;
    protected int nMax = 3000;
    protected int nIter = 0;
    protected int konvge = 3;
    protected int kRestart = 0;
    protected double fTol = 1.0E-13;
    protected double rCoeff = 1.0;
    protected double eCoeff = 2.0;
    protected double cCoeff = 0.5;
    protected double[] startH = null;
    protected double[] step = null;
    protected double dStep = 0.5;
    protected int maxTest = 0;
    protected double simplexSd = 0.0;

    public void suppressNoConvergenceMessage() {
        this.suppressNoConvergenceMessage = true;
    }

    public void nelderMead(MaximizationFunction maximizationFunction, double[] dArray, double[] dArray2, double d, int n) {
        this.nelderMead((Object)maximizationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(MaximisationFunction maximisationFunction, double[] dArray, double[] dArray2, double d, int n) {
        this.nelderMead((Object)maximisationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(Object object, double[] dArray, double[] dArray2, double d, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object2;
        Integer n7;
        boolean bl = false;
        int n8 = dArray.length;
        if (this.maxConstraintIndex >= n8) {
            throw new IllegalArgumentException("You have entered more constrained parameters (" + this.maxConstraintIndex + ") than minimisation parameters (" + n8 + ")");
        }
        this.nParam = n8;
        this.convStatus = true;
        int n9 = n8 + 1;
        this.lastFunctValNoCnstrnt = 0.0;
        if (this.scaleOpt < 2) {
            this.scale = new double[n8];
        }
        if (this.scaleOpt == 2 && this.scale.length != dArray.length) {
            throw new IllegalArgumentException("scale array and initial estimate array are of different lengths");
        }
        if (dArray2.length != dArray.length) {
            throw new IllegalArgumentException("step array length " + dArray2.length + " and initial estimate array length " + dArray.length + " are of different");
        }
        for (int i = 0; i < n8; ++i) {
            if (dArray2[i] != 0.0) continue;
            if (dArray[i] != 0.0) {
                dArray2[i] = dArray[i] * 0.1;
                continue;
            }
            dArray2[i] = 1.0;
            System.out.println("As no step size has been entered for an itial estimate of zero an initial step size of unity has been used");
            System.out.println("You are advised to repeat the maximization using one of the methods allowing the setting of an appropriate non-zero initial step size");
        }
        this.paramValue = new double[n8];
        this.startH = new double[n8];
        this.step = new double[n8];
        double[] dArray3 = new double[n8];
        double[][] dArray4 = new double[n9][n9];
        double[] dArray5 = new double[n9];
        double[] dArray6 = new double[n9];
        double[] dArray7 = new double[n9];
        double[] dArray8 = new double[n9];
        if (this.penalty) {
            n7 = (Integer)this.penalties.get(1);
            this.nConstraints = n7;
            this.penaltyParam = new int[this.nConstraints];
            this.penaltyCheck = new int[this.nConstraints];
            this.constraints = new double[this.nConstraints];
            object2 = null;
            n6 = 2;
            for (n5 = 0; n5 < this.nConstraints; ++n5) {
                n7 = (Integer)this.penalties.get(n6);
                this.penaltyParam[n5] = n7;
                n7 = (Integer)this.penalties.get(++n6);
                this.penaltyCheck[n5] = n7;
                object2 = (Double)this.penalties.get(++n6);
                this.constraints[n5] = (Double)object2;
                ++n6;
            }
        }
        if (this.sumPenalty) {
            n7 = (Integer)this.sumPenalties.get(1);
            this.nSumConstraints = n7;
            this.sumPenaltyParam = new int[this.nSumConstraints][];
            this.sumPlusOrMinus = new double[this.nSumConstraints][];
            this.sumPenaltyCheck = new int[this.nSumConstraints];
            this.sumPenaltyNumber = new int[this.nSumConstraints];
            this.sumConstraints = new double[this.nSumConstraints];
            object2 = null;
            double[] dArray9 = null;
            Double d2 = null;
            n4 = 2;
            for (int i = 0; i < this.nSumConstraints; ++i) {
                n7 = (Integer)this.sumPenalties.get(n4);
                this.sumPenaltyNumber[i] = n7;
                object2 = (int[])this.sumPenalties.get(++n4);
                this.sumPenaltyParam[i] = (int[])object2;
                dArray9 = (double[])this.sumPenalties.get(++n4);
                this.sumPlusOrMinus[i] = dArray9;
                n7 = (Integer)this.sumPenalties.get(++n4);
                this.sumPenaltyCheck[i] = n7;
                d2 = (Double)this.sumPenalties.get(++n4);
                this.sumConstraints[i] = d2;
                ++n4;
            }
        }
        for (n3 = 0; n3 < n8; ++n3) {
            this.startH[n3] = dArray[n3];
        }
        if (this.scaleOpt > 0) {
            n3 = 0;
            for (int i = 0; i < n8; ++i) {
                if (dArray[i] != 0.0) continue;
                n3 = 1;
            }
            if (n3 != 0) {
                System.out.println("Neler and Mead Simplex: a start value of zero precludes scaling");
                System.out.println("Regression performed without scaling");
                this.scaleOpt = 0;
            }
        }
        switch (this.scaleOpt) {
            case 0: {
                for (n3 = 0; n3 < n8; ++n3) {
                    this.scale[n3] = 1.0;
                }
                break;
            }
            case 1: {
                for (n3 = 0; n3 < n8; ++n3) {
                    this.scale[n3] = 1.0 / dArray[n3];
                    dArray2[n3] = dArray2[n3] / dArray[n3];
                    dArray[n3] = 1.0;
                }
                break;
            }
            case 2: {
                for (n3 = 0; n3 < n8; ++n3) {
                    int n10 = n3;
                    dArray2[n10] = dArray2[n10] * this.scale[n3];
                    int n11 = n3;
                    dArray[n11] = dArray[n11] * this.scale[n3];
                }
                break;
            }
        }
        this.fTol = d;
        this.nMax = n;
        this.nIter = 0;
        for (n3 = 0; n3 < n8; ++n3) {
            this.step[n3] = dArray2[n3];
            this.scale[n3] = this.scale[n3];
        }
        double d3 = 0.0;
        for (n6 = 0; n6 < n8; ++n6) {
            dArray7[n6] = d3 = dArray[n6];
            dArray8[n6] = d3;
            dArray3[n6] = d3;
        }
        n6 = this.konvge;
        for (n5 = 0; n5 < n8; ++n5) {
            dArray4[n5][n9 - 1] = dArray[n5];
        }
        dArray5[n9 - 1] = this.functionValue(object, dArray);
        for (n5 = 0; n5 < n8; ++n5) {
            dArray[n5] = dArray[n5] + dArray2[n5];
            for (n4 = 0; n4 < n8; ++n4) {
                dArray4[n4][n5] = dArray[n4];
            }
            dArray5[n5] = this.functionValue(object, dArray);
            dArray[n5] = dArray[n5] - dArray2[n5];
        }
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        boolean bl2 = true;
        while (bl2) {
            int n15;
            d4 = d7 = dArray5[0];
            n12 = 0;
            n13 = 0;
            for (n2 = 1; n2 < n9; ++n2) {
                if (dArray5[n2] < d7) {
                    d7 = dArray5[n2];
                    n12 = n2;
                }
                if (!(dArray5[n2] > d4)) continue;
                d4 = dArray5[n2];
                n13 = n2;
            }
            for (n2 = 0; n2 < n8; ++n2) {
                d11 = 0.0;
                for (n15 = 0; n15 < n9; ++n15) {
                    d11 += dArray4[n2][n15];
                }
                dArray6[n2] = (d11 -= dArray4[n2][n13]) / (double)n8;
            }
            for (n2 = 0; n2 < n8; ++n2) {
                dArray7[n2] = (1.0 + this.rCoeff) * dArray6[n2] - this.rCoeff * dArray4[n2][n13];
            }
            d5 = this.functionValue(object, dArray7);
            ++this.nIter;
            if (d5 < d7) {
                for (n2 = 0; n2 < n8; ++n2) {
                    dArray8[n2] = dArray7[n2] * (1.0 + this.eCoeff) - this.eCoeff * dArray6[n2];
                }
                d6 = this.functionValue(object, dArray8);
                ++this.nIter;
                if (d6 < d7) {
                    for (n2 = 0; n2 < n8; ++n2) {
                        dArray4[n2][n13] = dArray8[n2];
                    }
                    dArray5[n13] = d6;
                } else {
                    for (n2 = 0; n2 < n8; ++n2) {
                        dArray4[n2][n13] = dArray7[n2];
                    }
                    dArray5[n13] = d5;
                }
            } else {
                n14 = 0;
                for (n2 = 0; n2 < n9; ++n2) {
                    if (n2 == n13 || !(d5 > dArray5[n2])) continue;
                    ++n14;
                }
                if (n14 == n8) {
                    if (d5 <= dArray5[n13]) {
                        for (n2 = 0; n2 < n8; ++n2) {
                            dArray4[n2][n13] = dArray7[n2];
                        }
                        dArray5[n13] = d5;
                    }
                    for (n2 = 0; n2 < n8; ++n2) {
                        dArray8[n2] = this.cCoeff * dArray4[n2][n13] + (1.0 - this.cCoeff) * dArray6[n2];
                    }
                    d6 = this.functionValue(object, dArray8);
                    ++this.nIter;
                    if (d6 > dArray5[n13]) {
                        for (n2 = 0; n2 < n9; ++n2) {
                            for (n15 = 0; n15 < n8; ++n15) {
                                dArray4[n15][n2] = 0.5 * (dArray4[n15][n2] + dArray4[n15][n12]);
                                dArray3[n15] = dArray4[n15][n2];
                            }
                            dArray5[n2] = this.functionValue(object, dArray3);
                        }
                        this.nIter += n9;
                    } else {
                        for (n2 = 0; n2 < n8; ++n2) {
                            dArray4[n2][n13] = dArray8[n2];
                        }
                        dArray5[n13] = d6;
                    }
                } else {
                    for (n2 = 0; n2 < n8; ++n2) {
                        dArray4[n2][n13] = dArray7[n2];
                    }
                    dArray5[n13] = d5;
                }
            }
            d9 = 0.0;
            d4 = dArray5[0];
            n12 = 0;
            for (n2 = 0; n2 < n9; ++n2) {
                d9 += dArray5[n2];
                if (!(d4 > dArray5[n2])) continue;
                d4 = dArray5[n2];
                n12 = n2;
            }
            d9 /= (double)n9;
            d10 = 0.0;
            for (n2 = 0; n2 < n9; ++n2) {
                d11 = dArray5[n2] - d9;
                d10 += d11 * d11;
            }
            d8 = Math.sqrt(d10 / (double)n8);
            switch (this.maxTest) {
                case 0: {
                    if (!(d8 < d)) break;
                    bl2 = false;
                }
            }
            this.maximum = -d4;
            if (!bl2) {
                for (n2 = 0; n2 < n8; ++n2) {
                    dArray3[n2] = dArray4[n2][n12];
                }
                dArray5[n9 - 1] = d4;
                this.simplexSd = d8;
                if (--n6 > 0) {
                    bl2 = true;
                    for (n2 = 0; n2 < n8; ++n2) {
                        dArray3[n2] = dArray3[n2] + dArray2[n2];
                        for (n15 = 0; n15 < n8; ++n15) {
                            dArray4[n15][n2] = dArray3[n15];
                        }
                        dArray5[n2] = this.functionValue(object, dArray3);
                        dArray3[n2] = dArray3[n2] - dArray2[n2];
                    }
                }
            }
            if (!bl2 || this.nIter <= this.nMax) continue;
            if (!this.suppressNoConvergenceMessage) {
                System.out.println("Maximum iteration number reached, in Maximisation.simplex(...)");
                System.out.println("without the convergence criterion being satisfied");
                System.out.println("Current parameter estimates and function value returned");
            }
            this.convStatus = false;
            for (n2 = 0; n2 < n8; ++n2) {
                dArray3[n2] = dArray4[n2][n12];
            }
            dArray5[n9 - 1] = d4;
            bl2 = false;
        }
        for (n2 = 0; n2 < n8; ++n2) {
            dArray3[n2] = dArray4[n2][n12];
            this.paramValue[n2] = dArray3[n2] / this.scale[n2];
        }
        this.maximum = -d4;
        this.kRestart = this.konvge - n6;
    }

    public void nelderMead(MaximizationFunction maximizationFunction, double[] dArray, double[] dArray2, double d) {
        int n = this.nMax;
        this.nelderMead(maximizationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(MaximisationFunction maximisationFunction, double[] dArray, double[] dArray2, double d) {
        int n = this.nMax;
        this.nelderMead(maximisationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(MaximizationFunction maximizationFunction, double[] dArray, double[] dArray2, int n) {
        double d = this.fTol;
        this.nelderMead(maximizationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(MaximisationFunction maximisationFunction, double[] dArray, double[] dArray2, int n) {
        double d = this.fTol;
        this.nelderMead(maximisationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(MaximizationFunction maximizationFunction, double[] dArray, double[] dArray2) {
        double d = this.fTol;
        int n = this.nMax;
        this.nelderMead(maximizationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(MaximisationFunction maximisationFunction, double[] dArray, double[] dArray2) {
        double d = this.fTol;
        int n = this.nMax;
        this.nelderMead(maximisationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(MaximizationFunction maximizationFunction, double[] dArray, double d, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = this.dStep * dArray[i];
        }
        this.nelderMead(maximizationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(MaximisationFunction maximisationFunction, double[] dArray, double d, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = this.dStep * dArray[i];
        }
        this.nelderMead(maximisationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(MaximizationFunction maximizationFunction, double[] dArray, double d) {
        int n = dArray.length;
        int n2 = this.nMax;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.dStep * dArray[i];
        }
        this.nelderMead(maximizationFunction, dArray, dArray2, d, n2);
    }

    public void nelderMead(MaximisationFunction maximisationFunction, double[] dArray, double d) {
        int n = dArray.length;
        int n2 = this.nMax;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.dStep * dArray[i];
        }
        this.nelderMead(maximisationFunction, dArray, dArray2, d, n2);
    }

    public void nelderMead(MaximizationFunction maximizationFunction, double[] dArray, int n) {
        int n2 = dArray.length;
        double d = this.fTol;
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = this.dStep * dArray[i];
        }
        this.nelderMead(maximizationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(MaximisationFunction maximisationFunction, double[] dArray, int n) {
        int n2 = dArray.length;
        double d = this.fTol;
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = this.dStep * dArray[i];
        }
        this.nelderMead(maximisationFunction, dArray, dArray2, d, n);
    }

    public void nelderMead(MaximizationFunction maximizationFunction, double[] dArray) {
        int n = dArray.length;
        int n2 = this.nMax;
        double d = this.fTol;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.dStep * dArray[i];
        }
        this.nelderMead(maximizationFunction, dArray, dArray2, d, n2);
    }

    public void nelderMead(MaximisationFunction maximisationFunction, double[] dArray) {
        int n = dArray.length;
        int n2 = this.nMax;
        double d = this.fTol;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.dStep * dArray[i];
        }
        this.nelderMead(maximisationFunction, dArray, dArray2, d, n2);
    }

    protected double functionValue(Object object, double[] dArray) {
        if (this.iseOption) {
            return this.functionValue((MaximisationFunction)object, dArray);
        }
        return this.functionValue((MaximizationFunction)object, dArray);
    }

    protected double functionValue(MaximizationFunction maximizationFunction, double[] dArray) {
        int n;
        double[] dArray2 = new double[this.nParam];
        for (n = 0; n < this.nParam; ++n) {
            dArray2[n] = dArray[n] / this.scale[n];
        }
        n = this.functionValueCommon(dArray, dArray2) ? 1 : 0;
        if (n != 0) {
            this.lastFunctValNoCnstrnt = this.functValue = -maximizationFunction.function(dArray2);
        }
        return this.functValue;
    }

    protected double functionValue(MaximisationFunction maximisationFunction, double[] dArray) {
        int n;
        double[] dArray2 = new double[this.nParam];
        for (n = 0; n < this.nParam; ++n) {
            dArray2[n] = dArray[n] / this.scale[n];
        }
        n = this.functionValueCommon(dArray, dArray2) ? 1 : 0;
        if (n != 0) {
            this.lastFunctValNoCnstrnt = this.functValue = -maximisationFunction.function(dArray2);
        }
        return this.functValue;
    }

    protected boolean functionValueCommon(double[] dArray, double[] dArray2) {
        int n;
        double d = this.lastFunctValNoCnstrnt;
        boolean bl = true;
        if (this.penalty) {
            n = 0;
            block10: for (int i = 0; i < this.nConstraints; ++i) {
                n = this.penaltyParam[i];
                switch (this.penaltyCheck[i]) {
                    case -1: {
                        if (!(dArray2[n] < this.constraints[i])) continue block10;
                        this.functValue = d + this.penaltyWeight * Fmath.square(this.constraints[i] - dArray2[n]);
                        bl = false;
                        continue block10;
                    }
                    case 0: {
                        if (dArray2[n] < this.constraints[i] * (1.0 - this.constraintTolerance)) {
                            this.functValue = d + this.penaltyWeight * Fmath.square(this.constraints[i] * (1.0 - this.constraintTolerance) - dArray2[n]);
                            bl = false;
                        }
                        if (!(dArray2[n] > this.constraints[i] * (1.0 + this.constraintTolerance))) continue block10;
                        this.functValue = d + this.penaltyWeight * Fmath.square(dArray2[n] - this.constraints[i] * (1.0 + this.constraintTolerance));
                        bl = false;
                        continue block10;
                    }
                    case 1: {
                        if (!(dArray2[n] > this.constraints[i])) continue block10;
                        this.functValue = d + this.penaltyWeight * Fmath.square(dArray2[n] - this.constraints[i]);
                        bl = false;
                    }
                }
            }
        }
        if (this.sumPenalty) {
            n = 0;
            double d2 = 0.0;
            block11: for (int i = 0; i < this.nSumConstraints; ++i) {
                double d3 = 0.0;
                for (int j = 0; j < this.sumPenaltyNumber[i]; ++j) {
                    n = this.sumPenaltyParam[i][j];
                    d2 = this.sumPlusOrMinus[i][j];
                    d3 += dArray2[n] * d2;
                }
                switch (this.sumPenaltyCheck[i]) {
                    case -1: {
                        if (!(d3 < this.sumConstraints[i])) continue block11;
                        this.functValue = d + this.penaltyWeight * Fmath.square(this.sumConstraints[i] - d3);
                        bl = false;
                        continue block11;
                    }
                    case 0: {
                        if (d3 < this.sumConstraints[i] * (1.0 - this.constraintTolerance)) {
                            this.functValue = d + this.penaltyWeight * Fmath.square(this.sumConstraints[i] * (1.0 - this.constraintTolerance) - d3);
                            bl = false;
                        }
                        if (!(d3 > this.sumConstraints[i] * (1.0 + this.constraintTolerance))) continue block11;
                        this.functValue = d + this.penaltyWeight * Fmath.square(d3 - this.sumConstraints[i] * (1.0 + this.constraintTolerance));
                        bl = false;
                        continue block11;
                    }
                    case 1: {
                        if (!(d3 > this.sumConstraints[i])) continue block11;
                        this.functValue = d + this.penaltyWeight * Fmath.square(d3 - this.sumConstraints[i]);
                        bl = false;
                    }
                }
            }
        }
        return bl;
    }

    public void addConstraint(int n, int n2, double d) {
        this.penalty = true;
        if (this.penalties.isEmpty()) {
            this.penalties.add(new Integer(this.constraintMethod));
        }
        if (this.penalties.size() == 1) {
            this.penalties.add(new Integer(1));
        } else {
            int n3 = (Integer)this.penalties.get(1);
            this.penalties.set(1, new Integer(++n3));
        }
        this.penalties.add(new Integer(n));
        this.penalties.add(new Integer(n2));
        this.penalties.add(new Double(d));
        if (n > this.maxConstraintIndex) {
            this.maxConstraintIndex = n;
        }
    }

    public void addConstraint(int[] nArray, int[] nArray2, int n, double d) {
        ArrayMaths arrayMaths = new ArrayMaths(nArray2);
        double[] dArray = arrayMaths.getArray_as_double();
        this.addConstraint(nArray, dArray, n, d);
    }

    public void addConstraint(int[] nArray, double[] dArray, int n, double d) {
        int n2 = nArray.length;
        int n3 = dArray.length;
        if (n2 != n3) {
            throw new IllegalArgumentException("num of parameters, " + n2 + ", does not equal number of parameter signs, " + n3);
        }
        this.sumPenalty = true;
        if (this.sumPenalties.isEmpty()) {
            this.sumPenalties.add(new Integer(this.constraintMethod));
        }
        if (this.sumPenalties.size() == 1) {
            this.sumPenalties.add(new Integer(1));
        } else {
            int n4 = (Integer)this.sumPenalties.get(1);
            this.sumPenalties.set(1, new Integer(++n4));
        }
        this.sumPenalties.add(new Integer(n2));
        this.sumPenalties.add(nArray);
        this.sumPenalties.add(dArray);
        this.sumPenalties.add(new Integer(n));
        this.sumPenalties.add(new Double(d));
        ArrayMaths arrayMaths = new ArrayMaths(nArray);
        int n5 = arrayMaths.getMaximum_as_int();
        if (n5 > this.maxConstraintIndex) {
            this.maxConstraintIndex = n5;
        }
    }

    public void setConstraintMethod(int n) {
        this.constraintMethod = n;
        if (!this.penalties.isEmpty()) {
            this.penalties.set(0, new Integer(this.constraintMethod));
        }
    }

    public void removeConstraints() {
        int n;
        int n2;
        if (!this.penalties.isEmpty()) {
            n2 = this.penalties.size();
            for (n = n2 - 1; n >= 0; --n) {
                this.penalties.remove(n);
            }
        }
        this.penalty = false;
        this.nConstraints = 0;
        if (!this.sumPenalties.isEmpty()) {
            n2 = this.sumPenalties.size();
            for (n = n2 - 1; n >= 0; --n) {
                this.sumPenalties.remove(n);
            }
        }
        this.sumPenalty = false;
        this.nSumConstraints = 0;
        this.maxConstraintIndex = -1;
    }

    public void setConstraintTolerance(double d) {
        this.constraintTolerance = d;
    }

    public void setPenaltyWeight(double d) {
        this.penaltyWeight = d;
    }

    public void print(String string, int n) {
        this.prec = n;
        this.print(string);
    }

    public void print(int n) {
        this.prec = n;
        String string = "MaximisationOutput.txt";
        this.print(string);
    }

    public void print(String string) {
        int n;
        if (string.indexOf(46) == -1) {
            string = string + ".txt";
        }
        FileOutput fileOutput = new FileOutput(string, 'n');
        fileOutput.dateAndTimeln(string);
        fileOutput.println(" ");
        fileOutput.println("Simplex maximisation, using the method of Nelder and Mead,");
        fileOutput.println("of the function y = f(c[0], c[1], c[2] . . .)");
        this.paraName = new String[this.nParam];
        for (n = 0; n < this.nParam; ++n) {
            this.paraName[n] = "c[" + n + "]";
        }
        fileOutput.println();
        if (!this.convStatus) {
            fileOutput.println("Convergence criterion was not satisfied");
            fileOutput.println("The following results are the current estimates on exiting the maximisation method");
            fileOutput.println();
        }
        fileOutput.println("Value of parameters at the maximum");
        fileOutput.println(" ");
        fileOutput.printtab(" ", this.field);
        fileOutput.printtab("Value at", this.field);
        fileOutput.printtab("Initial", this.field);
        fileOutput.println("Initial");
        fileOutput.printtab(" ", this.field);
        fileOutput.printtab("maximium", this.field);
        fileOutput.printtab("estimate", this.field);
        fileOutput.println("step");
        for (n = 0; n < this.nParam; ++n) {
            fileOutput.printtab(this.paraName[n], this.field);
            fileOutput.printtab(Fmath.truncate(this.paramValue[n], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.startH[n], this.prec), this.field);
            fileOutput.println(Fmath.truncate(this.step[n], this.prec));
        }
        fileOutput.println();
        fileOutput.println(" ");
        fileOutput.printtab("Number of paramaters");
        fileOutput.println(this.nParam);
        fileOutput.printtab("Number of iterations taken");
        fileOutput.println(this.nIter);
        fileOutput.printtab("Maximum number of iterations allowed");
        fileOutput.println(this.nMax);
        fileOutput.printtab("Number of restarts taken");
        fileOutput.println(this.kRestart);
        fileOutput.printtab("Maximum number of restarts allowed");
        fileOutput.println(this.konvge);
        fileOutput.printtab("Standard deviation of the simplex at the maximum");
        fileOutput.println(Fmath.truncate(this.simplexSd, this.prec));
        fileOutput.printtab("Convergence tolerance");
        fileOutput.println(this.fTol);
        switch (this.maxTest) {
            case 0: {
                if (this.convStatus) {
                    fileOutput.println("simplex sd < the tolerance");
                    break;
                }
                fileOutput.println("NOTE!!! simplex sd > the tolerance");
            }
        }
        fileOutput.println();
        fileOutput.println("End of file");
        fileOutput.close();
    }

    public void print() {
        String string = "MaximisationOutput.txt";
        this.print(string);
    }

    public boolean getConvStatus() {
        return this.convStatus;
    }

    public void setScale(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("The argument must be 0 (no scaling) 1(initial estimates all scaled to unity) or the array of scaling factors");
        }
        this.scaleOpt = n;
    }

    public void setScale(double[] dArray) {
        this.scale = dArray;
        this.scaleOpt = 2;
    }

    public double[] getScale() {
        return this.scale;
    }

    public void setMaxTest(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("maxTest must be 0 or 1");
        }
        this.maxTest = n;
    }

    public int getMaxTest() {
        return this.maxTest;
    }

    public double getSimplexSd() {
        return this.simplexSd;
    }

    public double[] getParamValues() {
        return this.paramValue;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public int getNiter() {
        return this.nIter;
    }

    public void setNmax(int n) {
        this.nMax = n;
    }

    public int getNmax() {
        return this.nMax;
    }

    public int getNrestarts() {
        return this.kRestart;
    }

    public void setNrestartsMax(int n) {
        this.konvge = n;
    }

    public int getNrestartsMax() {
        return this.konvge;
    }

    public void setNMreflect(double d) {
        this.rCoeff = d;
    }

    public double getNMreflect() {
        return this.rCoeff;
    }

    public void setNMextend(double d) {
        this.eCoeff = d;
    }

    public double getNMextend() {
        return this.eCoeff;
    }

    public void setNMcontract(double d) {
        this.cCoeff = d;
    }

    public double getNMcontract() {
        return this.cCoeff;
    }

    public void setTolerance(double d) {
        this.fTol = d;
    }

    public double getTolerance() {
        return this.fTol;
    }
}

