/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.interpolation.BiCubicSplineFirstDerivative;
import flanagan.interpolation.CubicSpline;
import flanagan.math.Conv;
import java.util.ArrayList;

public class Gradient {
    private double[] xArray = null;
    private double[] yArray = null;
    private int[] xSampling = null;
    private int[] ySampling = null;
    private double[] fArray1d = null;
    private double[][] fArray2d = null;
    private int xSamplingStart = 0;
    private int ySamplingStart = 0;
    private int xSamplingEnd = 0;
    private int ySamplingEnd = 0;
    private int xSamplingPeriod = 1;
    private int ySamplingPeriod = 1;
    private boolean sampled = false;
    private ArrayList<Object> numDiffArray = new ArrayList();
    private double[] ndGrad1 = null;
    private double[][] ndGrad2_X = null;
    private double[][] ndGrad2_Y = null;
    private boolean numArrayDone = false;
    private int nDim = 0;
    private int xLength = 0;
    private int yLength = 0;
    private int xLengthS = 0;
    private int yLengthS = 0;
    private ArrayList<Object> splineDerivArray = new ArrayList();
    private ArrayList<Object> splineSecondDerivArray = new ArrayList();
    private double[] csGrad1F = null;
    private double[] csGrad1 = null;
    private double[][] bcsGrad2_XF = null;
    private double[][] bcsGrad2_X = null;
    private double[][] bcsGrad2_YF = null;
    private double[][] bcsGrad2_Y = null;
    private double[] cs2Grad1 = null;
    private double[][] bcs2Grad2_X2 = null;
    private double[][] bcs2Grad2_Y2 = null;
    private double[][] bcs2Grad2_XY = null;
    private CubicSpline cs = null;
    private BiCubicSplineFirstDerivative bcs = null;
    private boolean splineDone = false;
    private CubicSpline cs2 = null;
    private BiCubicSplineFirstDerivative bcs2x = null;
    private BiCubicSplineFirstDerivative bcs2y = null;
    private boolean spline2Done = false;

    public Gradient(double[] dArray, double[] dArray2) {
        this.xLength = dArray2.length;
        if (dArray.length != this.xLength) {
            throw new IllegalArgumentException("x length, " + dArray.length + ", does not match corresponding f length, " + this.xLength);
        }
        this.nDim = 1;
        this.xLengthS = this.xLength;
        this.xArray = Conv.copy(dArray);
        this.fArray1d = Conv.copy(dArray2);
        this.xSampling = new int[this.xLengthS];
        for (int i = 0; i < this.xLengthS; ++i) {
            this.xSampling[i] = i;
        }
        this.xSamplingStart = 0;
        this.xSamplingEnd = this.xLengthS - 1;
        this.xSamplingPeriod = 1;
        this.sampled = false;
    }

    public Gradient(float[] fArray, float[] fArray2) {
        int n;
        this.xLength = fArray2.length;
        if (fArray.length != this.xLength) {
            throw new IllegalArgumentException("x length, " + fArray.length + ", does not match corresponding f length, " + this.xLength);
        }
        this.nDim = 1;
        this.xLengthS = this.xLength;
        float[] fArray3 = Conv.copy(fArray);
        float[] fArray4 = Conv.copy(fArray2);
        this.xArray = new double[this.xLength];
        this.fArray1d = new double[this.xLength];
        for (n = 0; n < this.xLength; ++n) {
            this.xArray[n] = Conv.convert_float_to_double(fArray3[n]);
            this.fArray1d[n] = Conv.convert_float_to_double(fArray4[n]);
        }
        this.xSampling = new int[this.xLengthS];
        for (n = 0; n < this.xLengthS; ++n) {
            this.xSampling[n] = n;
        }
        this.xSamplingStart = 0;
        this.xSamplingEnd = this.xLengthS - 1;
        this.xSamplingPeriod = 1;
        this.sampled = false;
    }

    public Gradient(long[] lArray, long[] lArray2) {
        int n;
        this.xLength = lArray2.length;
        if (lArray.length != this.xLength) {
            throw new IllegalArgumentException("x length, " + lArray.length + ", does not match corresponding f length, " + this.xLength);
        }
        this.nDim = 1;
        this.xLengthS = this.xLength;
        long[] lArray3 = Conv.copy(lArray);
        long[] lArray4 = Conv.copy(lArray2);
        this.xArray = new double[this.xLength];
        this.fArray1d = new double[this.xLength];
        for (n = 0; n < this.xLength; ++n) {
            this.xArray[n] = Conv.convert_long_to_double(lArray3[n]);
            this.fArray1d[n] = Conv.convert_long_to_double(lArray4[n]);
        }
        this.xSampling = new int[this.xLengthS];
        for (n = 0; n < this.xLengthS; ++n) {
            this.xSampling[n] = n;
        }
        this.xSamplingStart = 0;
        this.xSamplingEnd = this.xLengthS - 1;
        this.xSamplingPeriod = 1;
        this.sampled = false;
    }

    public Gradient(int[] nArray, int[] nArray2) {
        int n;
        this.xLength = nArray2.length;
        if (nArray.length != this.xLength) {
            throw new IllegalArgumentException("x length, " + nArray.length + ", does not match corresponding f length, " + this.xLength);
        }
        this.nDim = 1;
        this.xLengthS = this.xLength;
        int[] nArray3 = Conv.copy(nArray);
        int[] nArray4 = Conv.copy(nArray2);
        this.xArray = new double[this.xLength];
        this.fArray1d = new double[this.xLength];
        for (n = 0; n < this.xLength; ++n) {
            this.xArray[n] = Conv.convert_int_to_double(nArray3[n]);
            this.fArray1d[n] = Conv.convert_int_to_double(nArray4[n]);
        }
        this.xSampling = new int[this.xLengthS];
        for (n = 0; n < this.xLengthS; ++n) {
            this.xSampling[n] = n;
        }
        this.xSamplingStart = 0;
        this.xSamplingEnd = this.xLengthS - 1;
        this.xSamplingPeriod = 1;
        this.sampled = false;
    }

    public Gradient(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        this.xLength = dArray3.length;
        this.yLength = dArray3[0].length;
        if (dArray.length != this.xLength) {
            throw new IllegalArgumentException("x length, " + dArray.length + ", does not match corresponding f length, " + this.xLength);
        }
        if (dArray2.length != this.yLength) {
            throw new IllegalArgumentException("y length, " + dArray2.length + ", does not match corresponding f length, " + this.yLength);
        }
        this.nDim = 2;
        this.xLengthS = this.xLength;
        this.yLengthS = this.yLength;
        this.xArray = Conv.copy(dArray);
        this.yArray = Conv.copy(dArray2);
        this.fArray2d = Conv.copy(dArray3);
        this.xSampling = new int[this.xLengthS];
        for (n = 0; n < this.xLengthS; ++n) {
            this.xSampling[n] = n;
        }
        this.ySampling = new int[this.yLengthS];
        for (n = 0; n < this.yLengthS; ++n) {
            this.ySampling[n] = n;
        }
        this.xSamplingStart = 0;
        this.xSamplingEnd = this.xLengthS - 1;
        this.xSamplingPeriod = 1;
        this.ySamplingStart = 0;
        this.ySamplingEnd = this.yLengthS - 1;
        this.ySamplingPeriod = 1;
        this.sampled = false;
    }

    public Gradient(float[] fArray, float[] fArray2, float[][] fArray3) {
        int n;
        this.xLength = fArray3.length;
        this.yLength = fArray3[0].length;
        if (fArray.length != this.xLength) {
            throw new IllegalArgumentException("x length, " + fArray.length + ", does not match corresponding f length, " + this.xLength);
        }
        if (fArray2.length != this.yLength) {
            throw new IllegalArgumentException("y length, " + fArray2.length + ", does not match corresponding f length, " + this.yLength);
        }
        this.nDim = 2;
        this.xLengthS = this.xLength;
        this.yLengthS = this.yLength;
        float[] fArray4 = Conv.copy(fArray);
        float[] fArray5 = Conv.copy(fArray2);
        float[][] fArray6 = Conv.copy(fArray3);
        this.xArray = new double[this.xLength];
        this.yArray = new double[this.yLength];
        this.fArray2d = new double[this.xLength][this.yLength];
        for (n = 0; n < this.xLength; ++n) {
            this.xArray[n] = Conv.convert_float_to_double(fArray4[n]);
            for (int i = 0; i < this.yLength; ++i) {
                if (n == 0) {
                    this.yArray[i] = Conv.convert_float_to_double(fArray5[i]);
                }
                this.fArray2d[n][i] = Conv.convert_float_to_double(fArray6[n][i]);
            }
        }
        this.xSampling = new int[this.xLengthS];
        for (n = 0; n < this.xLengthS; ++n) {
            this.xSampling[n] = n;
        }
        this.ySampling = new int[this.yLengthS];
        for (n = 0; n < this.yLengthS; ++n) {
            this.ySampling[n] = n;
        }
        this.xSamplingStart = 0;
        this.xSamplingEnd = this.xLengthS - 1;
        this.xSamplingPeriod = 1;
        this.ySamplingStart = 0;
        this.ySamplingEnd = this.yLengthS - 1;
        this.ySamplingPeriod = 1;
        this.sampled = false;
    }

    public Gradient(long[] lArray, long[] lArray2, long[][] lArray3) {
        int n;
        this.xLength = lArray3.length;
        this.yLength = lArray3[0].length;
        if (lArray.length != this.xLength) {
            throw new IllegalArgumentException("x length, " + lArray.length + ", does not match corresponding f length, " + this.xLength);
        }
        if (lArray2.length != this.yLength) {
            throw new IllegalArgumentException("y length, " + lArray2.length + ", does not match corresponding f length, " + this.yLength);
        }
        this.nDim = 2;
        this.xLengthS = this.xLength;
        this.yLengthS = this.yLength;
        long[] lArray4 = Conv.copy(lArray);
        long[] lArray5 = Conv.copy(lArray2);
        long[][] lArray6 = Conv.copy(lArray3);
        this.xArray = new double[this.xLength];
        this.yArray = new double[this.yLength];
        this.fArray2d = new double[this.xLength][this.yLength];
        for (n = 0; n < this.xLength; ++n) {
            this.xArray[n] = Conv.convert_long_to_double(lArray4[n]);
            for (int i = 0; i < this.yLength; ++i) {
                if (n == 0) {
                    this.yArray[i] = Conv.convert_long_to_double(lArray5[i]);
                }
                this.fArray2d[n][i] = Conv.convert_long_to_double(lArray6[n][i]);
            }
        }
        this.xSampling = new int[this.xLengthS];
        for (n = 0; n < this.xLengthS; ++n) {
            this.xSampling[n] = n;
        }
        this.ySampling = new int[this.yLengthS];
        for (n = 0; n < this.yLengthS; ++n) {
            this.ySampling[n] = n;
        }
        this.xSamplingStart = 0;
        this.xSamplingEnd = this.xLengthS - 1;
        this.xSamplingPeriod = 1;
        this.ySamplingStart = 0;
        this.ySamplingEnd = this.yLengthS - 1;
        this.ySamplingPeriod = 1;
        this.sampled = false;
    }

    public Gradient(int[] nArray, int[] nArray2, int[][] nArray3) {
        int n;
        this.xLength = nArray3.length;
        this.yLength = nArray3[0].length;
        if (nArray.length != this.xLength) {
            throw new IllegalArgumentException("x length, " + nArray.length + ", does not match corresponding f length, " + this.xLength);
        }
        if (nArray2.length != this.yLength) {
            throw new IllegalArgumentException("y length, " + nArray2.length + ", does not match corresponding f length, " + this.yLength);
        }
        this.nDim = 2;
        this.xLengthS = this.xLength;
        this.yLengthS = this.yLength;
        int[] nArray4 = Conv.copy(nArray);
        int[] nArray5 = Conv.copy(nArray2);
        int[][] nArray6 = Conv.copy(nArray3);
        this.xArray = new double[this.xLength];
        this.yArray = new double[this.yLength];
        this.fArray2d = new double[this.xLength][this.yLength];
        for (n = 0; n < this.xLength; ++n) {
            this.xArray[n] = Conv.convert_int_to_double(nArray4[n]);
            for (int i = 0; i < this.yLength; ++i) {
                if (n == 0) {
                    this.yArray[i] = Conv.convert_int_to_double(nArray5[i]);
                }
                this.fArray2d[n][i] = Conv.convert_int_to_double(nArray6[n][i]);
            }
        }
        this.xSampling = new int[this.xLengthS];
        for (n = 0; n < this.xLengthS; ++n) {
            this.xSampling[n] = n;
        }
        this.ySampling = new int[this.yLengthS];
        for (n = 0; n < this.yLengthS; ++n) {
            this.ySampling[n] = n;
        }
        this.xSamplingStart = 0;
        this.xSamplingEnd = this.xLengthS - 1;
        this.xSamplingPeriod = 1;
        this.ySamplingStart = 0;
        this.ySamplingEnd = this.yLengthS - 1;
        this.ySamplingPeriod = 1;
        this.sampled = false;
    }

    public void sampling(int n) {
        this.xSamplingStart = 0;
        this.ySamplingStart = 0;
        this.xSamplingEnd = this.xLength - 1;
        this.ySamplingEnd = this.yLength - 1;
        this.xSamplingPeriod = n;
        this.ySamplingPeriod = n;
        this.samplingSelection();
    }

    public void sampling(int n, int n2) {
        this.xSamplingStart = 0;
        this.ySamplingStart = 0;
        this.xSamplingEnd = this.xLength - 1;
        this.ySamplingEnd = this.yLength - 1;
        this.xSamplingPeriod = n;
        this.ySamplingPeriod = n2;
        this.samplingSelection();
    }

    public void sampling(int n, int n2, int n3) {
        this.xSamplingStart = n2;
        this.ySamplingStart = n2;
        this.xSamplingEnd = n3;
        this.ySamplingEnd = n3;
        this.xSamplingPeriod = n;
        this.ySamplingPeriod = n;
        this.samplingSelection();
    }

    public void sampling(int n, int n2, int n3, int n4, int n5, int n6) {
        this.xSamplingStart = n2;
        this.ySamplingStart = n5;
        this.xSamplingEnd = n3;
        this.ySamplingEnd = n6;
        this.xSamplingPeriod = n;
        this.ySamplingPeriod = n4;
        this.samplingSelection();
    }

    private void samplingSelection() {
        switch (this.nDim) {
            case 2: {
                int n;
                this.yLengthS = (this.ySamplingEnd - this.ySamplingStart + 1) / this.ySamplingPeriod;
                int n2 = this.yLength % this.ySamplingPeriod;
                if (n2 != 0) {
                    ++this.yLengthS;
                }
                this.ySampling = new int[this.yLengthS];
                this.ySampling[0] = this.ySamplingStart;
                for (n = 1; n < this.yLengthS; ++n) {
                    this.ySampling[n] = this.ySampling[n - 1] + this.ySamplingPeriod;
                }
            }
            case 1: {
                this.xLengthS = (this.xSamplingEnd - this.xSamplingStart + 1) / this.xSamplingPeriod;
                int n = this.xLength % this.xSamplingPeriod;
                if (n != 0) {
                    ++this.xLengthS;
                }
                this.xSampling = new int[this.xLengthS];
                this.xSampling[0] = this.xSamplingStart;
                for (int i = 1; i < this.xLengthS; ++i) {
                    this.xSampling[i] = this.xSampling[i - 1] + this.xSamplingPeriod;
                }
                break;
            }
        }
        this.numArrayDone = false;
    }

    public double[] splineDeriv_1D_array() {
        if (this.nDim != 1) {
            throw new IllegalArgumentException("method splineDeriv_1D_array is only applicable if the entered data is a ONE dimensional array");
        }
        if (!this.splineDone) {
            this.splineDerivativesArray();
        }
        return this.csGrad1;
    }

    public double[][] splineDeriv_2D_x_direction() {
        if (this.nDim != 2) {
            throw new IllegalArgumentException("method splineDeriv_2D_x_direction is only applicable if the entered data is a TWO dimensional array");
        }
        if (!this.splineDone) {
            this.splineDerivativesArray();
        }
        return this.bcsGrad2_X;
    }

    public double[][] splineDeriv_2D_y_direction() {
        if (this.nDim != 2) {
            throw new IllegalArgumentException("method splineDeriv_2D_y_direction is only applicable if the entered data is a TWO dimensional array");
        }
        if (!this.splineDone) {
            this.splineDerivativesArray();
        }
        return this.bcsGrad2_Y;
    }

    public ArrayList<Object> splineDerivativesArray() {
        this.splineDerivArray = new ArrayList();
        switch (this.nDim) {
            case 1: {
                int n;
                this.cs = new CubicSpline(this.xArray, this.fArray1d);
                this.csGrad1F = new double[this.xLength];
                this.csGrad1 = new double[this.xLengthS];
                for (n = 0; n < this.xLength; ++n) {
                    this.csGrad1F[n] = this.cs.interpolate_for_y_and_dydx(this.xArray[n])[1];
                }
                for (n = 0; n < this.xLengthS; ++n) {
                    this.csGrad1[n] = this.csGrad1F[this.xSampling[n]];
                }
                this.splineDerivArray.add(this.csGrad1);
                break;
            }
            case 2: {
                int n;
                int n2;
                this.bcs = new BiCubicSplineFirstDerivative(this.xArray, this.yArray, this.fArray2d);
                this.bcsGrad2_XF = new double[this.xLength][this.yLength];
                this.bcsGrad2_YF = new double[this.xLength][this.yLength];
                this.bcsGrad2_X = new double[this.xLengthS][this.yLengthS];
                this.bcsGrad2_Y = new double[this.xLengthS][this.yLengthS];
                for (n2 = 0; n2 < this.xLength; ++n2) {
                    for (n = 0; n < this.yLength; ++n) {
                        double[] dArray = this.bcs.interpolate(this.xArray[n2], this.yArray[n]);
                        this.bcsGrad2_XF[n2][n] = dArray[1];
                        this.bcsGrad2_YF[n2][n] = dArray[2];
                    }
                }
                for (n2 = 0; n2 < this.xLengthS; ++n2) {
                    for (n = 0; n < this.yLengthS; ++n) {
                        this.bcsGrad2_X[n2][n] = this.bcsGrad2_XF[this.xSampling[n2]][this.ySampling[n]];
                        this.bcsGrad2_Y[n2][n] = this.bcsGrad2_YF[this.xSampling[n2]][this.ySampling[n]];
                    }
                }
                this.splineDerivArray.add(this.bcsGrad2_X);
                this.splineDerivArray.add(this.bcsGrad2_Y);
            }
        }
        this.splineDone = true;
        return this.splineDerivArray;
    }

    public double splineDerivAtPoint(double d) {
        if (this.nDim != 1) {
            throw new IllegalArgumentException("Only one coordinate entered for a multiple dimensioned array");
        }
        if (d < this.xArray[0] || d > this.xArray[this.xLength - 1]) {
            throw new IllegalArgumentException("Entered xx value, " + d + ", is outside the x value range, " + this.xArray[0] + " to " + this.xArray[this.xLength - 1]);
        }
        if (!this.splineDone) {
            this.cs = new CubicSpline(this.xArray, this.fArray1d);
        }
        return this.cs.interpolate_for_y_and_dydx(d)[1];
    }

    public double[] splineDerivAtPoint(double d, double d2) {
        if (this.nDim == 1) {
            throw new IllegalArgumentException("Two coordinates entered for a one dimension array");
        }
        if (d < this.xArray[0] || d > this.xArray[this.xLength - 1]) {
            throw new IllegalArgumentException("Entered xx value, " + d + ", is outside the x value range, " + this.xArray[0] + " to " + this.xArray[this.xLength - 1]);
        }
        if (d2 < this.yArray[0] || d2 > this.yArray[this.yLength - 1]) {
            throw new IllegalArgumentException("Entered yy value, " + d2 + ", is outside the y value range, " + this.yArray[0] + " to " + this.yArray[this.yLength - 1]);
        }
        if (!this.splineDone) {
            this.bcs = new BiCubicSplineFirstDerivative(this.xArray, this.yArray, this.fArray2d);
        }
        double[] dArray = new double[2];
        double[] dArray2 = this.bcs.interpolate(d, d2);
        dArray[0] = dArray2[1];
        dArray[1] = dArray2[2];
        return dArray;
    }

    public double[] numDeriv_1D_array() {
        if (this.nDim != 1) {
            throw new IllegalArgumentException("method numDeriv_1D_array is only applicable if the entered data is a ONE dimensional array");
        }
        if (!this.numArrayDone) {
            this.numericalDerivativesArray();
        }
        return this.ndGrad1;
    }

    public double[][] numDeriv_2D_x_direction() {
        if (this.nDim != 2) {
            throw new IllegalArgumentException("method numDeriv_2D_x_direction is only applicable if the entered data is a TWO dimensional array");
        }
        if (!this.numArrayDone) {
            this.numericalDerivativesArray();
        }
        return this.ndGrad2_X;
    }

    public double[][] numDeriv_2D_y_direction() {
        if (this.nDim != 2) {
            throw new IllegalArgumentException("method numDeriv_2D_y_direction is only applicable if the entered data is a TWO dimensional array");
        }
        if (!this.numArrayDone) {
            this.numericalDerivativesArray();
        }
        return this.ndGrad2_Y;
    }

    public ArrayList<Object> numericalDerivativesArray() {
        this.numDiffArray = new ArrayList();
        switch (this.nDim) {
            case 1: {
                this.ndGrad1 = new double[this.xLengthS];
                for (int i = 0; i < this.xLengthS; ++i) {
                    this.ndGrad1[i] = this.xSampling[i] == 0 ? (this.fArray1d[this.xSampling[i] + 1] - this.fArray1d[this.xSampling[i]]) / (this.xArray[this.xSampling[i] + 1] - this.xArray[this.xSampling[i]]) : (this.xSampling[i] == this.xLength - 1 ? (this.fArray1d[this.xSampling[i]] - this.fArray1d[this.xSampling[i] - 1]) / (this.xArray[this.xSampling[i]] - this.xArray[this.xSampling[i] - 1]) : ((this.fArray1d[this.xSampling[i]] - this.fArray1d[this.xSampling[i] - 1]) / (this.xArray[this.xSampling[i]] - this.xArray[this.xSampling[i] - 1]) + (this.fArray1d[this.xSampling[i] + 1] - this.fArray1d[this.xSampling[i]]) / (this.xArray[this.xSampling[i] + 1] - this.xArray[this.xSampling[i]])) / 2.0);
                }
                this.numDiffArray.add(this.ndGrad1);
                break;
            }
            case 2: {
                int n;
                int n2;
                this.ndGrad2_Y = new double[this.xLengthS][this.yLengthS];
                this.ndGrad2_X = new double[this.xLengthS][this.yLengthS];
                for (n2 = 0; n2 < this.xLengthS; ++n2) {
                    for (n = 0; n < this.yLengthS; ++n) {
                        this.ndGrad2_Y[n2][n] = this.ySampling[n] == 0 ? (this.fArray2d[this.xSampling[n2]][this.ySampling[n] + 1] - this.fArray2d[this.xSampling[n2]][this.ySampling[n]]) / (this.yArray[this.ySampling[n] + 1] - this.yArray[this.ySampling[n]]) : (this.ySampling[n] == this.yLength - 1 ? (this.fArray2d[this.xSampling[n2]][this.ySampling[n]] - this.fArray2d[this.xSampling[n2]][this.ySampling[n] - 1]) / (this.yArray[this.ySampling[n]] - this.yArray[this.ySampling[n] - 1]) : ((this.fArray2d[this.xSampling[n2]][this.ySampling[n]] - this.fArray2d[this.xSampling[n2]][this.ySampling[n] - 1]) / (this.yArray[this.ySampling[n]] - this.yArray[this.ySampling[n] - 1]) + (this.fArray2d[this.xSampling[n2]][this.ySampling[n] + 1] - this.fArray2d[this.xSampling[n2]][this.ySampling[n]]) / (this.yArray[this.ySampling[n] + 1] - this.yArray[this.ySampling[n]])) / 2.0);
                    }
                }
                this.numDiffArray.add(this.ndGrad2_Y);
                for (n2 = 0; n2 < this.yLengthS; ++n2) {
                    for (n = 0; n < this.xLengthS; ++n) {
                        this.ndGrad2_X[n][n2] = this.xSampling[n] == 0 ? (this.fArray2d[this.xSampling[n] + 1][this.ySampling[n2]] - this.fArray2d[this.xSampling[n]][this.ySampling[n2]]) / (this.xArray[this.xSampling[n] + 1] - this.xArray[this.xSampling[n]]) : (this.xSampling[n] == this.xLength - 1 ? (this.fArray2d[this.xSampling[n]][this.ySampling[n2]] - this.fArray2d[this.xSampling[n] - 1][this.ySampling[n2]]) / (this.xArray[this.xSampling[n]] - this.xArray[this.xSampling[n] - 1]) : ((this.fArray2d[this.xSampling[n]][this.ySampling[n2]] - this.fArray2d[this.xSampling[n] - 1][this.ySampling[n2]]) / (this.xArray[this.xSampling[n]] - this.xArray[this.xSampling[n] - 1]) + this.ndGrad2_X[n][n2] + (this.fArray2d[this.xSampling[n] + 1][this.ySampling[n2]] - this.fArray2d[this.xSampling[n]][this.ySampling[n2]]) / (this.xArray[this.xSampling[n] + 1] - this.xArray[this.xSampling[n]])) / 2.0);
                    }
                }
                this.numDiffArray.add(this.ndGrad2_X);
                break;
            }
            default: {
                throw new IllegalArgumentException("Arrays of " + this.nDim + " dimensions are not handles by this class");
            }
        }
        this.numArrayDone = true;
        return this.numDiffArray;
    }

    public double numDerivAtPoint(double d) {
        if (this.nDim != 1) {
            throw new IllegalArgumentException("Only one coordinate entered for a multiple dimensioned array");
        }
        if (d < this.xArray[0] || d > this.xArray[this.xLength - 1]) {
            throw new IllegalArgumentException("Entered xx value, " + d + ", is outside the x value range, " + this.xArray[0] + " to " + this.xArray[this.xLength - 1]);
        }
        double d2 = 0.0;
        boolean bl = true;
        int n = 0;
        while (bl) {
            if (d <= this.xArray[n]) {
                bl = false;
                if (n == 0) {
                    d2 = (this.fArray1d[n + 1] - this.fArray1d[n]) / (this.xArray[n + 1] - this.xArray[n]);
                    continue;
                }
                if (d == this.xArray[this.xLength - 1]) {
                    d2 = (this.fArray1d[n] - this.fArray1d[n - 1]) / (this.xArray[n] - this.xArray[n - 1]);
                    continue;
                }
                if (d == this.xArray[n]) {
                    d2 = ((this.fArray1d[n] - this.fArray1d[n - 1]) / (this.xArray[n] - this.xArray[n - 1]) + (this.fArray1d[n + 1] - this.fArray1d[n]) / (this.xArray[n + 1] - this.xArray[n])) / 2.0;
                    continue;
                }
                d2 = (this.fArray1d[n] - this.fArray1d[n - 1]) / (this.xArray[n] - this.xArray[n - 1]);
                continue;
            }
            ++n;
        }
        return d2;
    }

    public double[] numDerivAtPoint(double d, double d2) {
        if (this.nDim == 1) {
            throw new IllegalArgumentException("Two coordinates entered for a one dimension array");
        }
        if (d < this.xArray[0] || d > this.xArray[this.xLength - 1]) {
            throw new IllegalArgumentException("Entered xx value, " + d + ", is outside the x value range, " + this.xArray[0] + " to " + this.xArray[this.xLength - 1]);
        }
        if (d2 < this.yArray[0] || d2 > this.yArray[this.yLength - 1]) {
            throw new IllegalArgumentException("Entered yy value, " + d2 + ", is outside the y value range, " + this.yArray[0] + " to " + this.yArray[this.yLength - 1]);
        }
        double[] dArray = new double[2];
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        while (bl) {
            if (d <= this.xArray[n2]) {
                bl = false;
                if (d == this.xArray[n2]) {
                    bl2 = true;
                }
                n = n2;
                continue;
            }
            ++n2;
        }
        boolean bl3 = true;
        boolean bl4 = false;
        int n3 = 0;
        n2 = 0;
        while (bl3) {
            if (d2 <= this.yArray[n2]) {
                bl3 = false;
                if (d2 == this.yArray[n2]) {
                    bl4 = true;
                }
                n3 = n2;
                continue;
            }
            ++n2;
        }
        int n4 = 0;
        if (bl2) {
            n4 = 1;
        }
        if (bl4) {
            n4 = 2;
        }
        if (bl2 && bl4) {
            n4 = 3;
        }
        if (!this.numArrayDone) {
            this.numericalDerivativesArray();
        }
        System.out.println(n + " " + n3);
        switch (n4) {
            case 0: {
                double d3 = (this.yArray[n3 - 1] - d2) / (this.yArray[n3 - 1] - this.yArray[n3]);
                double d4 = (this.xArray[n - 1] - d) / (this.xArray[n - 1] - this.xArray[n]);
                double d5 = this.ndGrad2_X[n][n3 - 1] - (this.ndGrad2_X[n][n3 - 1] - this.ndGrad2_X[n][n3]) * d3;
                double d6 = this.ndGrad2_X[n - 1][n3 - 1] - (this.ndGrad2_X[n - 1][n3 - 1] - this.ndGrad2_X[n - 1][n3]) * d3;
                dArray[0] = d6 - (d6 - d5) * d4;
                d5 = this.ndGrad2_Y[n - 1][n3] - (this.ndGrad2_Y[n - 1][n3] - this.ndGrad2_Y[n][n3]) * d4;
                d6 = this.ndGrad2_Y[n - 1][n3 - 1] - (this.ndGrad2_Y[n - 1][n3 - 1] - this.ndGrad2_Y[n][n3 - 1]) * d4;
                dArray[1] = d6 - (d6 - d5) * d3;
                break;
            }
            case 1: {
                double d7 = (this.yArray[n3 - 1] - d2) / (this.yArray[n3 - 1] - this.yArray[n3]);
                dArray[0] = this.ndGrad2_X[n][n3 - 1] - (this.ndGrad2_X[n][n3 - 1] - this.ndGrad2_X[n][n3]) * d7;
                dArray[1] = this.ndGrad2_Y[n][n3 - 1] - (this.ndGrad2_Y[n][n3 - 1] - this.ndGrad2_Y[n][n3]) * d7;
                break;
            }
            case 2: {
                double d8 = (this.xArray[n - 1] - d) / (this.xArray[n - 1] - this.xArray[n]);
                dArray[0] = this.ndGrad2_X[n - 1][n3] - (this.ndGrad2_X[n - 1][n3] - this.ndGrad2_X[n][n3]) * d8;
                dArray[1] = this.ndGrad2_Y[n - 1][n3] - (this.ndGrad2_Y[n - 1][n3] - this.ndGrad2_Y[n][n3]) * d8;
                break;
            }
            case 3: {
                dArray[0] = this.ndGrad2_X[n][n3];
                dArray[1] = this.ndGrad2_Y[n][n3];
            }
        }
        return dArray;
    }

    public Gradient copy() {
        double[] dArray = null;
        double[][] dArray2 = null;
        Gradient gradient = null;
        gradient = this.nDim == 1 ? new Gradient(this.xArray, this.fArray1d) : new Gradient(this.xArray, this.yArray, this.fArray2d);
        gradient.xSampling = Conv.copy(this.xSampling);
        gradient.ySampling = Conv.copy(this.ySampling);
        gradient.xSamplingStart = this.xSamplingStart;
        gradient.ySamplingStart = this.ySamplingStart;
        gradient.xSamplingEnd = this.xSamplingEnd;
        gradient.ySamplingEnd = this.ySamplingEnd;
        gradient.xSamplingPeriod = this.xSamplingPeriod;
        gradient.ySamplingPeriod = this.ySamplingPeriod;
        gradient.sampled = this.sampled;
        if (this.numDiffArray == null) {
            gradient.numDiffArray = null;
        } else {
            gradient.numDiffArray = new ArrayList();
            if (this.nDim == 1) {
                dArray = (double[])this.numDiffArray.get(0);
                gradient.numDiffArray.add(Conv.copy(dArray));
            } else {
                dArray2 = (double[][])this.numDiffArray.get(0);
                gradient.numDiffArray.add(Conv.copy(dArray2));
                dArray2 = (double[][])this.numDiffArray.get(1);
                gradient.numDiffArray.add(Conv.copy(dArray2));
            }
        }
        gradient.ndGrad1 = Conv.copy(this.ndGrad1);
        gradient.ndGrad2_X = Conv.copy(this.ndGrad2_X);
        gradient.ndGrad2_Y = Conv.copy(this.ndGrad2_Y);
        gradient.numArrayDone = this.numArrayDone;
        gradient.nDim = this.nDim;
        gradient.xLength = this.xLength;
        gradient.yLength = this.yLength;
        gradient.xLengthS = this.xLengthS;
        gradient.yLengthS = this.yLengthS;
        if (this.splineDerivArray == null) {
            gradient.splineDerivArray = null;
        } else {
            gradient.splineDerivArray = new ArrayList();
            if (this.nDim == 1) {
                dArray = (double[])this.splineDerivArray.get(0);
                gradient.splineDerivArray.add(Conv.copy(dArray));
            } else {
                dArray2 = (double[][])this.splineDerivArray.get(0);
                gradient.splineDerivArray.add(Conv.copy(dArray2));
                dArray2 = (double[][])this.splineDerivArray.get(1);
                gradient.splineDerivArray.add(Conv.copy(dArray2));
            }
        }
        gradient.csGrad1 = Conv.copy(this.csGrad1);
        gradient.bcsGrad2_X = Conv.copy(this.bcsGrad2_X);
        gradient.bcsGrad2_Y = Conv.copy(this.bcsGrad2_Y);
        gradient.cs = this.cs;
        gradient.bcs = this.bcs;
        gradient.splineDone = this.splineDone;
        return gradient;
    }

    public Object clone() {
        return this.copy();
    }
}

