/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.analysis.ErrorProp;
import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.complex.ComplexErrorProp;
import flanagan.complex.ComplexPoly;
import flanagan.io.DialogueBox;
import flanagan.math.Fmath;
import flanagan.math.Polynomial;
import flanagan.math.TimeAndDate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Conv {
    private static double max_float_as_double = 3.4028234663852886E38;
    private static double max_long_as_double = 9.223372036854776E18;
    private static double max_long_as_float = 9.223372036854776E18;
    private static double max_int_as_double = 2.147483647E9;
    private static double max_int_as_float = 2.147483648E9;
    private static double max_int_as_long = 2.147483647E9;
    private static double max_short_as_double = 32767.0;
    private static double max_short_as_long = 32767.0;
    private static double max_short_as_float = 32767.0;
    private static double max_short_as_int = 32767.0;
    private static double max_byte_as_double = 127.0;
    private static double max_byte_as_float = 127.0;
    private static double max_byte_as_long = 127.0;
    private static double max_byte_as_int = 127.0;
    private static double max_byte_as_short = 127.0;
    private static boolean suppressMessage = false;
    private static boolean suppressMessageAM = false;

    public static void suppressMessages() {
        suppressMessage = true;
    }

    public static void restoreMessages() {
        if (!suppressMessageAM) {
            suppressMessage = false;
        }
    }

    public static void suppressMessagesAM() {
        suppressMessageAM = true;
    }

    public static void restoreMessagesAM() {
        suppressMessageAM = false;
    }

    public static double[] ArrayList_to_doubles(ArrayList arrayList) {
        return Conv.convert_ArrayList_to_doubles(arrayList);
    }

    public static double[] convert_ArrayList_to_doubles(ArrayList arrayList) {
        double[] dArray = null;
        if (arrayList != null) {
            int n = arrayList.size();
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                if (e instanceof Double) {
                    dArray[i] = (Double)e;
                    continue;
                }
                if (e instanceof Float) {
                    dArray[i] = ((Float)e).floatValue();
                    continue;
                }
                if (e instanceof Long) {
                    dArray[i] = ((Long)e).longValue();
                    continue;
                }
                if (e instanceof Integer) {
                    dArray[i] = ((Integer)e).intValue();
                    continue;
                }
                if (e instanceof Short) {
                    dArray[i] = ((Short)e).shortValue();
                    continue;
                }
                if (e instanceof Byte) {
                    dArray[i] = ((Byte)e).byteValue();
                    continue;
                }
                if (e instanceof BigDecimal) {
                    dArray[i] = ((BigDecimal)e).doubleValue();
                    continue;
                }
                if (e instanceof BigInteger) {
                    dArray[i] = ((BigInteger)e).doubleValue();
                    continue;
                }
                throw new IllegalArgumentException("Element " + i + " is not convertible to double");
            }
        }
        return dArray;
    }

    public static long[] ArrayList_to_longs(ArrayList arrayList) {
        return Conv.convert_ArrayList_to_longs(arrayList);
    }

    public static long[] convert_ArrayList_to_longs(ArrayList arrayList) {
        long[] lArray = null;
        if (arrayList != null) {
            int n = arrayList.size();
            lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                if (e instanceof Double) {
                    lArray[i] = (long)((Double)e).doubleValue();
                    continue;
                }
                if (e instanceof Float) {
                    lArray[i] = (long)((Float)e).floatValue();
                    continue;
                }
                if (e instanceof Long) {
                    lArray[i] = (Long)e;
                    continue;
                }
                if (e instanceof Integer) {
                    lArray[i] = ((Integer)e).intValue();
                    continue;
                }
                if (e instanceof Short) {
                    lArray[i] = ((Short)e).shortValue();
                    continue;
                }
                if (e instanceof Byte) {
                    lArray[i] = ((Byte)e).byteValue();
                    continue;
                }
                if (e instanceof BigDecimal) {
                    lArray[i] = ((BigDecimal)e).longValue();
                    continue;
                }
                if (e instanceof BigInteger) {
                    lArray[i] = ((BigInteger)e).longValue();
                    continue;
                }
                throw new IllegalArgumentException("Element " + i + " is not convertible to double");
            }
        }
        return lArray;
    }

    public static int[] ArrayList_to_ints(ArrayList arrayList) {
        return Conv.convert_ArrayList_to_ints(arrayList);
    }

    public static int[] convert_ArrayList_to_ints(ArrayList arrayList) {
        int[] nArray = null;
        if (arrayList != null) {
            int n = arrayList.size();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                if (e instanceof Double) {
                    nArray[i] = (int)((Double)e).doubleValue();
                    continue;
                }
                if (e instanceof Float) {
                    nArray[i] = (int)((Float)e).floatValue();
                    continue;
                }
                if (e instanceof Long) {
                    nArray[i] = (int)((Long)e).longValue();
                    continue;
                }
                if (e instanceof Integer) {
                    nArray[i] = (Integer)e;
                    continue;
                }
                if (e instanceof Short) {
                    nArray[i] = ((Short)e).shortValue();
                    continue;
                }
                if (e instanceof Byte) {
                    nArray[i] = ((Byte)e).byteValue();
                    continue;
                }
                if (e instanceof BigDecimal) {
                    nArray[i] = ((BigDecimal)e).intValue();
                    continue;
                }
                if (e instanceof BigInteger) {
                    nArray[i] = ((BigInteger)e).intValue();
                    continue;
                }
                throw new IllegalArgumentException("Element " + i + " is not convertible to double");
            }
        }
        return nArray;
    }

    public static Double convert_double_to_Double(double d) {
        return new Double(d);
    }

    public static double convert_Double_to_double(Double d) {
        return d;
    }

    public static float convert_double_to_float(double d) {
        if (d > max_float_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_double_to_float: possible loss of precision");
        }
        return new Double(d).floatValue();
    }

    public static Float convert_double_to_Float(double d) {
        if (d > max_float_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_double_to_Float: possible loss of precision");
        }
        return new Float(new Double(d).floatValue());
    }

    public static float convert_Double_to_float(Double d) {
        double d2 = d;
        if (d2 > max_float_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Double_to_float: possible loss of precision");
        }
        return d.floatValue();
    }

    public static Float convert_Double_to_Float(Double d) {
        double d2 = d;
        if (d2 > max_float_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as Float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Double_to_Float: possible loss of precision");
        }
        return new Float(d2);
    }

    public static long convert_double_to_long(double d) {
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as long");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Double(d).longValue();
    }

    public static Long convert_double_to_Long(double d) {
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as long");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Long(new Double(d).longValue());
    }

    public static long convert_Double_to_long(Double d) {
        double d2 = d;
        if (d2 > max_long_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as long");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return d.longValue();
    }

    public static Long convert_Double_to_Long(Double d) {
        double d2 = d;
        if (d2 > max_long_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as Long");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return new Long(d.longValue());
    }

    public static int convert_double_to_int(double d) {
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as int");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Double(d).intValue();
    }

    public static Integer convert_double_to_Integer(double d) {
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as int");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Integer(new Double(d).intValue());
    }

    public static int convert_Double_to_int(Double d) {
        double d2 = d;
        if (d2 > max_int_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as int");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return d.intValue();
    }

    public static Integer convert_Double_to_Integer(Double d) {
        double d2 = d;
        if (d2 > max_int_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as Integer");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return new Integer(d.intValue());
    }

    public static short convert_double_to_short(double d) {
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as short");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Double(d).shortValue();
    }

    public static Short convert_double_to_Short(double d) {
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as short");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Short(new Double(d).shortValue());
    }

    public static short convert_Double_to_short(Double d) {
        double d2 = d;
        if (d2 > max_short_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as short");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return d.shortValue();
    }

    public static Short convert_Double_to_Short(Double d) {
        double d2 = d;
        if (d2 > max_short_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as Short");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return new Short(d.shortValue());
    }

    public static byte convert_double_to_byte(double d) {
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as byte");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Double(d).byteValue();
    }

    public static Byte convert_double_to_Byte(double d) {
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as byte");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Byte(new Double(d).byteValue());
    }

    public static byte convert_Double_to_byte(Double d) {
        double d2 = d;
        if (d2 > max_byte_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as byte");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return d.byteValue();
    }

    public static Byte convert_Double_to_Byte(Double d) {
        double d2 = d;
        if (d2 > max_byte_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as Byte");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return new Byte(d.byteValue());
    }

    public static BigDecimal convert_double_to_BigDecimal(double d) {
        return new BigDecimal(d);
    }

    public static BigDecimal convert_Double_to_BigDecimal(Double d) {
        return new BigDecimal(d);
    }

    public static BigInteger convert_double_to_BigInteger(double d) {
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new BigInteger(Double.toString(d));
    }

    public static BigInteger convert_Double_to_BigInteger(Double d) {
        double d2 = d;
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new BigInteger(Double.toString(d2).trim());
    }

    public static String convert_double_to_String(double d) {
        return Double.toString(d).trim();
    }

    public static String convert_Double_to_String(Double d) {
        return Double.toString(d).trim();
    }

    public static Float convert_float_to_Float(float f) {
        return new Float(f);
    }

    public static float convert_Float_to_float(Float f) {
        return f.floatValue();
    }

    public static double convert_float_to_double(float f) {
        return new Float(f).doubleValue();
    }

    public static Double convert_float_to_Double(float f) {
        return new Double(new Float(f).doubleValue());
    }

    public static double convert_Float_to_double(Float f) {
        return f.doubleValue();
    }

    public static Double convert_Float_to_Double(Float f) {
        return new Double(f.doubleValue());
    }

    public static long convert_float_to_long(float f) {
        if ((double)f > max_long_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as long");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Float(f).longValue();
    }

    public static Long convert_float_to_Long(float f) {
        if ((double)f > max_long_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as long");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Long(new Float(f).longValue());
    }

    public static long convert_Float_to_long(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_long_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as long");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return f.longValue();
    }

    public static Long convert_Float_to_Long(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_long_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as Long");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return new Long(f.longValue());
    }

    public static int convert_float_to_int(float f) {
        if ((double)f > max_int_as_float) {
            throw new IllegalArgumentException("double is too large to be recast as int");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Float(f).intValue();
    }

    public static Integer convert_float_to_Integer(float f) {
        if ((double)f > max_int_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as int");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Integer(new Float(f).intValue());
    }

    public static int convert_Float_to_int(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_int_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as int");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return f.intValue();
    }

    public static Integer convert_Float_to_Integer(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_int_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as Integer");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return new Integer(f.intValue());
    }

    public static short convert_float_to_short(float f) {
        if ((double)f > max_short_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as short");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Float(f).shortValue();
    }

    public static Short convert_float_to_Short(float f) {
        if ((double)f > max_short_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as short");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Short(new Float(f).shortValue());
    }

    public static short convert_Float_to_short(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_short_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as short");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return f.shortValue();
    }

    public static Short convert_Float_to_Short(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_short_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as Short");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return new Short(f.shortValue());
    }

    public static byte convert_float_to_byte(float f) {
        if ((double)f > max_byte_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as byte");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Float(f).byteValue();
    }

    public static Byte convert_float_to_Byte(float f) {
        if ((double)f > max_byte_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as byte");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Byte(new Float(f).byteValue());
    }

    public static byte convert_Float_to_byte(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_byte_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as byte");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return f.byteValue();
    }

    public static Byte convert_Float_to_Byte(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_byte_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as Byte");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return new Byte(f.byteValue());
    }

    public static BigDecimal convert_float_to_BigDecimal(float f) {
        return new BigDecimal(f);
    }

    public static BigDecimal convert_Float_to_BigDecimal(Float f) {
        return new BigDecimal(f.doubleValue());
    }

    public static BigInteger convert_double_to_BigInteger(float f) {
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new BigInteger(Float.toString(f).trim());
    }

    public static BigInteger convert_Float_to_BigInteger(Float f) {
        double d = f.doubleValue();
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return new BigInteger(Double.toString(d).trim());
    }

    public static String convert_float_to_String(float f) {
        return Float.toString(f).trim();
    }

    public static String convert_Float_to_String(Float f) {
        return Float.toString(f.floatValue()).trim();
    }

    public static Long convert_long_to_Long(long l) {
        return new Long(l);
    }

    public static long convert_Long_to_long(Long l) {
        return l;
    }

    public static double convert_long_to_double(long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_long_to_double: possible loss of precision");
        }
        return new Long(l).doubleValue();
    }

    public static Double convert_long_to_Double(long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_long_to_Double: possible loss of precision");
        }
        return new Double(new Long(l).doubleValue());
    }

    public static double convert_Long_to_double(Long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Long_to_double: possible loss of precision");
        }
        return l.doubleValue();
    }

    public static Double convert_Long_to_Double(Long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Long_to_Double: possible loss of precision");
        }
        return new Double(l.doubleValue());
    }

    public static float convert_long_to_float(long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_long_to_float: possible loss of precision");
        }
        return new Long(l).floatValue();
    }

    public static Float convert_long_to_Float(long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_long_to_Float: possible loss of precision");
        }
        return new Float(new Long(l).floatValue());
    }

    public static float convert_Long_to_float(Long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Long_to_float: possible loss of precision");
        }
        return l.floatValue();
    }

    public static Float convert_Long_to_Float(Long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Long_to_Float: possible loss of precision");
        }
        return new Float(l.floatValue());
    }

    public static int convert_long_to_int(long l) {
        if ((double)l > max_int_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as int");
        }
        return new Float(l).intValue();
    }

    public static Integer convert_long_to_Integer(long l) {
        if ((double)l > max_int_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as Integer");
        }
        return new Integer(new Long(l).intValue());
    }

    public static int convert_Long_to_int(Long l) {
        long l2 = l;
        if ((double)l2 > max_int_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as int");
        }
        return l.intValue();
    }

    public static Integer convert_Long_to_Integer(Long l) {
        long l2 = l;
        if ((double)l2 > max_int_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as Integer");
        }
        return new Integer(l.intValue());
    }

    public static short convert_long_to_short(long l) {
        if ((double)l > max_short_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as short");
        }
        return new Long(l).shortValue();
    }

    public static Short convert_long_to_Short(long l) {
        if ((double)l > max_short_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as Short");
        }
        return new Short(new Long(l).shortValue());
    }

    public static short convert_Long_to_short(Long l) {
        long l2 = l;
        if ((double)l2 > max_short_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as short");
        }
        return l.shortValue();
    }

    public static Short convert_Long_to_Short(Long l) {
        long l2 = l;
        if ((double)l2 > max_short_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as Short");
        }
        return new Short(l.shortValue());
    }

    public static byte convert_long_to_byte(long l) {
        if ((double)l > max_byte_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as byte");
        }
        return new Long(l).byteValue();
    }

    public static Byte convert_long_to_Byte(long l) {
        if ((double)l > max_byte_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as Byte");
        }
        return new Byte(new Long(l).byteValue());
    }

    public static byte convert_Long_to_byte(Long l) {
        long l2 = l;
        if ((double)l2 > max_byte_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as byte");
        }
        return l.byteValue();
    }

    public static Byte convert_Long_to_Byte(Long l) {
        long l2 = l;
        if ((double)l2 > max_byte_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as Byte");
        }
        return new Byte(l.byteValue());
    }

    public static BigDecimal convert_long_to_BigDecimal(long l) {
        return new BigDecimal(new Long(l).toString());
    }

    public static BigDecimal convert_Long_to_BigDecimal(Long l) {
        return new BigDecimal(l.toString().trim());
    }

    public static BigInteger convert_long_to_BigInteger(long l) {
        return new BigInteger(Long.toString(l).trim());
    }

    public static BigInteger convert_Long_to_BigInteger(Long l) {
        double d = l.doubleValue();
        return new BigInteger(l.toString().trim());
    }

    public static String convert_long_to_String(long l) {
        return Long.toString(l).trim();
    }

    public static String convert_Long_to_String(Long l) {
        return Long.toString(l).trim();
    }

    public static Integer convert_int_to_Integer(int n) {
        return new Integer(n);
    }

    public static int convert_Integer_to_int(Integer n) {
        return n;
    }

    public static double convert_int_to_double(int n) {
        return new Integer(n).doubleValue();
    }

    public static Double convert_int_to_Double(int n) {
        return new Double(new Integer(n).doubleValue());
    }

    public static double convert_Integer_to_double(Integer n) {
        return n.doubleValue();
    }

    public static Double convert_Integer_to_Double(Integer n) {
        return new Double(n.doubleValue());
    }

    public static float convert_int_to_float(int n) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_int_to_float: possible loss of precision");
        }
        return new Integer(n).floatValue();
    }

    public static Float convert_int_to_Float(int n) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_int_to_Float: possible loss of precision");
        }
        return new Float(new Integer(n).floatValue());
    }

    public static float convert_Integer_to_float(Integer n) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Integer_to_float: possible loss of precision");
        }
        return n.floatValue();
    }

    public static Float convert_Integer_to_Float(Integer n) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Integer_to_Float: possible loss of precision");
        }
        return new Float(n.floatValue());
    }

    public static long convert_int_to_long(int n) {
        return new Integer(n).longValue();
    }

    public static Long convert_int_to_Long(int n) {
        return new Long(new Integer(n).longValue());
    }

    public static long convert_Integer_to_long(Integer n) {
        return n.longValue();
    }

    public static Long convert_Integer_to_Long(Integer n) {
        return new Long(n.longValue());
    }

    public static short convert_int_to_short(int n) {
        if ((double)n > max_short_as_int) {
            throw new IllegalArgumentException("int is too large to be recast as short");
        }
        return new Integer(n).shortValue();
    }

    public static Short convert_int_to_Short(int n) {
        if ((double)n > max_short_as_int) {
            throw new IllegalArgumentException("int is too large to be recast as Short");
        }
        return new Short(new Integer(n).shortValue());
    }

    public static short convert_Integer_to_short(Integer n) {
        int n2 = n;
        if ((double)n2 > max_short_as_int) {
            throw new IllegalArgumentException("Integer is too large to be recast as short");
        }
        return n.shortValue();
    }

    public static Short convert_Integer_to_Short(Integer n) {
        int n2 = n;
        if ((double)n2 > max_short_as_int) {
            throw new IllegalArgumentException("Integer is too large to be recast as Short");
        }
        return new Short(n.shortValue());
    }

    public static byte convert_int_to_byte(int n) {
        if ((double)n > max_byte_as_int) {
            throw new IllegalArgumentException("int is too large to be recast as byte");
        }
        return new Integer(n).byteValue();
    }

    public static Byte convert_int_to_Byte(int n) {
        if ((double)n > max_byte_as_int) {
            throw new IllegalArgumentException("int is too large to be recast as Byte");
        }
        return new Byte(new Integer(n).byteValue());
    }

    public static byte convert_Integer_to_byte(Integer n) {
        int n2 = n;
        if ((double)n2 > max_byte_as_int) {
            throw new IllegalArgumentException("Integer is too large to be recast as byte");
        }
        return n.byteValue();
    }

    public static Byte convert_Integer_to_Byte(Integer n) {
        int n2 = n;
        if ((double)n2 > max_byte_as_int) {
            throw new IllegalArgumentException("Integer is too large to be recast as Byte");
        }
        return new Byte(n.byteValue());
    }

    public static BigDecimal convert_int_to_BigDecimal(int n) {
        return new BigDecimal(new Integer(n).toString());
    }

    public static BigDecimal convert_Integer_to_BigDecimal(Integer n) {
        return new BigDecimal(n.toString().trim());
    }

    public static BigInteger convert_int_to_BigInteger(int n) {
        return new BigInteger(Long.toString(n).trim());
    }

    public static BigInteger convert_Integer_to_BigInteger(Integer n) {
        return new BigInteger(n.toString().trim());
    }

    public static String convert_int_to_String(int n) {
        return Integer.toString(n).trim();
    }

    public static String convert_Integer_to_String(Integer n) {
        return Integer.toString(n).trim();
    }

    public static char convert_int_to_char(int n) {
        return (char)n;
    }

    public static Short convert_short_to_Short(short s) {
        return new Short(s);
    }

    public static short convert_Short_to_short(Short s) {
        return s;
    }

    public static double convert_short_to_double(short s) {
        return new Short(s).doubleValue();
    }

    public static Double convert_short_to_Double(short s) {
        return new Double(new Short(s).doubleValue());
    }

    public static double convert_Short_to_double(Short s) {
        return s.doubleValue();
    }

    public static Double convert_Short_to_Double(Short s) {
        return new Double(s.doubleValue());
    }

    public static float convert_short_to_float(short s) {
        return new Short(s).floatValue();
    }

    public static Float convert_short_to_Float(short s) {
        return new Float(new Short(s).floatValue());
    }

    public static float convert_Short_to_float(Short s) {
        return s.floatValue();
    }

    public static Float convert_Short_to_Float(Short s) {
        return new Float(s.floatValue());
    }

    public static long convert_short_to_long(short s) {
        return new Short(s).longValue();
    }

    public static Long convert_short_to_Long(short s) {
        return new Long(new Short(s).longValue());
    }

    public static long convert_Short_to_long(Short s) {
        return s.longValue();
    }

    public static Long convert_Short_to_Long(Short s) {
        return new Long(s.longValue());
    }

    public static int convert_short_to_int(short s) {
        return new Short(s).intValue();
    }

    public static Integer convert_short_to_Integer(short s) {
        return new Integer(new Short(s).intValue());
    }

    public static int convert_Short_to_int(Short s) {
        return s.intValue();
    }

    public static Integer convert_Short_to_Integer(Short s) {
        return new Integer(s.intValue());
    }

    public static byte convert_short_to_byte(short s) {
        if ((double)s > max_byte_as_short) {
            throw new IllegalArgumentException("short is too large to be recast as byte");
        }
        return new Short(s).byteValue();
    }

    public static Byte convert_short_to_Byte(short s) {
        if ((double)s > max_byte_as_short) {
            throw new IllegalArgumentException("short is too large to be recast as Byte");
        }
        return new Byte(new Short(s).byteValue());
    }

    public static byte convert_Short_to_byte(Short s) {
        short s2 = s;
        if ((double)s2 > max_byte_as_short) {
            throw new IllegalArgumentException("Short is too large to be recast as byte");
        }
        return s.byteValue();
    }

    public static Byte convert_Short_to_Byte(Short s) {
        short s2 = s;
        if ((double)s2 > max_byte_as_short) {
            throw new IllegalArgumentException("Short is too large to be recast as Byte");
        }
        return new Byte(s.byteValue());
    }

    public static BigDecimal convert_short_to_BigDecimal(short s) {
        return new BigDecimal(new Short(s).toString().trim());
    }

    public static BigDecimal convert_Short_to_BigDecimal(Short s) {
        return new BigDecimal(s.toString().trim());
    }

    public static BigInteger convert_short_to_BigInteger(short s) {
        return new BigInteger(Short.toString(s).trim());
    }

    public static BigInteger convert_Short_to_BigInteger(Short s) {
        return new BigInteger(s.toString().trim());
    }

    public static String convert_short_to_String(short s) {
        return Short.toString(s).trim();
    }

    public static String convert_Short_to_String(Short s) {
        return Short.toString(s).trim();
    }

    public static Byte convert_byte_to_Byte(byte by) {
        return new Byte(by);
    }

    public static byte convert_Byte_to_byte(Byte by) {
        return by;
    }

    public static double convert_byte_to_double(byte by) {
        return new Byte(by).doubleValue();
    }

    public static Double convert_byte_to_Double(byte by) {
        return new Double(new Byte(by).doubleValue());
    }

    public static double convert_Byte_to_double(Byte by) {
        return by.doubleValue();
    }

    public static Double convert_Byte_to_Double(Byte by) {
        return new Double(by.doubleValue());
    }

    public static float convert_byte_to_float(byte by) {
        return new Byte(by).floatValue();
    }

    public static Float convert_byte_to_Float(byte by) {
        return new Float(new Byte(by).floatValue());
    }

    public static float convert_Byte_to_float(Byte by) {
        return by.floatValue();
    }

    public static Float convert_Byte_to_Float(Byte by) {
        return new Float(by.floatValue());
    }

    public static long convert_byte_to_long(byte by) {
        return new Byte(by).longValue();
    }

    public static Long convert_byte_to_Long(byte by) {
        return new Long(new Byte(by).longValue());
    }

    public static long convert_Byte_to_long(Byte by) {
        return by.longValue();
    }

    public static Long convert_Byte_to_Long(Byte by) {
        return new Long(by.longValue());
    }

    public static int convert_byte_to_int(byte by) {
        return new Byte(by).intValue();
    }

    public static Integer convert_byte_to_Integer(byte by) {
        return new Integer(new Byte(by).intValue());
    }

    public static int convert_Byte_to_int(Byte by) {
        return by.intValue();
    }

    public static Integer convert_Byte_to_Integer(Byte by) {
        return new Integer(by.intValue());
    }

    public static short convert_byte_to_short(byte by) {
        return new Byte(by).shortValue();
    }

    public static Short convert_byte_to_Short(byte by) {
        return new Short(new Byte(by).shortValue());
    }

    public static short convert_Byte_to_short(Byte by) {
        return by.shortValue();
    }

    public static Short convert_Byte_to_Short(Byte by) {
        return new Short(by.shortValue());
    }

    public static BigDecimal convert_byte_to_BigDecimal(byte by) {
        return new BigDecimal(new Byte(by).toString().trim());
    }

    public static BigDecimal convert_Byte_to_BigDecimal(Byte by) {
        return new BigDecimal(by.toString().trim());
    }

    public static BigInteger convert_byte_to_BigInteger(byte by) {
        return new BigInteger(Byte.toString(by).trim());
    }

    public static BigInteger convert_Byte_to_BigInteger(Byte by) {
        return new BigInteger(by.toString().trim());
    }

    public static String convert_byte_to_String(byte by) {
        return Byte.toString(by).trim();
    }

    public static String convert_Byte_to_String(Byte by) {
        return Byte.toString(by).trim();
    }

    public static double convert_BigDecimal_to_double(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as double");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigDecimal_to_double: possible loss of precision");
        }
        return d;
    }

    public static Double convert_BigDecimal_to_Double(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as double");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigDecimal_to_double: possible loss of precision");
        }
        return new Double(d);
    }

    public static float convert_BigDecimal_to_float(BigDecimal bigDecimal) {
        float f = bigDecimal.floatValue();
        if (Fmath.isInfinity(f)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigDecimal_to_float: possible loss of precision");
        }
        return f;
    }

    public static Float convert_BigDecimal_to_Float(BigDecimal bigDecimal) {
        float f = bigDecimal.floatValue();
        if (Fmath.isInfinity(f)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigDecimal_to_float: possible loss of precision");
        }
        return new Float(f);
    }

    public static long convert_BigDecimal_to_long(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as long");
        }
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as long");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return bigDecimal.longValue();
    }

    public static Long convert_BigDecimal_to_Long(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Long");
        }
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Long");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return new Long(bigDecimal.longValue());
    }

    public static int convert_BigDecimal_to_int(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as int");
        }
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as int");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return bigDecimal.intValue();
    }

    public static Integer convert_BigDecimal_to_Integer(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Integer");
        }
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Integer");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return new Integer(bigDecimal.intValue());
    }

    public static short convert_BigDecimal_to_short(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as short");
        }
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as short");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return bigDecimal.shortValue();
    }

    public static Short convert_BigDecimal_to_Short(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Short");
        }
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Short");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return new Short(bigDecimal.shortValue());
    }

    public static byte convert_BigDecimal_to_byte(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as byte");
        }
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as byte");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return bigDecimal.byteValue();
    }

    public static Byte convert_BigDecimal_to_Byte(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Byte");
        }
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Byte");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return new Byte(bigDecimal.byteValue());
    }

    public static BigInteger convert_BigDecimal_to_BigInteger(BigDecimal bigDecimal) {
        String string = bigDecimal.toString().trim();
        int n = string.indexOf(46);
        int n2 = string.indexOf(69);
        String string2 = null;
        if (n == -1) {
            return bigDecimal.toBigInteger();
        }
        string2 = n2 == -1 ? string.substring(n + 1) : string.substring(n + 1, n2);
        int n3 = string2.length();
        boolean bl = true;
        boolean bl2 = true;
        int n4 = 0;
        while (bl) {
            if (string2.charAt(n4) != '0') {
                bl = false;
                bl2 = false;
                continue;
            }
            if (++n4 != n3) continue;
            bl = false;
        }
        if (bl2) {
            return bigDecimal.toBigInteger();
        }
        throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
    }

    public static String convert_BigDecimal_to_String(BigDecimal bigDecimal) {
        return bigDecimal.toEngineeringString().trim();
    }

    public static double convert_BigInteger_to_double(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as double");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigInteger_to_double: possible loss of precision");
        }
        return d;
    }

    public static Double convert_BigInteger_to_Double(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as double");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigInteger_to_double: possible loss of precision");
        }
        return new Double(d);
    }

    public static float convert_BigInteger_to_float(BigInteger bigInteger) {
        float f = bigInteger.floatValue();
        if (Fmath.isInfinity(f)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigInteger_to_float: possible loss of precision");
        }
        return f;
    }

    public static Float convert_BigInteger_to_Float(BigInteger bigInteger) {
        float f = bigInteger.floatValue();
        if (Fmath.isInfinity(f)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigInteger_to_float: possible loss of precision");
        }
        return new Float(f);
    }

    public static long convert_BigInteger_to_long(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as long");
        }
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as long");
        }
        return bigInteger.longValue();
    }

    public static Long convert_BigInteger_to_Long(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Long");
        }
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Long");
        }
        return new Long(bigInteger.longValue());
    }

    public static int convert_BigInteger_to_int(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as int");
        }
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as int");
        }
        return bigInteger.intValue();
    }

    public static Integer convert_BigInteger_to_Integer(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Integer");
        }
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Integer");
        }
        return new Integer(bigInteger.intValue());
    }

    public static short convert_BigInteger_to_short(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as short");
        }
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as short");
        }
        return bigInteger.shortValue();
    }

    public static Short convert_BigInteger_to_Short(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Short");
        }
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Short");
        }
        return new Short(bigInteger.shortValue());
    }

    public static byte convert_BigInteger_to_byte(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as byte");
        }
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as byte");
        }
        return bigInteger.byteValue();
    }

    public static Byte convert_BigInteger_to_Byte(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Byte");
        }
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Byte");
        }
        return new Byte(bigInteger.byteValue());
    }

    public static BigDecimal convert_BigInteger_to_BigDecimal(BigInteger bigInteger) {
        return new BigDecimal(bigInteger);
    }

    public static String convert_BigInteger_to_String(BigInteger bigInteger) {
        return bigInteger.toString().trim();
    }

    public static Phasor convert_Complex_to_Phasor(Complex complex) {
        double d = complex.abs();
        double d2 = complex.argDeg();
        return new Phasor(d, d2);
    }

    public static String convert_Complex_to_String(Complex complex) {
        return complex.toString().trim();
    }

    public static Complex convert_Phasor_to_Complex(Phasor phasor) {
        return phasor.toComplex();
    }

    public static String convert_Phasor_to_String(Phasor phasor) {
        return phasor.toString().trim();
    }

    public static double convert_char_to_double(char c) {
        char c2 = c;
        return Conv.convert_int_to_double(c2);
    }

    public static Double convert_char_to_Double(char c) {
        char c2 = c;
        return Conv.convert_int_to_Double(c2);
    }

    public static double convert_Character_to_double(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_double(n);
    }

    public static Double convert_Character_to_Double(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_Double(n);
    }

    public static float convert_char_to_float(char c) {
        char c2 = c;
        return Conv.convert_int_to_float(c2);
    }

    public static Float convert_char_to_Float(char c) {
        char c2 = c;
        return Conv.convert_int_to_Float(c2);
    }

    public static float convert_Character_to_float(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_float(n);
    }

    public static Float convert_Character_to_Float(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_Float(n);
    }

    public static long convert_char_to_long(char c) {
        char c2 = c;
        return Conv.convert_int_to_long(c2);
    }

    public static Long convert_char_to_Long(char c) {
        char c2 = c;
        return Conv.convert_int_to_Long(c2);
    }

    public static long convert_Character_to_long(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_long(n);
    }

    public static Long convert_Character_to_Long(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_Long(n);
    }

    public static int convert_char_to_int(char c) {
        return c;
    }

    public static Integer convert_char_to_Integer(char c) {
        return new Integer(c);
    }

    public static int convert_Character_to_int(Character c) {
        return Character.getNumericValue(c.charValue());
    }

    public static Integer convert_Character_to_Integer(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return new Integer(n);
    }

    public static short convert_char_to_short(char c) {
        char c2 = c;
        return Conv.convert_int_to_short(c2);
    }

    public static Short convert_char_to_Short(char c) {
        char c2 = c;
        return Conv.convert_int_to_Short(c2);
    }

    public static short convert_Character_to_short(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_short(n);
    }

    public static Short convert_Character_to_Short(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_Short(n);
    }

    public static byte convert_char_to_byte(char c) {
        char c2 = c;
        return Conv.convert_int_to_byte(c2);
    }

    public static Byte convert_char_to_Byte(char c) {
        char c2 = c;
        return Conv.convert_int_to_Byte(c2);
    }

    public static byte convert_Character_to_byte(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_byte(n);
    }

    public static Byte convert_Character_to_Byte(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_Byte(n);
    }

    public static String convert_char_to_String(char c) {
        return Character.toString(c).trim();
    }

    public static String convert_Character_to_String(Character c) {
        return c.toString().trim();
    }

    public static Character convert_char_to_Character(char c) {
        return new Character(c);
    }

    public static char convert_Character_to_char(Character c) {
        return c.charValue();
    }

    public static BigDecimal convert_char_to_BigDecimal(char c) {
        return new BigDecimal(Conv.convert_char_to_String(c).trim());
    }

    public static BigDecimal convert_Character_to_BigDecimal(Character c) {
        return new BigDecimal(Conv.convert_Character_to_String(c).trim());
    }

    public static BigInteger convert_char_to_BigInteger(char c) {
        return new BigInteger(Conv.convert_char_to_String(c).trim());
    }

    public static BigInteger convert_Character_to_BigInteger(Character c) {
        return new BigInteger(Conv.convert_char_to_String(c.charValue()).trim());
    }

    public static double convert_String_to_double(String string) {
        return Double.parseDouble(string.trim());
    }

    public static Double convert_String_to_Double(String string) {
        return Double.valueOf(string.trim());
    }

    public static float convert_String_to_float(String string) {
        return Float.parseFloat(string.trim());
    }

    public static Float convert_String_to_Float(String string) {
        return Float.valueOf(string.trim());
    }

    public static long convert_String_to_long(String string) {
        return Long.parseLong(string.trim());
    }

    public static Long convert_String_to_Long(String string) {
        return Long.valueOf(string.trim());
    }

    public static int convert_String_to_int(String string) {
        return Integer.parseInt(string.trim());
    }

    public static Integer convert_String_to_Integer(String string) {
        return Integer.valueOf(string.trim());
    }

    public static short convert_String_to_short(String string) {
        return Short.parseShort(string.trim());
    }

    public static Short convert_String_to_Short(String string) {
        return Short.valueOf(string.trim());
    }

    public static byte convert_String_to_byte(String string) {
        return Byte.parseByte(string.trim());
    }

    public static Byte convert_String_to_Byte(String string) {
        return Byte.valueOf(string.trim());
    }

    public static BigDecimal convert_String_to_BigDecimal(String string) {
        return new BigDecimal(string.trim());
    }

    public static BigInteger convert_String_to_BigInteger(String string) {
        return new BigInteger(string.trim());
    }

    public static String toTitleCase(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
            nArray2[n] = stringArray[n].length();
            nArray[n] = string.indexOf(stringArray[n]);
            nArray3[n] = nArray[n] + nArray2[n];
            stringArray[n] = stringArray[n].substring(0, 1).toUpperCase() + stringArray[n].substring(1).toLowerCase();
        }
        for (n = 1; n < n2; ++n) {
            nArray4[n - 1] = nArray[n] - nArray3[n - 1];
        }
        nArray4[n2 - 1] = string.length() - nArray3[n2 - 1] - 1;
        if (nArray[0] > 0) {
            for (n = 0; n < nArray[0]; ++n) {
                string2 = string2 + " ";
            }
        }
        for (n = 0; n < n2; ++n) {
            string2 = string2 + stringArray[n];
            for (int i = 0; i < nArray4[n]; ++i) {
                string2 = string2 + " ";
            }
        }
        return string2;
    }

    public static double[] copy(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    public static float[] copy(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray2[i] = fArray[i];
        }
        return fArray2;
    }

    public static int[] copy(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    public static long[] copy(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[] lArray2 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray2[i] = lArray[i];
        }
        return lArray2;
    }

    public static double[][] copy(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = dArray[i].length;
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                dArrayArray[i][j] = dArray[i][j];
            }
        }
        return dArrayArray;
    }

    public static float[][] copy(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[][] fArrayArray = new float[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = fArray[i].length;
            fArrayArray[i] = new float[n2];
            for (int j = 0; j < n2; ++j) {
                fArrayArray[i][j] = fArray[i][j];
            }
        }
        return fArrayArray;
    }

    public static int[][] copy(int[][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i].length;
            nArrayArray[i] = new int[n2];
            for (int j = 0; j < n2; ++j) {
                nArrayArray[i][j] = nArray[i][j];
            }
        }
        return nArrayArray;
    }

    public static long[][] copy(long[][] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[][] lArrayArray = new long[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = lArray[i].length;
            lArrayArray[i] = new long[n2];
            for (int j = 0; j < n2; ++j) {
                lArrayArray[i][j] = lArray[i][j];
            }
        }
        return lArrayArray;
    }

    public static double[][][] copy(double[][][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[][][] dArrayArray = new double[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = dArray[i].length;
            dArrayArray[i] = new double[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = dArray[i][j].length;
                dArrayArray[i][j] = new double[n3];
                for (int k = 0; k < n3; ++k) {
                    dArrayArray[i][j][k] = dArray[i][j][k];
                }
            }
        }
        return dArrayArray;
    }

    public static float[][][] copy(float[][][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[][][] fArrayArray = new float[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = fArray[i].length;
            fArrayArray[i] = new float[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = fArray[i][j].length;
                fArrayArray[i][j] = new float[n3];
                for (int k = 0; k < n3; ++k) {
                    fArrayArray[i][j][k] = fArray[i][j][k];
                }
            }
        }
        return fArrayArray;
    }

    public static int[][][] copy(int[][][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[][][] nArrayArray = new int[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i].length;
            nArrayArray[i] = new int[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = nArray[i][j].length;
                nArrayArray[i][j] = new int[n3];
                for (int k = 0; k < n3; ++k) {
                    nArrayArray[i][j][k] = nArray[i][j][k];
                }
            }
        }
        return nArrayArray;
    }

    public static long[][][] copy(long[][][] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[][][] lArrayArray = new long[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = lArray[i].length;
            lArrayArray[i] = new long[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = lArray[i][j].length;
                lArrayArray[i][j] = new long[n3];
                for (int k = 0; k < n3; ++k) {
                    lArrayArray[i][j][k] = lArray[i][j][k];
                }
            }
        }
        return lArrayArray;
    }

    public static double[][][][] copy(double[][][][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[][][][] dArrayArray = new double[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = dArray[i].length;
            dArrayArray[i] = new double[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = dArray[i][j].length;
                dArrayArray[i][j] = new double[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = dArray[i][j][k].length;
                    dArrayArray[i][j][k] = new double[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        dArrayArray[i][j][k][i2] = dArray[i][j][k][i2];
                    }
                }
            }
        }
        return dArrayArray;
    }

    public static float[][][][] copy(float[][][][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[][][][] fArrayArray = new float[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = fArray[i].length;
            fArrayArray[i] = new float[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = fArray[i][j].length;
                fArrayArray[i][j] = new float[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = fArray[i][j][k].length;
                    fArrayArray[i][j][k] = new float[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        fArrayArray[i][j][k][i2] = fArray[i][j][k][i2];
                    }
                }
            }
        }
        return fArrayArray;
    }

    public static int[][][][] copy(int[][][][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[][][][] nArrayArray = new int[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i].length;
            nArrayArray[i] = new int[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = nArray[i][j].length;
                nArrayArray[i][j] = new int[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = nArray[i][j][k].length;
                    nArrayArray[i][j][k] = new int[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        nArrayArray[i][j][k][i2] = nArray[i][j][k][i2];
                    }
                }
            }
        }
        return nArrayArray;
    }

    public static long[][][][] copy(long[][][][] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[][][][] lArrayArray = new long[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = lArray[i].length;
            lArrayArray[i] = new long[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = lArray[i][j].length;
                lArrayArray[i][j] = new long[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = lArray[i][j][k].length;
                    lArrayArray[i][j][k] = new long[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        lArrayArray[i][j][k][i2] = lArray[i][j][k][i2];
                    }
                }
            }
        }
        return lArrayArray;
    }

    public static String[] copy(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public static String[][] copy(String[][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][] stringArray2 = new String[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].length;
            stringArray2[i] = new String[n2];
            for (int j = 0; j < n2; ++j) {
                stringArray2[i][j] = stringArray[i][j];
            }
        }
        return stringArray2;
    }

    public static String[][][] copy(String[][][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][][] stringArray2 = new String[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].length;
            stringArray2[i] = new String[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = stringArray[i][j].length;
                stringArray2[i][j] = new String[n3];
                for (int k = 0; k < n3; ++k) {
                    stringArray2[i][j][k] = stringArray[i][j][k];
                }
            }
        }
        return stringArray2;
    }

    public static String[][][][] copy(String[][][][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][][][] stringArray2 = new String[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].length;
            stringArray2[i] = new String[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = stringArray[i][j].length;
                stringArray2[i][j] = new String[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = stringArray[i][j][k].length;
                    stringArray2[i][j][k] = new String[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        stringArray2[i][j][k][i2] = stringArray[i][j][k][i2];
                    }
                }
            }
        }
        return stringArray2;
    }

    public static boolean[] copy(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[] blArray2 = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray2[i] = blArray[i];
        }
        return blArray2;
    }

    public static boolean[][] copy(boolean[][] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[][] blArrayArray = new boolean[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = blArray[i].length;
            blArrayArray[i] = new boolean[n2];
            for (int j = 0; j < n2; ++j) {
                blArrayArray[i][j] = blArray[i][j];
            }
        }
        return blArrayArray;
    }

    public static boolean[][][] copy(boolean[][][] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[][][] blArrayArray = new boolean[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = blArray[i].length;
            blArrayArray[i] = new boolean[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = blArray[i][j].length;
                blArrayArray[i][j] = new boolean[n3];
                for (int k = 0; k < n3; ++k) {
                    blArrayArray[i][j][k] = blArray[i][j][k];
                }
            }
        }
        return blArrayArray;
    }

    public static boolean[][][][] copy(boolean[][][][] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[][][][] blArrayArray = new boolean[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = blArray[i].length;
            blArrayArray[i] = new boolean[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = blArray[i][j].length;
                blArrayArray[i][j] = new boolean[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = blArray[i][j][k].length;
                    blArrayArray[i][j][k] = new boolean[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        blArrayArray[i][j][k][i2] = blArray[i][j][k][i2];
                    }
                }
            }
        }
        return blArrayArray;
    }

    public static char[] copy(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[] cArray2 = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray2[i] = cArray[i];
        }
        return cArray2;
    }

    public static char[][] copy(char[][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[][] cArrayArray = new char[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = cArray[i].length;
            cArrayArray[i] = new char[n2];
            for (int j = 0; j < n2; ++j) {
                cArrayArray[i][j] = cArray[i][j];
            }
        }
        return cArrayArray;
    }

    public static char[][][] copy(char[][][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[][][] cArrayArray = new char[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = cArray[i].length;
            cArrayArray[i] = new char[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = cArray[i][j].length;
                cArrayArray[i][j] = new char[n3];
                for (int k = 0; k < n3; ++k) {
                    cArrayArray[i][j][k] = cArray[i][j][k];
                }
            }
        }
        return cArrayArray;
    }

    public static char[][][][] copy(char[][][][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[][][][] cArrayArray = new char[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = cArray[i].length;
            cArrayArray[i] = new char[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = cArray[i][j].length;
                cArrayArray[i][j] = new char[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = cArray[i][j][k].length;
                    cArrayArray[i][j][k] = new char[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        cArrayArray[i][j][k][i2] = cArray[i][j][k][i2];
                    }
                }
            }
        }
        return cArrayArray;
    }

    public static Character[] copy(Character[] characterArray) {
        if (characterArray == null) {
            return null;
        }
        int n = characterArray.length;
        Character[] characterArray2 = new Character[n];
        for (int i = 0; i < n; ++i) {
            characterArray2[i] = characterArray[i];
        }
        return characterArray2;
    }

    public static Character[][] copy(Character[][] characterArray) {
        if (characterArray == null) {
            return null;
        }
        int n = characterArray.length;
        Character[][] characterArray2 = new Character[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = characterArray[i].length;
            characterArray2[i] = new Character[n2];
            for (int j = 0; j < n2; ++j) {
                characterArray2[i][j] = characterArray[i][j];
            }
        }
        return characterArray2;
    }

    public static Character[][][] copy(Character[][][] characterArray) {
        if (characterArray == null) {
            return null;
        }
        int n = characterArray.length;
        Character[][][] characterArray2 = new Character[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = characterArray[i].length;
            characterArray2[i] = new Character[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = characterArray[i][j].length;
                characterArray2[i][j] = new Character[n3];
                for (int k = 0; k < n3; ++k) {
                    characterArray2[i][j][k] = characterArray[i][j][k];
                }
            }
        }
        return characterArray2;
    }

    public static Character[][][][] copy(Character[][][][] characterArray) {
        if (characterArray == null) {
            return null;
        }
        int n = characterArray.length;
        Character[][][][] characterArray2 = new Character[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = characterArray[i].length;
            characterArray2[i] = new Character[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = characterArray[i][j].length;
                characterArray2[i][j] = new Character[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = characterArray[i][j][k].length;
                    characterArray2[i][j][k] = new Character[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        characterArray2[i][j][k][i2] = characterArray[i][j][k][i2];
                    }
                }
            }
        }
        return characterArray2;
    }

    public static Complex[] copy(Complex[] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        Complex[] complexArray2 = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray2[i] = complexArray[i].copy();
        }
        return complexArray2;
    }

    public static Complex[][] copy(Complex[][] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        Complex[][] complexArray2 = new Complex[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = complexArray[i].length;
            complexArray2[i] = new Complex[n2];
            for (int j = 0; j < n2; ++j) {
                complexArray2[i][j] = complexArray[i][j].copy();
            }
        }
        return complexArray2;
    }

    public static Complex[][][] copy(Complex[][][] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        Complex[][][] complexArray2 = new Complex[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = complexArray[i].length;
            complexArray2[i] = new Complex[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = complexArray[i][j].length;
                complexArray2[i][j] = new Complex[n3];
                for (int k = 0; k < n3; ++k) {
                    complexArray2[i][j][k] = complexArray[i][j][k].copy();
                }
            }
        }
        return complexArray2;
    }

    public static Complex[][][][] copy(Complex[][][][] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        Complex[][][][] complexArray2 = new Complex[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = complexArray[i].length;
            complexArray2[i] = new Complex[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = complexArray[i][j].length;
                complexArray2[i][j] = new Complex[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = complexArray[i][j][k].length;
                    complexArray2[i][j][k] = new Complex[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        complexArray2[i][j][k][i2] = complexArray[i][j][k][i2].copy();
                    }
                }
            }
        }
        return complexArray2;
    }

    public static ComplexPoly[] copy(ComplexPoly[] complexPolyArray) {
        if (complexPolyArray == null) {
            return null;
        }
        int n = complexPolyArray.length;
        ComplexPoly[] complexPolyArray2 = new ComplexPoly[n];
        for (int i = 0; i < n; ++i) {
            complexPolyArray2[i] = complexPolyArray[i].copy();
        }
        return complexPolyArray2;
    }

    public static ComplexPoly[][] copy(ComplexPoly[][] complexPolyArray) {
        if (complexPolyArray == null) {
            return null;
        }
        int n = complexPolyArray.length;
        ComplexPoly[][] complexPolyArray2 = new ComplexPoly[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = complexPolyArray[i].length;
            complexPolyArray2[i] = new ComplexPoly[n2];
            for (int j = 0; j < n2; ++j) {
                complexPolyArray2[i][j] = complexPolyArray[i][j].copy();
            }
        }
        return complexPolyArray2;
    }

    public static ComplexPoly[][][] copy(ComplexPoly[][][] complexPolyArray) {
        if (complexPolyArray == null) {
            return null;
        }
        int n = complexPolyArray.length;
        ComplexPoly[][][] complexPolyArray2 = new ComplexPoly[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = complexPolyArray[i].length;
            complexPolyArray2[i] = new ComplexPoly[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = complexPolyArray[i][j].length;
                complexPolyArray2[i][j] = new ComplexPoly[n3];
                for (int k = 0; k < n3; ++k) {
                    complexPolyArray2[i][j][k] = complexPolyArray[i][j][k].copy();
                }
            }
        }
        return complexPolyArray2;
    }

    public static ComplexPoly[][][][] copy(ComplexPoly[][][][] complexPolyArray) {
        if (complexPolyArray == null) {
            return null;
        }
        int n = complexPolyArray.length;
        ComplexPoly[][][][] complexPolyArray2 = new ComplexPoly[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = complexPolyArray[i].length;
            complexPolyArray2[i] = new ComplexPoly[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = complexPolyArray[i][j].length;
                complexPolyArray2[i][j] = new ComplexPoly[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = complexPolyArray[i][j][k].length;
                    complexPolyArray2[i][j][k] = new ComplexPoly[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        complexPolyArray2[i][j][k][i2] = complexPolyArray[i][j][k][i2].copy();
                    }
                }
            }
        }
        return complexPolyArray2;
    }

    public static Polynomial[] copy(Polynomial[] polynomialArray) {
        if (polynomialArray == null) {
            return null;
        }
        int n = polynomialArray.length;
        Polynomial[] polynomialArray2 = new Polynomial[n];
        for (int i = 0; i < n; ++i) {
            polynomialArray2[i] = polynomialArray[i].copy();
        }
        return polynomialArray2;
    }

    public static Polynomial[][] copy(Polynomial[][] polynomialArray) {
        if (polynomialArray == null) {
            return null;
        }
        int n = polynomialArray.length;
        Polynomial[][] polynomialArray2 = new Polynomial[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = polynomialArray[i].length;
            polynomialArray2[i] = new Polynomial[n2];
            for (int j = 0; j < n2; ++j) {
                polynomialArray2[i][j] = polynomialArray[i][j].copy();
            }
        }
        return polynomialArray2;
    }

    public static Polynomial[][][] copy(Polynomial[][][] polynomialArray) {
        if (polynomialArray == null) {
            return null;
        }
        int n = polynomialArray.length;
        Polynomial[][][] polynomialArray2 = new Polynomial[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = polynomialArray[i].length;
            polynomialArray2[i] = new Polynomial[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = polynomialArray[i][j].length;
                polynomialArray2[i][j] = new Polynomial[n3];
                for (int k = 0; k < n3; ++k) {
                    polynomialArray2[i][j][k] = polynomialArray[i][j][k].copy();
                }
            }
        }
        return polynomialArray2;
    }

    public static Polynomial[][][][] copy(Polynomial[][][][] polynomialArray) {
        if (polynomialArray == null) {
            return null;
        }
        int n = polynomialArray.length;
        Polynomial[][][][] polynomialArray2 = new Polynomial[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = polynomialArray[i].length;
            polynomialArray2[i] = new Polynomial[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = polynomialArray[i][j].length;
                polynomialArray2[i][j] = new Polynomial[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = polynomialArray[i][j][k].length;
                    polynomialArray2[i][j][k] = new Polynomial[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        polynomialArray2[i][j][k][i2] = polynomialArray[i][j][k][i2].copy();
                    }
                }
            }
        }
        return polynomialArray2;
    }

    public static BigDecimal[] copy(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray == null) {
            return null;
        }
        int n = bigDecimalArray.length;
        BigDecimal[] bigDecimalArray2 = new BigDecimal[n];
        for (int i = 0; i < n; ++i) {
            bigDecimalArray2[i] = bigDecimalArray[i];
        }
        return bigDecimalArray2;
    }

    public static BigDecimal[][] copy(BigDecimal[][] bigDecimalArray) {
        if (bigDecimalArray == null) {
            return null;
        }
        int n = bigDecimalArray.length;
        BigDecimal[][] bigDecimalArray2 = new BigDecimal[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = bigDecimalArray[i].length;
            bigDecimalArray2[i] = new BigDecimal[n2];
            for (int j = 0; j < n2; ++j) {
                bigDecimalArray2[i][j] = bigDecimalArray[i][j];
            }
        }
        return bigDecimalArray2;
    }

    public static BigDecimal[][][] copy(BigDecimal[][][] bigDecimalArray) {
        if (bigDecimalArray == null) {
            return null;
        }
        int n = bigDecimalArray.length;
        BigDecimal[][][] bigDecimalArray2 = new BigDecimal[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = bigDecimalArray[i].length;
            bigDecimalArray2[i] = new BigDecimal[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = bigDecimalArray[i][j].length;
                bigDecimalArray2[i][j] = new BigDecimal[n3];
                for (int k = 0; k < n3; ++k) {
                    bigDecimalArray2[i][j][k] = bigDecimalArray[i][j][k];
                }
            }
        }
        return bigDecimalArray2;
    }

    public static BigDecimal[][][][] copy(BigDecimal[][][][] bigDecimalArray) {
        if (bigDecimalArray == null) {
            return null;
        }
        int n = bigDecimalArray.length;
        BigDecimal[][][][] bigDecimalArray2 = new BigDecimal[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = bigDecimalArray[i].length;
            bigDecimalArray2[i] = new BigDecimal[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = bigDecimalArray[i][j].length;
                bigDecimalArray2[i][j] = new BigDecimal[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = bigDecimalArray[i][j][k].length;
                    bigDecimalArray2[i][j][k] = new BigDecimal[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        bigDecimalArray2[i][j][k][i2] = bigDecimalArray[i][j][k][i2];
                    }
                }
            }
        }
        return bigDecimalArray2;
    }

    public static BigInteger[] copy(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        int n = bigIntegerArray.length;
        BigInteger[] bigIntegerArray2 = new BigInteger[n];
        for (int i = 0; i < n; ++i) {
            bigIntegerArray2[i] = bigIntegerArray[i];
        }
        return bigIntegerArray2;
    }

    public static BigInteger[][] copy(BigInteger[][] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        int n = bigIntegerArray.length;
        BigInteger[][] bigIntegerArray2 = new BigInteger[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = bigIntegerArray[i].length;
            bigIntegerArray2[i] = new BigInteger[n2];
            for (int j = 0; j < n2; ++j) {
                bigIntegerArray2[i][j] = bigIntegerArray[i][j];
            }
        }
        return bigIntegerArray2;
    }

    public static BigInteger[][][] copy(BigInteger[][][] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        int n = bigIntegerArray.length;
        BigInteger[][][] bigIntegerArray2 = new BigInteger[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = bigIntegerArray[i].length;
            bigIntegerArray2[i] = new BigInteger[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = bigIntegerArray[i][j].length;
                bigIntegerArray2[i][j] = new BigInteger[n3];
                for (int k = 0; k < n3; ++k) {
                    bigIntegerArray2[i][j][k] = bigIntegerArray[i][j][k];
                }
            }
        }
        return bigIntegerArray2;
    }

    public static BigInteger[][][][] copy(BigInteger[][][][] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        int n = bigIntegerArray.length;
        BigInteger[][][][] bigIntegerArray2 = new BigInteger[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = bigIntegerArray[i].length;
            bigIntegerArray2[i] = new BigInteger[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = bigIntegerArray[i][j].length;
                bigIntegerArray2[i][j] = new BigInteger[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = bigIntegerArray[i][j][k].length;
                    bigIntegerArray2[i][j][k] = new BigInteger[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        bigIntegerArray2[i][j][k][i2] = bigIntegerArray[i][j][k][i2];
                    }
                }
            }
        }
        return bigIntegerArray2;
    }

    public static ErrorProp[] copy(ErrorProp[] errorPropArray) {
        if (errorPropArray == null) {
            return null;
        }
        int n = errorPropArray.length;
        ErrorProp[] errorPropArray2 = new ErrorProp[n];
        for (int i = 0; i < n; ++i) {
            errorPropArray2[i] = errorPropArray[i].copy();
        }
        return errorPropArray2;
    }

    public static ErrorProp[][] copy(ErrorProp[][] errorPropArray) {
        if (errorPropArray == null) {
            return null;
        }
        int n = errorPropArray.length;
        ErrorProp[][] errorPropArray2 = new ErrorProp[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = errorPropArray[i].length;
            errorPropArray2[i] = new ErrorProp[n2];
            for (int j = 0; j < n2; ++j) {
                errorPropArray2[i][j] = errorPropArray[i][j].copy();
            }
        }
        return errorPropArray2;
    }

    public static ErrorProp[][][] copy(ErrorProp[][][] errorPropArray) {
        if (errorPropArray == null) {
            return null;
        }
        int n = errorPropArray.length;
        ErrorProp[][][] errorPropArray2 = new ErrorProp[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = errorPropArray[i].length;
            errorPropArray2[i] = new ErrorProp[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = errorPropArray[i][j].length;
                errorPropArray2[i][j] = new ErrorProp[n3];
                for (int k = 0; k < n3; ++k) {
                    errorPropArray2[i][j][k] = errorPropArray[i][j][k].copy();
                }
            }
        }
        return errorPropArray2;
    }

    public static ErrorProp[][][][] copy(ErrorProp[][][][] errorPropArray) {
        if (errorPropArray == null) {
            return null;
        }
        int n = errorPropArray.length;
        ErrorProp[][][][] errorPropArray2 = new ErrorProp[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = errorPropArray[i].length;
            errorPropArray2[i] = new ErrorProp[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = errorPropArray[i][j].length;
                errorPropArray2[i][j] = new ErrorProp[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = errorPropArray[i][j][k].length;
                    errorPropArray2[i][j][k] = new ErrorProp[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        errorPropArray2[i][j][k][i2] = errorPropArray[i][j][k][i2].copy();
                    }
                }
            }
        }
        return errorPropArray2;
    }

    public static ComplexErrorProp[] copy(ComplexErrorProp[] complexErrorPropArray) {
        if (complexErrorPropArray == null) {
            return null;
        }
        int n = complexErrorPropArray.length;
        ComplexErrorProp[] complexErrorPropArray2 = new ComplexErrorProp[n];
        for (int i = 0; i < n; ++i) {
            complexErrorPropArray2[i] = complexErrorPropArray[i].copy();
        }
        return complexErrorPropArray2;
    }

    public static ComplexErrorProp[][] copy(ComplexErrorProp[][] complexErrorPropArray) {
        if (complexErrorPropArray == null) {
            return null;
        }
        int n = complexErrorPropArray.length;
        ComplexErrorProp[][] complexErrorPropArray2 = new ComplexErrorProp[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = complexErrorPropArray[i].length;
            complexErrorPropArray2[i] = new ComplexErrorProp[n2];
            for (int j = 0; j < n2; ++j) {
                complexErrorPropArray2[i][j] = complexErrorPropArray[i][j].copy();
            }
        }
        return complexErrorPropArray2;
    }

    public static ComplexErrorProp[][][] copy(ComplexErrorProp[][][] complexErrorPropArray) {
        if (complexErrorPropArray == null) {
            return null;
        }
        int n = complexErrorPropArray.length;
        ComplexErrorProp[][][] complexErrorPropArray2 = new ComplexErrorProp[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = complexErrorPropArray[i].length;
            complexErrorPropArray2[i] = new ComplexErrorProp[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = complexErrorPropArray[i][j].length;
                complexErrorPropArray2[i][j] = new ComplexErrorProp[n3];
                for (int k = 0; k < n3; ++k) {
                    complexErrorPropArray2[i][j][k] = complexErrorPropArray[i][j][k].copy();
                }
            }
        }
        return complexErrorPropArray2;
    }

    public static ComplexErrorProp[][][][] copy(ComplexErrorProp[][][][] complexErrorPropArray) {
        if (complexErrorPropArray == null) {
            return null;
        }
        int n = complexErrorPropArray.length;
        ComplexErrorProp[][][][] complexErrorPropArray2 = new ComplexErrorProp[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = complexErrorPropArray[i].length;
            complexErrorPropArray2[i] = new ComplexErrorProp[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = complexErrorPropArray[i][j].length;
                complexErrorPropArray2[i][j] = new ComplexErrorProp[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = complexErrorPropArray[i][j][k].length;
                    complexErrorPropArray2[i][j][k] = new ComplexErrorProp[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        complexErrorPropArray2[i][j][k][i2] = complexErrorPropArray[i][j][k][i2].copy();
                    }
                }
            }
        }
        return complexErrorPropArray2;
    }

    public static Phasor[] copy(Phasor[] phasorArray) {
        if (phasorArray == null) {
            return null;
        }
        int n = phasorArray.length;
        Phasor[] phasorArray2 = new Phasor[n];
        for (int i = 0; i < n; ++i) {
            phasorArray2[i] = phasorArray[i].copy();
        }
        return phasorArray2;
    }

    public static Phasor[][] copy(Phasor[][] phasorArray) {
        if (phasorArray == null) {
            return null;
        }
        int n = phasorArray.length;
        Phasor[][] phasorArray2 = new Phasor[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = phasorArray[i].length;
            phasorArray2[i] = new Phasor[n2];
            for (int j = 0; j < n2; ++j) {
                phasorArray2[i][j] = phasorArray[i][j].copy();
            }
        }
        return phasorArray2;
    }

    public static Phasor[][][] copy(Phasor[][][] phasorArray) {
        if (phasorArray == null) {
            return null;
        }
        int n = phasorArray.length;
        Phasor[][][] phasorArray2 = new Phasor[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = phasorArray[i].length;
            phasorArray2[i] = new Phasor[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = phasorArray[i][j].length;
                phasorArray2[i][j] = new Phasor[n3];
                for (int k = 0; k < n3; ++k) {
                    phasorArray2[i][j][k] = phasorArray[i][j][k].copy();
                }
            }
        }
        return phasorArray2;
    }

    public static Phasor[][][][] copy(Phasor[][][][] phasorArray) {
        if (phasorArray == null) {
            return null;
        }
        int n = phasorArray.length;
        Phasor[][][][] phasorArray2 = new Phasor[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = phasorArray[i].length;
            phasorArray2[i] = new Phasor[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = phasorArray[i][j].length;
                phasorArray2[i][j] = new Phasor[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = phasorArray[i][j][k].length;
                    phasorArray2[i][j][k] = new Phasor[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        phasorArray2[i][j][k][i2] = phasorArray[i][j][k][i2].copy();
                    }
                }
            }
        }
        return phasorArray2;
    }

    public static short[] copy(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        short[] sArray2 = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray2[i] = sArray[i];
        }
        return sArray2;
    }

    public static short[][] copy(short[][] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        short[][] sArrayArray = new short[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = sArray[i].length;
            sArrayArray[i] = new short[n2];
            for (int j = 0; j < n2; ++j) {
                sArrayArray[i][j] = sArray[i][j];
            }
        }
        return sArrayArray;
    }

    public static short[][][] copy(short[][][] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        short[][][] sArrayArray = new short[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = sArray[i].length;
            sArrayArray[i] = new short[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = sArray[i][j].length;
                sArrayArray[i][j] = new short[n3];
                for (int k = 0; k < n3; ++k) {
                    sArrayArray[i][j][k] = sArray[i][j][k];
                }
            }
        }
        return sArrayArray;
    }

    public static short[][][][] copy(short[][][][] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        short[][][][] sArrayArray = new short[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = sArray[i].length;
            sArrayArray[i] = new short[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = sArray[i][j].length;
                sArrayArray[i][j] = new short[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = sArray[i][j][k].length;
                    sArrayArray[i][j][k] = new short[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        sArrayArray[i][j][k][i2] = sArray[i][j][k][i2];
                    }
                }
            }
        }
        return sArrayArray;
    }

    public static byte[] copy(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[i];
        }
        return byArray2;
    }

    public static byte[][] copy(byte[][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i].length;
            byArrayArray[i] = new byte[n2];
            for (int j = 0; j < n2; ++j) {
                byArrayArray[i][j] = byArray[i][j];
            }
        }
        return byArrayArray;
    }

    public static byte[][][] copy(byte[][][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[][][] byArrayArray = new byte[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i].length;
            byArrayArray[i] = new byte[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = byArray[i][j].length;
                byArrayArray[i][j] = new byte[n3];
                for (int k = 0; k < n3; ++k) {
                    byArrayArray[i][j][k] = byArray[i][j][k];
                }
            }
        }
        return byArrayArray;
    }

    public static byte[][][][] copy(byte[][][][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[][][][] byArrayArray = new byte[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i].length;
            byArrayArray[i] = new byte[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = byArray[i][j].length;
                byArrayArray[i][j] = new byte[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = byArray[i][j][k].length;
                    byArrayArray[i][j][k] = new byte[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        byArrayArray[i][j][k][i2] = byArray[i][j][k][i2];
                    }
                }
            }
        }
        return byArrayArray;
    }

    public static Double[] copy(Double[] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        int n = doubleArray.length;
        Double[] doubleArray2 = new Double[n];
        for (int i = 0; i < n; ++i) {
            doubleArray2[i] = doubleArray[i];
        }
        return doubleArray2;
    }

    public static Double[][] copy(Double[][] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        int n = doubleArray.length;
        Double[][] doubleArray2 = new Double[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = doubleArray[i].length;
            doubleArray2[i] = new Double[n2];
            for (int j = 0; j < n2; ++j) {
                doubleArray2[i][j] = doubleArray[i][j];
            }
        }
        return doubleArray2;
    }

    public static Double[][][] copy(Double[][][] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        int n = doubleArray.length;
        Double[][][] doubleArray2 = new Double[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = doubleArray[i].length;
            doubleArray2[i] = new Double[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = doubleArray[i][j].length;
                doubleArray2[i][j] = new Double[n3];
                for (int k = 0; k < n3; ++k) {
                    doubleArray2[i][j][k] = doubleArray[i][j][k];
                }
            }
        }
        return doubleArray2;
    }

    public static Double[][][][] copy(Double[][][][] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        int n = doubleArray.length;
        Double[][][][] doubleArray2 = new Double[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = doubleArray[i].length;
            doubleArray2[i] = new Double[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = doubleArray[i][j].length;
                doubleArray2[i][j] = new Double[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = doubleArray[i][j][k].length;
                    doubleArray2[i][j][k] = new Double[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        doubleArray2[i][j][k][i2] = doubleArray[i][j][k][i2];
                    }
                }
            }
        }
        return doubleArray2;
    }

    public static Float[] copy(Float[] floatArray) {
        if (floatArray == null) {
            return null;
        }
        int n = floatArray.length;
        Float[] floatArray2 = new Float[n];
        for (int i = 0; i < n; ++i) {
            floatArray2[i] = floatArray[i];
        }
        return floatArray2;
    }

    public static Float[][] copy(Float[][] floatArray) {
        if (floatArray == null) {
            return null;
        }
        int n = floatArray.length;
        Float[][] floatArray2 = new Float[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = floatArray[i].length;
            floatArray2[i] = new Float[n2];
            for (int j = 0; j < n2; ++j) {
                floatArray2[i][j] = floatArray[i][j];
            }
        }
        return floatArray2;
    }

    public static Float[][][] copy(Float[][][] floatArray) {
        if (floatArray == null) {
            return null;
        }
        int n = floatArray.length;
        Float[][][] floatArray2 = new Float[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = floatArray[i].length;
            floatArray2[i] = new Float[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = floatArray[i][j].length;
                floatArray2[i][j] = new Float[n3];
                for (int k = 0; k < n3; ++k) {
                    floatArray2[i][j][k] = floatArray[i][j][k];
                }
            }
        }
        return floatArray2;
    }

    public static Float[][][][] copy(Float[][][][] floatArray) {
        if (floatArray == null) {
            return null;
        }
        int n = floatArray.length;
        Float[][][][] floatArray2 = new Float[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = floatArray[i].length;
            floatArray2[i] = new Float[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = floatArray[i][j].length;
                floatArray2[i][j] = new Float[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = floatArray[i][j][k].length;
                    floatArray2[i][j][k] = new Float[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        floatArray2[i][j][k][i2] = floatArray[i][j][k][i2];
                    }
                }
            }
        }
        return floatArray2;
    }

    public static Long[] copy(Long[] longArray) {
        if (longArray == null) {
            return null;
        }
        int n = longArray.length;
        Long[] longArray2 = new Long[n];
        for (int i = 0; i < n; ++i) {
            longArray2[i] = longArray[i];
        }
        return longArray2;
    }

    public static Long[][] copy(Long[][] longArray) {
        if (longArray == null) {
            return null;
        }
        int n = longArray.length;
        Long[][] longArray2 = new Long[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = longArray[i].length;
            longArray2[i] = new Long[n2];
            for (int j = 0; j < n2; ++j) {
                longArray2[i][j] = longArray[i][j];
            }
        }
        return longArray2;
    }

    public static Long[][][] copy(Long[][][] longArray) {
        if (longArray == null) {
            return null;
        }
        int n = longArray.length;
        Long[][][] longArray2 = new Long[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = longArray[i].length;
            longArray2[i] = new Long[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = longArray[i][j].length;
                longArray2[i][j] = new Long[n3];
                for (int k = 0; k < n3; ++k) {
                    longArray2[i][j][k] = longArray[i][j][k];
                }
            }
        }
        return longArray2;
    }

    public static Long[][][][] copy(Long[][][][] longArray) {
        if (longArray == null) {
            return null;
        }
        int n = longArray.length;
        Long[][][][] longArray2 = new Long[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = longArray[i].length;
            longArray2[i] = new Long[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = longArray[i][j].length;
                longArray2[i][j] = new Long[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = longArray[i][j][k].length;
                    longArray2[i][j][k] = new Long[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        longArray2[i][j][k][i2] = longArray[i][j][k][i2];
                    }
                }
            }
        }
        return longArray2;
    }

    public static Integer[] copy(Integer[] integerArray) {
        if (integerArray == null) {
            return null;
        }
        int n = integerArray.length;
        Integer[] integerArray2 = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray2[i] = integerArray[i];
        }
        return integerArray2;
    }

    public static Integer[][] copy(Integer[][] integerArray) {
        if (integerArray == null) {
            return null;
        }
        int n = integerArray.length;
        Integer[][] integerArray2 = new Integer[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray[i].length;
            integerArray2[i] = new Integer[n2];
            for (int j = 0; j < n2; ++j) {
                integerArray2[i][j] = integerArray[i][j];
            }
        }
        return integerArray2;
    }

    public static Integer[][][] copy(Integer[][][] integerArray) {
        if (integerArray == null) {
            return null;
        }
        int n = integerArray.length;
        Integer[][][] integerArray2 = new Integer[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray[i].length;
            integerArray2[i] = new Integer[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = integerArray[i][j].length;
                integerArray2[i][j] = new Integer[n3];
                for (int k = 0; k < n3; ++k) {
                    integerArray2[i][j][k] = integerArray[i][j][k];
                }
            }
        }
        return integerArray2;
    }

    public static Integer[][][][] copy(Integer[][][][] integerArray) {
        if (integerArray == null) {
            return null;
        }
        int n = integerArray.length;
        Integer[][][][] integerArray2 = new Integer[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray[i].length;
            integerArray2[i] = new Integer[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = integerArray[i][j].length;
                integerArray2[i][j] = new Integer[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = integerArray[i][j][k].length;
                    integerArray2[i][j][k] = new Integer[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        integerArray2[i][j][k][i2] = integerArray[i][j][k][i2];
                    }
                }
            }
        }
        return integerArray2;
    }

    public static Short[] copy(Short[] shortArray) {
        if (shortArray == null) {
            return null;
        }
        int n = shortArray.length;
        Short[] shortArray2 = new Short[n];
        for (int i = 0; i < n; ++i) {
            shortArray2[i] = shortArray[i];
        }
        return shortArray2;
    }

    public static Short[][] copy(Short[][] shortArray) {
        if (shortArray == null) {
            return null;
        }
        int n = shortArray.length;
        Short[][] shortArray2 = new Short[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = shortArray[i].length;
            shortArray2[i] = new Short[n2];
            for (int j = 0; j < n2; ++j) {
                shortArray2[i][j] = shortArray[i][j];
            }
        }
        return shortArray2;
    }

    public static Short[][][] copy(Short[][][] shortArray) {
        if (shortArray == null) {
            return null;
        }
        int n = shortArray.length;
        Short[][][] shortArray2 = new Short[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = shortArray[i].length;
            shortArray2[i] = new Short[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = shortArray[i][j].length;
                shortArray2[i][j] = new Short[n3];
                for (int k = 0; k < n3; ++k) {
                    shortArray2[i][j][k] = shortArray[i][j][k];
                }
            }
        }
        return shortArray2;
    }

    public static Short[][][][] copy(Short[][][][] shortArray) {
        if (shortArray == null) {
            return null;
        }
        int n = shortArray.length;
        Short[][][][] shortArray2 = new Short[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = shortArray[i].length;
            shortArray2[i] = new Short[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = shortArray[i][j].length;
                shortArray2[i][j] = new Short[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = shortArray[i][j][k].length;
                    shortArray2[i][j][k] = new Short[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        shortArray2[i][j][k][i2] = shortArray[i][j][k][i2];
                    }
                }
            }
        }
        return shortArray2;
    }

    public static Byte[] copy(Byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        int n = byteArray.length;
        Byte[] byteArray2 = new Byte[n];
        for (int i = 0; i < n; ++i) {
            byteArray2[i] = byteArray[i];
        }
        return byteArray2;
    }

    public static Byte[][] copy(Byte[][] byteArray) {
        if (byteArray == null) {
            return null;
        }
        int n = byteArray.length;
        Byte[][] byteArray2 = new Byte[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = byteArray[i].length;
            byteArray2[i] = new Byte[n2];
            for (int j = 0; j < n2; ++j) {
                byteArray2[i][j] = byteArray[i][j];
            }
        }
        return byteArray2;
    }

    public static Byte[][][] copy(Byte[][][] byteArray) {
        if (byteArray == null) {
            return null;
        }
        int n = byteArray.length;
        Byte[][][] byteArray2 = new Byte[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = byteArray[i].length;
            byteArray2[i] = new Byte[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = byteArray[i][j].length;
                byteArray2[i][j] = new Byte[n3];
                for (int k = 0; k < n3; ++k) {
                    byteArray2[i][j][k] = byteArray[i][j][k];
                }
            }
        }
        return byteArray2;
    }

    public static Byte[][][][] copy(Byte[][][][] byteArray) {
        if (byteArray == null) {
            return null;
        }
        int n = byteArray.length;
        Byte[][][][] byteArray2 = new Byte[n][][][];
        for (int i = 0; i < n; ++i) {
            int n2 = byteArray[i].length;
            byteArray2[i] = new Byte[n2][][];
            for (int j = 0; j < n2; ++j) {
                int n3 = byteArray[i][j].length;
                byteArray2[i][j] = new Byte[n3][];
                for (int k = 0; k < n3; ++k) {
                    int n4 = byteArray[i][j][k].length;
                    byteArray2[i][j][k] = new Byte[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        byteArray2[i][j][k][i2] = byteArray[i][j][k][i2];
                    }
                }
            }
        }
        return byteArray2;
    }

    public static Object copy(Object object) {
        if (object == null) {
            return null;
        }
        return Conv.copyObject(object);
    }

    public static Object copyObject(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object2 = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return object2;
    }

    public static double radToDeg(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double degToRad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double frequencyToRadialFrequency(double d) {
        return Math.PI * 2 * d;
    }

    public static double radialFrequencyToFrequency(double d) {
        return d / (Math.PI * 2);
    }

    public static double evToNm(double d) {
        return 2.99792458E17 / (-d * -1.60217646263E-19 / 6.6260687652E-34);
    }

    public static double nmToEv(double d) {
        return 2.99792458E8 / (-d * 1.0E-9) * 6.6260687652E-34 / -1.60217646263E-19;
    }

    public static double molarToPercentWeightByVol(double d, double d2) {
        return d * d2 / 10.0;
    }

    public static double percentWeightByVolToMolar(double d, double d2) {
        return d * 10.0 / d2;
    }

    public static double celsiusToKelvin(double d) {
        return d - -273.15;
    }

    public static double kelvinToCelsius(double d) {
        return d + -273.15;
    }

    public static double celsiusToFahren(double d) {
        return d * 1.8 + 32.0;
    }

    public static double fahrenToCelsius(double d) {
        return (d - 32.0) * 5.0 / 9.0;
    }

    public static double calorieToJoule(double d) {
        return d * 4.1868;
    }

    public static double jouleToCalorie(double d) {
        return d * 0.23884;
    }

    public static double gramToOunce(double d) {
        return d / 28.3459;
    }

    public static double ounceToGram(double d) {
        return d * 28.3459;
    }

    public static double kgToPound(double d) {
        return d / 0.4536;
    }

    public static double poundToKg(double d) {
        return d * 0.4536;
    }

    public static double kgToTon(double d) {
        return d / 1016.05;
    }

    public static double tonToKg(double d) {
        return d * 1016.05;
    }

    public static double millimetreToInch(double d) {
        return d / 25.4;
    }

    public static double inchToMillimetre(double d) {
        return d * 25.4;
    }

    public static double footToMetre(double d) {
        return d * 0.3048;
    }

    public static double metreToFoot(double d) {
        return d / 0.3048;
    }

    public static double yardToMetre(double d) {
        return d * 0.9144;
    }

    public static double metreToYard(double d) {
        return d / 0.9144;
    }

    public static double mileToKm(double d) {
        return d * 1.6093;
    }

    public static double kmToMile(double d) {
        return d / 1.6093;
    }

    public static double gallonToLitre(double d) {
        return d * 4.546;
    }

    public static double litreToGallon(double d) {
        return d / 4.546;
    }

    public static double quartToLitre(double d) {
        return d * 1.137;
    }

    public static double litreToQuart(double d) {
        return d / 1.137;
    }

    public static double pintToLitre(double d) {
        return d * 0.568;
    }

    public static double litreToPint(double d) {
        return d / 0.568;
    }

    public static double gallonPerMileToLitrePerKm(double d) {
        return d * 2.825;
    }

    public static double litrePerKmToGallonPerMile(double d) {
        return d / 2.825;
    }

    public static double milePerGallonToKmPerLitre(double d) {
        return d * 0.354;
    }

    public static double kmPerLitreToMilePerGallon(double d) {
        return d / 0.354;
    }

    public static double fluidOunceUKtoUS(double d) {
        return d * 0.961;
    }

    public static double fluidOunceUStoUK(double d) {
        return d * 1.041;
    }

    public static double pintUKtoUS(double d) {
        return d * 1.201;
    }

    public static double pintUStoUK(double d) {
        return d * 0.833;
    }

    public static double quartUKtoUS(double d) {
        return d * 1.201;
    }

    public static double quartUStoUK(double d) {
        return d * 0.833;
    }

    public static double gallonUKtoUS(double d) {
        return d * 1.201;
    }

    public static double gallonUStoUK(double d) {
        return d * 0.833;
    }

    public static double pintUKtoCupUS(double d) {
        return d / 0.417;
    }

    public static double cupUStoPintUK(double d) {
        return d * 0.417;
    }

    public static double calcBMImetric(double d, double d2) {
        return d2 / (d * d);
    }

    public static double calcBMIimperial(double d, double d2) {
        d = Fmath.footToMetre(d);
        d2 = Fmath.poundToKg(d2);
        return d2 / (d * d);
    }

    public static double calcWeightFromBMImetric(double d, double d2) {
        return d * d2 * d2;
    }

    public static double calcWeightFromBMIimperial(double d, double d2) {
        d2 = Fmath.footToMetre(d2);
        double d3 = d * d2 * d2;
        d3 = Fmath.kgToPound(d3);
        return d3;
    }

    public static long dateToJavaMilliSecondsUK(int n, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        TimeAndDate timeAndDate = new TimeAndDate();
        long l = timeAndDate.dateToJavaMilliSecondsUK(n, n2, n3, string, n4, n5, n6, n7);
        return l;
    }

    public static String decToHex() {
        long l = DialogueBox.readLong("Enter integer decimal number");
        String string = Conv.decToHex(l);
        DialogueBox.show(string);
        return string;
    }

    public static String decToHex(long l) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String string = "";
        boolean bl = true;
        while (bl) {
            long l2 = l % 16L;
            string = cArray[(int)l2] + string;
            if ((l /= 16L) >= 16L) continue;
            string = cArray[(int)l] + string;
            bl = false;
        }
        return string;
    }

    public static String decToHex(int n) {
        return Conv.decToHex((long)n);
    }

    public static String decToBin() {
        long l = DialogueBox.readLong("Enter integer decimal number");
        String string = Conv.decToBin(l);
        DialogueBox.show(string);
        return string;
    }

    public static String decToBin(long l) {
        String string = "";
        boolean bl = true;
        while (bl) {
            long l2 = l % 2L;
            string = l2 + string;
            if ((l /= 2L) != 0L) continue;
            bl = false;
        }
        return string;
    }

    public static String decToBin(int n) {
        return Conv.decToBin(n);
    }

    public static long binToDec() {
        String string = DialogueBox.readLine("Enter binary number");
        long l = Conv.binToDec(string);
        DialogueBox.show(l);
        return l;
    }

    public static long binToDec(String string) {
        int n = string.length();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(n - i - 1) != '1') continue;
            l = (long)((double)l + Math.pow(2.0, i));
        }
        return l;
    }

    public static String binToHex() {
        String string = DialogueBox.readLine("Enter binary number");
        String string2 = Conv.binToHex(string);
        DialogueBox.show(string2);
        return string2;
    }

    public static String binToHex(String string) {
        long l = Conv.binToDec(string);
        String string2 = Conv.decToHex(l);
        return string2;
    }

    public static String hexToBin() {
        String string = DialogueBox.readLine("Enter integer hexadecimal number");
        String string2 = Conv.hexToBin(string);
        DialogueBox.show(string2);
        return string2;
    }

    public static String hexToBin(String string) {
        long l = Conv.hexToDec(string);
        return Conv.decToBin(l);
    }

    public static long hexToDec() {
        String string = DialogueBox.readLine("Enter integer hexadecimal number");
        long l = Conv.hexToDec(string, true);
        DialogueBox.show(l);
        return l;
    }

    public static long hexToDec(String string) {
        return Conv.hexToDec(string, false);
    }

    public static long hexToDec(String string, boolean bl) {
        int n = string.length();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(n - i - 1);
            if (n2 <= 56) {
                if (n2 < 48) {
                    if (bl) {
                        DialogueBox.show(string + " is not an integer hexadecimal number\nMethod hexToDec aborted");
                    }
                    System.out.println(string + " is not an integer hexadecimal number\nMethod hexToDec aborted");
                    System.exit(0);
                } else {
                    n2 -= 48;
                }
            } else if (n2 > 64 && n2 < 71) {
                n2 -= 55;
            } else {
                if (bl) {
                    DialogueBox.show(string + " is not an integer hexadecimal number\nMethod hexToDec aborted");
                }
                System.out.println(string + " is not an integer hexadecimal number\nMethod hexToDec aborted");
                System.exit(0);
            }
            l = (long)((double)l + (double)n2 * Math.pow(16.0, i));
        }
        return l;
    }
}

