/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.TriCubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import java.util.ArrayList;

public class TriCubicInterpolation {
    int[][] unitCube = new int[][]{{0, 0, 0}, {1, 0, 0}, {1, 1, 0}, {0, 1, 0}, {0, 0, 1}, {1, 0, 1}, {1, 1, 1}, {0, 1, 1}};
    private int lPoints = 0;
    private int mPoints = 0;
    private int nPoints = 0;
    private double[] x1 = null;
    private double[] x2 = null;
    private double[] x3 = null;
    private double[][][] y = null;
    private double[][][] dydx1 = null;
    private double[][][] dydx2 = null;
    private double[][][] dydx3 = null;
    private double[][][] d2ydx1dx2 = null;
    private double[][][] d2ydx1dx3 = null;
    private double[][][] d2ydx2dx3 = null;
    private double[][][] d3ydx1dx2dx3 = null;
    private boolean derivCalculated = false;
    private TriCubicSpline tcs = null;
    private double incrX1 = 0.0;
    private double incrX2 = 0.0;
    private double incrX3 = 0.0;
    private double xx1 = Double.NaN;
    private double xx2 = Double.NaN;
    private double xx3 = Double.NaN;
    private ArrayList<Object> coeff = new ArrayList();
    private double[][] weights = new double[64][64];
    private int[] x1indices = null;
    private int[] x2indices = null;
    private int[] x3indices = null;
    private double[] xMin = new double[3];
    private double[] xMax = new double[3];
    private double interpolatedValue = Double.NaN;
    private double interpolatedDydx1 = Double.NaN;
    private double interpolatedDydx2 = Double.NaN;
    private double interpolatedDydx3 = Double.NaN;
    private double interpolatedD2ydx1dx2 = Double.NaN;
    private double interpolatedD2ydx1dx3 = Double.NaN;
    private double interpolatedD2ydx2dx3 = Double.NaN;
    private double interpolatedD3ydx1dx2dx3 = Double.NaN;
    private boolean numerDiffFlag = true;
    private static double delta = 0.001;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = false;

    public TriCubicInterpolation(double[] dArray, double[] dArray2, double[] dArray3, double[][][] dArray4, int n) {
        if (n == 0) {
            this.numerDiffFlag = false;
        } else if (n == 1) {
            this.numerDiffFlag = true;
        } else {
            throw new IllegalArgumentException("The numerical differencing option, " + n + ", must be 0 or 1");
        }
        this.initialize(Conv.copy(dArray), Conv.copy(dArray2), Conv.copy(dArray3), Conv.copy(dArray4));
        this.calcDeriv();
        this.gridCoefficients();
    }

    public TriCubicInterpolation(double[] dArray, double[] dArray2, double[] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[][][] dArray7, double[][][] dArray8, double[][][] dArray9, double[][][] dArray10, double[][][] dArray11) {
        this.initialize(Conv.copy(dArray), Conv.copy(dArray2), Conv.copy(dArray3), Conv.copy(dArray4), Conv.copy(dArray5), Conv.copy(dArray6), Conv.copy(dArray7), Conv.copy(dArray8), Conv.copy(dArray9), Conv.copy(dArray10), Conv.copy(dArray11));
        this.gridCoefficients();
    }

    private void initialize(double[] dArray, double[] dArray2, double[] dArray3, double[][][] dArray4) {
        this.initialize(dArray, dArray2, dArray3, dArray4, null, null, null, null, null, null, null, false);
    }

    private void initialize(double[] dArray, double[] dArray2, double[] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[][][] dArray7, double[][][] dArray8, double[][][] dArray9, double[][][] dArray10, double[][][] dArray11) {
        this.initialize(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, this.dydx3, dArray8, dArray9, dArray10, dArray11, true);
    }

    private void initialize(double[] dArray, double[] dArray2, double[] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[][][] dArray7, double[][][] dArray8, double[][][] dArray9, double[][][] dArray10, double[][][] dArray11, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = dArray.length;
        int n5 = dArray2.length;
        int n6 = dArray3.length;
        if (n4 != dArray4.length) {
            throw new IllegalArgumentException("Array x1 and y-row are of different length " + n4 + " " + dArray4.length);
        }
        if (n5 != dArray4[0].length) {
            throw new IllegalArgumentException("Array x2 and y-column are of different length " + n5 + " " + dArray4[0].length);
        }
        if (n6 != dArray4[0][0].length) {
            throw new IllegalArgumentException("Array x3 and y-column are of different length " + n6 + " " + dArray4[0][0].length);
        }
        if (n4 < 2 || n5 < 2 || n6 < 2) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 2 X 2 X 2");
        }
        this.calcWeights();
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        this.x1indices = arrayMaths.originalIndices();
        dArray = arrayMaths.array();
        double[][][] dArray12 = new double[n4][n5][n6];
        double[][][] dArray13 = null;
        double[][][] dArray14 = null;
        double[][][] dArray15 = null;
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    dArray12[n3][n2][n] = dArray4[this.x1indices[n3]][n2][n];
                }
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    dArray4[n3][n2][n] = dArray12[n3][n2][n];
                }
            }
        }
        if (bl) {
            dArray13 = new double[n4][n5][n6];
            dArray14 = new double[n4][n5][n6];
            dArray15 = new double[n4][n5][n6];
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        dArray13[n3][n2][n] = dArray5[this.x1indices[n3]][n2][n];
                        dArray14[n3][n2][n] = dArray6[this.x1indices[n3]][n2][n];
                        dArray15[n3][n2][n] = dArray8[this.x1indices[n3]][n2][n];
                    }
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        dArray5[n3][n2][n] = dArray13[n3][n2][n];
                        dArray6[n3][n2][n] = dArray14[n3][n2][n];
                        dArray8[n3][n2][n] = dArray15[n3][n2][n];
                    }
                }
            }
        }
        arrayMaths = new ArrayMaths(dArray2);
        arrayMaths = arrayMaths.sort();
        this.x2indices = arrayMaths.originalIndices();
        dArray2 = arrayMaths.array();
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    dArray12[n3][n2][n] = dArray4[n3][this.x2indices[n2]][n];
                }
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    dArray4[n3][n2][n] = dArray12[n3][n2][n];
                }
            }
        }
        if (bl) {
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        dArray13[n3][n2][n] = dArray5[n3][this.x2indices[n2]][n];
                        dArray14[n3][n2][n] = dArray6[n3][this.x2indices[n2]][n];
                        dArray15[n3][n2][n] = dArray8[n3][this.x2indices[n2]][n];
                    }
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        dArray5[n3][n2][n] = dArray13[n3][n2][n];
                        dArray6[n3][n2][n] = dArray14[n3][n2][n];
                        dArray8[n3][n2][n] = dArray15[n3][n2][n];
                    }
                }
            }
        }
        arrayMaths = new ArrayMaths(dArray3);
        arrayMaths = arrayMaths.sort();
        this.x3indices = arrayMaths.originalIndices();
        dArray3 = arrayMaths.array();
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    dArray12[n3][n2][n] = dArray4[n3][n2][this.x3indices[n]];
                }
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    dArray4[n3][n2][n] = dArray12[n3][n2][n];
                }
            }
        }
        if (bl) {
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        dArray13[n3][n2][n] = dArray5[n3][n2][this.x3indices[n]];
                        dArray14[n3][n2][n] = dArray6[n3][n2][this.x3indices[n]];
                        dArray15[n3][n2][n] = dArray8[n3][n2][this.x3indices[n]];
                    }
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        dArray5[n3][n2][n] = dArray13[n3][n2][n];
                        dArray6[n3][n2][n] = dArray14[n3][n2][n];
                        dArray8[n3][n2][n] = dArray15[n3][n2][n];
                    }
                }
            }
        }
        for (n3 = 1; n3 < n4; ++n3) {
            if (dArray[n3] != dArray[n3 - 1]) continue;
            System.out.println("x1[" + this.x1indices[n3] + "] and x1[" + this.x1indices[n3 + 1] + "] are identical, " + dArray[n3]);
            double d = (Fmath.maximum(dArray) - Fmath.minimum(dArray)) / 5.0E-4;
            int n7 = n3 - 1;
            dArray[n7] = dArray[n7] - d;
            int n8 = n3;
            dArray[n8] = dArray[n8] + d;
            System.out.println("They have been separated by" + 2.0 * d);
        }
        for (n3 = 1; n3 < n5; ++n3) {
            if (dArray2[n3] != dArray2[n3 - 1]) continue;
            System.out.println("x2[" + this.x2indices[n3] + "] and x2[" + this.x2indices[n3 + 1] + "] are identical, " + dArray2[n3]);
            double d = (Fmath.maximum(dArray2) - Fmath.minimum(dArray2)) / 5.0E-4;
            int n9 = n3 - 1;
            dArray2[n9] = dArray2[n9] - d;
            int n10 = n3;
            dArray2[n10] = dArray2[n10] + d;
            System.out.println("They have been separated by" + 2.0 * d);
        }
        for (n3 = 1; n3 < n6; ++n3) {
            if (dArray3[n3] != dArray3[n3 - 1]) continue;
            System.out.println("x3[" + this.x3indices[n3] + "] and x3[" + this.x3indices[n3 + 1] + "] are identical, " + dArray3[n3]);
            double d = (Fmath.maximum(dArray3) - Fmath.minimum(dArray3)) / 5.0E-4;
            int n11 = n3 - 1;
            dArray3[n11] = dArray3[n11] - d;
            int n12 = n3;
            dArray3[n12] = dArray3[n12] + d;
            System.out.println("They have been separated by" + 2.0 * d);
        }
        this.lPoints = n4;
        this.mPoints = n5;
        this.nPoints = n6;
        this.x1 = new double[this.lPoints];
        this.x2 = new double[this.mPoints];
        this.x3 = new double[this.nPoints];
        this.y = new double[this.lPoints][this.mPoints][this.nPoints];
        this.dydx1 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.dydx2 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.dydx3 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.d2ydx1dx2 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.d2ydx1dx3 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.d2ydx2dx3 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.d3ydx1dx2dx3 = new double[this.lPoints][this.mPoints][this.nPoints];
        for (n3 = 0; n3 < this.lPoints; ++n3) {
            this.x1[n3] = dArray[n3];
        }
        for (n3 = 0; n3 < this.mPoints; ++n3) {
            this.x2[n3] = dArray2[n3];
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.x3[n3] = dArray3[n3];
        }
        for (n3 = 0; n3 < this.lPoints; ++n3) {
            for (int i = 0; i < this.mPoints; ++i) {
                for (n = 0; n < this.nPoints; ++n) {
                    this.y[n3][i][n] = dArray4[n3][i][n];
                }
            }
        }
        if (bl) {
            for (n3 = 0; n3 < this.lPoints; ++n3) {
                for (int i = 0; i < this.mPoints; ++i) {
                    for (n = 0; n < this.nPoints; ++n) {
                        this.dydx1[n3][i][n] = dArray5[n3][i][n];
                        this.dydx2[n3][i][n] = dArray6[n3][i][n];
                        this.dydx3[n3][i][n] = this.dydx3[n3][i][n];
                        this.d2ydx1dx2[n3][i][n] = dArray8[n3][i][n];
                        this.d2ydx1dx3[n3][i][n] = dArray9[n3][i][n];
                        this.d2ydx2dx3[n3][i][n] = dArray10[n3][i][n];
                        this.d3ydx1dx2dx3[n3][i][n] = dArray11[n3][i][n];
                    }
                }
            }
            this.derivCalculated = true;
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        this.xMin[2] = Fmath.minimum(this.x3);
        this.xMax[2] = Fmath.maximum(this.x3);
        if (!bl && this.numerDiffFlag) {
            double d;
            double d2 = this.xMax[0] - this.xMin[0];
            double d3 = this.xMax[1] - this.xMin[1];
            double d4 = this.xMax[2] - this.xMin[2];
            double d5 = d2 / (double)this.lPoints;
            double d6 = d3 / (double)this.mPoints;
            double d7 = d4 / (double)this.nPoints;
            double d8 = d = this.x1[1] - this.x1[0];
            for (int i = 2; i < this.lPoints; ++i) {
                d = this.x1[i] - this.x1[i - 1];
                if (!(d < d8)) continue;
                d8 = d;
            }
            double d9 = d = this.x2[1] - this.x2[0];
            for (int i = 2; i < this.mPoints; ++i) {
                d = this.x2[i] - this.x2[i - 1];
                if (!(d < d9)) continue;
                d9 = d;
            }
            double d10 = d = this.x3[1] - this.x3[0];
            for (int i = 2; i < this.nPoints; ++i) {
                d = this.x3[i] - this.x3[i - 1];
                if (!(d < d10)) continue;
                d10 = d;
            }
            this.incrX1 = d2 * delta;
            double d11 = d8;
            if (d8 < d5 / 10.0) {
                d11 = d5 / 10.0;
            }
            if (this.incrX1 > d5) {
                this.incrX1 = d11;
            }
            this.incrX2 = d3 * delta;
            d11 = d9;
            if (d9 < d6 / 10.0) {
                d11 = d6 / 10.0;
            }
            if (this.incrX2 > d6) {
                this.incrX2 = d11;
            }
            this.incrX3 = d4 * delta;
            d11 = d10;
            if (d10 < d7 / 10.0) {
                d11 = d7 / 10.0;
            }
            if (this.incrX3 > d7) {
                this.incrX3 = d11;
            }
        }
    }

    private void calcWeights() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        for (n5 = 0; n5 < 8; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < 4; ++n3) {
                for (n2 = 0; n2 < 4; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        this.weights[n6][n4] = Math.pow(this.unitCube[n5][0], n3) * Math.pow(this.unitCube[n5][1], n2) * Math.pow(this.unitCube[n5][2], n);
                        ++n4;
                    }
                }
            }
            ++n6;
        }
        for (n5 = 0; n5 < 8; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < 4; ++n3) {
                for (n2 = 0; n2 < 4; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        this.weights[n6][n4] = n3 == 0 ? 0.0 : (double)n3 * Math.pow(this.unitCube[n5][0], n3 - 1) * Math.pow(this.unitCube[n5][1], n2) * Math.pow(this.unitCube[n5][2], n);
                        ++n4;
                    }
                }
            }
            ++n6;
        }
        for (n5 = 0; n5 < 8; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < 4; ++n3) {
                for (n2 = 0; n2 < 4; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        this.weights[n6][n4] = n2 == 0 ? 0.0 : (double)n2 * Math.pow(this.unitCube[n5][0], n3) * Math.pow(this.unitCube[n5][1], n2 - 1) * Math.pow(this.unitCube[n5][2], n);
                        ++n4;
                    }
                }
            }
            ++n6;
        }
        for (n5 = 0; n5 < 8; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < 4; ++n3) {
                for (n2 = 0; n2 < 4; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        this.weights[n6][n4] = n == 0 ? 0.0 : (double)n * Math.pow(this.unitCube[n5][0], n3) * Math.pow(this.unitCube[n5][1], n2) * Math.pow(this.unitCube[n5][2], n - 1);
                        ++n4;
                    }
                }
            }
            ++n6;
        }
        for (n5 = 0; n5 < 8; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < 4; ++n3) {
                for (n2 = 0; n2 < 4; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        this.weights[n6][n4] = n3 == 0 || n2 == 0 ? 0.0 : (double)(n3 * n2) * Math.pow(this.unitCube[n5][0], n3 - 1) * Math.pow(this.unitCube[n5][1], n2 - 1) * Math.pow(this.unitCube[n5][2], n);
                        ++n4;
                    }
                }
            }
            ++n6;
        }
        for (n5 = 0; n5 < 8; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < 4; ++n3) {
                for (n2 = 0; n2 < 4; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        this.weights[n6][n4] = n3 == 0 || n == 0 ? 0.0 : (double)(n3 * n) * Math.pow(this.unitCube[n5][0], n3 - 1) * Math.pow(this.unitCube[n5][1], n2) * Math.pow(this.unitCube[n5][2], n - 1);
                        ++n4;
                    }
                }
            }
            ++n6;
        }
        for (n5 = 0; n5 < 8; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < 4; ++n3) {
                for (n2 = 0; n2 < 4; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        this.weights[n6][n4] = n2 == 0 || n == 0 ? 0.0 : (double)(n2 * n) * Math.pow(this.unitCube[n5][0], n3) * Math.pow(this.unitCube[n5][1], n2 - 1) * Math.pow(this.unitCube[n5][2], n - 1);
                        ++n4;
                    }
                }
            }
            ++n6;
        }
        for (n5 = 0; n5 < 8; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < 4; ++n3) {
                for (n2 = 0; n2 < 4; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        this.weights[n6][n4] = n3 == 0 || n2 == 0 || n == 0 ? 0.0 : (double)(n3 * n2 * n) * Math.pow(this.unitCube[n5][0], n3 - 1) * Math.pow(this.unitCube[n5][1], n2 - 1) * Math.pow(this.unitCube[n5][2], n - 1);
                        ++n4;
                    }
                }
            }
            ++n6;
        }
        Matrix matrix = new Matrix(this.weights);
        matrix = matrix.inverse();
        this.weights = matrix.getArrayCopy();
    }

    private void calcDeriv() {
        if (this.numerDiffFlag) {
            int n;
            this.tcs = new TriCubicSpline(this.x1, this.x2, this.x3, this.y);
            double[] dArray = new double[this.lPoints];
            double[] dArray2 = new double[this.lPoints];
            double[] dArray3 = new double[this.mPoints];
            double[] dArray4 = new double[this.mPoints];
            double[] dArray5 = new double[this.nPoints];
            double[] dArray6 = new double[this.nPoints];
            for (n = 0; n < this.lPoints; ++n) {
                dArray[n] = this.x1[n] + this.incrX1;
                if (dArray[n] > this.x1[this.lPoints - 1]) {
                    dArray[n] = this.x1[this.lPoints - 1];
                }
                dArray2[n] = this.x1[n] - this.incrX1;
                if (!(dArray2[n] < this.x1[0])) continue;
                dArray2[n] = this.x1[0];
            }
            for (n = 0; n < this.mPoints; ++n) {
                dArray3[n] = this.x2[n] + this.incrX2;
                if (dArray3[n] > this.x2[this.mPoints - 1]) {
                    dArray3[n] = this.x2[this.mPoints - 1];
                }
                dArray4[n] = this.x2[n] - this.incrX2;
                if (!(dArray4[n] < this.x2[0])) continue;
                dArray4[n] = this.x2[0];
            }
            for (n = 0; n < this.nPoints; ++n) {
                dArray5[n] = this.x3[n] + this.incrX3;
                if (dArray5[n] > this.x3[this.nPoints - 1]) {
                    dArray5[n] = this.x3[this.nPoints - 1];
                }
                dArray6[n] = this.x3[n] - this.incrX3;
                if (!(dArray6[n] < this.x3[0])) continue;
                dArray6[n] = this.x3[0];
            }
            for (n = 0; n < this.lPoints; ++n) {
                for (int i = 0; i < this.mPoints; ++i) {
                    for (int j = 0; j < this.nPoints; ++j) {
                        this.dydx1[n][i][j] = (this.tcs.interpolate(dArray[n], this.x2[i], this.x3[j]) - this.tcs.interpolate(dArray2[n], this.x2[i], this.x3[j])) / (dArray[n] - dArray2[n]);
                        this.dydx2[n][i][j] = (this.tcs.interpolate(this.x1[n], dArray3[i], this.x3[j]) - this.tcs.interpolate(this.x1[n], dArray4[i], this.x3[j])) / (dArray3[i] - dArray4[i]);
                        this.dydx3[n][i][j] = (this.tcs.interpolate(this.x1[n], this.x2[i], dArray5[j]) - this.tcs.interpolate(this.x1[n], this.x2[i], dArray6[j])) / (dArray5[j] - dArray6[j]);
                        this.d2ydx1dx2[n][i][j] = (this.tcs.interpolate(dArray[n], dArray3[i], this.x3[j]) - this.tcs.interpolate(dArray[n], dArray4[i], this.x3[j]) - this.tcs.interpolate(dArray2[n], dArray3[i], this.x3[j]) + this.tcs.interpolate(dArray2[n], dArray4[i], this.x3[j])) / ((dArray[n] - dArray2[n]) * (dArray3[i] - dArray4[i]));
                        this.d2ydx1dx3[n][i][j] = (this.tcs.interpolate(dArray[n], this.x2[i], dArray5[j]) - this.tcs.interpolate(dArray[n], this.x2[i], dArray6[j]) - this.tcs.interpolate(dArray2[n], this.x2[i], dArray5[j]) + this.tcs.interpolate(dArray2[n], this.x2[i], dArray6[j])) / ((dArray[n] - dArray2[n]) * (dArray5[j] - dArray6[j]));
                        this.d2ydx2dx3[n][i][j] = (this.tcs.interpolate(this.x1[n], dArray3[i], dArray5[j]) - this.tcs.interpolate(this.x1[n], dArray3[i], dArray6[j]) - this.tcs.interpolate(this.x1[n], dArray4[i], dArray5[j]) + this.tcs.interpolate(this.x1[n], dArray4[i], dArray6[j])) / ((dArray3[i] - dArray4[i]) * (dArray5[j] - dArray6[j]));
                        this.d3ydx1dx2dx3[n][i][j] = (this.tcs.interpolate(dArray[n], dArray3[i], dArray5[j]) - this.tcs.interpolate(dArray[n], dArray4[i], dArray5[j]) - this.tcs.interpolate(dArray2[n], dArray3[i], dArray5[j]) + this.tcs.interpolate(dArray2[n], dArray4[i], dArray5[j]) - (this.tcs.interpolate(dArray[n], dArray3[i], dArray6[j]) - this.tcs.interpolate(dArray[n], dArray4[i], dArray6[j]) - this.tcs.interpolate(dArray2[n], dArray3[i], dArray6[j]) + this.tcs.interpolate(dArray2[n], dArray4[i], dArray6[j]))) / ((dArray[n] - dArray2[n]) * (dArray3[i] - dArray4[i]) * (dArray5[j] - dArray6[j]));
                    }
                }
            }
        } else {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < this.lPoints; ++i) {
                n = i + 1;
                if (n >= this.lPoints) {
                    n = this.lPoints - 1;
                }
                if ((n2 = i - 1) < 0) {
                    n2 = 0;
                }
                for (int j = 0; j < this.mPoints; ++j) {
                    n3 = j + 1;
                    if (n3 >= this.mPoints) {
                        n3 = this.mPoints - 1;
                    }
                    if ((n4 = j - 1) < 0) {
                        n4 = 0;
                    }
                    for (int k = 0; k < this.nPoints; ++k) {
                        n5 = k + 1;
                        if (n5 >= this.nPoints) {
                            n5 = this.nPoints - 1;
                        }
                        if ((n6 = k - 1) < 0) {
                            n6 = 0;
                        }
                        this.dydx1[i][j][k] = (this.y[n][j][k] - this.y[n2][j][k]) / (this.x1[n] - this.x1[n2]);
                        this.dydx2[i][j][k] = (this.y[i][n3][k] - this.y[i][n4][k]) / (this.x2[n3] - this.x2[n4]);
                        this.dydx3[i][j][k] = (this.y[i][j][n5] - this.y[i][j][n6]) / (this.x3[n5] - this.x3[n6]);
                        this.d2ydx1dx2[i][j][k] = (this.y[n][n3][k] - this.y[n][n4][k] - this.y[n2][n3][k] + this.y[n2][n4][k]) / ((this.x1[n] - this.x1[n2]) * (this.x2[n3] - this.x2[n4]));
                        this.d2ydx1dx3[i][j][k] = (this.y[n][j][n5] - this.y[n][j][n6] - this.y[n2][j][n5] + this.y[n2][j][n6]) / ((this.x1[n] - this.x1[n2]) * (this.x3[n5] - this.x3[n6]));
                        this.d2ydx2dx3[i][j][k] = (this.y[i][n3][n5] - this.y[i][n3][n6] - this.y[i][n4][n5] + this.y[i][n4][n6]) / ((this.x2[n3] - this.x2[n4]) * (this.x3[n5] - this.x3[n6]));
                        this.d2ydx1dx2[i][j][k] = (this.y[n][n3][n5] - this.y[n][n4][n5] - this.y[n2][n3][n5] + this.y[n2][n4][n5] - this.y[n][n3][n6] + this.y[n][n4][n6] + this.y[n2][n3][n6] - this.y[n2][n4][n6]) / ((this.x1[n] - this.x1[n2]) * (this.x2[n3] - this.x2[n4]) * (this.x3[n5] - this.x3[n6]));
                    }
                }
            }
        }
        this.derivCalculated = true;
    }

    private void gridCoefficients() {
        double[] dArray = new double[8];
        double[] dArray2 = new double[8];
        double[] dArray3 = new double[8];
        double[] dArray4 = new double[8];
        double[] dArray5 = new double[8];
        double[] dArray6 = new double[8];
        double[] dArray7 = new double[8];
        double[] dArray8 = new double[8];
        double[] dArray9 = new double[64];
        double[] dArray10 = new double[64];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.lPoints - 1; ++i) {
            d = this.x1[i + 1] - this.x1[i];
            for (int j = 0; j < this.mPoints - 1; ++j) {
                d2 = this.x2[j + 1] - this.x2[j];
                for (int k = 0; k < this.nPoints - 1; ++k) {
                    int n;
                    int n2;
                    int n3;
                    d3 = this.x3[k + 1] - this.x3[k];
                    double[][][] dArray11 = new double[4][4][4];
                    this.coeff.add(new Double(d));
                    this.coeff.add(new Double(this.x1[i]));
                    this.coeff.add(new Double(d2));
                    this.coeff.add(new Double(this.x2[j]));
                    this.coeff.add(new Double(d3));
                    this.coeff.add(new Double(this.x3[k]));
                    for (n3 = 0; n3 < 8; ++n3) {
                        dArray[n3] = this.y[i + this.unitCube[n3][0]][j + this.unitCube[n3][1]][k + this.unitCube[n3][2]];
                        dArray2[n3] = this.dydx1[i + this.unitCube[n3][0]][j + this.unitCube[n3][1]][k + this.unitCube[n3][2]];
                        dArray3[n3] = this.dydx2[i + this.unitCube[n3][0]][j + this.unitCube[n3][1]][k + this.unitCube[n3][2]];
                        dArray4[n3] = this.dydx3[i + this.unitCube[n3][0]][j + this.unitCube[n3][1]][k + this.unitCube[n3][2]];
                        dArray5[n3] = this.d2ydx1dx2[i + this.unitCube[n3][0]][j + this.unitCube[n3][1]][k + this.unitCube[n3][2]];
                        dArray6[n3] = this.d2ydx1dx3[i + this.unitCube[n3][0]][j + this.unitCube[n3][1]][k + this.unitCube[n3][2]];
                        dArray7[n3] = this.d2ydx2dx3[i + this.unitCube[n3][0]][j + this.unitCube[n3][1]][k + this.unitCube[n3][2]];
                        dArray8[n3] = this.d3ydx1dx2dx3[i + this.unitCube[n3][0]][j + this.unitCube[n3][1]][k + this.unitCube[n3][2]];
                    }
                    for (n3 = 0; n3 < 8; ++n3) {
                        dArray10[n3] = dArray[n3];
                        dArray10[n3 + 8] = dArray2[n3] * d;
                        dArray10[n3 + 16] = dArray3[n3] * d2;
                        dArray10[n3 + 24] = dArray4[n3] * d3;
                        dArray10[n3 + 32] = dArray5[n3] * d * d2;
                        dArray10[n3 + 40] = dArray6[n3] * d * d3;
                        dArray10[n3 + 48] = dArray7[n3] * d2 * d3;
                        dArray10[n3 + 56] = dArray8[n3] * d * d2 * d3;
                    }
                    double d4 = 0.0;
                    for (n2 = 0; n2 < 64; ++n2) {
                        for (n = 0; n < 64; ++n) {
                            d4 += this.weights[n2][n] * dArray10[n];
                        }
                        dArray9[n2] = d4;
                        d4 = 0.0;
                    }
                    n2 = 0;
                    for (n = 0; n < 4; ++n) {
                        for (int i2 = 0; i2 < 4; ++i2) {
                            for (int i3 = 0; i3 < 4; ++i3) {
                                dArray11[n][i2][i3] = dArray9[n2++];
                            }
                        }
                    }
                    this.coeff.add(dArray11);
                }
            }
        }
    }

    public double interpolate(double d, double d2, double d3) {
        int n;
        int n2;
        int n3;
        if (d < this.x1[0]) {
            if (d >= this.x1[0] - potentialRoundingError) {
                d = this.x1[0];
            } else {
                throw new IllegalArgumentException(d + " is outside the limits, " + this.x1[0] + " - " + this.x1[this.lPoints - 1]);
            }
        }
        if (d2 < this.x2[0]) {
            if (d2 >= this.x2[0] - potentialRoundingError) {
                d2 = this.x2[0];
            } else {
                throw new IllegalArgumentException(d2 + " is outside the limits, " + this.x2[0] + " - " + this.x2[this.mPoints - 1]);
            }
        }
        if (d3 < this.x3[0]) {
            if (d3 >= this.x3[0] - potentialRoundingError) {
                d3 = this.x3[0];
            } else {
                throw new IllegalArgumentException(d + " is outside the limits, " + this.x3[0] + " - " + this.x3[this.nPoints - 1]);
            }
        }
        if (d > this.x1[this.lPoints - 1]) {
            if (d <= this.x1[this.lPoints - 1] + potentialRoundingError) {
                d = this.x1[this.lPoints - 1];
            } else {
                throw new IllegalArgumentException(d + " is outside the limits, " + this.x1[0] + " - " + this.x1[this.lPoints - 1]);
            }
        }
        if (d2 > this.x2[this.mPoints - 1]) {
            if (d2 <= this.x2[this.mPoints - 1] + potentialRoundingError) {
                d2 = this.x2[this.mPoints - 1];
            } else {
                throw new IllegalArgumentException(d2 + " is outside the limits, " + this.x2[0] + " - " + this.x2[this.mPoints - 1]);
            }
        }
        if (d3 > this.x3[this.nPoints - 1]) {
            if (d3 <= this.x3[this.nPoints - 1] + potentialRoundingError) {
                d3 = this.x3[this.mPoints - 1];
            } else {
                throw new IllegalArgumentException(d3 + " is outside the limits, " + this.x3[0] + " - " + this.x3[this.nPoints - 1]);
            }
        }
        this.xx1 = d;
        this.xx2 = d2;
        this.xx3 = d3;
        int n4 = 0;
        double d4 = (Double)this.coeff.get(7 * n4);
        double d5 = (Double)this.coeff.get(7 * n4 + 1);
        double d6 = (Double)this.coeff.get(7 * n4 + 2);
        double d7 = (Double)this.coeff.get(7 * n4 + 3);
        double d8 = (Double)this.coeff.get(7 * n4 + 4);
        double d9 = (Double)this.coeff.get(7 * n4 + 5);
        boolean bl = true;
        while (bl) {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (d >= d5 && d <= d5 + d4) {
                bl2 = true;
            }
            if (d2 >= d7 && d2 <= d7 + d6) {
                bl3 = true;
            }
            if (d3 >= d9 && d3 <= d9 + d8) {
                bl4 = true;
            }
            if (bl2 && bl3 && bl4) {
                bl = false;
                continue;
            }
            d4 = (Double)this.coeff.get(7 * ++n4);
            d5 = (Double)this.coeff.get(7 * n4 + 1);
            d6 = (Double)this.coeff.get(7 * n4 + 2);
            d7 = (Double)this.coeff.get(7 * n4 + 3);
            d8 = (Double)this.coeff.get(7 * n4 + 4);
            d9 = (Double)this.coeff.get(7 * n4 + 5);
        }
        double[][][] dArray = (double[][][])this.coeff.get(7 * n4 + 6);
        double d10 = (d - d5) / d4;
        double d11 = (d2 - d7) / d6;
        double d12 = (d3 - d9) / d8;
        this.interpolatedValue = 0.0;
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < 4; ++n) {
                    this.interpolatedValue += dArray[n3][n2][n] * Math.pow(d10, n3) * Math.pow(d11, n2) * Math.pow(d12, n);
                }
            }
        }
        this.interpolatedDydx1 = 0.0;
        for (n3 = 1; n3 < 4; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < 4; ++n) {
                    this.interpolatedDydx1 += (double)n3 * dArray[n3][n2][n] * Math.pow(d10, n3 - 1) * Math.pow(d11, n2) * Math.pow(d12, n);
                }
            }
        }
        this.interpolatedDydx2 = 0.0;
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 1; n2 < 4; ++n2) {
                for (n = 0; n < 4; ++n) {
                    this.interpolatedDydx2 += (double)n2 * dArray[n3][n2][n] * Math.pow(d10, n3) * Math.pow(d11, n2 - 1) * Math.pow(d12, n);
                }
            }
        }
        this.interpolatedDydx3 = 0.0;
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 1; n2 < 4; ++n2) {
                for (n = 0; n < 4; ++n) {
                    this.interpolatedDydx2 += (double)n * dArray[n3][n2][n] * Math.pow(d10, n3) * Math.pow(d11, n2) * Math.pow(d12, n - 1);
                }
            }
        }
        this.interpolatedD2ydx1dx2 = 0.0;
        for (n3 = 1; n3 < 4; ++n3) {
            for (n2 = 1; n2 < 4; ++n2) {
                for (n = 0; n < 4; ++n) {
                    this.interpolatedD2ydx1dx2 += (double)(n3 * n2) * dArray[n3][n2][n] * Math.pow(d10, n3 - 1) * Math.pow(d11, n2 - 1) * Math.pow(d12, n);
                }
            }
        }
        return this.interpolatedValue;
    }

    public double[] getInterpolatedValues() {
        double[] dArray = new double[]{this.interpolatedValue, this.interpolatedDydx1, this.interpolatedDydx2, this.interpolatedDydx3, this.interpolatedD2ydx1dx2, this.interpolatedD2ydx1dx3, this.interpolatedD2ydx2dx3, this.interpolatedD3ydx1dx2dx3, this.xx1, this.xx2, this.xx3};
        return dArray;
    }

    public double[][][] getGridDydx1() {
        double[][][] dArray = new double[this.lPoints][this.mPoints][this.nPoints];
        for (int i = 0; i < this.lPoints; ++i) {
            for (int j = 0; j < this.mPoints; ++j) {
                for (int k = 0; k < this.nPoints; ++k) {
                    dArray[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.dydx1[i][j][k];
                }
            }
        }
        return dArray;
    }

    public double[][][] getGridDydx2() {
        double[][][] dArray = new double[this.lPoints][this.mPoints][this.nPoints];
        for (int i = 0; i < this.lPoints; ++i) {
            for (int j = 0; j < this.mPoints; ++j) {
                for (int k = 0; k < this.nPoints; ++k) {
                    dArray[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.dydx2[i][j][k];
                }
            }
        }
        return dArray;
    }

    public double[][][] getGridDydx3() {
        double[][][] dArray = new double[this.lPoints][this.mPoints][this.nPoints];
        for (int i = 0; i < this.lPoints; ++i) {
            for (int j = 0; j < this.mPoints; ++j) {
                for (int k = 0; k < this.nPoints; ++k) {
                    dArray[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.dydx3[i][j][k];
                }
            }
        }
        return dArray;
    }

    public double[][][] getGridD2ydx1dx2() {
        double[][][] dArray = new double[this.lPoints][this.mPoints][this.nPoints];
        for (int i = 0; i < this.lPoints; ++i) {
            for (int j = 0; j < this.mPoints; ++j) {
                for (int k = 0; k < this.nPoints; ++k) {
                    dArray[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.d2ydx1dx2[i][j][k];
                }
            }
        }
        return dArray;
    }

    public double[][][] getGridD2ydx1dx3() {
        double[][][] dArray = new double[this.lPoints][this.mPoints][this.nPoints];
        for (int i = 0; i < this.lPoints; ++i) {
            for (int j = 0; j < this.mPoints; ++j) {
                for (int k = 0; k < this.nPoints; ++k) {
                    dArray[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.d2ydx1dx3[i][j][k];
                }
            }
        }
        return dArray;
    }

    public double[][][] getGridD2ydx2dx3() {
        double[][][] dArray = new double[this.lPoints][this.mPoints][this.nPoints];
        for (int i = 0; i < this.lPoints; ++i) {
            for (int j = 0; j < this.mPoints; ++j) {
                for (int k = 0; k < this.nPoints; ++k) {
                    dArray[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.d2ydx2dx3[i][j][k];
                }
            }
        }
        return dArray;
    }

    public double[][][] getGridD3ydx1dx2dx3() {
        double[][][] dArray = new double[this.lPoints][this.mPoints][this.nPoints];
        for (int i = 0; i < this.lPoints; ++i) {
            for (int j = 0; j < this.mPoints; ++j) {
                for (int k = 0; k < this.nPoints; ++k) {
                    dArray[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.d3ydx1dx2dx3[i][j][k];
                }
            }
        }
        return dArray;
    }

    public static void resetDelta(double d) {
        delta = d;
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        potentialRoundingError = 0.0;
    }

    public static void potentialRoundingError(double d) {
        potentialRoundingError = d;
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] dArray = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1], this.xMin[2], this.xMax[2]};
        return dArray;
    }

    public void displayLimits() {
        System.out.println(" ");
        for (int i = 0; i < 3; ++i) {
            System.out.println("The limits to the x array x" + (i + 1) + " are " + this.xMin[i] + " and " + this.xMax[i]);
        }
        System.out.println(" ");
    }
}

