/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.math.Fmath;
import flanagan.math.Point;
import flanagan.math.VectorMaths;
import flanagan.plot.PlotGraph;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class PolylineSimplification {
    private Point[] originalPoints = null;
    private int nPoints = 0;
    private Point[] simplifiedPoints = null;
    private int[] simplifiedIndices = null;
    private int nSimplifiedPoints = 0;
    private int pointDimension = 0;
    private double tolerance = 0.0;
    private double toleranceSquared = 0.0;
    private boolean tolerenceEntered = false;
    private boolean simplifyDone = false;

    public PolylineSimplification(Point[] pointArray) {
        this.originalPoints = pointArray;
        int[] nArray = Point.getArrayDimensions(pointArray);
        this.nPoints = nArray[0];
        this.pointDimension = nArray[1];
        if (this.pointDimension > 3 || this.pointDimension < 2) {
            throw new IllegalArgumentException("This method will not operate on dimensions greater than 3");
        }
        this.simplifyDone = false;
    }

    public PolylineSimplification(double[] dArray, double[] dArray2) {
        this.pointDimension = 2;
        this.nPoints = dArray.length;
        if (this.nPoints != dArray2.length) {
            throw new IllegalArgumentException("The number of x-coordinate points, " + this.nPoints + ", must equal the number of y-coordinate points, " + dArray2.length);
        }
        this.originalPoints = Point.oneDarray(dArray, dArray2);
        this.simplifyDone = false;
    }

    public PolylineSimplification(double[] dArray, double[] dArray2, double[] dArray3) {
        this.pointDimension = 3;
        this.nPoints = dArray.length;
        if (this.nPoints != dArray2.length) {
            throw new IllegalArgumentException("The number of x-coordinate points, " + this.nPoints + ", must equal the number of y-coordinate points, " + dArray2.length);
        }
        if (this.nPoints != dArray3.length) {
            throw new IllegalArgumentException("The number of x-coordinate points, " + this.nPoints + ", must equal the number of z-coordinate points, " + dArray3.length);
        }
        this.originalPoints = Point.oneDarray(dArray, dArray2, dArray3);
        this.simplifyDone = false;
    }

    public PolylineSimplification(double[][] dArray) {
        this.pointDimension = dArray.length;
        this.nPoints = dArray[0].length;
        this.originalPoints = Point.oneDarray(dArray);
        if (this.pointDimension > 3 || this.pointDimension < 2) {
            throw new IllegalArgumentException("This method will not operate on dimensions greater than 3");
        }
        this.simplifyDone = false;
    }

    public PolylineSimplification(Object object) {
        Object object2 = Fmath.copyObject(object);
        this.nPoints = 1;
        while (!((object2 = Array.get(object2, 0)) instanceof Double)) {
            ++this.nPoints;
        }
        double[][] dArray = (double[][])object;
        this.pointDimension = dArray.length;
        this.originalPoints = Point.oneDarray(dArray);
        if (this.pointDimension > 3 || this.pointDimension < 2) {
            throw new IllegalArgumentException("This method will not operate on dimensions greater than 3 or less than 2");
        }
        this.simplifyDone = false;
    }

    public Point[] douglasPeucker(double d) {
        this.tolerance = d;
        this.toleranceSquared = d * d;
        this.tolerenceEntered = true;
        return this.douglasPeucker();
    }

    public Point[] douglasPeucker() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Point[] pointArray = Point.oneDarray(this.nPoints);
        int[] nArray = new int[this.nPoints];
        boolean[] blArray = new boolean[this.nPoints];
        if (this.pointDimension == 2) {
            this.toThreeDimO();
        }
        pointArray[0] = this.originalPoints[0].copy();
        nArray[0] = 0;
        n2 = 1;
        for (n = 1; n < this.nPoints; ++n) {
            if (Point.distanceSquared(this.originalPoints[n], this.originalPoints[n3]) < this.toleranceSquared) continue;
            pointArray[n2] = this.originalPoints[n].copy();
            nArray[n2] = n;
            n3 = n;
            ++n2;
        }
        if (n3 < this.nPoints - 1) {
            pointArray[n2] = this.originalPoints[this.nPoints - 1].copy();
            nArray[n2] = this.nPoints - 1;
            ++n2;
        }
        blArray[0] = true;
        blArray[n2 - 1] = true;
        this.douglasPeuckerSimplificationRoutine(pointArray, 0, n2 - 1, blArray);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < n2; ++n) {
            if (!blArray[n]) continue;
            arrayList.add(pointArray[n]);
            arrayList2.add(new Integer(nArray[n]));
        }
        this.nSimplifiedPoints = arrayList.size();
        this.simplifiedPoints = Point.oneDarray(this.nSimplifiedPoints);
        this.simplifiedIndices = new int[this.nSimplifiedPoints];
        for (n = 0; n < this.nSimplifiedPoints; ++n) {
            this.simplifiedPoints[n] = (Point)arrayList.get(n);
            this.simplifiedIndices[n] = (Integer)arrayList2.get(n);
        }
        Point[] pointArray2 = Point.copy(this.simplifiedPoints);
        int[] nArray2 = (int[])this.simplifiedIndices.clone();
        for (n = 0; n < this.nSimplifiedPoints - 1; ++n) {
            for (int i = n + 1; i < this.nSimplifiedPoints; ++i) {
                if (!Point.isEqual(pointArray2[n], pointArray2[i])) continue;
                for (int j = i; j < this.nSimplifiedPoints - 1; ++j) {
                    pointArray2[j] = pointArray2[j + 1];
                    nArray2[j] = nArray2[j + 1];
                }
                --this.nSimplifiedPoints;
            }
        }
        this.simplifiedPoints = Point.oneDarray(this.nSimplifiedPoints);
        for (n = 0; n < this.nSimplifiedPoints; ++n) {
            this.simplifiedPoints[n] = pointArray2[n];
            this.simplifiedIndices[n] = nArray2[n];
        }
        if (this.pointDimension == 2) {
            this.toTwoDimO();
            this.toTwoDimS();
        }
        this.simplifyDone = true;
        return this.simplifiedPoints;
    }

    private void douglasPeuckerSimplificationRoutine(Point[] pointArray, int n, int n2, boolean[] blArray) {
        if (n2 <= n + 1) {
            return;
        }
        int n3 = n;
        double d = 0.0;
        Point[] pointArray2 = Point.oneDarray(2);
        pointArray2[0] = pointArray[n];
        pointArray2[1] = pointArray[n2];
        VectorMaths vectorMaths = new VectorMaths(pointArray[n], pointArray[n2]);
        double d2 = pointArray[n].distanceSquared(pointArray[n2]);
        VectorMaths vectorMaths2 = null;
        Point point = null;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = n + 1; i < n2; ++i) {
            vectorMaths2 = new VectorMaths(pointArray2[0], pointArray[i]);
            d4 = vectorMaths2.dot(vectorMaths);
            if (d4 <= 0.0) {
                d5 = Point.distanceSquared(pointArray[i], pointArray2[0]);
            } else if (d2 <= d4) {
                d5 = Point.distanceSquared(pointArray[i], pointArray2[1]);
            } else {
                d3 = d4 / d2;
                VectorMaths vectorMaths3 = vectorMaths.times(d3);
                VectorMaths vectorMaths4 = new VectorMaths(pointArray2[0]).plus(vectorMaths3);
                point = vectorMaths4.getFinalPoint();
                d5 = Point.distanceSquared(pointArray[i], point);
            }
            if (d5 <= d) continue;
            n3 = i;
            d = d5;
        }
        if (d > this.toleranceSquared) {
            blArray[n3] = true;
            this.douglasPeuckerSimplificationRoutine(pointArray, n, n3, blArray);
            this.douglasPeuckerSimplificationRoutine(pointArray, n3, n2, blArray);
        }
    }

    private void toThreeDimO() {
        for (int i = 0; i < this.nPoints; ++i) {
            this.originalPoints[i].toThreeD();
        }
    }

    private void toTwoDimO() {
        for (int i = 0; i < this.nPoints; ++i) {
            this.originalPoints[i].toTwoD();
        }
    }

    private void toTwoDimS() {
        for (int i = 0; i < this.nSimplifiedPoints; ++i) {
            this.simplifiedPoints[i].toTwoD();
        }
    }

    public double[][] simplifiedCurveCoordinates() {
        if (!this.simplifyDone) {
            if (!this.tolerenceEntered) {
                throw new IllegalArgumentException("No tolerance has been entered");
            }
            this.douglasPeucker();
        }
        return Point.getArrayCoordinates(this.simplifiedPoints);
    }

    public Point[] simplifiedCurve() {
        if (!this.simplifyDone) {
            if (!this.tolerenceEntered) {
                throw new IllegalArgumentException("No tolerance has been entered");
            }
            this.douglasPeucker();
        }
        return this.simplifiedPoints;
    }

    public int numberOfSimplifiedCurvePoints() {
        return this.nSimplifiedPoints;
    }

    public int[] simplifiedCurveIndices() {
        return this.simplifiedIndices;
    }

    public void setTolerance(double d) {
        this.tolerance = d;
        this.toleranceSquared = d * d;
        this.tolerenceEntered = true;
    }

    public double getTolerance() {
        if (!this.tolerenceEntered) {
            System.out.println("No tolerance has been entered; 0.0 returned");
        }
        return this.tolerance;
    }

    public void plot() {
        if (this.pointDimension != 2) {
            throw new IllegalArgumentException("Plot will only function for an array of 2D points");
        }
        double[][] dArray = Point.getArrayCoordinates(this.originalPoints);
        double[][] dArray2 = this.simplifiedCurveCoordinates();
        double[][] dArrayArray = new double[][]{dArray[0], dArray[1], dArray2[0], dArray2[1]};
        PlotGraph plotGraph = new PlotGraph(dArrayArray);
        int[] nArray = new int[]{3, 3};
        plotGraph.setLine(nArray);
        plotGraph.setXaxisLegend("x-coordinate");
        plotGraph.setYaxisLegend("y-coordinate");
        plotGraph.setGraphTitle("Polyline Simplification: tolerance = " + this.tolerance);
        plotGraph.setGraphTitle2("circles = original data, squares = simplified curve");
        plotGraph.plot();
    }
}

