/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSplineFast;
import flanagan.interpolation.CubicSplineFast;
import flanagan.math.Fmath;
import java.lang.reflect.Array;

public class PolyCubicSplineFast {
    private int nDimensions = 0;
    private Object fOfX = null;
    private Object xArrays = null;
    private Object method = null;
    private double[][] xArray = null;
    private double[] csArray = null;
    private PolyCubicSplineFast[] pcs = null;
    private int dimOne = 0;
    private double yValue = 0.0;

    public PolyCubicSplineFast(Object object, Object object2) {
        Object object3;
        this.fOfX = Fmath.copyObject(object2);
        this.xArrays = Fmath.copyObject(object);
        Object object4 = Fmath.copyObject(object2);
        this.nDimensions = 1;
        while (!((object4 = Array.get(object4, 0)) instanceof Double)) {
            ++this.nDimensions;
        }
        if (this.xArrays instanceof double[] && this.nDimensions == 1) {
            object3 = new double[][]{(double[])this.xArrays};
            this.xArrays = object3;
        } else if (!(this.xArrays instanceof double[][])) {
            throw new IllegalArgumentException("xArrays should be a two dimensional array of doubles");
        }
        this.xArray = (double[][])this.xArrays;
        switch (this.nDimensions) {
            case 0: {
                throw new IllegalArgumentException("data array must have at least one dimension");
            }
            case 1: {
                object3 = new CubicSplineFast(this.xArray[0], (double[])this.fOfX);
                this.method = object3;
                break;
            }
            case 2: {
                BiCubicSplineFast biCubicSplineFast = new BiCubicSplineFast(this.xArray[0], this.xArray[1], (double[][])this.fOfX);
                this.method = biCubicSplineFast;
                break;
            }
            default: {
                int n;
                Object object5 = object2;
                this.dimOne = Array.getLength(object5);
                this.csArray = new double[this.dimOne];
                double[][] dArrayArray = new double[this.nDimensions - 1][];
                for (n = 0; n < this.nDimensions - 1; ++n) {
                    dArrayArray[n] = this.xArray[n + 1];
                }
                this.pcs = new PolyCubicSplineFast[this.dimOne];
                for (n = 0; n < this.dimOne; ++n) {
                    Object object6 = Array.get(object5, n);
                    this.pcs[n] = new PolyCubicSplineFast(dArrayArray, object6);
                }
            }
        }
    }

    public double interpolate(double[] dArray) {
        int n = dArray.length;
        if (n != this.nDimensions) {
            throw new IllegalArgumentException("Number of unknown value coordinates, " + n + ", does not equal the number of tabulated data dimensions, " + this.nDimensions);
        }
        switch (this.nDimensions) {
            case 0: {
                throw new IllegalArgumentException("data array must have at least one dimension");
            }
            case 1: {
                this.yValue = ((CubicSplineFast)this.method).interpolate(dArray[0]);
                break;
            }
            case 2: {
                this.yValue = ((BiCubicSplineFast)this.method).interpolate(dArray[0], dArray[1]);
                break;
            }
            default: {
                int n2;
                double[] dArray2 = new double[this.nDimensions - 1];
                for (n2 = 0; n2 < this.nDimensions - 1; ++n2) {
                    dArray2[n2] = dArray[n2 + 1];
                }
                for (n2 = 0; n2 < this.dimOne; ++n2) {
                    this.csArray[n2] = this.pcs[n2].interpolate(dArray2);
                }
                CubicSplineFast cubicSplineFast = new CubicSplineFast(this.xArray[0], this.csArray);
                this.yValue = cubicSplineFast.interpolate(dArray[0]);
            }
        }
        return this.yValue;
    }
}

