/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.math.Conv;
import flanagan.math.Fmath;

public class CubicSpline {
    private int nPoints = 0;
    private int nPointsOriginal = 0;
    private double[] y = null;
    private double[] x = null;
    private double yy = Double.NaN;
    private double dydx = Double.NaN;
    private int[] newAndOldIndices;
    private double xMin = Double.NaN;
    private double xMax = Double.NaN;
    private double range = Double.NaN;
    private double[] d2ydx2 = null;
    private double yp1 = Double.NaN;
    private double ypn = Double.NaN;
    private boolean derivCalculated = false;
    private boolean checkPoints = false;
    private static boolean supress = false;
    private static boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public CubicSpline(double[] dArray, double[] dArray2) {
        this.nPointsOriginal = this.nPoints = dArray.length;
        if (this.nPoints != dArray2.length) {
            throw new IllegalArgumentException("Arrays x and y are of different length " + this.nPoints + " " + dArray2.length);
        }
        if (this.nPoints < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        this.x = new double[this.nPoints];
        this.y = new double[this.nPoints];
        this.d2ydx2 = new double[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            this.x[i] = dArray[i];
            this.y[i] = dArray2[i];
        }
        this.orderPoints();
        this.checkForIdenticalPoints();
        this.calcDeriv();
    }

    public CubicSpline(int n) {
        this.nPointsOriginal = this.nPoints = n;
        if (this.nPoints < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        this.x = new double[n];
        this.y = new double[n];
        this.d2ydx2 = new double[n];
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
    }

    public static void potentialRoundingError(double d) {
        potentialRoundingError = d;
    }

    public void resetData(double[] dArray, double[] dArray2) {
        this.nPoints = this.nPointsOriginal;
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays x and y are of different length");
        }
        if (this.nPoints != dArray.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        for (int i = 0; i < this.nPoints; ++i) {
            this.x[i] = dArray[i];
            this.y[i] = dArray2[i];
        }
        this.orderPoints();
        this.checkForIdenticalPoints();
        this.calcDeriv();
    }

    public static void averageIdenticalAbscissae() {
        averageIdenticalAbscissae = true;
    }

    public void orderPoints() {
        double[] dArray = new double[this.nPoints];
        this.newAndOldIndices = new int[this.nPoints];
        Fmath.selectionSort(this.x, dArray, this.newAndOldIndices);
        Fmath.selectionSort(this.x, this.y, this.x, this.y);
        this.xMin = Fmath.minimum(this.x);
        this.xMax = Fmath.maximum(this.x);
        this.range = this.xMax - this.xMin;
    }

    public double getXmax() {
        return this.xMax;
    }

    public double getXmin() {
        return this.xMin;
    }

    public double[] getLimits() {
        double[] dArray = new double[]{this.xMin, this.xMax};
        return dArray;
    }

    public void displayLimits() {
        System.out.println("\nThe limits of the abscissae (x-values) are " + this.xMin + " and " + this.xMax + "\n");
    }

    public void checkForIdenticalPoints() {
        int n = this.nPoints;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            boolean bl2 = true;
            int n3 = n2 + 1;
            while (bl2) {
                if (this.x[n2] == this.x[n3]) {
                    int n4;
                    double[] dArray;
                    if (this.y[n2] == this.y[n3]) {
                        if (!supress) {
                            System.out.print("CubicSpline: Two identical points, " + this.x[n2] + ", " + this.y[n2]);
                            System.out.println(", in data array at indices " + this.newAndOldIndices[n2] + " and " + this.newAndOldIndices[n3] + ", latter point removed");
                        }
                        double[] dArray2 = new double[this.nPoints - 1];
                        dArray = new double[this.nPoints - 1];
                        int[] nArray = new int[this.nPoints - 1];
                        for (n4 = 0; n4 < n3; ++n4) {
                            dArray2[n4] = this.x[n4];
                            dArray[n4] = this.y[n4];
                            nArray[n4] = this.newAndOldIndices[n4];
                        }
                        for (n4 = n3; n4 < this.nPoints - 1; ++n4) {
                            dArray2[n4] = this.x[n4 + 1];
                            dArray[n4] = this.y[n4 + 1];
                            nArray[n4] = this.newAndOldIndices[n4 + 1];
                        }
                        --this.nPoints;
                        this.x = Conv.copy(dArray2);
                        this.y = Conv.copy(dArray);
                        this.newAndOldIndices = Conv.copy(nArray);
                    } else if (averageIdenticalAbscissae) {
                        if (!supress) {
                            System.out.print("CubicSpline: Two identical points on the absicca (x-axis) with different ordinate (y-axis) values, " + this.x[n2] + ": " + this.y[n2] + ", " + this.y[n3]);
                            System.out.println(", average of the ordinates taken");
                        }
                        this.y[n2] = (this.y[n2] + this.y[n3]) / 2.0;
                        double[] dArray3 = new double[this.nPoints - 1];
                        dArray = new double[this.nPoints - 1];
                        int[] nArray = new int[this.nPoints - 1];
                        for (n4 = 0; n4 < n3; ++n4) {
                            dArray3[n4] = this.x[n4];
                            dArray[n4] = this.y[n4];
                            nArray[n4] = this.newAndOldIndices[n4];
                        }
                        for (n4 = n3; n4 < this.nPoints - 1; ++n4) {
                            dArray3[n4] = this.x[n4 + 1];
                            dArray[n4] = this.y[n4 + 1];
                            nArray[n4] = this.newAndOldIndices[n4 + 1];
                        }
                        --this.nPoints;
                        this.x = Conv.copy(dArray3);
                        this.y = Conv.copy(dArray);
                        this.newAndOldIndices = Conv.copy(nArray);
                    } else {
                        double d = this.range * 5.0E-4;
                        if (!supress) {
                            System.out.print("CubicSpline: Two identical points on the absicca (x-axis) with different ordinate (y-axis) values, " + this.x[n2] + ": " + this.y[n2] + ", " + this.y[n3]);
                        }
                        boolean bl3 = false;
                        if (n2 == 0) {
                            if (this.x[2] - this.x[1] <= d) {
                                d = (this.x[2] - this.x[1]) / 2.0;
                            }
                            bl3 = this.y[0] > this.y[1] ? (this.y[1] > this.y[2] ? this.stay(n2, n3, d) : this.swap(n2, n3, d)) : (this.y[2] <= this.y[1] ? this.swap(n2, n3, d) : this.stay(n2, n3, d));
                        }
                        if (n3 == this.nPoints - 1) {
                            if (this.x[n - 2] - this.x[n - 3] <= d) {
                                d = (this.x[n - 2] - this.x[n - 3]) / 2.0;
                            }
                            bl3 = this.y[n2] <= this.y[n3] ? (this.y[n2 - 1] <= this.y[n2] ? this.stay(n2, n3, d) : this.swap(n2, n3, d)) : (this.y[n2 - 1] <= this.y[n2] ? this.swap(n2, n3, d) : this.stay(n2, n3, d));
                        }
                        if (n2 != 0 && n3 != this.nPoints - 1) {
                            if (this.x[n2] - this.x[n2 - 1] <= d) {
                                d = (this.x[n2] - this.x[n2 - 1]) / 2.0;
                            }
                            if (this.x[n3 + 1] - this.x[n3] <= d) {
                                d = (this.x[n3 + 1] - this.x[n3]) / 2.0;
                            }
                            if (this.y[n2] > this.y[n2 - 1]) {
                                if (this.y[n3] > this.y[n2]) {
                                    bl3 = this.y[n3] > this.y[n3 + 1] ? (this.y[n2 - 1] <= this.y[n3 + 1] ? this.stay(n2, n3, d) : this.swap(n2, n3, d)) : this.stay(n2, n3, d);
                                } else if (this.y[n3 + 1] > this.y[n3]) {
                                    if (this.y[n3 + 1] > this.y[n2 - 1] && this.y[n3 + 1] > this.y[n2 - 1]) {
                                        bl3 = this.stay(n2, n3, d);
                                    }
                                } else {
                                    bl3 = this.swap(n2, n3, d);
                                }
                            } else if (this.y[n3] > this.y[n2]) {
                                if (this.y[n3 + 1] > this.y[n3]) {
                                    bl3 = this.stay(n2, n3, d);
                                }
                            } else {
                                bl3 = this.y[n3 + 1] > this.y[n2 - 1] ? this.stay(n2, n3, d) : this.swap(n2, n3, d);
                            }
                        }
                        if (!bl3) {
                            bl3 = this.stay(n2, n3, d);
                        }
                        if (!supress) {
                            System.out.println(", the two abscissae have been separated by a distance " + d);
                        }
                        ++n3;
                    }
                    if (this.nPoints - 1 == n2) {
                        bl2 = false;
                    }
                } else {
                    ++n3;
                }
                if (n3 < this.nPoints) continue;
                bl2 = false;
            }
            if (++n2 < this.nPoints - 1) continue;
            bl = false;
        }
        if (this.nPoints < 3) {
            throw new IllegalArgumentException("Removal of duplicate points has reduced the number of points to less than the required minimum of three data points");
        }
        this.checkPoints = true;
    }

    private boolean swap(int n, int n2, double d) {
        int n3 = n;
        this.x[n3] = this.x[n3] + d;
        int n4 = n2;
        this.x[n4] = this.x[n4] - d;
        double d2 = this.x[n];
        this.x[n] = this.x[n2];
        this.x[n2] = d2;
        d2 = this.y[n];
        this.y[n] = this.y[n2];
        this.y[n2] = d2;
        return true;
    }

    private boolean stay(int n, int n2, double d) {
        int n3 = n;
        this.x[n3] = this.x[n3] - d;
        int n4 = n2;
        this.x[n4] = this.x[n4] + d;
        return true;
    }

    public static void supress() {
        supress = true;
    }

    public static void unsupress() {
        supress = false;
    }

    public static CubicSpline zero(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        CubicSpline cubicSpline = new CubicSpline(n);
        return cubicSpline;
    }

    public static CubicSpline[] oneDarray(int n, int n2) {
        if (n2 < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        CubicSpline[] cubicSplineArray = new CubicSpline[n];
        for (int i = 0; i < n; ++i) {
            cubicSplineArray[i] = CubicSpline.zero(n2);
        }
        return cubicSplineArray;
    }

    public void setDerivLimits(double d, double d2) {
        this.yp1 = d;
        this.ypn = d2;
        this.calcDeriv();
    }

    public void setDerivLimits() {
        this.yp1 = Double.NaN;
        this.ypn = Double.NaN;
        this.calcDeriv();
    }

    public void setDeriv(double d, double d2) {
        this.yp1 = d;
        this.ypn = d2;
        this.calcDeriv();
    }

    public double[] getDeriv() {
        if (!this.derivCalculated) {
            this.calcDeriv();
        }
        return this.d2ydx2;
    }

    public void setDeriv(double[] dArray) {
        this.d2ydx2 = dArray;
        this.derivCalculated = true;
    }

    public void calcDeriv() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = new double[this.nPoints];
        if (Double.isNaN(this.yp1)) {
            dArray[0] = 0.0;
            this.d2ydx2[0] = 0.0;
        } else {
            this.d2ydx2[0] = -0.5;
            dArray[0] = 3.0 / (this.x[1] - this.x[0]) * ((this.y[1] - this.y[0]) / (this.x[1] - this.x[0]) - this.yp1);
        }
        for (n = 1; n <= this.nPoints - 2; ++n) {
            d3 = (this.x[n] - this.x[n - 1]) / (this.x[n + 1] - this.x[n - 1]);
            d = d3 * this.d2ydx2[n - 1] + 2.0;
            this.d2ydx2[n] = (d3 - 1.0) / d;
            dArray[n] = (this.y[n + 1] - this.y[n]) / (this.x[n + 1] - this.x[n]) - (this.y[n] - this.y[n - 1]) / (this.x[n] - this.x[n - 1]);
            dArray[n] = (6.0 * dArray[n] / (this.x[n + 1] - this.x[n - 1]) - d3 * dArray[n - 1]) / d;
        }
        if (Double.isNaN(this.ypn)) {
            d4 = 0.0;
            d2 = 0.0;
        } else {
            d2 = 0.5;
            d4 = 3.0 / (this.x[this.nPoints - 1] - this.x[this.nPoints - 2]) * (this.ypn - (this.y[this.nPoints - 1] - this.y[this.nPoints - 2]) / (this.x[this.nPoints - 1] - this.x[this.nPoints - 2]));
        }
        this.d2ydx2[this.nPoints - 1] = (d4 - d2 * dArray[this.nPoints - 2]) / (d2 * this.d2ydx2[this.nPoints - 2] + 1.0);
        for (n = this.nPoints - 2; n >= 0; --n) {
            this.d2ydx2[n] = this.d2ydx2[n] * this.d2ydx2[n + 1] + dArray[n];
        }
        this.derivCalculated = true;
    }

    public double interpolate(double d) {
        if (d < this.x[0]) {
            if (roundingCheck && Math.abs(this.x[0] - d) <= Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.x[0])))) * potentialRoundingError) {
                d = this.x[0];
            } else {
                throw new IllegalArgumentException("x (" + d + ") is outside the range of data points (" + this.x[0] + " to " + this.x[this.nPoints - 1] + ")");
            }
        }
        if (d > this.x[this.nPoints - 1]) {
            if (roundingCheck && Math.abs(d - this.x[this.nPoints - 1]) <= Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.x[this.nPoints - 1])))) * potentialRoundingError) {
                d = this.x[this.nPoints - 1];
            } else {
                throw new IllegalArgumentException("x (" + d + ") is outside the range of data points (" + this.x[0] + " to " + this.x[this.nPoints - 1] + ")");
            }
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = this.nPoints - 1;
        while (n3 - n2 > 1) {
            n = n3 + n2 >> 1;
            if (this.x[n] > d) {
                n3 = n;
                continue;
            }
            n2 = n;
        }
        d2 = this.x[n3] - this.x[n2];
        if (d2 == 0.0) {
            throw new IllegalArgumentException("Two values of x are identical: point " + n2 + " (" + this.x[n2] + ") and point " + n3 + " (" + this.x[n3] + ")");
        }
        d4 = (this.x[n3] - d) / d2;
        d3 = (d - this.x[n2]) / d2;
        this.yy = d4 * this.y[n2] + d3 * this.y[n3] + ((d4 * d4 * d4 - d4) * this.d2ydx2[n2] + (d3 * d3 * d3 - d3) * this.d2ydx2[n3]) * (d2 * d2) / 6.0;
        this.dydx = (this.y[n3] - this.y[n2]) / d2 - ((3.0 * d4 * d4 - 1.0) * this.d2ydx2[n2] - (3.0 * d3 * d3 - 1.0) * this.d2ydx2[n3]) * d2 / 6.0;
        return this.yy;
    }

    public double[] interpolate_for_y_and_dydx(double d) {
        this.interpolate(d);
        double[] dArray = new double[]{this.yy, this.dydx};
        return dArray;
    }

    public static double interpolate(double d, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray.length != dArray2.length || dArray.length != dArray3.length || dArray2.length != dArray3.length) {
            throw new IllegalArgumentException("array lengths are not all equal");
        }
        int n = dArray.length;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = n - 1;
        while (n4 - n3 > 1) {
            n2 = n4 + n3 >> 1;
            if (dArray[n2] > d) {
                n4 = n2;
                continue;
            }
            n3 = n2;
        }
        d2 = dArray[n4] - dArray[n3];
        if (d2 == 0.0) {
            throw new IllegalArgumentException("Two values of x are identical");
        }
        d4 = (dArray[n4] - d) / d2;
        d3 = (d - dArray[n3]) / d2;
        d5 = d4 * dArray2[n3] + d3 * dArray2[n4] + ((d4 * d4 * d4 - d4) * dArray3[n3] + (d3 * d3 * d3 - d3) * dArray3[n4]) * (d2 * d2) / 6.0;
        return d5;
    }
}

