/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.CubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;

public class CubicInterpolation {
    private int nPoints = 0;
    private double[] x = null;
    private double[] y = null;
    private double[] dydx = null;
    private boolean derivCalculated = false;
    private CubicSpline cs = null;
    private double incrX = 0.0;
    double[][] coeff = null;
    private double xx = Double.NaN;
    private double[][] weights = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {-3.0, 3.0, -2.0, -1.0}, {2.0, -2.0, 1.0, 1.0}};
    private int[] xIndices = null;
    private double xMin = 0.0;
    private double xMax = 0.0;
    private double interpolatedValue = Double.NaN;
    private double interpolatedDydx = Double.NaN;
    private boolean numerDiffFlag = true;
    private static double delta = 0.001;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = false;

    public CubicInterpolation(double[] dArray, double[] dArray2, int n) {
        if (n == 0) {
            this.numerDiffFlag = false;
        } else if (n == 1) {
            this.numerDiffFlag = true;
        } else {
            throw new IllegalArgumentException("The numerical differencing option, " + n + ", must be 0 or 1");
        }
        this.initialize(Conv.copy(dArray), Conv.copy(dArray2));
        this.calcDeriv();
        this.gridCoefficients();
    }

    public CubicInterpolation(double[] dArray, double[] dArray2, double[] dArray3) {
        this.initialize(Conv.copy(dArray), Conv.copy(dArray2), Conv.copy(dArray3));
        this.gridCoefficients();
    }

    private void initialize(double[] dArray, double[] dArray2) {
        this.initialize(dArray, dArray2, null, false);
    }

    private void initialize(double[] dArray, double[] dArray2, double[] dArray3) {
        this.initialize(dArray, dArray2, dArray3, true);
    }

    private void initialize(double[] dArray, double[] dArray2, double[] dArray3, boolean bl) {
        int n;
        int n2;
        int n3 = 3;
        if (bl) {
            n3 = 2;
        }
        if ((n2 = dArray.length) != dArray2.length) {
            throw new IllegalArgumentException("Arrays x and y-row are of different length " + n2 + " " + dArray2.length);
        }
        if (n2 < n3) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of " + n3 + " X " + n3);
        }
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        this.xIndices = arrayMaths.originalIndices();
        dArray = arrayMaths.array();
        double[] dArray4 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray4[n] = dArray2[this.xIndices[n]];
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray4[n];
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                dArray4[n] = dArray3[this.xIndices[n]];
            }
            for (n = 0; n < n2; ++n) {
                dArray3[n] = dArray4[n];
            }
        }
        for (n = 1; n < n2; ++n) {
            int n4;
            if (dArray[n] != dArray[n - 1]) continue;
            System.out.println("x[" + this.xIndices[n] + "] and x[" + this.xIndices[n + 1] + "] are identical, " + dArray[n]);
            System.out.println("The y values have been averaged and one point has been deleted");
            dArray2[n - 1] = (dArray2[n - 1] + dArray2[n]) / 2.0;
            for (n4 = n; n4 < n2 - 1; ++n4) {
                dArray[n4] = dArray[n4 + 1];
                dArray2[n4] = dArray2[n4 + 1];
                this.xIndices[n4] = this.xIndices[n4 + 1];
            }
            if (bl) {
                dArray3[n - 1] = (dArray3[n - 1] + dArray3[n]) / 2.0;
                for (n4 = n; n4 < n2 - 1; ++n4) {
                    dArray3[n4] = dArray3[n4 + 1];
                }
            }
            --n2;
        }
        this.nPoints = n2;
        this.x = new double[this.nPoints];
        this.y = new double[this.nPoints];
        this.dydx = new double[this.nPoints];
        for (n = 0; n < this.nPoints; ++n) {
            this.x[n] = dArray[n];
            this.y[n] = dArray2[n];
        }
        if (bl) {
            for (n = 0; n < this.nPoints; ++n) {
                this.dydx[n] = dArray3[n];
            }
            this.derivCalculated = true;
        }
        this.xMin = Fmath.minimum(this.x);
        this.xMax = Fmath.maximum(this.x);
        if (!bl && this.numerDiffFlag) {
            double d;
            double d2 = this.xMax - this.xMin;
            double d3 = d2 / (double)this.nPoints;
            double d4 = d = this.x[1] - this.x[0];
            for (int i = 2; i < this.nPoints; ++i) {
                d = this.x[i] - this.x[i - 1];
                if (!(d < d4)) continue;
                d4 = d;
            }
            this.incrX = d2 * delta;
            double d5 = d4;
            if (d4 < d3 / 10.0) {
                d5 = d3 / 10.0;
            }
            if (this.incrX > d3) {
                this.incrX = d5;
            }
        }
    }

    private void calcDeriv() {
        if (this.numerDiffFlag) {
            int n;
            this.cs = new CubicSpline(this.x, this.y);
            double[] dArray = new double[this.nPoints];
            double[] dArray2 = new double[this.nPoints];
            for (n = 0; n < this.nPoints; ++n) {
                dArray[n] = this.x[n] + this.incrX;
                if (dArray[n] > this.x[this.nPoints - 1]) {
                    dArray[n] = this.x[this.nPoints - 1];
                }
                dArray2[n] = this.x[n] - this.incrX;
                if (!(dArray2[n] < this.x[0])) continue;
                dArray2[n] = this.x[0];
            }
            for (n = 0; n < this.nPoints; ++n) {
                this.dydx[n] = (this.cs.interpolate(dArray[n]) - this.cs.interpolate(dArray2[n])) / (dArray[n] - dArray2[n]);
            }
        } else {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.nPoints; ++i) {
                n = i + 1;
                if (n >= this.nPoints) {
                    n = this.nPoints - 1;
                }
                if ((n2 = i - 1) < 0) {
                    n2 = 0;
                }
                this.dydx[i] = (this.y[n] - this.y[n2]) / (this.x[n] - this.x[n2]);
            }
        }
        this.derivCalculated = true;
    }

    private void gridCoefficients() {
        double[] dArray = new double[4];
        this.coeff = new double[this.nPoints][4];
        double d = 0.0;
        for (int i = 0; i < this.nPoints - 1; ++i) {
            d = this.x[i + 1] - this.x[i];
            dArray[0] = this.y[i];
            dArray[1] = this.y[i + 1];
            dArray[2] = this.dydx[i] * d;
            dArray[3] = this.dydx[i + 1] * d;
            double d2 = 0.0;
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    d2 += this.weights[j][k] * dArray[k];
                }
                this.coeff[i][j] = d2;
                d2 = 0.0;
            }
        }
    }

    public double interpolate(double d) {
        int n;
        if (d < this.x[0]) {
            if (d >= this.x[0] - potentialRoundingError) {
                d = this.x[0];
            } else {
                throw new IllegalArgumentException(d + " is outside the limits, " + this.x[0] + " - " + this.x[this.nPoints - 1]);
            }
        }
        if (d > this.x[this.nPoints - 1]) {
            if (d <= this.x[this.nPoints - 1] + potentialRoundingError) {
                d = this.x[this.nPoints - 1];
            } else {
                throw new IllegalArgumentException(d + " is outside the limits, " + this.x[0] + " - " + this.x[this.nPoints - 1]);
            }
        }
        this.xx = d;
        int n2 = 0;
        int n3 = 1;
        boolean bl = true;
        while (bl) {
            if (d < this.x[n3]) {
                n2 = n3 - 1;
                bl = false;
                continue;
            }
            if (++n3 < this.nPoints) continue;
            n2 = this.nPoints - 2;
            bl = false;
        }
        double d2 = (d - this.x[n2]) / (this.x[n2 + 1] - this.x[n2]);
        this.interpolatedValue = 0.0;
        for (n = 0; n < 4; ++n) {
            this.interpolatedValue += this.coeff[n2][n] * Math.pow(d2, n);
        }
        this.interpolatedDydx = 0.0;
        for (n = 1; n < 4; ++n) {
            this.interpolatedDydx += (double)n * this.coeff[n2][n] * Math.pow(d2, n - 1);
        }
        return this.interpolatedValue;
    }

    public double[] getInterpolatedValues() {
        double[] dArray = new double[]{this.interpolatedValue, this.interpolatedDydx, this.xx};
        return dArray;
    }

    public double[] getGridDydx() {
        double[] dArray = new double[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            dArray[this.xIndices[i]] = this.dydx[i];
        }
        return dArray;
    }

    public static void resetDelta(double d) {
        delta = d;
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        potentialRoundingError = 0.0;
    }

    public static void potentialRoundingError(double d) {
        potentialRoundingError = d;
    }

    public double getXmin() {
        return this.xMin;
    }

    public double getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] dArray = new double[]{this.xMin, this.xMax};
        return dArray;
    }

    public void displayLimits() {
        System.out.println(" ");
        System.out.println("The limits to the x array are " + this.xMin + " and " + this.xMax);
        System.out.println(" ");
    }
}

