/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSplinePartialDerivative;
import flanagan.interpolation.CubicSpline;
import flanagan.math.Fmath;

public class BiCubicSplineFirstDerivative {
    private int nPoints = 0;
    private int mPoints = 0;
    private double[][] y = null;
    private double[][] yTranspose = null;
    private double[] x1 = null;
    private double[] x2 = null;
    private double[] xMin = new double[2];
    private double[] xMax = new double[2];
    private BiCubicSplinePartialDerivative cspdY = null;
    private BiCubicSplinePartialDerivative cspdYt = null;
    private boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public BiCubicSplineFirstDerivative(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        int n2;
        this.nPoints = dArray.length;
        this.mPoints = dArray2.length;
        if (this.nPoints != dArray3.length) {
            throw new IllegalArgumentException("Arrays x1 and y-row are of different length " + this.nPoints + " " + dArray3.length);
        }
        if (this.mPoints != dArray3[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y-column are of different length " + this.mPoints + " " + dArray3[0].length);
        }
        if (this.nPoints < 3 || this.mPoints < 3) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 3 X 3");
        }
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.y = new double[this.nPoints][this.mPoints];
        this.yTranspose = new double[this.mPoints][this.nPoints];
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            this.x1[n2] = dArray[n2];
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        for (n2 = 0; n2 < this.mPoints; ++n2) {
            this.x2[n2] = dArray2[n2];
        }
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            for (n = 0; n < this.mPoints; ++n) {
                this.y[n2][n] = dArray3[n2][n];
            }
        }
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            for (n = 0; n < this.mPoints; ++n) {
                this.yTranspose[n][n2] = this.y[n2][n];
            }
        }
        this.cspdY = new BiCubicSplinePartialDerivative(dArray, dArray2, dArray3);
        this.cspdYt = new BiCubicSplinePartialDerivative(dArray2, dArray, this.yTranspose);
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        CubicSpline.noRoundingErrorCheck();
    }

    public static void potentialRoundingError(double d) {
        potentialRoundingError = d;
        CubicSpline.potentialRoundingError(d);
    }

    public void averageIdenticalAbscissae() {
        this.averageIdenticalAbscissae = true;
        this.cspdY.averageIdenticalAbscissae();
        this.cspdYt.averageIdenticalAbscissae();
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] dArray = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1]};
        return dArray;
    }

    public void displayLimits() {
        System.out.println(" ");
        for (int i = 0; i < 2; ++i) {
            System.out.println("The limits to the x array " + i + " are " + this.xMin[i] + " and " + this.xMax[i]);
        }
        System.out.println(" ");
    }

    public double[] interpolate(double d, double d2) {
        double[] dArray = this.cspdY.interpolate(d, d2);
        double[] dArray2 = this.cspdYt.interpolate(d2, d);
        double d3 = (dArray[0] + dArray2[0]) / 2.0;
        double[] dArray3 = new double[]{d3, dArray[1], dArray2[1], dArray[0], dArray2[0]};
        return dArray3;
    }
}

