/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.CubicSpline;
import flanagan.math.Fmath;

public class BiCubicSpline {
    private int nPoints = 0;
    private int mPoints = 0;
    private int nPointsT = 0;
    private int mPointsT = 0;
    private double[][] y = null;
    private double[][] yT = null;
    private double[] x1 = null;
    private double[] x2 = null;
    private double xx1 = Double.NaN;
    private double xx2 = Double.NaN;
    private double[] xMin = new double[2];
    private double[] xMax = new double[2];
    private double[][] d2ydx2inner = null;
    private double[][] d2ydx2innerT = null;
    private CubicSpline[] csn = null;
    private CubicSpline csm = null;
    private CubicSpline[] csnT = null;
    private CubicSpline csmT = null;
    private double interpolatedValue = Double.NaN;
    private double interpolatedValueTranspose = Double.NaN;
    private double interpolatedValueMean = Double.NaN;
    private boolean derivCalculated = false;
    private boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public BiCubicSpline(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        int n2;
        int n3;
        this.nPoints = dArray.length;
        this.nPointsT = this.mPoints = dArray2.length;
        this.mPointsT = this.nPoints;
        if (this.nPoints != dArray3.length) {
            throw new IllegalArgumentException("Arrays x1 and y-row are of different length " + this.nPoints + " " + dArray3.length);
        }
        if (this.mPoints != dArray3[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y-column are of different length " + this.mPoints + " " + dArray3[0].length);
        }
        if (this.nPoints < 3 || this.mPoints < 3) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 3 X 3");
        }
        this.csm = new CubicSpline(this.nPoints);
        this.csn = CubicSpline.oneDarray(this.nPoints, this.mPoints);
        this.csmT = new CubicSpline(this.mPoints);
        this.csnT = CubicSpline.oneDarray(this.nPointsT, this.mPointsT);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.y = new double[this.nPoints][this.mPoints];
        this.yT = new double[this.nPointsT][this.mPointsT];
        this.d2ydx2inner = new double[this.nPoints][this.mPoints];
        this.d2ydx2innerT = new double[this.nPointsT][this.mPointsT];
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.x1[n3] = dArray[n3];
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        for (n3 = 0; n3 < this.mPoints; ++n3) {
            this.x2[n3] = dArray2[n3];
        }
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            for (n2 = 0; n2 < this.mPoints; ++n2) {
                this.y[n3][n2] = dArray3[n3][n2];
            }
        }
        for (n3 = 0; n3 < this.nPointsT; ++n3) {
            for (n2 = 0; n2 < this.mPointsT; ++n2) {
                this.yT[n3][n2] = dArray3[n2][n3];
            }
        }
        double[] dArray4 = new double[this.mPoints];
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            for (n = 0; n < this.mPoints; ++n) {
                dArray4[n] = dArray3[n2][n];
            }
            this.csn[n2].resetData(dArray2, dArray4);
            this.csn[n2].calcDeriv();
            this.d2ydx2inner[n2] = this.csn[n2].getDeriv();
        }
        double[] dArray5 = new double[this.mPointsT];
        for (n = 0; n < this.nPointsT; ++n) {
            for (int i = 0; i < this.mPointsT; ++i) {
                dArray5[i] = this.yT[n][i];
            }
            this.csnT[n].resetData(dArray, dArray5);
            this.csnT[n].calcDeriv();
            this.d2ydx2innerT[n] = this.csnT[n].getDeriv();
        }
        this.derivCalculated = true;
    }

    public BiCubicSpline(int n, int n2) {
        this.nPoints = n;
        this.mPoints = n2;
        if (this.nPoints < 3 || this.mPoints < 3) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 3 X 3");
        }
        this.nPointsT = n2;
        this.mPointsT = n;
        this.csm = new CubicSpline(this.nPoints);
        this.csmT = new CubicSpline(this.nPointsT);
        if (!roundingCheck) {
            BiCubicSpline biCubicSpline = this;
            biCubicSpline.csm.noRoundingErrorCheck();
        }
        this.csn = CubicSpline.oneDarray(this.nPoints, this.mPoints);
        this.csnT = CubicSpline.oneDarray(this.nPointsT, this.mPointsT);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.y = new double[this.nPoints][this.mPoints];
        this.yT = new double[this.nPointsT][this.mPointsT];
        this.d2ydx2inner = new double[this.nPoints][this.mPoints];
        this.d2ydx2innerT = new double[this.nPointsT][this.mPointsT];
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        CubicSpline.noRoundingErrorCheck();
    }

    public static void potentialRoundingError(double d) {
        potentialRoundingError = d;
        CubicSpline.potentialRoundingError(d);
    }

    public void averageIdenticalAbscissae() {
        this.averageIdenticalAbscissae = true;
        for (int i = 0; i < this.csn.length; ++i) {
            CubicSpline cfr_ignored_0 = this.csn[i];
            CubicSpline.averageIdenticalAbscissae();
        }
        BiCubicSpline biCubicSpline = this;
        biCubicSpline.csm.averageIdenticalAbscissae();
    }

    public void resetData(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        int n2;
        int n3;
        if (dArray.length != dArray3.length) {
            throw new IllegalArgumentException("Arrays x1 and y row are of different length");
        }
        if (dArray2.length != dArray3[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y column are of different length");
        }
        if (this.nPoints != dArray.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        if (this.mPoints != dArray2.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.x1[n3] = dArray[n3];
        }
        for (n3 = 0; n3 < this.mPoints; ++n3) {
            this.x2[n3] = dArray2[n3];
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            for (n2 = 0; n2 < this.mPoints; ++n2) {
                this.y[n3][n2] = dArray3[n3][n2];
                this.yT[n2][n3] = dArray3[n3][n2];
            }
        }
        this.csm = new CubicSpline(this.nPoints);
        this.csn = CubicSpline.oneDarray(this.nPoints, this.mPoints);
        double[] dArray4 = new double[this.mPoints];
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            for (n = 0; n < this.mPoints; ++n) {
                dArray4[n] = dArray3[n2][n];
            }
            this.csn[n2].resetData(dArray2, dArray4);
            this.csn[n2].calcDeriv();
            this.d2ydx2inner[n2] = this.csn[n2].getDeriv();
        }
        this.csmT = new CubicSpline(this.nPointsT);
        this.csnT = CubicSpline.oneDarray(this.nPointsT, this.mPointsT);
        double[] dArray5 = new double[this.mPointsT];
        for (n = 0; n < this.nPointsT; ++n) {
            for (int i = 0; i < this.mPointsT; ++i) {
                dArray5[i] = this.yT[n][i];
            }
            this.csnT[n].resetData(dArray, dArray5);
            this.csnT[n].calcDeriv();
            this.d2ydx2innerT[n] = this.csnT[n].getDeriv();
        }
        this.derivCalculated = true;
    }

    public static BiCubicSpline zero(int n, int n2) {
        if (n < 3 || n2 < 3) {
            throw new IllegalArgumentException("A minimum of three x three data points is needed");
        }
        BiCubicSpline biCubicSpline = new BiCubicSpline(n, n2);
        return biCubicSpline;
    }

    public static BiCubicSpline[] oneDarray(int n, int n2, int n3) {
        if (n2 < 3 || n3 < 3) {
            throw new IllegalArgumentException("A minimum of three x three data points is needed");
        }
        BiCubicSpline[] biCubicSplineArray = new BiCubicSpline[n];
        for (int i = 0; i < n; ++i) {
            biCubicSplineArray[i] = BiCubicSpline.zero(n2, n3);
        }
        return biCubicSplineArray;
    }

    public double[][] getDeriv() {
        return this.d2ydx2inner;
    }

    public double[][] getDerivTranspose() {
        return this.d2ydx2innerT;
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] dArray = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1]};
        return dArray;
    }

    public void displayLimits() {
        System.out.println(" ");
        for (int i = 0; i < 2; ++i) {
            System.out.println("The limits to the x array " + i + " are " + this.xMin[i] + " and " + this.xMax[i]);
        }
        System.out.println(" ");
    }

    public void setDeriv(double[][] dArray) {
        this.d2ydx2inner = dArray;
        this.derivCalculated = true;
    }

    public void setDerivTranspose(double[][] dArray) {
        this.d2ydx2innerT = dArray;
        this.derivCalculated = true;
    }

    public double interpolate(double d, double d2) {
        this.xx1 = d;
        this.xx2 = d2;
        double[] dArray = new double[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            dArray[i] = this.csn[i].interpolate(d2);
        }
        this.csm.resetData(this.x1, dArray);
        this.interpolatedValue = this.csm.interpolate(d);
        double[] dArray2 = new double[this.nPointsT];
        for (int i = 0; i < this.nPointsT; ++i) {
            dArray2[i] = this.csnT[i].interpolate(d);
        }
        this.csmT.resetData(this.x2, dArray2);
        this.interpolatedValueTranspose = this.csmT.interpolate(d2);
        this.interpolatedValueMean = (this.interpolatedValue + this.interpolatedValueTranspose) / 2.0;
        return this.interpolatedValueMean;
    }

    public double[] getInterpolatedValues() {
        double[] dArray = new double[]{this.interpolatedValueMean, this.interpolatedValue, this.interpolatedValueTranspose, this.xx1, this.xx2};
        return dArray;
    }
}

