/*
 * Decompiled with CFR 0.152.
 */
package flanagan.integration;

import flanagan.integration.IntegralFunction;
import flanagan.math.Fmath;
import java.util.ArrayList;

public class Integration {
    private IntegralFunction integralFunc = null;
    private boolean setFunction = false;
    private double lowerLimit = Double.NaN;
    private double upperLimit = Double.NaN;
    private boolean setLimits = false;
    private int glPoints = 0;
    private boolean setGLpoints = false;
    private int nIntervals = 0;
    private boolean setIntervals = false;
    private double integralSum = 0.0;
    private double integralMean = 0.0;
    private double integralSD = 0.0;
    private boolean integrationDone = false;
    private boolean integrationStatsDone = false;
    private ArrayList<Integer> gaussQuadIndex = new ArrayList();
    private ArrayList<double[]> gaussQuadDistArrayList = new ArrayList();
    private double[] gaussQuadDist = null;
    private ArrayList<double[]> gaussQuadWeightArrayList = new ArrayList();
    private double[] gaussQuadWeight = null;
    private double glPrec = 3.0E-11;
    private double requiredAccuracy = 0.0;
    private double trapeziumAccuracy = 0.0;
    private static double trapAccuracy = 0.0;
    private int maxIntervals = 0;
    private int trapeziumIntervals = 1;
    private static int trapIntervals = 1;

    public Integration() {
    }

    public Integration(IntegralFunction integralFunction) {
        this.integralFunc = integralFunction;
        this.setFunction = true;
    }

    public Integration(IntegralFunction integralFunction, double d, double d2) {
        this.integralFunc = integralFunction;
        this.setFunction = true;
        this.lowerLimit = d;
        this.upperLimit = d2;
        this.setLimits = true;
    }

    public void setIntegrationFunction(IntegralFunction integralFunction) {
        this.integralFunc = integralFunction;
        this.setFunction = true;
    }

    public void setLimits(double d, double d2) {
        this.lowerLimit = d;
        this.upperLimit = d2;
        this.setLimits = true;
    }

    public void setLowerLimit(double d) {
        this.lowerLimit = d;
        if (!Fmath.isNaN(this.upperLimit)) {
            this.setLimits = true;
        }
    }

    public void setlowerLimit(double d) {
        this.lowerLimit = d;
        if (!Fmath.isNaN(this.upperLimit)) {
            this.setLimits = true;
        }
    }

    public void setUpperLimit(double d) {
        this.upperLimit = d;
        if (!Fmath.isNaN(this.lowerLimit)) {
            this.setLimits = true;
        }
    }

    public void setupperLimit(double d) {
        this.upperLimit = d;
        if (!Fmath.isNaN(this.lowerLimit)) {
            this.setLimits = true;
        }
    }

    public void setGLpoints(int n) {
        this.glPoints = n;
        this.setGLpoints = true;
    }

    public void setNintervals(int n) {
        this.nIntervals = n;
        this.setIntervals = true;
    }

    public double getIntegralSum() {
        if (!this.integrationDone) {
            throw new IllegalArgumentException("No integration has been performed");
        }
        return this.integralSum;
    }

    public double getIntegralMean() {
        if (!this.integrationStatsDone) {
            throw new IllegalArgumentException("No relevant integration has been performed");
        }
        return this.integralMean;
    }

    public double getIntegralStandardDeviation() {
        if (!this.integrationStatsDone) {
            throw new IllegalArgumentException("No relevant integration has been performed");
        }
        return this.integralSD;
    }

    public double[] getGauassQuadDistances() {
        return this.gaussQuadDist;
    }

    public double[] getGauassQuadWeights() {
        return this.gaussQuadWeight;
    }

    public double gaussQuad() {
        if (!this.setGLpoints) {
            throw new IllegalArgumentException("Number of points not set");
        }
        if (!this.setLimits) {
            throw new IllegalArgumentException("One limit or both limits not set");
        }
        if (!this.setFunction) {
            throw new IllegalArgumentException("No integral function has been set");
        }
        this.gaussQuadDist = new double[this.glPoints];
        this.gaussQuadWeight = new double[this.glPoints];
        boolean bl = true;
        int n = -1;
        if (!this.gaussQuadIndex.isEmpty()) {
            for (int i = 0; i < this.gaussQuadIndex.size(); ++i) {
                Integer n2 = this.gaussQuadIndex.get(i);
                if (n2 != this.glPoints) continue;
                bl = false;
                n = i;
            }
        }
        if (bl) {
            this.gaussQuadCoeff(this.glPoints);
            this.gaussQuadIndex.add(new Integer(this.glPoints));
            this.gaussQuadDistArrayList.add(this.gaussQuadDist);
            this.gaussQuadWeightArrayList.add(this.gaussQuadWeight);
        } else {
            this.gaussQuadDist = this.gaussQuadDistArrayList.get(n);
            this.gaussQuadWeight = this.gaussQuadWeightArrayList.get(n);
        }
        double d = 0.0;
        double d2 = 0.5 * (this.upperLimit + this.lowerLimit);
        double d3 = 0.5 * (this.upperLimit - this.lowerLimit);
        double d4 = 0.0;
        for (int i = 0; i < this.glPoints; ++i) {
            d4 = d3 * this.gaussQuadDist[i];
            d += this.gaussQuadWeight[i] * this.integralFunc.function(d2 + d4);
        }
        this.integralSum = d * d3;
        this.integrationDone = true;
        return this.integralSum;
    }

    public double gaussQuad(int n) {
        this.glPoints = n;
        this.setGLpoints = true;
        return this.gaussQuad();
    }

    public static double gaussQuad(IntegralFunction integralFunction, double d, double d2, int n) {
        Integration integration = new Integration(integralFunction, d, d2);
        return integration.gaussQuad(n);
    }

    public ArrayList<Double> gaussQuadPlusMeanAndSD() {
        if (!this.setGLpoints) {
            throw new IllegalArgumentException("Number of points not set");
        }
        if (!this.setLimits) {
            throw new IllegalArgumentException("One limit or both limits not set");
        }
        if (!this.setFunction) {
            throw new IllegalArgumentException("No integral function has been set");
        }
        this.gaussQuadDist = new double[this.glPoints];
        this.gaussQuadWeight = new double[this.glPoints];
        double d = 0.5 * (this.upperLimit + this.lowerLimit);
        double d2 = 0.5 * (this.upperLimit - this.lowerLimit);
        boolean bl = true;
        int n = -1;
        if (!this.gaussQuadIndex.isEmpty()) {
            for (int i = 0; i < this.gaussQuadIndex.size(); ++i) {
                Integer n2 = this.gaussQuadIndex.get(i);
                if (n2 != this.glPoints) continue;
                bl = false;
                n = i;
            }
        }
        if (bl) {
            this.gaussQuadCoeff(this.glPoints);
            this.gaussQuadIndex.add(new Integer(this.glPoints));
            this.gaussQuadDistArrayList.add(this.gaussQuadDist);
            this.gaussQuadWeightArrayList.add(this.gaussQuadWeight);
        } else {
            this.gaussQuadDist = this.gaussQuadDistArrayList.get(n);
            this.gaussQuadWeight = this.gaussQuadWeightArrayList.get(n);
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < this.glPoints; ++i) {
            d7 = d2 * this.gaussQuadDist[i];
            d5 = d + d7;
            d4 = this.gaussQuadWeight[i] * this.integralFunc.function(d5);
            d3 += d4;
            d6 += d4 * d5;
        }
        this.integralSum = d3 * d2;
        this.integralMean = d6 / d3;
        double d8 = 0.0;
        for (int i = 0; i < this.glPoints; ++i) {
            d7 = d2 * this.gaussQuadDist[i];
            d5 = d + d7;
            d4 = this.gaussQuadWeight[i] * this.integralFunc.function(d5);
            d8 += Fmath.square(d5 - this.integralMean) * d4;
        }
        this.integralSD = Math.sqrt(d8 / d3);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(this.integralSum));
        arrayList.add(new Double(this.integralMean));
        arrayList.add(new Double(this.integralSD));
        this.integrationStatsDone = true;
        this.integrationDone = true;
        return arrayList;
    }

    public ArrayList<Double> gaussQuadPlusMeanAndSD(int n) {
        this.glPoints = n;
        this.setGLpoints = true;
        return this.gaussQuadPlusMeanAndSD();
    }

    public static ArrayList<Double> gaussQuadPlusMeanAndSD(IntegralFunction integralFunction, double d, double d2, int n) {
        Integration integration = new Integration(integralFunction, d, d2);
        return integration.gaussQuadPlusMeanAndSD(n);
    }

    public void gaussQuadCoeff(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = -1.0;
        double d8 = 1.0;
        int n2 = (n + 1) / 2;
        double d9 = 0.5 * (d8 + d7);
        double d10 = 0.5 * (d8 - d7);
        for (int i = 1; i <= n2; ++i) {
            d = Math.cos(Math.PI * ((double)i - 0.25) / ((double)n + 0.5));
            do {
                d3 = 1.0;
                d4 = 0.0;
                for (int j = 1; j <= n; ++j) {
                    d5 = d4;
                    d4 = d3;
                    d3 = ((2.0 * (double)j - 1.0) * d * d4 - ((double)j - 1.0) * d5) / (double)j;
                }
            } while (Math.abs((d = (d2 = d) - d3 / (d6 = (double)n * (d * d3 - d4) / (d * d - 1.0))) - d2) > this.glPrec);
            this.gaussQuadDist[i - 1] = d9 - d10 * d;
            this.gaussQuadDist[n - i] = d9 + d10 * d;
            this.gaussQuadWeight[i - 1] = 2.0 * d10 / ((1.0 - d * d) * d6 * d6);
            this.gaussQuadWeight[n - i] = this.gaussQuadWeight[i - 1];
        }
    }

    public static void gaussQuadCoeff(double[] dArray, double[] dArray2, int n) {
        Integration integration = new Integration();
        integration.gaussQuadCoeff(n);
        dArray = integration.getGauassQuadDistances();
        dArray2 = integration.getGauassQuadWeights();
    }

    public double trapezium() {
        if (!this.setIntervals) {
            throw new IllegalArgumentException("Number of intervals not set");
        }
        if (!this.setLimits) {
            throw new IllegalArgumentException("One limit or both limits not set");
        }
        if (!this.setFunction) {
            throw new IllegalArgumentException("No integral function has been set");
        }
        double d = 0.0;
        double d2 = (this.upperLimit - this.lowerLimit) / (double)this.nIntervals;
        double d3 = this.lowerLimit;
        double d4 = this.lowerLimit + d2;
        double d5 = this.integralFunc.function(d3);
        this.integralSum = 0.0;
        for (int i = 0; i < this.nIntervals; ++i) {
            if (d4 > this.upperLimit) {
                d4 = this.upperLimit;
                d2 -= d4 - this.upperLimit;
            }
            d = this.integralFunc.function(d4);
            this.integralSum += 0.5 * (d5 + d) * d2;
            d3 = d4;
            d5 = d;
            d4 += d2;
        }
        this.integrationDone = true;
        return this.integralSum;
    }

    public double trapezium(int n) {
        this.nIntervals = n;
        this.setIntervals = true;
        return this.trapezium();
    }

    public static double trapezium(IntegralFunction integralFunction, double d, double d2, int n) {
        Integration integration = new Integration(integralFunction, d, d2);
        return integration.trapezium(n);
    }

    public double trapezium(double d, int n) {
        double d2;
        this.requiredAccuracy = d;
        this.maxIntervals = n;
        this.trapeziumIntervals = 1;
        double d3 = d2 = Integration.trapezium(this.integralFunc, this.lowerLimit, this.upperLimit, 1);
        int n2 = 2;
        for (n2 = 2; n2 <= this.maxIntervals; ++n2) {
            d2 = Integration.trapezium(this.integralFunc, this.lowerLimit, this.upperLimit, n2);
            this.trapeziumAccuracy = Math.abs((d2 - d3) / d3);
            if (this.trapeziumAccuracy <= this.requiredAccuracy) break;
            d3 = d2;
        }
        if (n2 > this.maxIntervals) {
            System.out.println("accuracy criterion was not met in this.trapezium - current sum was returned as result.");
            this.trapeziumIntervals = this.maxIntervals;
        } else {
            this.trapeziumIntervals = n2;
        }
        trapIntervals = this.trapeziumIntervals;
        trapAccuracy = this.trapeziumAccuracy;
        return d2;
    }

    public static double trapezium(IntegralFunction integralFunction, double d, double d2, double d3, int n) {
        Integration integration = new Integration(integralFunction, d, d2);
        return integration.trapezium(d3, n);
    }

    public int getTrapeziumIntervals() {
        return this.trapeziumIntervals;
    }

    public static int getTrapIntervals() {
        return trapIntervals;
    }

    public double getTrapeziumAccuracy() {
        return this.trapeziumAccuracy;
    }

    public static double getTrapAccuracy() {
        return trapAccuracy;
    }

    public double backward() {
        if (!this.setIntervals) {
            throw new IllegalArgumentException("Number of intervals not set");
        }
        if (!this.setLimits) {
            throw new IllegalArgumentException("One limit or both limits not set");
        }
        if (!this.setFunction) {
            throw new IllegalArgumentException("No integral function has been set");
        }
        double d = (this.upperLimit - this.lowerLimit) / (double)this.nIntervals;
        double d2 = this.lowerLimit + d;
        double d3 = this.integralFunc.function(d2);
        this.integralSum = 0.0;
        for (int i = 0; i < this.nIntervals; ++i) {
            if (d2 > this.upperLimit) {
                d2 = this.upperLimit;
                d -= d2 - this.upperLimit;
            }
            d3 = this.integralFunc.function(d2);
            this.integralSum += d3 * d;
            d2 += d;
        }
        this.integrationDone = true;
        return this.integralSum;
    }

    public double backward(int n) {
        this.nIntervals = n;
        this.setIntervals = true;
        return this.backward();
    }

    public static double backward(IntegralFunction integralFunction, double d, double d2, int n) {
        Integration integration = new Integration(integralFunction, d, d2);
        return integration.backward(n);
    }

    public double forward() {
        double d = (this.upperLimit - this.lowerLimit) / (double)this.nIntervals;
        double d2 = this.lowerLimit;
        double d3 = this.integralFunc.function(d2);
        this.integralSum = 0.0;
        for (int i = 0; i < this.nIntervals; ++i) {
            if (d2 > this.upperLimit) {
                d2 = this.upperLimit;
                d -= d2 - this.upperLimit;
            }
            d3 = this.integralFunc.function(d2);
            this.integralSum += d3 * d;
            d2 += d;
        }
        this.integrationDone = true;
        return this.integralSum;
    }

    public double forward(int n) {
        this.nIntervals = n;
        this.setIntervals = true;
        return this.forward();
    }

    public static double forward(IntegralFunction integralFunction, double d, double d2, int n) {
        Integration integration = new Integration(integralFunction, d, d2);
        return integration.forward(n);
    }

    public static double foreward(IntegralFunction integralFunction, double d, double d2, int n) {
        Integration integration = new Integration(integralFunction, d, d2);
        return integration.forward(n);
    }
}

