/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;

public class SecondOrder
extends BlackBox {
    private double aConst = 1.0;
    private double bConst = 1.0;
    private double cConst = 1.0;
    private double dConst = 1.0;
    private double omegaN = 1.0;
    private double zeta = 1.0;
    private double kConst = 1.0;
    private double sigma = 1.0;

    public SecondOrder() {
        super("SecondOrder");
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0, 1.0, 1.0));
        this.sNumerDeg = 0;
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public SecondOrder(double d, double d2, double d3, double d4) {
        super("SecondOrder");
        this.aConst = d;
        this.bConst = d2;
        this.cConst = d3;
        this.dConst = d4;
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        super.setSnumer(new ComplexPoly(this.dConst));
        super.setSdenom(new ComplexPoly(this.cConst, this.bConst, this.aConst));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setCoeff(double d, double d2, double d3, double d4) {
        this.aConst = d;
        this.bConst = d2;
        this.cConst = d3;
        this.dConst = d4;
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        Complex[] complexArray = Complex.oneDarray(1);
        complexArray[0].reset(this.dConst, 0.0);
        this.sNumer.resetPoly(complexArray);
        Complex[] complexArray2 = Complex.oneDarray(3);
        complexArray2[0].reset(this.cConst, 0.0);
        complexArray2[1].reset(this.bConst, 0.0);
        complexArray2[2].reset(this.aConst, 0.0);
        this.sDenom.resetPoly(complexArray2);
        this.fixedName = "Second Order Process";
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    private void standardForm() {
        this.omegaN = Math.sqrt(this.cConst / this.aConst);
        this.zeta = this.bConst / (2.0 * this.aConst * this.omegaN);
        this.kConst = this.dConst / this.cConst;
        this.sigma = this.zeta * this.omegaN;
    }

    public void setA(double d) {
        this.aConst = d;
        Complex complex = new Complex(this.aConst, 0.0);
        this.sDenom.resetCoeff(2, complex);
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setB(double d) {
        this.bConst = d;
        Complex complex = new Complex(this.bConst, 0.0);
        this.sDenom.resetCoeff(1, complex);
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setC(double d) {
        this.cConst = d;
        Complex complex = new Complex(this.cConst, 0.0);
        this.sDenom.resetCoeff(0, complex);
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setD(double d) {
        this.dConst = d;
        Complex complex = new Complex(this.dConst, 0.0);
        this.sNumer.resetCoeff(0, complex);
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setStandardForm(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("zero or negative natural frequency");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("negative damping ratio");
        }
        this.zeta = d;
        this.omegaN = d2;
        this.kConst = d3;
        this.sigma = this.omegaN * this.zeta;
        this.reverseStandard();
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setZeta(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("negative damping ratio");
        }
        this.zeta = d;
        this.sigma = this.omegaN * this.zeta;
        this.reverseStandard();
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setOmegaN(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("zero or negative natural frequency");
        }
        this.omegaN = d;
        this.sigma = this.omegaN * this.zeta;
        this.reverseStandard();
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setK(double d) {
        this.kConst = d;
        this.reverseStandard();
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    private void reverseStandard() {
        this.aConst = this.omegaN * this.omegaN;
        this.bConst = 2.0 * this.zeta * this.omegaN;
        this.cConst = 1.0;
        this.dConst = this.kConst * this.aConst;
        Complex[] complexArray = Complex.oneDarray(1);
        complexArray[0].reset(this.dConst, 0.0);
        this.sNumer.resetPoly(complexArray);
        Complex[] complexArray2 = Complex.oneDarray(3);
        complexArray2[0].reset(this.cConst, 0.0);
        complexArray2[1].reset(this.bConst, 0.0);
        complexArray2[2].reset(this.aConst, 0.0);
        this.sDenom.resetPoly(complexArray2);
    }

    public double getA() {
        return this.aConst;
    }

    public double getB() {
        return this.bConst;
    }

    public double getC() {
        return this.cConst;
    }

    public double getD() {
        return this.dConst;
    }

    public double getOmegaN() {
        return this.omegaN;
    }

    public double getZeta() {
        return this.zeta;
    }

    public double getK() {
        return this.kConst;
    }

    public double getAttenuation() {
        return this.sigma;
    }

    @Override
    public Complex getOutputS(Complex complex, Complex complex2) {
        this.sValue = complex;
        this.inputS = complex2;
        return this.getOutputS();
    }

    @Override
    public Complex getOutputS() {
        Complex complex = Complex.plusOne();
        complex = complex.times(this.dConst);
        Complex complex2 = new Complex();
        complex2 = this.sValue.times(this.sValue.times(this.aConst));
        complex2 = complex2.plus(this.sValue.times(this.aConst));
        complex2 = complex2.plus(this.cConst);
        Complex complex3 = new Complex();
        complex3 = complex.over(complex2);
        this.outputS = complex3.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    @Override
    public void zTransform() {
        if (this.deltaT == 0.0) {
            System.out.println("z-transform attempted in SecondOrder with a zero sampling period");
        }
        if (this.ztransMethod == 0) {
            this.mapstozAdHoc();
        } else {
            Complex[] complexArray = null;
            Complex[] complexArray2 = null;
            double d = this.bConst * this.deltaT;
            double d2 = this.deltaT * this.deltaT;
            double d3 = this.cConst * d2;
            double d4 = this.dConst * d2;
            switch (this.integMethod) {
                case 0: {
                    complexArray = Complex.oneDarray(3);
                    complexArray[0].reset(d4 / 4.0, 0.0);
                    complexArray[1].reset(d4 / 2.0, 0.0);
                    complexArray[2].reset(d4 / 4.0, 0.0);
                    this.zNumer = new ComplexPoly(2);
                    this.zNumer.resetPoly(complexArray);
                    this.zNumerDeg = 2;
                    complexArray2 = Complex.oneDarray(3);
                    complexArray2[0].reset(this.aConst - d + d3 / 4.0, 0.0);
                    complexArray2[1].reset(-2.0 * this.aConst + d + d3 / 2.0, 0.0);
                    complexArray2[2].reset(this.aConst + d3 / 4.0, 0.0);
                    this.zDenom = new ComplexPoly(2);
                    this.zDenom.resetPoly(complexArray2);
                    this.zDenomDeg = 2;
                    this.zZeros = this.zNumer.roots();
                    this.zPoles = this.zDenom.roots();
                    break;
                }
                case 1: {
                    complexArray = Complex.oneDarray(3);
                    complexArray[0].reset(0.0, 0.0);
                    complexArray[1].reset(0.0, 0.0);
                    complexArray[2].reset(d4, 0.0);
                    this.zNumer = new ComplexPoly(2);
                    this.zNumer.resetPoly(complexArray);
                    this.zNumerDeg = 2;
                    complexArray2 = Complex.oneDarray(3);
                    complexArray2[0].reset(this.aConst - d, 0.0);
                    complexArray2[1].reset(-2.0 * this.aConst, 0.0);
                    complexArray2[2].reset(this.aConst + d + d3, 0.0);
                    this.zDenom = new ComplexPoly(2);
                    this.zDenom.resetPoly(complexArray2);
                    this.zDenomDeg = 2;
                    this.zPoles = this.zDenom.roots();
                    this.zZeros = Complex.oneDarray(2);
                    this.zZeros[0].reset(0.0, 0.0);
                    this.zZeros[1].reset(0.0, 0.0);
                    break;
                }
                case 2: {
                    complexArray = Complex.oneDarray(3);
                    complexArray[0].reset(0.0, 0.0);
                    complexArray[1].reset(0.0, 0.0);
                    complexArray[2].reset(d4, 0.0);
                    this.zNumer = new ComplexPoly(2);
                    this.zNumer.resetPoly(complexArray);
                    this.zNumerDeg = 2;
                    complexArray2 = Complex.oneDarray(3);
                    complexArray2[0].reset(this.aConst - d + d3, 0.0);
                    complexArray2[1].reset(-2.0 * this.aConst + d, 0.0);
                    complexArray2[2].reset(this.aConst, 0.0);
                    this.zDenom = new ComplexPoly(2);
                    this.zDenom.resetPoly(complexArray2);
                    this.zDenomDeg = 2;
                    this.zPoles = this.zDenom.roots();
                    this.zZeros = Complex.oneDarray(2);
                    this.zZeros[0].reset(0.0, 0.0);
                    this.zZeros[1].reset(0.0, 0.0);
                    break;
                }
                default: {
                    System.out.println("Integration method option in SecondOrder must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("z-transform not performed");
                }
            }
        }
    }

    @Override
    public void zTransform(double d) {
        super.setDeltaT(d);
        super.deadTimeWarning("zTransform");
        this.zTransform();
    }

    public double calcOutputT(double d, double d2) {
        return super.getCurrentOutputT(d, d2);
    }

    public double calcOutputT() {
        return super.getCurrentOutputT();
    }

    public Complex[] getSzeros() {
        System.out.println("This standard second order process (class SecondOrder) has no s-domain zeros");
        return null;
    }

    @Override
    public SecondOrder copy() {
        if (this == null) {
            return null;
        }
        SecondOrder secondOrder = new SecondOrder();
        this.copyBBvariables(secondOrder);
        secondOrder.aConst = this.aConst;
        secondOrder.bConst = this.bConst;
        secondOrder.cConst = this.cConst;
        secondOrder.dConst = this.dConst;
        secondOrder.omegaN = this.omegaN;
        secondOrder.zeta = this.zeta;
        secondOrder.kConst = this.kConst;
        secondOrder.sigma = this.sigma;
        return secondOrder;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

