/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.plot.PlotGraph;

public class PropDeriv
extends BlackBox {
    private double kp = 1.0;
    private double td = 0.0;
    private double kd = 0.0;

    public PropDeriv() {
        super("PropDeriv");
        this.sNumerDeg = 1;
        this.sDenomDeg = 0;
        super.setSnumer(new ComplexPoly(1.0, 0.0));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public PropDeriv(double d, double d2) {
        super("PropDeriv");
        this.sNumerDeg = 1;
        this.sDenomDeg = 0;
        this.kp = d;
        this.kd = d2;
        this.td = d2 / this.kp;
        super.setSnumer(new ComplexPoly(new Complex(this.kp, 0.0), new Complex(this.kd, 0.0)));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setKp(double d) {
        this.kp = d;
        if (this.sNumerDeg != 1) {
            super.setSnumer(new ComplexPoly(new Complex(this.kp, 0.0), new Complex(this.kd, 0.0)));
            super.setSdenom(new ComplexPoly(1.0));
        } else {
            this.sNumer.resetCoeff(0, new Complex(this.kp, 0.0));
            if (this.sZeros == null) {
                this.sZeros = Complex.oneDarray(1);
            }
            this.sZeros[0].reset(-this.kp / this.kd, 0.0);
        }
        super.addDeadTimeExtras();
    }

    public void setKd(double d) {
        this.kd = d;
        this.td = d / this.kp;
        if (this.sNumerDeg != 1) {
            super.setSnumer(new ComplexPoly(new Complex(this.kp, 0.0), new Complex(this.kd, 0.0)));
            super.setSdenom(new ComplexPoly(1.0));
        } else {
            this.sNumer.resetCoeff(1, new Complex(this.kd, 0.0));
            if (this.sZeros == null) {
                this.sZeros = Complex.oneDarray(1);
            }
            this.sZeros[0].reset(-this.kp / this.kd, 0.0);
        }
        super.addDeadTimeExtras();
    }

    public void setTd(double d) {
        this.td = d;
        this.kd = this.td * this.kp;
        if (this.sNumerDeg != 1) {
            super.setSnumer(new ComplexPoly(new Complex(this.kp, 0.0), new Complex(this.kd, 0.0)));
            super.setSdenom(new ComplexPoly(1.0));
        } else {
            if (this.sZeros == null) {
                this.sZeros = Complex.oneDarray(1);
            }
            this.sNumer.resetCoeff(1, new Complex(this.kd, 0.0));
            this.sZeros[0].reset(-this.kp / this.kd, 0.0);
        }
        super.addDeadTimeExtras();
    }

    public double getKp() {
        return this.kp;
    }

    public double getKd() {
        return this.kd;
    }

    public double getTd() {
        return this.td;
    }

    @Override
    public void zTransform() {
        if (this.deltaT == 0.0) {
            System.out.println("z-transform attempted in PropDeriv with a zero sampling period");
        }
        super.deadTimeWarning("zTransform");
        if (this.ztransMethod == 0) {
            this.mapstozAdHoc();
        } else {
            this.zNumerDeg = 1;
            this.zDenomDeg = 1;
            this.zNumer = new ComplexPoly(-this.kd, this.kp * this.deltaT + this.kd);
            this.zDenom = new ComplexPoly(0.0, this.deltaT);
            this.zZeros = Complex.oneDarray(1);
            this.zZeros[0].reset(this.kd / (this.kp * this.deltaT + this.kd), 0.0);
            this.zPoles = Complex.oneDarray(1);
            this.zPoles[0].reset(0.0, 0.0);
        }
    }

    @Override
    public void zTransform(double d) {
        super.setDeltaT(d);
        super.deadTimeWarning("zTransform");
        this.zTransform();
    }

    @Override
    public void stepInput(double d, double d2) {
        int n;
        int n2 = 51;
        double d3 = d2 / (double)(n2 - 2);
        double[][] dArray = new double[2][n2];
        dArray[0][0] = 0.0;
        dArray[1][0] = 0.0;
        for (int i = 2; i < n2; ++i) {
            dArray[0][i] = dArray[0][i - 1] + d3;
        }
        double d4 = this.kp * d;
        dArray[1][0] = 0.0;
        for (n = 1; n < n2; ++n) {
            dArray[1][n] = d4;
        }
        if (this.deadTime != 0.0) {
            n = 0;
            while (n < n2) {
                double[] dArray2 = dArray[0];
                int n3 = n++;
                dArray2[n3] = dArray2[n3] + this.deadTime;
            }
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setGraphTitle("Step Input Transient:   Step magnitude = " + d);
        plotGraph.setGraphTitle2(this.getName());
        plotGraph.setXaxisLegend("Time");
        plotGraph.setXaxisUnitsName("s");
        plotGraph.setYaxisLegend("Output");
        plotGraph.setPoint(0);
        plotGraph.setLine(3);
        plotGraph.plot();
    }

    @Override
    public void stepInput(double d) {
        this.stepInput(1.0, d);
    }

    @Override
    public void rampInput(double d, int n, double d2) {
        if (n == 0) {
            this.stepInput(d, d2);
        } else {
            int n2;
            int n3 = 50;
            double d3 = d2 / (double)(n3 - 1);
            double[][] dArray = new double[2][n3];
            double d4 = 0.0;
            dArray[0][0] = 0.0;
            dArray[1][0] = 0.0;
            for (n2 = 1; n2 < n3; ++n2) {
                dArray[0][n2] = dArray[0][n2 - 1] + d3;
                dArray[1][n2] = d * Math.pow(dArray[0][n2], n - 1) * (this.kp * dArray[0][n2] + this.kd);
            }
            if (this.deadTime != 0.0) {
                n2 = 0;
                while (n2 < n3) {
                    double[] dArray2 = dArray[0];
                    int n4 = n2++;
                    dArray2[n4] = dArray2[n4] + this.deadTime;
                }
            }
            PlotGraph plotGraph = new PlotGraph(dArray);
            plotGraph.setGraphTitle("Ramp (a.t^n) Input Transient:   ramp gradient (a) = " + d + " ramp order (n) = " + n);
            plotGraph.setGraphTitle2(this.getName());
            plotGraph.setXaxisLegend("Time");
            plotGraph.setXaxisUnitsName("s");
            plotGraph.setYaxisLegend("Output");
            plotGraph.setPoint(0);
            plotGraph.plot();
        }
    }

    @Override
    public void rampInput(int n, double d) {
        double d2 = 1.0;
        this.rampInput(d2, n, d);
    }

    @Override
    public void rampInput(double d, double d2) {
        int n = 1;
        this.rampInput(d, n, d2);
    }

    @Override
    public void rampInput(double d) {
        double d2 = 1.0;
        int n = 1;
        this.rampInput(d2, n, d);
    }

    @Override
    public Complex getOutputS(Complex complex, Complex complex2) {
        this.sValue = complex;
        this.inputS = complex2;
        Complex complex3 = this.sValue.times(this.kd);
        complex3 = complex3.plus(this.kp);
        this.outputS = complex3.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    @Override
    public Complex getOutputS() {
        Complex complex = this.sValue.times(this.kd);
        complex = complex.plus(this.kp);
        this.outputS = complex.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void calcOutputT(double d, double d2) {
        super.setInputT(d, d2);
        this.calcOutputT();
    }

    public void calcOutputT() {
        this.outputT[this.sampLen - 1] = this.kp * this.inputT[this.sampLen - 1];
        int n = this.sampLen - 1;
        this.outputT[n] = this.outputT[n] + this.kd * (this.inputT[this.sampLen - 1] - this.inputT[this.sampLen - 2]) / this.deltaT;
    }

    public Complex[] getSpoles() {
        System.out.println("PD controller has no s-domain poles");
        return null;
    }

    @Override
    public PropDeriv copy() {
        if (this == null) {
            return null;
        }
        PropDeriv propDeriv = new PropDeriv();
        this.copyBBvariables(propDeriv);
        propDeriv.kp = this.kp;
        propDeriv.td = this.td;
        propDeriv.kd = this.kd;
        return propDeriv;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

