/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.control.BlackBox;
import java.util.ArrayList;
import java.util.Vector;

public class OpenLoop
extends BlackBox {
    private ArrayList<BlackBox> openPath = new ArrayList();
    private ArrayList<Object> segments = new ArrayList();
    private int nBoxes = 0;
    private int nSeg = 0;
    private boolean checkPath = false;
    private boolean checkNoMix = true;
    private boolean checkConsolidate = false;
    private boolean[] adcs = null;
    private boolean[] dacs = null;
    private boolean[] zeroHolds = null;

    public OpenLoop() {
        super("OpenLoop");
    }

    public void addBoxToPath(BlackBox blackBox) {
        this.openPath.add(blackBox);
        ++this.nBoxes;
    }

    public void consolidate() {
        if (!this.segments.isEmpty()) {
            this.segments.clear();
            this.nBoxes = 0;
            this.nSeg = 0;
            this.checkNoMix = true;
            this.checkPath = false;
        }
        this.segment();
        BlackBox blackBox = null;
        blackBox = this.nSeg == 1 ? (this.nBoxes == 1 ? this.openPath.get(0) : (BlackBox)this.segments.get(3)) : this.combineSegment(0, this.nBoxes);
        this.sNumer = blackBox.sNumer.copy();
        this.sDenom = blackBox.sDenom.copy();
        this.sNumerPade = blackBox.sNumerPade.copy();
        this.sDenomPade = blackBox.sDenomPade.copy();
        this.sNumerDeg = blackBox.sNumerDeg;
        this.sDenomDeg = blackBox.sDenomDeg;
        this.sNumerDegPade = blackBox.sNumerDegPade;
        this.sDenomDegPade = blackBox.sDenomDegPade;
        this.sNumerSet = true;
        this.sDenomSet = true;
        this.deadTime = blackBox.deadTime;
        this.sZeros = Complex.copy(blackBox.sZeros);
        this.sPoles = Complex.copy(blackBox.sPoles);
        this.sZerosPade = Complex.copy(blackBox.sZerosPade);
        this.sPolesPade = Complex.copy(blackBox.sPolesPade);
        this.padeAdded = true;
        this.sNumerScaleFactor = this.sNumerDeg == 0 ? this.sNumer.coeffCopy(0) : BlackBox.scaleFactor(this.sNumer, this.sZeros);
        this.sDenomScaleFactor = this.sDenomDeg == 0 ? this.sDenom.coeffCopy(0) : BlackBox.scaleFactor(this.sDenom, this.sPoles);
        this.checkConsolidate = true;
    }

    public void segment() {
        int n;
        this.adcs = new boolean[this.nBoxes];
        int n2 = 0;
        this.dacs = new boolean[this.nBoxes];
        int n3 = 0;
        this.zeroHolds = new boolean[this.nBoxes];
        int n4 = 0;
        String string = null;
        for (n = 0; n < this.nBoxes; ++n) {
            this.adcs[n] = false;
            this.dacs[n] = false;
            this.zeroHolds[n] = false;
            BlackBox blackBox = this.openPath.get(n);
            string = blackBox.fixedName;
            if (string.equals("ADC")) {
                this.adcs[n] = true;
                ++n2;
                continue;
            }
            if (string.equals("DAC")) {
                this.dacs[n] = true;
                ++n3;
                continue;
            }
            if (!string.equals("ZeroOrderHold")) continue;
            this.zeroHolds[n] = true;
            ++n4;
        }
        if (n2 == 0 && n3 == 0) {
            this.nSeg = 1;
            this.checkNoMix = true;
            this.checkPath = true;
            this.segments.add(new Integer(0));
            this.segments.add(new Integer(this.nBoxes - 1));
            this.segments.add("analogue");
            BlackBox blackBox = this.combineSegment(0, this.nBoxes - 1);
            this.segments.add(blackBox);
        } else {
            BlackBox blackBox;
            boolean bl;
            this.nSeg = 0;
            n = 0;
            int n5 = 0;
            boolean bl2 = false;
            if (n2 > 0 && n3 > 0) {
                bl = true;
                n = 0;
                while (bl) {
                    if (this.adcs[n]) {
                        bl = false;
                        continue;
                    }
                    if (++n < this.nBoxes) continue;
                    bl = false;
                }
                bl = true;
                while (bl) {
                    if (this.dacs[n5]) {
                        bl = false;
                        continue;
                    }
                    if (++n5 < this.nBoxes) continue;
                    bl = false;
                }
                if (n < n5) {
                    bl2 = true;
                }
            } else if (n2 > 0) {
                bl2 = true;
            }
            bl = bl2;
            ++this.nSeg;
            int n6 = 0;
            if (bl2) {
                this.segments.add(new Integer(0));
                this.segments.add(new Integer(n));
                this.segments.add("digital");
                blackBox = this.combineSegment(0, n);
                this.segments.add(blackBox);
                n6 = n + 1;
            } else {
                this.segments.add(new Integer(0));
                this.segments.add(new Integer(n5));
                this.segments.add("analogue");
                blackBox = this.combineSegment(0, n5);
                this.segments.add(blackBox);
                n6 = n5 + 1;
            }
            boolean bl3 = true;
            if (n6 >= this.nBoxes) {
                bl3 = false;
            }
            while (bl3) {
                if (bl) {
                    n6 = this.nextDigitalSegment(n6);
                    bl = false;
                } else {
                    n6 = this.nextAnalogueSegment(n6);
                    bl = true;
                }
                if (n6 < this.nBoxes) continue;
                bl3 = false;
            }
        }
    }

    private int nextDigitalSegment(int n) {
        int n2 = this.nBoxes;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = n;
        while (bl2) {
            if (this.adcs[n3]) {
                n2 = n3;
                bl2 = false;
                continue;
            }
            if (++n3 < this.nBoxes) continue;
            bl2 = false;
        }
        int n4 = this.nBoxes;
        bl2 = true;
        n3 = n;
        while (bl2) {
            if (this.dacs[n3]) {
                n4 = n3;
                bl2 = false;
                continue;
            }
            if (++n3 < this.nBoxes) continue;
            bl2 = false;
            bl = true;
        }
        if (bl) {
            n4 = this.nBoxes - 1;
        }
        if (n2 < n4) {
            throw new IllegalArgumentException("Two consecutive ADCs with no intervening DAC");
        }
        ++this.nSeg;
        this.segments.add(new Integer(0));
        this.segments.add(new Integer(n4));
        this.segments.add("digital");
        BlackBox blackBox = this.combineSegment(0, n4);
        this.segments.add(blackBox);
        return n4 + 1;
    }

    private int nextAnalogueSegment(int n) {
        int n2 = this.nBoxes;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = n;
        while (bl2) {
            if (this.adcs[n3]) {
                n2 = n3;
                bl2 = false;
                continue;
            }
            if (++n3 < this.nBoxes) continue;
            bl2 = false;
            bl = true;
        }
        int n4 = this.nBoxes;
        bl2 = true;
        n3 = n;
        while (bl2) {
            if (this.dacs[n3]) {
                n4 = n3;
                bl2 = false;
                continue;
            }
            if (++n3 < this.nBoxes) continue;
            bl2 = false;
        }
        if (bl) {
            n2 = this.nBoxes - 1;
        }
        if (n4 < n2) {
            throw new IllegalArgumentException("Two consecutive DACs with no intervening ADC");
        }
        ++this.nSeg;
        this.segments.add(new Integer(0));
        this.segments.add(new Integer(n2));
        this.segments.add("digital");
        BlackBox blackBox = this.combineSegment(0, n2);
        this.segments.add(blackBox);
        return n2 + 1;
    }

    public BlackBox combineSegment(int n, int n2) {
        int n3;
        int n4;
        Complex[] complexArray;
        ArrayList<Complex> arrayList = new ArrayList<Complex>();
        ArrayList<Complex> arrayList2 = new ArrayList<Complex>();
        ArrayList<Complex> arrayList3 = new ArrayList<Complex>();
        ArrayList<Complex> arrayList4 = new ArrayList<Complex>();
        BlackBox blackBox = new BlackBox();
        int n5 = n2 - n + 1;
        BlackBox blackBox2 = this.openPath.get(n);
        if (!blackBox2.padeAdded) {
            blackBox2.transferPolesZeros();
        }
        blackBox.sNumerPade = blackBox2.sNumerPade.copy();
        blackBox.sDenomPade = blackBox2.sDenomPade.copy();
        blackBox.sNumer = blackBox2.sNumer.copy();
        blackBox.sDenom = blackBox2.sDenom.copy();
        blackBox.sNumerDegPade = blackBox2.sNumerDegPade;
        blackBox.sDenomDegPade = blackBox2.sDenomDegPade;
        blackBox.sNumerDeg = blackBox2.sNumerDeg;
        blackBox.sDenomDeg = blackBox2.sDenomDeg;
        if (blackBox.sNumerDegPade > 0) {
            complexArray = Complex.copy(blackBox2.sZerosPade);
            for (n4 = 0; n4 < blackBox.sNumerDegPade; ++n4) {
                arrayList3.add(complexArray[n4]);
            }
        }
        if (blackBox.sDenomDegPade > 0) {
            complexArray = Complex.copy(blackBox2.sPolesPade);
            for (n4 = 0; n4 < blackBox.sDenomDegPade; ++n4) {
                arrayList4.add(complexArray[n4]);
            }
        }
        if (blackBox.sNumerDeg > 0) {
            complexArray = Complex.copy(blackBox2.sZeros);
            for (n4 = 0; n4 < blackBox.sNumerDeg; ++n4) {
                arrayList.add(complexArray[n4]);
            }
        }
        if (blackBox.sDenomDeg > 0) {
            complexArray = Complex.copy(blackBox2.sPoles);
            for (n4 = 0; n4 < blackBox.sDenomDeg; ++n4) {
                arrayList2.add(complexArray[n4]);
            }
        }
        blackBox.deadTime = blackBox2.deadTime;
        blackBox.sNumerScaleFactor = blackBox2.sNumerScaleFactor.copy();
        blackBox.sDenomScaleFactor = blackBox2.sDenomScaleFactor.copy();
        for (n3 = 1; n3 < n5; ++n3) {
            int n6;
            blackBox2 = this.openPath.get(n3 + n);
            if (!blackBox2.padeAdded) {
                blackBox2.transferPolesZeros();
            }
            if (blackBox.sNumerPade == null) {
                if (blackBox2.sNumerPade != null) {
                    blackBox.sNumerPade = blackBox2.sNumerPade.copy();
                }
            } else if (blackBox2.sNumerPade != null) {
                blackBox.sNumerPade = blackBox.sNumerPade.times(blackBox2.sNumerPade);
            }
            if (blackBox.sNumer == null) {
                if (blackBox2.sNumer != null) {
                    blackBox.sNumer = blackBox2.sNumer.copy();
                }
            } else if (blackBox2.sNumer != null) {
                blackBox.sNumer = blackBox.sNumer.times(blackBox2.sNumer);
            }
            if (blackBox.sDenom == null) {
                if (blackBox2.sDenom != null) {
                    blackBox.sDenom = blackBox2.sDenom.copy();
                }
            } else if (blackBox2.sDenom != null) {
                blackBox.sDenom = blackBox.sDenom.times(blackBox2.sDenom);
            }
            if (blackBox.sDenomPade == null) {
                if (blackBox2.sDenomPade != null) {
                    blackBox.sDenomPade = blackBox2.sDenomPade.copy();
                }
            } else if (blackBox2.sDenomPade != null) {
                blackBox.sDenomPade = blackBox.sDenomPade.times(blackBox2.sDenomPade);
            }
            blackBox.sNumerDegPade += blackBox2.sNumerDegPade;
            blackBox.sDenomDegPade += blackBox2.sDenomDegPade;
            blackBox.sNumerDeg += blackBox2.sNumerDeg;
            blackBox.sDenomDeg += blackBox2.sDenomDeg;
            blackBox.sNumerScaleFactor = blackBox2.sNumerScaleFactor.times(blackBox.sNumerScaleFactor);
            blackBox.sDenomScaleFactor = blackBox2.sDenomScaleFactor.times(blackBox.sDenomScaleFactor);
            blackBox.deadTime += blackBox2.deadTime;
            if (blackBox2.sNumerDegPade > 0) {
                Complex[] complexArray2 = Complex.copy(blackBox2.sZerosPade);
                for (n6 = 0; n6 < blackBox2.sNumerDegPade; ++n6) {
                    arrayList3.add(complexArray2[n6]);
                }
            }
            if (blackBox2.sDenomDegPade > 0) {
                Complex[] complexArray3 = Complex.copy(blackBox2.sPolesPade);
                for (n6 = 0; n6 < blackBox2.sDenomDegPade; ++n6) {
                    arrayList4.add(complexArray3[n6]);
                }
            }
            if (blackBox2.sNumerDeg > 0) {
                Complex[] complexArray4 = Complex.copy(blackBox2.sZeros);
                for (n6 = 0; n6 < blackBox2.sNumerDeg; ++n6) {
                    arrayList.add(complexArray4[n6]);
                }
            }
            if (blackBox2.sDenomDeg <= 0) continue;
            Complex[] complexArray5 = Complex.copy(blackBox2.sPoles);
            for (n6 = 0; n6 < blackBox2.sDenomDeg; ++n6) {
                arrayList2.add(complexArray5[n6]);
            }
        }
        if (blackBox.sNumerDegPade > 0) {
            blackBox.sZerosPade = Complex.oneDarray(blackBox.sNumerDegPade);
            for (n3 = 0; n3 < blackBox.sNumerDegPade; ++n3) {
                blackBox.sZerosPade[n3] = (Complex)arrayList3.get(n3);
            }
        }
        if (blackBox.sDenomDegPade > 0) {
            blackBox.sPolesPade = Complex.oneDarray(blackBox.sDenomDegPade);
            for (n3 = 0; n3 < blackBox.sDenomDegPade; ++n3) {
                blackBox.sPolesPade[n3] = (Complex)arrayList4.get(n3);
            }
        }
        if (blackBox.sNumerDeg > 0) {
            blackBox.sZeros = Complex.oneDarray(blackBox.sNumerDeg);
            for (n3 = 0; n3 < blackBox.sNumerDeg; ++n3) {
                blackBox.sZeros[n3] = (Complex)arrayList.get(n3);
            }
        }
        if (blackBox.sDenomDeg > 0) {
            blackBox.sPoles = Complex.oneDarray(blackBox.sDenomDeg);
            for (n3 = 0; n3 < blackBox.sDenomDeg; ++n3) {
                blackBox.sPoles[n3] = (Complex)arrayList2.get(n3);
            }
        }
        return blackBox;
    }

    public int getNumberOfBoxes() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.nBoxes;
    }

    public ArrayList<Object> getSegmentsArrayList() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.segments;
    }

    public Vector<Object> getSegmentsVector() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        ArrayList<Object> arrayList = this.segments;
        Vector<Object> vector = null;
        if (arrayList != null) {
            int n = arrayList.size();
            vector = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                vector.addElement(arrayList.get(i));
            }
        }
        return vector;
    }

    public int getNumberOfSegments() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.nSeg;
    }

    public String getNamesOfBoxes() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        String string = "";
        for (int i = 0; i < this.nBoxes; ++i) {
            BlackBox blackBox = this.openPath.get(i);
            string = string + i + ": " + blackBox.getName() + "   ";
        }
        return string;
    }

    public void removeAllBoxes() {
        if (!this.openPath.isEmpty()) {
            this.openPath.clear();
        }
        if (!this.segments.isEmpty()) {
            this.segments.clear();
        }
        this.nSeg = 0;
        this.checkNoMix = true;
        this.checkPath = false;
        this.nBoxes = 0;
        this.checkConsolidate = false;
        this.adcs = null;
        this.dacs = null;
        this.zeroHolds = null;
    }

    public boolean getCheckNoMix() {
        return this.checkNoMix;
    }

    @Override
    public OpenLoop copy() {
        int n;
        if (this == null) {
            return null;
        }
        OpenLoop openLoop = new OpenLoop();
        this.copyBBvariables(openLoop);
        openLoop.nBoxes = this.nBoxes;
        openLoop.nSeg = this.nSeg;
        openLoop.checkPath = this.checkPath;
        openLoop.checkNoMix = this.checkNoMix;
        openLoop.checkConsolidate = this.checkConsolidate;
        if (this.openPath.size() == 0) {
            openLoop.openPath = new ArrayList();
        } else {
            for (n = 0; n < this.openPath.size(); ++n) {
                openLoop.openPath.add(this.openPath.get(n).copy());
            }
        }
        if (this.segments.size() == 0) {
            openLoop.segments = new ArrayList();
        } else {
            n = 0;
            for (int i = 0; i < this.nSeg; ++i) {
                Integer n2 = (Integer)this.segments.get(n);
                int n3 = n2;
                openLoop.segments.add(new Integer(n3));
                Integer n4 = (Integer)this.segments.get(++n);
                n3 = n4;
                openLoop.segments.add(new Integer(n3));
                String string = (String)this.segments.get(++n);
                openLoop.segments.add(string);
                openLoop.segments.add(((BlackBox)this.segments.get(++n)).copy());
                ++n;
            }
        }
        return openLoop;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

