/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.AtoD;
import flanagan.control.BlackBox;
import flanagan.math.Conv;

public class DtoA
extends BlackBox {
    private int nBits = 0;
    private long maximumDecimal = 0L;
    private double vRef = 0.0;
    private int[] vBinary = null;
    private boolean trueDtoA = true;
    private double outputVoltage = 0.0;
    private double voltageInput = 0.0;
    private String binaryInput = "";
    private long decimalInput = 0L;
    private boolean inputSet = false;

    public DtoA(int n, double d) {
        super("DtoA");
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
        this.nBits = n;
        this.vBinary = new int[n + 1];
        this.maximumDecimal = (long)Math.pow(2.0, this.nBits) - 1L;
        this.vRef = d;
        this.trueDtoA = true;
    }

    public DtoA() {
        super("DtoA");
        this.trueDtoA = false;
        this.sNumerDeg = 0;
        this.sDenomDeg = 0;
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
    }

    public boolean getTrueDtoAoption() {
        if (this.trueDtoA) {
            System.out.println("This instance of DtoA is a true simulation of an ADC");
            System.out.println("getTrueDtoAoption has returned 'true'");
        } else {
            System.out.println("This instance of DtoA is not a true simulation of an ADC");
            System.out.println("It is simple an 'D to A marker'");
            System.out.println("getTrueDtoAoption has returned 'false'");
        }
        return this.trueDtoA;
    }

    public void setInput(String string) {
        int n;
        this.binaryInput = string.trim();
        int n2 = this.binaryInput.length();
        if (n2 > this.nBits + 1) {
            throw new IllegalArgumentException("length of input String is greater than the DAC bit number plus one");
        }
        if (n2 < this.nBits + 1) {
            System.out.println("Class - DtoA;  method - setInput(String)");
            System.out.println("The input String is less than DAC number of bits plus one");
            System.out.println("String assumed to represent a postive unsigned binary number");
            System.out.println("unfilled bits assigned zeros");
            for (n = n2; n < this.nBits + 1; ++n) {
                this.binaryInput = '0' + this.binaryInput;
            }
            n2 = this.nBits + 1;
        }
        n = 0;
        int n3 = 0;
        int n4 = 32;
        for (int i = n2 - 1; i >= 0; --i) {
            n4 = this.binaryInput.charAt(i);
            if (n4 == 49) {
                n = 1;
            } else if (n4 == 48) {
                n = 0;
            } else {
                throw new IllegalArgumentException("String input must be '0's or '1's");
            }
            n3 = n2 - i - 1;
            this.vBinary[n3] = n;
        }
        long l = 1L;
        int[] nArray = Conv.copy(this.vBinary);
        if (this.vBinary[n2 - 1] == 1) {
            l = -1L;
            nArray = DtoA.negateNegativeBinary(nArray);
        }
        this.decimalInput = DtoA.binaryToDecimal(nArray);
        if (l == -1L) {
            this.decimalInput = -this.decimalInput;
        }
        this.outputVoltage = (double)this.decimalInput * this.vRef / (double)(this.maximumDecimal + 1L);
        this.inputSet = true;
    }

    public void setInput(int[] nArray) {
        int n;
        int n2 = nArray.length;
        if (n2 > this.nBits + 1) {
            throw new IllegalArgumentException("length of input array is greater than the DAC bit number plus  one");
        }
        for (n = 0; n < n2; ++n) {
            this.vBinary[n] = nArray[n];
        }
        if (n2 < this.nBits + 1) {
            System.out.println("Class - DtoA;  method - setInput(String)");
            System.out.println("The input array is less than DAC number of bits plus one");
            System.out.println("Array assumed to represent a postive unsigned binary number");
            System.out.println("unfilled bits assigned zeros");
            for (n = n2; n < this.nBits + 1; ++n) {
                this.vBinary[n] = 0;
            }
            n2 = this.nBits + 1;
        }
        this.binaryInput = "";
        for (n = this.nBits; n >= 0; --n) {
            this.binaryInput = this.binaryInput + this.vBinary[n];
        }
        long l = 1L;
        int[] nArray2 = Conv.copy(this.vBinary);
        if (this.vBinary[n2 - 1] == 1) {
            l = -1L;
            nArray2 = DtoA.negateNegativeBinary(this.vBinary);
        }
        this.decimalInput = DtoA.binaryToDecimal(nArray2);
        if (l == -1L) {
            this.decimalInput = -this.decimalInput;
        }
        this.outputVoltage = (double)this.decimalInput * this.vRef / (double)(this.maximumDecimal + 1L);
        this.inputSet = true;
    }

    public void setInput(long l) {
        int n;
        if (Math.abs(l) > this.maximumDecimal) {
            throw new IllegalArgumentException("abs(input), " + l + ", is greater than the maximum decimal representation, " + this.maximumDecimal + ", allowed by the set number of bits, " + this.nBits);
        }
        this.decimalInput = l;
        this.outputVoltage = (double)l * this.vRef / (double)(this.maximumDecimal + 1L);
        long l2 = this.decimalInput;
        int n2 = 1;
        if (l2 < 0L) {
            n2 = -1;
            l2 = -l2;
        }
        for (n = 0; n < this.nBits + 1; ++n) {
            this.vBinary[n] = 0;
        }
        n = 1;
        int n3 = 0;
        while (n != 0) {
            this.vBinary[n3] = (int)(l2 % 2L);
            ++n3;
            if ((l2 /= 2L) != 0L) continue;
            n = 0;
        }
        if ((long)n2 == -1L) {
            this.vBinary = AtoD.negateBinary(this.vBinary);
        }
        this.binaryInput = "";
        for (int i = this.nBits; i >= 0; --i) {
            this.binaryInput = this.binaryInput + this.vBinary[i];
        }
        this.inputSet = true;
    }

    public void setInput(double d) {
        if (this.trueDtoA) {
            if (Math.abs(d) > this.vRef) {
                throw new IllegalArgumentException("The input voltage in this simulation of a DAC must be less than nor equal to the reference voltage\nIf you choose the constructor without an argument list, i.e. an instance of DtoA that is simply a DAC marker\nyou may imput any voltage and the output will be made equal to that voltage");
            }
            this.voltageInput = d;
            AtoD atoD = new AtoD(this.nBits, this.vRef);
            atoD.setInput(d);
            this.decimalInput = atoD.decimalOutput();
            this.binaryInput = atoD.binaryOutput();
            this.vBinary = atoD.binaryArray();
        } else {
            this.outputVoltage = d;
        }
        this.sNumer.resetCoeff(0, new Complex(this.outputVoltage / this.voltageInput, 0.0));
        this.inputSet = true;
    }

    private static long binaryToDecimal(int[] nArray) {
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            l += (long)(Math.pow(2.0, i) * (double)nArray[i]);
        }
        return l;
    }

    private static int[] negateNegativeBinary(int[] nArray) {
        int n;
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray3[n] = 1;
            nArray2[n] = 0;
        }
        nArray2 = DtoA.addBinary(nArray2, nArray3);
        for (n = 0; n < n2; ++n) {
            if (nArray[n] != 0) continue;
            nArray2[n] = 1;
        }
        return nArray2;
    }

    private static int[] addBinary(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            n3 = n2;
            n4 = n;
        }
        int[] nArray3 = new int[n3];
        int n5 = 0;
        int n6 = 0;
        block6: for (int i = 0; i < n4; ++i) {
            n6 = nArray[i] + nArray2[i] + n5;
            switch (n6) {
                case 0: {
                    nArray3[i] = 0;
                    n5 = 0;
                    continue block6;
                }
                case 1: {
                    nArray3[i] = 1;
                    n5 = 0;
                    continue block6;
                }
                case 2: {
                    nArray3[i] = 0;
                    n5 = 1;
                    continue block6;
                }
                case 3: {
                    nArray3[i] = 1;
                    n5 = 1;
                }
            }
        }
        return nArray3;
    }

    public double getOutput() {
        if (!this.inputSet) {
            throw new IllegalArgumentException("No input has been entered");
        }
        return this.outputVoltage;
    }

    public long getDecimalInput() {
        if (!this.inputSet) {
            throw new IllegalArgumentException("No input has been entered");
        }
        if (!this.trueDtoA) {
            System.out.println("Class - DtoA;  method - getDecimalInput");
            System.out.println("This instance of DtoA is not a true simulation of an DAC");
            System.out.println("It is simple an 'D to A marker'");
            System.out.println("getDecimalInput has returned 0L");
            this.decimalInput = 0L;
        }
        return this.decimalInput;
    }

    public String getBinaryInput() {
        if (!this.inputSet) {
            throw new IllegalArgumentException("No input has been entered");
        }
        if (!this.trueDtoA) {
            System.out.println("Class - DtoA;  method - getBinaryInput");
            System.out.println("This instance of DtoA is not a true simulation of an DAC");
            System.out.println("It is simple an 'D to A marker'");
            System.out.println("getBinaryInput has returned null");
            this.binaryInput = null;
        }
        return this.binaryInput;
    }

    public int[] getBinaryArray() {
        if (!this.inputSet) {
            throw new IllegalArgumentException("No input has been entered");
        }
        if (!this.trueDtoA) {
            System.out.println("Class - DtoA;  method - getBinaryInput");
            System.out.println("This instance of DtoA is not a true simulation of an DAC");
            System.out.println("It is simple an 'D to A marker'");
            System.out.println("getBinaryArray has returned null");
            this.vBinary = null;
        }
        return this.vBinary;
    }

    @Override
    public DtoA copy() {
        if (this == null) {
            return null;
        }
        DtoA dtoA = new DtoA();
        this.copyBBvariables(dtoA);
        dtoA.nBits = this.nBits;
        dtoA.maximumDecimal = this.maximumDecimal;
        dtoA.vRef = this.vRef;
        dtoA.vBinary = Conv.copy(this.vBinary);
        dtoA.trueDtoA = this.trueDtoA;
        dtoA.outputVoltage = this.outputVoltage;
        dtoA.voltageInput = this.voltageInput;
        dtoA.binaryInput = this.binaryInput;
        dtoA.decimalInput = this.decimalInput;
        dtoA.inputSet = this.inputSet;
        return dtoA;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

