/*
 * Decompiled with CFR 0.152.
 */
package flanagan.complex;

import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Polynomial;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class ComplexPoly {
    private int deg = 0;
    private int degwz = 0;
    private Complex[] coeff;
    private Complex[] coeffwz;
    private boolean suppressRootsErrorMessages = false;

    public ComplexPoly(int n) {
        this.deg = n;
        this.coeff = Complex.oneDarray(n + 1);
    }

    public ComplexPoly(Complex[] complexArray) {
        this.deg = complexArray.length - 1;
        this.coeff = Complex.oneDarray(this.deg + 1);
        for (int i = 0; i <= this.deg; ++i) {
            this.coeff[i] = Complex.copy(complexArray[i]);
        }
    }

    public ComplexPoly(double[] dArray) {
        this.deg = dArray.length - 1;
        this.coeff = Complex.oneDarray(this.deg + 1);
        for (int i = 0; i <= this.deg; ++i) {
            this.coeff[i].reset(dArray[i], 0.0);
        }
    }

    public ComplexPoly(float[] fArray) {
        this.deg = fArray.length - 1;
        this.coeff = Complex.oneDarray(this.deg + 1);
        for (int i = 0; i <= this.deg; ++i) {
            this.coeff[i].reset(fArray[i], 0.0);
        }
    }

    public ComplexPoly(int[] nArray) {
        this.deg = nArray.length - 1;
        this.coeff = Complex.oneDarray(this.deg + 1);
        for (int i = 0; i <= this.deg; ++i) {
            this.coeff[i].reset(nArray[i], 0.0);
        }
    }

    public ComplexPoly(Polynomial polynomial) {
        this.deg = polynomial.getDeg();
        this.coeff = Complex.oneDarray(this.deg + 1);
        for (int i = 0; i <= this.deg; ++i) {
            this.coeff[i].reset(polynomial.getCoefficient(i), 0.0);
        }
    }

    public ComplexPoly(ArrayList<Object> arrayList) {
        this.deg = arrayList.size() - 1;
        this.coeff = Complex.oneDarray(this.deg + 1);
        block12: for (int i = 0; i <= this.deg; ++i) {
            int n = this.getTypeCode(arrayList.get(i));
            switch (n) {
                case 1: {
                    this.coeff[i].reset(((Byte)arrayList.get(i)).byteValue(), 0.0);
                    continue block12;
                }
                case 2: {
                    this.coeff[i].reset(((Short)arrayList.get(i)).shortValue(), 0.0);
                    continue block12;
                }
                case 3: {
                    this.coeff[i].reset(((Integer)arrayList.get(i)).intValue(), 0.0);
                    continue block12;
                }
                case 4: {
                    this.coeff[i].reset(((Long)arrayList.get(i)).longValue(), 0.0);
                    continue block12;
                }
                case 5: {
                    this.coeff[i].reset(((Float)arrayList.get(i)).floatValue(), 0.0);
                    continue block12;
                }
                case 6: {
                    this.coeff[i].reset((Double)arrayList.get(i), 0.0);
                    continue block12;
                }
                case 7: {
                    this.coeff[i] = (Complex)arrayList.get(i);
                    continue block12;
                }
                case 8: {
                    this.coeff[i] = ((Phasor)arrayList.get(i)).toComplex();
                    continue block12;
                }
                case 9: {
                    this.coeff[i].reset(((BigInteger)arrayList.get(i)).doubleValue(), 0.0);
                    continue block12;
                }
                case 10: {
                    this.coeff[i].reset(((BigDecimal)arrayList.get(i)).doubleValue(), 0.0);
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Type code, " + n + ", not recognised");
                }
            }
        }
    }

    private int getTypeCode(Object object) {
        int n = 0;
        if (object instanceof Byte) {
            n = 1;
        } else if (object instanceof Short) {
            n = 2;
        } else if (object instanceof Integer) {
            n = 3;
        } else if (object instanceof Long) {
            n = 4;
        } else if (object instanceof Float) {
            n = 5;
        } else if (object instanceof Double) {
            n = 6;
        } else if (object instanceof Complex) {
            n = 7;
        } else if (object instanceof Phasor) {
            n = 8;
        } else if (object instanceof BigInteger) {
            n = 9;
        } else if (object instanceof BigDecimal) {
            n = 10;
        }
        return n;
    }

    public ComplexPoly(Complex complex) {
        this.deg = 0;
        this.coeff = Complex.oneDarray(1);
        this.coeff[0] = Complex.copy(complex);
    }

    public ComplexPoly(double d) {
        this.deg = 0;
        this.coeff = Complex.oneDarray(1);
        this.coeff[0].reset(d, 0.0);
    }

    public ComplexPoly(Complex complex, Complex complex2) {
        this.deg = 1;
        this.coeff = Complex.oneDarray(2);
        this.coeff[0] = Complex.copy(complex);
        this.coeff[1] = Complex.copy(complex2);
    }

    public ComplexPoly(double d, double d2) {
        this.deg = 1;
        this.coeff = Complex.oneDarray(2);
        this.coeff[0].reset(d, 0.0);
        this.coeff[1].reset(d2, 0.0);
    }

    public ComplexPoly(Complex complex, Complex complex2, Complex complex3) {
        this.deg = 2;
        this.coeff = Complex.oneDarray(3);
        this.coeff[0] = Complex.copy(complex);
        this.coeff[1] = Complex.copy(complex2);
        this.coeff[2] = Complex.copy(complex3);
    }

    public ComplexPoly(double d, double d2, double d3) {
        this.deg = 2;
        this.coeff = Complex.oneDarray(3);
        this.coeff[0].reset(d, 0.0);
        this.coeff[1].reset(d2, 0.0);
        this.coeff[2].reset(d3, 0.0);
    }

    public ComplexPoly(Complex complex, Complex complex2, Complex complex3, Complex complex4) {
        this.deg = 3;
        this.coeff = Complex.oneDarray(4);
        this.coeff[0] = Complex.copy(complex);
        this.coeff[1] = Complex.copy(complex2);
        this.coeff[2] = Complex.copy(complex3);
        this.coeff[3] = Complex.copy(complex4);
    }

    public ComplexPoly(double d, double d2, double d3, double d4) {
        this.deg = 3;
        this.coeff = Complex.oneDarray(4);
        this.coeff[0].reset(d, 0.0);
        this.coeff[1].reset(d2, 0.0);
        this.coeff[2].reset(d3, 0.0);
        this.coeff[3].reset(d4, 0.0);
    }

    public ComplexPoly reducePoly() {
        ComplexPoly complexPoly = null;
        int n = this.deg;
        boolean bl = true;
        int n2 = this.deg;
        while (bl) {
            if (this.coeff[n2].isZero()) {
                --n;
                if (--n2 >= 0) continue;
                bl = false;
                continue;
            }
            bl = false;
        }
        if (this.deg == n) {
            complexPoly = this.copy();
        } else if (n >= 0) {
            complexPoly = new ComplexPoly(n);
            for (int i = 0; i <= n; ++i) {
                complexPoly.resetCoeff(i, this.coeff[i].copy());
            }
        }
        return complexPoly;
    }

    public static ComplexPoly reducePoly(ComplexPoly complexPoly) {
        ComplexPoly complexPoly2 = null;
        if (complexPoly != null) {
            int n;
            int n2 = n = complexPoly.getDeg();
            boolean bl = true;
            int n3 = n2;
            while (bl) {
                if (complexPoly.coeffCopy(n3).isZero()) {
                    --n2;
                    if (--n3 >= 0) continue;
                    bl = false;
                    continue;
                }
                bl = false;
            }
            if (n2 == n) {
                complexPoly2 = complexPoly.copy();
            } else if (n2 >= 0) {
                complexPoly2 = new ComplexPoly(n2);
                for (int i = 0; i <= n2; ++i) {
                    complexPoly2.resetCoeff(i, complexPoly.coeffCopy(i));
                }
            }
        }
        return complexPoly2;
    }

    public static ComplexPoly rootsToPoly(Complex[] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        Complex[] complexArray2 = Complex.oneDarray(2);
        complexArray2[0] = complexArray[0].times(Complex.minusOne());
        complexArray2[1] = Complex.plusOne();
        ComplexPoly complexPoly = new ComplexPoly(complexArray2);
        for (int i = 1; i < n; ++i) {
            complexArray2[0] = complexArray[i].times(Complex.minusOne());
            ComplexPoly complexPoly2 = new ComplexPoly(complexArray2);
            complexPoly = complexPoly.times(complexPoly2);
        }
        return complexPoly;
    }

    public void resetPoly(Complex[] complexArray) {
        if (this.deg + 1 != complexArray.length) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        for (int i = 0; i < this.deg; ++i) {
            this.coeff[i] = Complex.copy(complexArray[i]);
        }
    }

    public void resetPoly(ArrayList<Object> arrayList) {
        if (this.deg + 1 != arrayList.size()) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        block12: for (int i = 0; i <= this.deg; ++i) {
            int n = this.getTypeCode(arrayList.get(i));
            switch (n) {
                case 1: {
                    this.coeff[i].reset(((Byte)arrayList.get(i)).byteValue(), 0.0);
                    continue block12;
                }
                case 2: {
                    this.coeff[i].reset(((Short)arrayList.get(i)).shortValue(), 0.0);
                    continue block12;
                }
                case 3: {
                    this.coeff[i].reset(((Integer)arrayList.get(i)).intValue(), 0.0);
                    continue block12;
                }
                case 4: {
                    this.coeff[i].reset(((Long)arrayList.get(i)).longValue(), 0.0);
                    continue block12;
                }
                case 5: {
                    this.coeff[i].reset(((Float)arrayList.get(i)).floatValue(), 0.0);
                    continue block12;
                }
                case 6: {
                    this.coeff[i].reset((Double)arrayList.get(i), 0.0);
                    continue block12;
                }
                case 7: {
                    this.coeff[i] = (Complex)arrayList.get(i);
                    continue block12;
                }
                case 8: {
                    this.coeff[i] = ((Phasor)arrayList.get(i)).toComplex();
                    continue block12;
                }
                case 9: {
                    this.coeff[i].reset(((BigInteger)arrayList.get(i)).doubleValue(), 0.0);
                    continue block12;
                }
                case 10: {
                    this.coeff[i].reset(((BigDecimal)arrayList.get(i)).doubleValue(), 0.0);
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Type code, " + n + ", not recognised");
                }
            }
        }
    }

    public void resetCoeff(int n, Complex complex) {
        this.coeff[n] = Complex.copy(complex);
    }

    public ComplexPoly copy() {
        if (this == null) {
            return null;
        }
        ComplexPoly complexPoly = new ComplexPoly(this.deg);
        for (int i = 0; i <= this.deg; ++i) {
            complexPoly.coeff[i] = Complex.copy(this.coeff[i]);
        }
        complexPoly.deg = this.deg;
        complexPoly.degwz = this.degwz;
        complexPoly.coeffwz = Conv.copy(this.coeffwz);
        return complexPoly;
    }

    public static ComplexPoly copy(ComplexPoly complexPoly) {
        if (complexPoly == null) {
            return null;
        }
        ComplexPoly complexPoly2 = new ComplexPoly(complexPoly.deg);
        for (int i = 0; i <= complexPoly.deg; ++i) {
            complexPoly2.coeff[i] = Complex.copy(complexPoly.coeff[i]);
        }
        complexPoly2.deg = complexPoly.deg;
        complexPoly2.degwz = complexPoly.degwz;
        complexPoly2.coeffwz = Conv.copy(complexPoly.coeffwz);
        return complexPoly2;
    }

    public Object clone() {
        return this.copy();
    }

    public Complex[] polyNomCopy() {
        Complex[] complexArray = Complex.oneDarray(this.deg + 1);
        for (int i = 0; i <= this.deg; ++i) {
            complexArray[i] = Complex.copy(this.coeff[i]);
        }
        return complexArray;
    }

    public Complex[] polyNomReference() {
        return this.coeff;
    }

    public Complex[] polyNomPointer() {
        return this.coeff;
    }

    public Complex coeffCopy(int n) {
        return Complex.copy(this.coeff[n]);
    }

    public Complex coeffReference(int n) {
        return this.coeff[n];
    }

    public Complex coeffPointer(int n) {
        return this.coeff[n];
    }

    public int getDeg() {
        return this.deg;
    }

    public void setj() {
        Complex.setj();
    }

    public void seti() {
        Complex.seti();
    }

    public String toString() {
        String string = "";
        string = string + this.coeffCopy(0).toString();
        if (this.deg > 0) {
            string = string + " + (" + this.coeffCopy(1).toString() + ").x";
        }
        for (int i = 2; i <= this.deg; ++i) {
            string = string + " + (" + this.coeffCopy(i).toString() + ").x^" + i;
        }
        return string;
    }

    public void print() {
        System.out.print(this.toString());
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void printToText(String string) {
        string = string + ".txt";
        FileOutput fileOutput = new FileOutput(string, 'n');
        fileOutput.println("Output File for a ComplexPoly");
        fileOutput.dateAndTimeln();
        fileOutput.println();
        fileOutput.print("Polynomial degree is ");
        fileOutput.println(this.deg);
        fileOutput.println();
        fileOutput.println("The coefficients are ");
        for (int i = 0; i <= this.deg; ++i) {
            fileOutput.println(this.coeff[i]);
        }
        fileOutput.println();
        fileOutput.println("End of file.");
        fileOutput.close();
    }

    public void printToText() {
        String string = "ComplexPolyOut";
        this.printToText(string);
    }

    public ArrayList<ComplexPoly> sTransform() {
        return ComplexPoly.sTransform(this.coeff);
    }

    public static ArrayList<ComplexPoly> sTransform(double[] dArray) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        Complex[] complexArray = arrayMaths.getArray_as_Complex();
        return ComplexPoly.sTransform(complexArray);
    }

    public static ArrayList<ComplexPoly> sTransform(Complex[] complexArray) {
        int n;
        int n2 = complexArray.length;
        ComplexPoly[] complexPolyArray = new ComplexPoly[n2];
        ComplexPoly[] complexPolyArray2 = new ComplexPoly[n2];
        ComplexPoly complexPoly = null;
        ComplexPoly complexPoly2 = new ComplexPoly(Complex.plusOne());
        for (n = 0; n < n2; ++n) {
            complexPolyArray[n] = new ComplexPoly(complexArray[n].times(new Complex(Fmath.factorial(n), 0.0)));
            complexPolyArray2[n] = new ComplexPoly(n + 1);
            complexPolyArray2[n].resetCoeff(n + 1, Complex.plusOne());
        }
        complexPoly2 = complexPolyArray2[n2 - 1];
        for (n = 0; n < n2 - 1; ++n) {
            complexPolyArray[n] = complexPolyArray[n].times(complexPolyArray2[n2 - n - 2]);
        }
        complexPoly = complexPolyArray[0];
        for (n = 1; n < n2; ++n) {
            complexPoly = complexPoly.plus(complexPolyArray[n]);
        }
        ArrayList<ComplexPoly> arrayList = new ArrayList<ComplexPoly>();
        arrayList.add(complexPoly);
        arrayList.add(complexPoly2);
        return arrayList;
    }

    public boolean equals(ComplexPoly complexPoly) {
        return this.isEqual(complexPoly);
    }

    public boolean isEqual(ComplexPoly complexPoly) {
        int n;
        boolean bl = false;
        int n2 = this.getDeg();
        if (n2 == (n = complexPoly.getDeg())) {
            boolean bl2 = true;
            int n3 = 0;
            while (bl2) {
                if (!this.coeff[n3].isEqual(complexPoly.coeffReference(n3))) {
                    bl2 = false;
                    continue;
                }
                if (++n3 <= n) continue;
                bl2 = false;
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isEqual(ComplexPoly complexPoly, ComplexPoly complexPoly2) {
        int n;
        boolean bl = false;
        int n2 = complexPoly.getDeg();
        if (n2 == (n = complexPoly2.getDeg())) {
            boolean bl2 = true;
            int n3 = 0;
            while (bl2) {
                if (!complexPoly.coeffReference(n3).isEqual(complexPoly2.coeffReference(n3))) {
                    bl2 = false;
                    continue;
                }
                if (++n3 <= n2) continue;
                bl2 = false;
                bl = true;
            }
        }
        return bl;
    }

    public ComplexPoly plus(ComplexPoly complexPoly) {
        ComplexPoly complexPoly2 = null;
        if (complexPoly.deg <= this.deg) {
            int n;
            complexPoly2 = new ComplexPoly(this.deg);
            for (n = complexPoly.deg + 1; n <= this.deg; ++n) {
                complexPoly2.coeff[n] = Complex.copy(this.coeff[n]);
            }
            for (n = 0; n <= complexPoly.deg; ++n) {
                complexPoly2.coeff[n] = this.coeff[n].plus(complexPoly.coeff[n]);
            }
        } else {
            int n;
            complexPoly2 = new ComplexPoly(complexPoly.deg);
            for (n = this.deg + 1; n <= complexPoly.deg; ++n) {
                complexPoly2.coeff[n] = Complex.copy(complexPoly.coeff[n]);
            }
            for (n = 0; n <= this.deg; ++n) {
                complexPoly2.coeff[n] = this.coeff[n].plus(complexPoly.coeff[n]);
            }
        }
        return complexPoly2;
    }

    public static ComplexPoly plus(ComplexPoly complexPoly, ComplexPoly complexPoly2) {
        ComplexPoly complexPoly3 = null;
        if (complexPoly2.deg <= complexPoly.deg) {
            int n;
            complexPoly3 = new ComplexPoly(complexPoly.deg);
            for (n = complexPoly2.deg + 1; n <= complexPoly.deg; ++n) {
                complexPoly3.coeff[n] = Complex.copy(complexPoly.coeff[n]);
            }
            for (n = 0; n <= complexPoly2.deg; ++n) {
                complexPoly3.coeff[n] = complexPoly.coeff[n].plus(complexPoly2.coeff[n]);
            }
        } else {
            int n;
            complexPoly3 = new ComplexPoly(complexPoly2.deg);
            for (n = complexPoly.deg + 1; n <= complexPoly2.deg; ++n) {
                complexPoly3.coeff[n] = Complex.copy(complexPoly2.coeff[n]);
            }
            for (n = 0; n <= complexPoly.deg; ++n) {
                complexPoly3.coeff[n] = complexPoly.coeff[n].plus(complexPoly2.coeff[n]);
            }
        }
        return complexPoly3;
    }

    public ComplexPoly plus(Complex complex) {
        ComplexPoly complexPoly = new ComplexPoly(complex);
        return this.plus(complexPoly);
    }

    public static ComplexPoly plus(ComplexPoly complexPoly, Complex complex) {
        ComplexPoly complexPoly2 = new ComplexPoly(complex);
        return ComplexPoly.plus(complexPoly, complexPoly2);
    }

    public ComplexPoly plus(double d) {
        ComplexPoly complexPoly = new ComplexPoly(new Complex(d, 0.0));
        return this.plus(complexPoly);
    }

    public static ComplexPoly plus(ComplexPoly complexPoly, double d) {
        ComplexPoly complexPoly2 = new ComplexPoly(new Complex(d, 0.0));
        return ComplexPoly.plus(complexPoly, complexPoly2);
    }

    public ComplexPoly plus(int n) {
        ComplexPoly complexPoly = new ComplexPoly(new Complex(n, 0.0));
        return this.plus(complexPoly);
    }

    public static ComplexPoly plus(ComplexPoly complexPoly, int n) {
        ComplexPoly complexPoly2 = new ComplexPoly(new Complex(n, 0.0));
        return ComplexPoly.plus(complexPoly, complexPoly2);
    }

    public ComplexPoly minus(ComplexPoly complexPoly) {
        ComplexPoly complexPoly2 = null;
        if (complexPoly.deg <= this.deg) {
            int n;
            complexPoly2 = new ComplexPoly(this.deg);
            for (n = complexPoly.deg + 1; n <= this.deg; ++n) {
                complexPoly2.coeff[n] = Complex.copy(this.coeff[n]);
            }
            for (n = 0; n <= complexPoly.deg; ++n) {
                complexPoly2.coeff[n] = this.coeff[n].minus(complexPoly.coeff[n]);
            }
        } else {
            int n;
            complexPoly2 = new ComplexPoly(complexPoly.deg);
            for (n = this.deg + 1; n <= complexPoly.deg; ++n) {
                complexPoly2.coeff[n] = complexPoly.coeff[n].times(Complex.minusOne());
            }
            for (n = 0; n <= this.deg; ++n) {
                complexPoly2.coeff[n] = this.coeff[n].minus(complexPoly.coeff[n]);
            }
        }
        return complexPoly2;
    }

    public ComplexPoly minus(Complex complex) {
        ComplexPoly complexPoly = new ComplexPoly(complex);
        return this.minus(complexPoly);
    }

    public ComplexPoly minus(double d) {
        ComplexPoly complexPoly = new ComplexPoly(new Complex(d, 0.0));
        return this.minus(complexPoly);
    }

    public ComplexPoly minus(int n) {
        ComplexPoly complexPoly = new ComplexPoly(new Complex(n, 0.0));
        return this.minus(complexPoly);
    }

    public static ComplexPoly minus(ComplexPoly complexPoly, ComplexPoly complexPoly2) {
        ComplexPoly complexPoly3 = null;
        if (complexPoly2.deg <= complexPoly.deg) {
            int n;
            complexPoly3 = new ComplexPoly(complexPoly.deg);
            for (n = complexPoly2.deg + 1; n <= complexPoly.deg; ++n) {
                complexPoly3.coeff[n] = Complex.copy(complexPoly.coeff[n]);
            }
            for (n = 0; n <= complexPoly2.deg; ++n) {
                complexPoly3.coeff[n] = complexPoly.coeff[n].minus(complexPoly2.coeff[n]);
            }
        } else {
            int n;
            complexPoly3 = new ComplexPoly(complexPoly2.deg);
            for (n = complexPoly.deg + 1; n <= complexPoly2.deg; ++n) {
                complexPoly3.coeff[n] = complexPoly2.coeff[n].times(Complex.minusOne());
            }
            for (n = 0; n <= complexPoly.deg; ++n) {
                complexPoly3.coeff[n] = complexPoly.coeff[n].minus(complexPoly2.coeff[n]);
            }
        }
        return complexPoly3;
    }

    public static ComplexPoly minus(ComplexPoly complexPoly, Complex complex) {
        ComplexPoly complexPoly2 = new ComplexPoly(complex);
        return ComplexPoly.minus(complexPoly, complexPoly2);
    }

    public static ComplexPoly minus(ComplexPoly complexPoly, double d) {
        ComplexPoly complexPoly2 = new ComplexPoly(new Complex(d, 0.0));
        return ComplexPoly.minus(complexPoly, complexPoly2);
    }

    public static ComplexPoly minus(ComplexPoly complexPoly, int n) {
        ComplexPoly complexPoly2 = new ComplexPoly(new Complex(n, 0.0));
        return ComplexPoly.minus(complexPoly, complexPoly2);
    }

    public ComplexPoly times(ComplexPoly complexPoly) {
        int n = this.deg + complexPoly.deg;
        ComplexPoly complexPoly2 = new ComplexPoly(n);
        for (int i = 0; i <= this.deg; ++i) {
            for (int j = 0; j <= complexPoly.deg; ++j) {
                complexPoly2.coeff[i + j].plusEquals(this.coeff[i].times(complexPoly.coeff[j]));
            }
        }
        return complexPoly2;
    }

    public static ComplexPoly times(ComplexPoly complexPoly, ComplexPoly complexPoly2) {
        int n = complexPoly.deg + complexPoly2.deg;
        ComplexPoly complexPoly3 = new ComplexPoly(n);
        for (int i = 0; i <= complexPoly.deg; ++i) {
            for (int j = 0; j <= complexPoly2.deg; ++j) {
                complexPoly3.coeff[i + j].plusEquals(complexPoly.coeff[i].times(complexPoly2.coeff[j]));
            }
        }
        return complexPoly3;
    }

    public ComplexPoly times(Complex complex) {
        ComplexPoly complexPoly = new ComplexPoly(this.deg);
        for (int i = 0; i <= this.deg; ++i) {
            complexPoly.coeff[i] = this.coeff[i].times(complex);
        }
        return complexPoly;
    }

    public static ComplexPoly times(ComplexPoly complexPoly, Complex complex) {
        ComplexPoly complexPoly2 = new ComplexPoly(complexPoly.deg);
        for (int i = 0; i <= complexPoly.deg; ++i) {
            complexPoly2.coeff[i] = complexPoly.coeff[i].times(complex);
        }
        return complexPoly2;
    }

    public ComplexPoly times(double d) {
        ComplexPoly complexPoly = new ComplexPoly(this.deg);
        for (int i = 0; i <= this.deg; ++i) {
            complexPoly.coeff[i] = this.coeff[i].times(new Complex(d, 0.0));
        }
        return complexPoly;
    }

    public static ComplexPoly times(ComplexPoly complexPoly, double d) {
        ComplexPoly complexPoly2 = new ComplexPoly(complexPoly.deg);
        for (int i = 0; i <= complexPoly.deg; ++i) {
            complexPoly2.coeff[i] = complexPoly.coeff[i].times(new Complex(d, 0.0));
        }
        return complexPoly2;
    }

    public ComplexPoly nthDerivative(int n) {
        ComplexPoly complexPoly;
        if (n > this.deg) {
            complexPoly = new ComplexPoly(0.0);
        } else {
            complexPoly = new ComplexPoly(this.deg - n);
            Complex[] complexArray = Complex.oneDarray(this.deg - n + 1);
            int n2 = this.deg - n;
            for (int i = this.deg; i > n - 1; --i) {
                complexArray[n2] = Complex.copy(this.coeff[i]);
                for (int j = 0; j < n; ++j) {
                    complexArray[n2] = Complex.times(complexArray[n2], (double)(i - j));
                }
                --n2;
            }
            complexPoly = new ComplexPoly(complexArray);
        }
        return complexPoly;
    }

    public Complex evaluate(Complex complex) {
        Complex complex2 = new Complex();
        if (this.deg == 0) {
            complex2 = Complex.copy(this.coeff[0]);
        } else {
            complex2 = Complex.copy(this.coeff[this.deg]);
            for (int i = this.deg - 1; i >= 0; --i) {
                complex2 = Complex.plus(Complex.times(complex2, complex), this.coeff[i]);
            }
        }
        return complex2;
    }

    public Complex evaluate(double d) {
        Complex complex = new Complex(d, 0.0);
        Complex complex2 = new Complex();
        if (this.deg == 0) {
            complex2 = Complex.copy(this.coeff[0]);
        } else {
            complex2 = Complex.copy(this.coeff[this.deg]);
            for (int i = this.deg - 1; i >= 0; --i) {
                complex2 = Complex.plus(Complex.times(complex2, complex), this.coeff[i]);
            }
        }
        return complex2;
    }

    public Complex nthDerivEvaluate(int n, Complex complex) {
        Complex complex2 = new Complex();
        Complex[] complexArray = Complex.oneDarray(this.deg + 1);
        if (n == 0) {
            complex2 = this.evaluate(complex);
            System.out.println("n = 0 in ComplexPoly.nthDerivative");
            System.out.println("polynomial itself evaluated and returned");
        } else {
            ComplexPoly complexPoly = this.nthDerivative(n);
            complex2 = complexPoly.evaluate(complex);
        }
        return complex2;
    }

    public Complex nthDerivEvaluate(int n, double d) {
        Complex complex = new Complex(d, 0.0);
        return this.nthDerivEvaluate(n, complex);
    }

    public Complex[] roots() {
        boolean bl = true;
        Complex complex = new Complex(0.0, 0.0);
        return this.roots(bl, complex);
    }

    public Complex[] rootsNoMessages() {
        this.suppressRootsErrorMessages = true;
        return this.roots();
    }

    public Complex[] roots(boolean bl) {
        Complex complex = new Complex(0.0, 0.0);
        return this.roots(bl, complex);
    }

    public Complex[] roots(Complex complex) {
        boolean bl = true;
        return this.roots(bl, complex);
    }

    public Complex[] roots(boolean bl, Complex complex) {
        int n;
        int n2;
        int n3;
        int n4;
        Complex[] complexArray = Complex.oneDarray(this.deg);
        if (this.deg == 0) {
            if (!this.suppressRootsErrorMessages) {
                System.out.println("degree of the polynomial is zero in the method ComplexPoly.roots");
                System.out.println("null returned");
            }
            return null;
        }
        int n5 = 0;
        for (n4 = 1; n4 <= this.deg; ++n4) {
            if (!this.coeff[n4].isZero()) continue;
            ++n5;
        }
        if (n5 == this.deg) {
            if (!this.suppressRootsErrorMessages) {
                System.out.println("polynomial coefficients above the zeroth are all zero in the method ComplexPoly.roots");
                System.out.println("null returned");
            }
            return null;
        }
        n4 = 0;
        int n6 = 0;
        for (n3 = 0; n3 <= this.deg; ++n3) {
            if (this.coeff[n3].isZero()) continue;
            ++n4;
            n6 = n3;
        }
        if (n4 == 1) {
            if (!this.suppressRootsErrorMessages) {
                System.out.println("all polynomial coefficients except a[" + n6 + "] are zero in the method ComplexPoly.roots");
                System.out.println("all roots returned as zero");
            }
            for (n3 = 0; n3 < this.deg; ++n3) {
                complexArray[n3] = Complex.zero();
            }
            return complexArray;
        }
        n3 = 1;
        int n7 = 0;
        int n8 = 0;
        while (n3 != 0) {
            if (this.coeff[n7].isZero()) {
                ++n8;
                ++n7;
                continue;
            }
            n3 = 0;
        }
        if (n8 > 0) {
            this.degwz = this.deg - n8;
            this.coeffwz = Complex.oneDarray(this.degwz + 1);
            for (n2 = 0; n2 <= this.degwz; ++n2) {
                this.coeffwz[n2] = this.coeff[n2 + n8].copy();
            }
        } else {
            this.degwz = this.deg;
            this.coeffwz = Complex.oneDarray(this.degwz + 1);
            for (n2 = 0; n2 <= this.degwz; ++n2) {
                this.coeffwz[n2] = this.coeff[n2].copy();
            }
        }
        Complex[] complexArray2 = Complex.oneDarray(this.degwz);
        switch (this.degwz) {
            case 1: {
                complexArray2[0] = Complex.negate(this.coeffwz[0].over(this.coeffwz[1]));
                break;
            }
            case 2: {
                complexArray2 = ComplexPoly.quadratic(this.coeffwz[0], this.coeffwz[1], this.coeffwz[2]);
                break;
            }
            case 3: {
                complexArray2 = ComplexPoly.cubic(this.coeffwz[0], this.coeffwz[1], this.coeffwz[2], this.coeffwz[3]);
                break;
            }
            default: {
                complexArray2 = this.laguerreAll(bl, complex);
            }
        }
        for (n = 0; n < this.degwz; ++n) {
            complexArray[n] = complexArray2[n].copy();
        }
        if (n8 > 0) {
            for (n = this.degwz; n < this.deg; ++n) {
                complexArray[n] = Complex.zero();
            }
        }
        return complexArray;
    }

    public static Complex[] quadratic(Complex complex, Complex complex2, Complex complex3) {
        double d = 1.0;
        Complex complex4 = new Complex();
        Complex complex5 = new Complex();
        Complex complex6 = new Complex();
        Complex[] complexArray = Complex.oneDarray(2);
        complex6 = complex2.conjugate();
        complex5 = complex6.times(complex4 = Complex.sqrt(Complex.square(complex2).minus(complex3.times(complex).times(4.0))));
        if (complex5.getReal() < 0.0) {
            d = -1.0;
        }
        complex4 = complex4.over(d).plus(complex2).over(-2.0);
        complexArray[0] = Complex.over(complex4, complex3);
        complexArray[1] = Complex.over(complex, complex4);
        return complexArray;
    }

    public static Complex[] quadratic(double d, double d2, double d3) {
        Complex complex = new Complex(d3, 0.0);
        Complex complex2 = new Complex(d2, 0.0);
        Complex complex3 = new Complex(d, 0.0);
        return ComplexPoly.quadratic(complex3, complex2, complex);
    }

    public static Complex[] cubic(Complex complex, Complex complex2, Complex complex3, Complex complex4) {
        Complex complex5 = complex3.over(complex4);
        Complex complex6 = complex2.over(complex4);
        Complex complex7 = complex.over(complex4);
        Complex[] complexArray = Complex.oneDarray(3);
        Complex complex8 = complex5.times(complex5).minus(complex6.times(3.0)).over(9.0);
        Complex complex9 = complex5.times(complex5).times(complex5).times(2.0).minus(complex5.times(complex6).times(9.0)).plus(complex7.times(27.0)).over(54.0);
        Complex complex10 = Complex.plusOne();
        Complex complex11 = Complex.sqrt(complex9.times(complex9).minus(complex8.times(complex8).times(complex8)));
        Complex complex12 = complex9.conjugate();
        if (complex12.times(complex11).getReal() < 0.0) {
            complex10 = Complex.minusOne();
        }
        Complex complex13 = Complex.pow(complex9.plus(complex10.times(complex11)), 0.3333333333333333).times(Complex.minusOne());
        Complex complex14 = null;
        complex14 = complex13.isZero() ? Complex.zero() : complex8.over(complex13);
        Complex complex15 = complex13.plus(complex14);
        Complex complex16 = complex13.minus(complex14);
        Complex complex17 = complex15.times(Complex.minusOne());
        Complex complex18 = complex5.over(3.0);
        Complex complex19 = new Complex(0.0, Math.sqrt(3.0) / 2.0);
        complexArray[0] = complex15.minus(complex18);
        complexArray[1] = complex17.over(2.0).minus(complex18).plus(complex19.times(complex16));
        complexArray[2] = complex17.over(2.0).minus(complex18).minus(complex19.times(complex16));
        return complexArray;
    }

    public static Complex[] cubic(double d, double d2, double d3, double d4) {
        Complex complex = new Complex(d4, 0.0);
        Complex complex2 = new Complex(d3, 0.0);
        Complex complex3 = new Complex(d2, 0.0);
        Complex complex4 = new Complex(d, 0.0);
        return ComplexPoly.cubic(complex4, complex3, complex2, complex);
    }

    public static Complex laguerre(Complex complex, Complex[] complexArray, int n) {
        double d = 1.0E-7;
        int n2 = 8;
        int n3 = 1000;
        int n4 = n2 * n3;
        int n5 = 0;
        double[] dArray = new double[]{0.5, 0.25, 0.75, 0.13, 0.38, 0.62, 0.88, 1.0};
        Complex complex2 = new Complex();
        Complex complex3 = new Complex();
        Complex complex4 = new Complex();
        Complex complex5 = new Complex();
        Complex complex6 = new Complex();
        Complex complex7 = new Complex();
        Complex complex8 = new Complex();
        Complex complex9 = new Complex();
        Complex complex10 = new Complex();
        Complex complex11 = new Complex();
        Complex complex12 = new Complex();
        Complex complex13 = new Complex();
        Complex complex14 = new Complex();
        Complex complex15 = new Complex();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n6 = 1;
        while (n6 <= n4) {
            n5 = n6;
            complex3 = Complex.copy(complexArray[n]);
            d4 = Complex.abs(complex3);
            complex4 = complex5 = Complex.zero();
            d5 = Complex.abs(complex);
            for (int i = n - 1; i >= 0; --i) {
                complex5 = Complex.plus(Complex.times(complex, complex5), complex4);
                complex4 = Complex.plus(Complex.times(complex, complex4), complex3);
                complex3 = Complex.plus(Complex.times(complex, complex3), complexArray[i]);
                d4 = Complex.abs(complex3) + d5 * d4;
            }
            d4 *= d;
            if (Complex.abs(complex3) <= d4) {
                complex2 = Complex.copy(complex);
                n5 = n6;
                return complex2;
            }
            complex6 = Complex.over(complex4, complex3);
            complex7 = Complex.square(complex6);
            complex8 = Complex.minus(complex7, Complex.times(2.0, Complex.over(complex5, complex3)));
            complex9 = Complex.sqrt(Complex.times((double)(n - 1), Complex.minus(Complex.times((double)n, complex8), complex7)));
            complex10 = Complex.plus(complex6, complex9);
            complex11 = Complex.minus(complex6, complex9);
            d2 = Complex.abs(complex10);
            if (d2 < (d3 = Complex.abs(complex11))) {
                complex10 = complex11;
            }
            complex14.setReal(n);
            complex15.setReal(Math.cos(n6));
            complex15.setImag(Math.sin(n6));
            complex12 = Math.max(d2, d3) > 0.0 ? Complex.over(complex14, complex10) : Complex.times(Math.exp(1.0 + d5), complex15);
            complex13 = Complex.minus(complex, complex12);
            if (Complex.isEqual(complex, complex13)) {
                complex2 = Complex.copy(complex);
                n5 = n6;
                return complex2;
            }
            complex = n6 % n3 != 0 ? Complex.copy(complex13) : Complex.minus(complex, Complex.times(dArray[n6 / n3 - 1], complex12));
            n5 = n6++;
        }
        complex2 = Complex.copy(complex);
        System.out.println("Maximum number of iterations exceeded in laguerre");
        System.out.println("root returned at this point");
        return complex2;
    }

    public Complex[] laguerreAll() {
        Complex complex = new Complex(0.0, 0.0);
        boolean bl = true;
        return this.laguerreAll(bl, complex);
    }

    public Complex[] laguerreAll(Complex complex) {
        boolean bl = true;
        return this.laguerreAll(bl, complex);
    }

    public Complex[] laguerreAll(boolean bl) {
        Complex complex = new Complex(0.0, 0.0);
        return this.laguerreAll(bl, complex);
    }

    public Complex[] laguerreAll(boolean bl, Complex complex) {
        int n;
        int n2;
        int n3 = this.degwz;
        double d = 2.0E-6;
        Complex complex2 = new Complex();
        Complex complex3 = new Complex();
        Complex complex4 = new Complex();
        Complex[] complexArray = new Complex[n3 + 1];
        Complex[] complexArray2 = new Complex[n3 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            complexArray[n2] = Complex.copy(this.coeffwz[n2]);
        }
        for (n2 = n3; n2 >= 1; --n2) {
            complex2 = Complex.copy(complex);
            if (Math.abs((complex2 = ComplexPoly.laguerre(complex2, complexArray, n2)).getImag()) <= 2.0 * d * Math.abs(complex2.getReal())) {
                complex2.setImag(0.0);
            }
            complexArray2[n2] = Complex.copy(complex2);
            complex3 = Complex.copy(complexArray[n2]);
            for (n = n2 - 1; n >= 0; --n) {
                complex4 = Complex.copy(complexArray[n]);
                complexArray[n] = Complex.copy(complex3);
                complex3 = complex2.times(complex3).plus(complex4);
            }
        }
        if (bl) {
            for (n2 = 1; n2 <= n3; ++n2) {
                complexArray2[n2] = ComplexPoly.laguerre(complexArray2[n2], this.coeffwz, n3);
            }
        }
        for (n2 = 2; n2 <= n3; ++n2) {
            complex2 = Complex.copy(complexArray2[n2]);
            n = 0;
            for (n = n2 - 1; n >= 1 && !(complexArray2[n].getReal() <= complex2.getReal()); --n) {
                complexArray2[n + 1] = Complex.copy(complexArray2[n]);
            }
            complexArray2[n + 1] = Complex.copy(complex2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            complexArray2[n2] = Complex.copy(complexArray2[n2 + 1]);
        }
        return complexArray2;
    }
}

