/*
 * Decompiled with CFR 0.152.
 */
package flanagan.complex;

import flanagan.math.Fmath;
import java.io.IOException;

public class Complex {
    private double real = 0.0;
    private double imag = 0.0;
    private static char jori = (char)106;
    private static boolean infOption = true;

    public Complex() {
        this.real = 0.0;
        this.imag = 0.0;
    }

    public Complex(double d, double d2) {
        this.real = d;
        this.imag = d2;
    }

    public Complex(double d) {
        this.real = d;
        this.imag = 0.0;
    }

    public Complex(Complex complex) {
        this.real = complex.real;
        this.imag = complex.imag;
    }

    public void setReal(double d) {
        this.real = d;
    }

    public void setImag(double d) {
        this.imag = d;
    }

    public void reset(double d, double d2) {
        this.real = d;
        this.imag = d2;
    }

    public void polarRad(double d, double d2) {
        this.real = d * Math.cos(d2);
        this.imag = d * Math.sin(d2);
    }

    public void polar(double d, double d2) {
        this.real = d * Math.cos(d2);
        this.imag = d * Math.sin(d2);
    }

    public void polarDeg(double d, double d2) {
        d2 = Math.toRadians(d2);
        this.real = d * Math.cos(d2);
        this.imag = d * Math.sin(d2);
    }

    public double getReal() {
        return this.real;
    }

    public double getImag() {
        return this.imag;
    }

    public static final synchronized Complex readComplex(String string) {
        int n = 32;
        String string2 = "";
        boolean bl = false;
        System.out.print(string + " ");
        System.out.flush();
        while (!bl) {
            try {
                n = System.in.read();
                if (n < 0 || (char)n == '\n') {
                    bl = true;
                    continue;
                }
                string2 = string2 + (char)n;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        return Complex.parseComplex(string2);
    }

    public static final synchronized Complex readComplex(String string, String string2) {
        int n = 32;
        String string3 = "";
        boolean bl = false;
        System.out.print(string + " [default value = " + string2 + "]  ");
        System.out.flush();
        int n2 = 0;
        while (!bl) {
            try {
                n = System.in.read();
                if (n < 0 || (char)n == '\n' || (char)n == '\r') {
                    if (n2 == 0) {
                        string3 = string2;
                        if ((char)n == '\r') {
                            n = System.in.read();
                        }
                    }
                    bl = true;
                    continue;
                }
                string3 = string3 + (char)n;
                ++n2;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        return Complex.parseComplex(string3);
    }

    public static final synchronized Complex readComplex(String string, Complex complex) {
        int n = 32;
        String string2 = "";
        boolean bl = false;
        System.out.print(string + " [default value = " + complex + "]  ");
        System.out.flush();
        int n2 = 0;
        while (!bl) {
            try {
                n = System.in.read();
                if (n < 0 || (char)n == '\n' || (char)n == '\r') {
                    if (n2 == 0) {
                        if ((char)n == '\r') {
                            n = System.in.read();
                        }
                        return complex;
                    }
                    bl = true;
                    continue;
                }
                string2 = string2 + (char)n;
                ++n2;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        return Complex.parseComplex(string2);
    }

    public static final synchronized Complex readComplex() {
        int n = 32;
        String string = "";
        boolean bl = false;
        System.out.print(" ");
        System.out.flush();
        while (!bl) {
            try {
                n = System.in.read();
                if (n < 0 || (char)n == '\n') {
                    bl = true;
                    continue;
                }
                string = string + (char)n;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        return Complex.parseComplex(string);
    }

    public void println(String string) {
        System.out.println(string + " " + this.toString());
    }

    public void println() {
        System.out.println(" " + this.toString());
    }

    public void print(String string) {
        System.out.print(string + " " + this.toString());
    }

    public void print() {
        System.out.print(" " + this.toString());
    }

    public static void println(String string, Complex[] complexArray) {
        System.out.println(string);
        for (int i = 0; i < complexArray.length; ++i) {
            System.out.println(complexArray[i].toString() + "  ");
        }
    }

    public static void println(Complex[] complexArray) {
        for (int i = 0; i < complexArray.length; ++i) {
            System.out.println(complexArray[i].toString() + "  ");
        }
    }

    public static void print(String string, Complex[] complexArray) {
        System.out.print(string + " ");
        for (int i = 0; i < complexArray.length; ++i) {
            System.out.print(complexArray[i].toString() + "   ");
        }
        System.out.println();
    }

    public static void print(Complex[] complexArray) {
        for (int i = 0; i < complexArray.length; ++i) {
            System.out.print(complexArray[i].toString() + "  ");
        }
        System.out.println();
    }

    public static Complex truncate(Complex complex, int n) {
        if (n < 0) {
            return complex;
        }
        double d = complex.getReal();
        double d2 = complex.getImag();
        Complex complex2 = new Complex();
        d = Fmath.truncate(d, n);
        d2 = Fmath.truncate(d2, n);
        complex2.reset(d, d2);
        return complex2;
    }

    public Complex truncate(int n) {
        if (n < 0) {
            return this;
        }
        double d = this.getReal();
        double d2 = this.getImag();
        Complex complex = new Complex();
        d = Fmath.truncate(d, n);
        d2 = Fmath.truncate(d2, n);
        complex.reset(d, d2);
        return complex;
    }

    public String toString() {
        char c = '+';
        if (this.imag < 0.0) {
            c = '-';
        }
        return this.real + " " + c + " " + jori + Math.abs(this.imag);
    }

    public static String toString(Complex complex) {
        char c = '+';
        if (complex.imag < 0.0) {
            c = '-';
        }
        return complex.real + " " + c + jori + Math.abs(complex.imag);
    }

    public static void setj() {
        jori = (char)106;
    }

    public static void seti() {
        jori = (char)105;
    }

    public static char getjori() {
        return jori;
    }

    public static Complex parseComplex(String string) {
        int n;
        Complex complex = new Complex();
        string = string.trim();
        double d = 1.0;
        if (string.charAt(0) == '-') {
            d = -1.0;
            string = string.substring(1);
        }
        if ((n = string.indexOf(106)) == -1) {
            n = string.indexOf(105);
        }
        if (n == -1) {
            throw new NumberFormatException("no i or j found");
        }
        int n2 = 1;
        int n3 = string.indexOf(43);
        if (n3 == -1 && (n3 = string.indexOf(45)) > -1) {
            n2 = -1;
        }
        if (n3 == -1) {
            throw new NumberFormatException("no + or - found");
        }
        int n4 = 0;
        int n5 = n3;
        int n6 = n + 1;
        int n7 = string.length();
        String string2 = string.substring(n4, n5);
        String string3 = string.substring(n6, n7);
        complex.real = d * Double.parseDouble(string2);
        complex.imag = (double)n2 * Double.parseDouble(string3);
        return complex;
    }

    public static Complex valueOf(String string) {
        return Complex.parseComplex(string);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.real);
        long l2 = Double.doubleToLongBits(this.imag);
        int n = (int)(l ^ l >>> 32);
        int n2 = (int)(l2 ^ l2 >>> 32);
        return 7 * (n / 10) + 3 * (n2 / 10);
    }

    public static void swap(Complex complex, Complex complex2) {
        double d = complex.real;
        double d2 = complex.imag;
        complex.reset(complex2.real, complex2.imag);
        complex2.reset(d, d2);
    }

    public static Complex[] oneDarray(int n) {
        Complex[] complexArray = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = Complex.zero();
        }
        return complexArray;
    }

    public static Complex[] oneDarray(int n, double d, double d2) {
        Complex[] complexArray = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = Complex.zero();
            complexArray[i].reset(d, d2);
        }
        return complexArray;
    }

    public static Complex mean(Complex[] complexArray) {
        int n = complexArray.length;
        Complex complex = new Complex(0.0, 0.0);
        for (int i = 0; i < n; ++i) {
            complex = complex.plus(complexArray[i]);
        }
        return complex.over(n);
    }

    public static Complex[] oneDarray(int n, Complex complex) {
        Complex[] complexArray = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = Complex.copy(complex);
        }
        return complexArray;
    }

    public static Complex[][] twoDarray(int n, int n2) {
        Complex[][] complexArray = new Complex[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                complexArray[i][j] = Complex.zero();
            }
        }
        return complexArray;
    }

    public static Complex[][] twoDarray(int n, int n2, double d, double d2) {
        Complex[][] complexArray = new Complex[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                complexArray[i][j] = Complex.zero();
                complexArray[i][j].reset(d, d2);
            }
        }
        return complexArray;
    }

    public static Complex[][] twoDarray(int n, int n2, Complex complex) {
        Complex[][] complexArray = new Complex[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                complexArray[i][j] = Complex.copy(complex);
            }
        }
        return complexArray;
    }

    public static Complex[][][] threeDarray(int n, int n2, int n3) {
        Complex[][][] complexArray = new Complex[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    complexArray[i][j][k] = Complex.zero();
                }
            }
        }
        return complexArray;
    }

    public static Complex[][][] threeDarray(int n, int n2, int n3, double d, double d2) {
        Complex[][][] complexArray = new Complex[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    complexArray[i][j][k] = Complex.zero();
                    complexArray[i][j][k].reset(d, d2);
                }
            }
        }
        return complexArray;
    }

    public static Complex[][][] threeDarray(int n, int n2, int n3, Complex complex) {
        Complex[][][] complexArray = new Complex[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    complexArray[i][j][k] = Complex.copy(complex);
                }
            }
        }
        return complexArray;
    }

    public static Complex copy(Complex complex) {
        if (complex == null) {
            return null;
        }
        Complex complex2 = new Complex();
        complex2.real = complex.real;
        complex2.imag = complex.imag;
        return complex2;
    }

    public Complex copy() {
        if (this == null) {
            return null;
        }
        Complex complex = new Complex();
        complex.real = this.real;
        complex.imag = this.imag;
        return complex;
    }

    public static Complex[] copy(Complex[] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        Complex[] complexArray2 = Complex.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            complexArray2[i] = Complex.copy(complexArray[i]);
        }
        return complexArray2;
    }

    public static Complex[][] copy(Complex[][] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        Complex[][] complexArray2 = Complex.twoDarray(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                complexArray2[i][j] = Complex.copy(complexArray[i][j]);
            }
        }
        return complexArray2;
    }

    public static Complex[][][] copy(Complex[][][] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        int n3 = complexArray[0][0].length;
        Complex[][][] complexArray2 = Complex.threeDarray(n, n2, n3);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    complexArray2[i][j][k] = Complex.copy(complexArray[i][j][k]);
                }
            }
        }
        return complexArray2;
    }

    public Object clone() {
        Complex complex = null;
        if (this != null) {
            Complex complex2 = new Complex();
            complex2.real = this.real;
            complex2.imag = this.imag;
            complex = complex2;
        }
        return complex;
    }

    public static Complex plus(Complex complex, Complex complex2) {
        Complex complex3 = new Complex();
        complex3.real = complex.real + complex2.real;
        complex3.imag = complex.imag + complex2.imag;
        return complex3;
    }

    public static Complex plus(Complex complex, double d) {
        Complex complex2 = new Complex();
        complex2.real = complex.real + d;
        complex2.imag = complex.imag;
        return complex2;
    }

    public static Complex plus(double d, Complex complex) {
        Complex complex2 = new Complex();
        complex2.real = d + complex.real;
        complex2.imag = complex.imag;
        return complex2;
    }

    public static Complex plus(double d, double d2) {
        Complex complex = new Complex();
        complex.real = d + d2;
        complex.imag = 0.0;
        return complex;
    }

    public Complex plus(Complex complex) {
        Complex complex2 = new Complex();
        complex2.real = this.real + complex.real;
        complex2.imag = this.imag + complex.imag;
        return complex2;
    }

    public Complex plus(double d) {
        Complex complex = new Complex();
        complex.real = this.real + d;
        complex.imag = this.imag;
        return complex;
    }

    public void plusEquals(Complex complex) {
        this.real += complex.real;
        this.imag += complex.imag;
    }

    public void plusEquals(double d) {
        this.real += d;
        this.imag = this.imag;
    }

    public static Complex minus(Complex complex, Complex complex2) {
        Complex complex3 = new Complex();
        complex3.real = complex.real - complex2.real;
        complex3.imag = complex.imag - complex2.imag;
        return complex3;
    }

    public static Complex minus(Complex complex, double d) {
        Complex complex2 = new Complex();
        complex2.real = complex.real - d;
        complex2.imag = complex.imag;
        return complex2;
    }

    public static Complex minus(double d, Complex complex) {
        Complex complex2 = new Complex();
        complex2.real = d - complex.real;
        complex2.imag = -complex.imag;
        return complex2;
    }

    public static Complex minus(double d, double d2) {
        Complex complex = new Complex();
        complex.real = d - d2;
        complex.imag = 0.0;
        return complex;
    }

    public Complex minus(Complex complex) {
        Complex complex2 = new Complex();
        complex2.real = this.real - complex.real;
        complex2.imag = this.imag - complex.imag;
        return complex2;
    }

    public Complex minus(double d) {
        Complex complex = new Complex();
        complex.real = this.real - d;
        complex.imag = this.imag;
        return complex;
    }

    public Complex transposedMinus(double d) {
        Complex complex = new Complex();
        complex.real = d - this.real;
        complex.imag = this.imag;
        return complex;
    }

    public void minusEquals(Complex complex) {
        this.real -= complex.real;
        this.imag -= complex.imag;
    }

    public void minusEquals(double d) {
        this.real -= d;
        this.imag = this.imag;
    }

    public static void setInfOption(boolean bl) {
        infOption = bl;
    }

    public static void setInfOption(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("opt must be 0 or 1");
        }
        infOption = true;
        if (n == 1) {
            infOption = false;
        }
    }

    public static boolean getInfOption() {
        return infOption;
    }

    public static Complex times(Complex complex, Complex complex2) {
        Complex complex3 = new Complex(0.0, 0.0);
        if (infOption) {
            if (complex.isInfinite() && !complex2.isZero()) {
                complex3.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return complex3;
            }
            if (complex2.isInfinite() && !complex.isZero()) {
                complex3.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return complex3;
            }
        }
        complex3.real = complex.real * complex2.real - complex.imag * complex2.imag;
        complex3.imag = complex.real * complex2.imag + complex.imag * complex2.real;
        return complex3;
    }

    public static Complex times(Complex complex, double d) {
        Complex complex2 = new Complex();
        if (infOption) {
            if (complex.isInfinite() && d != 0.0) {
                complex2.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return complex2;
            }
            if (Fmath.isInfinity(d) && !complex.isZero()) {
                complex2.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return complex2;
            }
        }
        complex2.real = complex.real * d;
        complex2.imag = complex.imag * d;
        return complex2;
    }

    public static Complex times(double d, Complex complex) {
        Complex complex2 = new Complex();
        if (infOption) {
            if (complex.isInfinite() && d != 0.0) {
                complex2.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return complex2;
            }
            if (Fmath.isInfinity(d) && !complex.isZero()) {
                complex2.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return complex2;
            }
        }
        complex2.real = d * complex.real;
        complex2.imag = d * complex.imag;
        return complex2;
    }

    public static Complex times(double d, double d2) {
        Complex complex = new Complex();
        complex.real = d * d2;
        complex.imag = 0.0;
        return complex;
    }

    public Complex times(Complex complex) {
        Complex complex2 = new Complex();
        if (infOption) {
            if (this.isInfinite() && !complex.isZero()) {
                complex2.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return complex2;
            }
            if (complex.isInfinite() && !this.isZero()) {
                complex2.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return complex2;
            }
        }
        complex2.real = this.real * complex.real - this.imag * complex.imag;
        complex2.imag = this.real * complex.imag + this.imag * complex.real;
        return complex2;
    }

    public Complex times(double d) {
        Complex complex = new Complex();
        if (infOption) {
            if (this.isInfinite() && d != 0.0) {
                complex.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return complex;
            }
            if (Fmath.isInfinity(d) && !this.isZero()) {
                complex.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return complex;
            }
        }
        complex.real = this.real * d;
        complex.imag = this.imag * d;
        return complex;
    }

    public void timesEquals(Complex complex) {
        Complex complex2 = new Complex();
        boolean bl = true;
        if (infOption && (this.isInfinite() && !complex.isZero() || complex.isInfinite() && !this.isZero())) {
            this.real = Double.POSITIVE_INFINITY;
            this.imag = Double.POSITIVE_INFINITY;
            bl = false;
        }
        if (bl) {
            complex2.real = complex.real * this.real - complex.imag * this.imag;
            complex2.imag = complex.real * this.imag + complex.imag * this.real;
            this.real = complex2.real;
            this.imag = complex2.imag;
        }
    }

    public void timesEquals(double d) {
        boolean bl = true;
        if (infOption && (this.isInfinite() && d != 0.0 || Fmath.isInfinity(d) && !this.isZero())) {
            this.real = Double.POSITIVE_INFINITY;
            this.imag = Double.POSITIVE_INFINITY;
            bl = false;
        }
        if (bl) {
            this.real *= d;
            this.imag *= d;
        }
    }

    public static Complex over(Complex complex, Complex complex2) {
        Complex complex3 = new Complex(0.0, 0.0);
        if (infOption && !complex.isInfinite() && complex2.isInfinite()) {
            return complex3;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (complex.isZero()) {
            if (complex2.isZero()) {
                complex3.real = Double.NaN;
                complex3.imag = Double.NaN;
            } else {
                complex3.real = 0.0;
                complex3.imag = 0.0;
            }
        } else if (Math.abs(complex2.real) >= Math.abs(complex2.imag)) {
            d2 = complex2.imag / complex2.real;
            d = complex2.real + complex2.imag * d2;
            complex3.real = (complex.real + complex.imag * d2) / d;
            complex3.imag = (complex.imag - complex.real * d2) / d;
        } else {
            d2 = complex2.real / complex2.imag;
            d = complex2.real * d2 + complex2.imag;
            complex3.real = (complex.real * d2 + complex.imag) / d;
            complex3.imag = (complex.imag * d2 - complex.real) / d;
        }
        return complex3;
    }

    public static Complex over(Complex complex, double d) {
        Complex complex2 = new Complex(0.0, 0.0);
        if (infOption && Fmath.isInfinity(d)) {
            return complex2;
        }
        complex2.real = complex.real / d;
        complex2.imag = complex.imag / d;
        return complex2;
    }

    public static Complex over(double d, Complex complex) {
        Complex complex2 = new Complex();
        if (infOption && !Fmath.isInfinity(d) && complex.isInfinite()) {
            return complex2;
        }
        if (d == 0.0) {
            if (complex.isZero()) {
                complex2.real = Double.NaN;
                complex2.imag = Double.NaN;
            } else {
                complex2.real = 0.0;
                complex2.imag = 0.0;
            }
        } else if (Math.abs(complex.real) >= Math.abs(complex.imag)) {
            double d2 = complex.imag / complex.real;
            double d3 = complex.real + complex.imag * d2;
            complex2.real = d / d3;
            complex2.imag = -d * d2 / d3;
        } else {
            double d4 = complex.real / complex.imag;
            double d5 = complex.real * d4 + complex.imag;
            complex2.real = d * d4 / d5;
            complex2.imag = -d / d5;
        }
        return complex2;
    }

    public static Complex over(double d, double d2) {
        Complex complex = new Complex();
        complex.real = d / d2;
        complex.imag = 0.0;
        return complex;
    }

    public Complex over(Complex complex) {
        Complex complex2 = new Complex(0.0, 0.0);
        if (infOption && !this.isInfinite() && complex.isInfinite()) {
            return complex2;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (Math.abs(complex.real) >= Math.abs(complex.imag)) {
            d2 = complex.imag / complex.real;
            d = complex.real + complex.imag * d2;
            complex2.real = (this.real + this.imag * d2) / d;
            complex2.imag = (this.imag - this.real * d2) / d;
        } else {
            d2 = complex.real / complex.imag;
            d = complex.real * d2 + complex.imag;
            complex2.real = (this.real * d2 + this.imag) / d;
            complex2.imag = (this.imag * d2 - this.real) / d;
        }
        return complex2;
    }

    public Complex over(double d) {
        Complex complex = new Complex(0.0, 0.0);
        complex.real = this.real / d;
        complex.imag = this.imag / d;
        return complex;
    }

    public Complex transposedOver(double d) {
        Complex complex = new Complex(0.0, 0.0);
        if (infOption && !Fmath.isInfinity(d) && this.isInfinite()) {
            return complex;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        if (Math.abs(this.real) >= Math.abs(this.imag)) {
            d3 = this.imag / this.real;
            d2 = this.real + this.imag * d3;
            complex.real = d / d2;
            complex.imag = -d * d3 / d2;
        } else {
            d3 = this.real / this.imag;
            d2 = this.real * d3 + this.imag;
            complex.real = d * d3 / d2;
            complex.imag = -d / d2;
        }
        return complex;
    }

    public void overEquals(Complex complex) {
        Complex complex2 = new Complex(0.0, 0.0);
        boolean bl = true;
        if (infOption && !this.isInfinite() && complex.isInfinite()) {
            this.real = 0.0;
            this.imag = 0.0;
            bl = false;
        }
        if (bl) {
            double d = 0.0;
            double d2 = 0.0;
            if (Math.abs(complex.real) >= Math.abs(complex.imag)) {
                d2 = complex.imag / complex.real;
                d = complex.real + complex.imag * d2;
                complex2.real = (this.real + this.imag * d2) / d;
                complex2.imag = (this.imag - this.real * d2) / d;
            } else {
                d2 = complex.real / complex.imag;
                d = complex.real * d2 + complex.imag;
                complex2.real = (this.real * d2 + this.imag) / d;
                complex2.imag = (this.imag * d2 - this.real) / d;
            }
            this.real = complex2.real;
            this.imag = complex2.imag;
        }
    }

    public void overEquals(double d) {
        this.real /= d;
        this.imag /= d;
    }

    public static Complex inverse(Complex complex) {
        Complex complex2 = new Complex(0.0, 0.0);
        if (infOption && complex.isInfinite()) {
            return complex2;
        }
        complex2 = Complex.over(1.0, complex);
        return complex2;
    }

    public Complex inverse() {
        Complex complex = new Complex(0.0, 0.0);
        complex = Complex.over(1.0, this);
        return complex;
    }

    public static Complex negate(Complex complex) {
        Complex complex2 = new Complex();
        complex2.real = -complex.real;
        complex2.imag = -complex.imag;
        return complex2;
    }

    public Complex negate() {
        Complex complex = new Complex();
        complex.real = -this.real;
        complex.imag = -this.imag;
        return complex;
    }

    public static double abs(Complex complex) {
        double d = Math.abs(complex.real);
        double d2 = Math.abs(complex.imag);
        double d3 = 0.0;
        double d4 = 0.0;
        if (d == 0.0) {
            d4 = d2;
        } else {
            if (d2 == 0.0) {
                d4 = d;
            }
            if (d >= d2) {
                d3 = complex.imag / complex.real;
                d4 = d * Math.sqrt(1.0 + d3 * d3);
            } else {
                d3 = complex.real / complex.imag;
                d4 = d2 * Math.sqrt(1.0 + d3 * d3);
            }
        }
        return d4;
    }

    public double abs() {
        double d = Math.abs(this.real);
        double d2 = Math.abs(this.imag);
        double d3 = 0.0;
        double d4 = 0.0;
        if (d == 0.0) {
            d4 = d2;
        } else {
            if (d2 == 0.0) {
                d4 = d;
            }
            if (d >= d2) {
                d3 = this.imag / this.real;
                d4 = d * Math.sqrt(1.0 + d3 * d3);
            } else {
                d3 = this.real / this.imag;
                d4 = d2 * Math.sqrt(1.0 + d3 * d3);
            }
        }
        return d4;
    }

    public static double squareAbs(Complex complex) {
        return complex.real * complex.real + complex.imag * complex.imag;
    }

    public double squareAbs() {
        return this.real * this.real + this.imag * this.imag;
    }

    public static double arg(Complex complex) {
        return Math.atan2(complex.imag, complex.real);
    }

    public double arg() {
        return Math.atan2(this.imag, this.real);
    }

    public static double argRad(Complex complex) {
        return Math.atan2(complex.imag, complex.real);
    }

    public double argRad() {
        return Math.atan2(this.imag, this.real);
    }

    public static double argDeg(Complex complex) {
        return Math.toDegrees(Math.atan2(complex.imag, complex.real));
    }

    public double argDeg() {
        return Math.toDegrees(Math.atan2(this.imag, this.real));
    }

    public static Complex conjugate(Complex complex) {
        Complex complex2 = new Complex();
        complex2.real = complex.real;
        complex2.imag = -complex.imag;
        return complex2;
    }

    public Complex conjugate() {
        Complex complex = new Complex();
        complex.real = this.real;
        complex.imag = -this.imag;
        return complex;
    }

    public static double hypot(Complex complex, Complex complex2) {
        double d = Complex.abs(complex);
        double d2 = Complex.abs(complex2);
        double d3 = 0.0;
        double d4 = 0.0;
        if (d == 0.0) {
            d3 = d2;
        } else if (d2 == 0.0) {
            d3 = d;
        } else if (d >= d2) {
            d4 = d2 / d;
            d3 = d * Math.sqrt(1.0 + d4 * d4);
        } else {
            d4 = d / d2;
            d3 = d2 * Math.sqrt(1.0 + d4 * d4);
        }
        return d3;
    }

    public Complex exp() {
        return Complex.exp(this);
    }

    public static Complex exp(Complex complex) {
        Complex complex2 = new Complex();
        double d = complex.real;
        double d2 = complex.imag;
        if (d2 == 0.0) {
            complex2.real = Math.exp(d);
            complex2.imag = 0.0;
        } else if (d == 0.0) {
            complex2.real = Math.cos(d2);
            complex2.imag = Math.sin(d2);
        } else {
            double d3 = Math.exp(d);
            complex2.real = d3 * Math.cos(d2);
            complex2.imag = d3 * Math.sin(d2);
        }
        return complex2;
    }

    public static Complex exp(double d) {
        Complex complex = new Complex(d, 0.0);
        return Complex.exp(complex);
    }

    public static Complex expPlusJayArg(double d) {
        Complex complex = new Complex(0.0, d);
        return Complex.exp(complex);
    }

    public static Complex expMinusJayArg(double d) {
        Complex complex = new Complex(0.0, -d);
        return Complex.exp(complex);
    }

    public Complex log() {
        double d = this.real;
        double d2 = this.imag;
        Complex complex = new Complex();
        complex.real = Math.log(Complex.abs(this));
        complex.imag = Math.atan2(d2, d);
        return complex;
    }

    public static Complex log(Complex complex) {
        double d = complex.real;
        double d2 = complex.imag;
        Complex complex2 = new Complex();
        complex2.real = Math.log(Complex.abs(complex));
        complex2.imag = Math.atan2(d2, d);
        return complex2;
    }

    public Complex sqrt() {
        return Complex.sqrt(this);
    }

    public static Complex sqrt(Complex complex) {
        double d = complex.real;
        double d2 = complex.imag;
        Complex complex2 = new Complex();
        if (d2 == 0.0) {
            if (d >= 0.0) {
                complex2.real = Math.sqrt(d);
                complex2.imag = 0.0;
            } else {
                complex2.real = 0.0;
                complex2.imag = Math.sqrt(-d);
            }
        } else {
            double d3;
            double d4;
            double d5 = Math.abs(d);
            if (d5 >= (d4 = Math.abs(d2))) {
                double d6 = d2 / d;
                d3 = Math.sqrt(d5) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + d6 * d6)));
            } else {
                double d7 = d / d2;
                d3 = Math.sqrt(d4) * Math.sqrt(0.5 * (Math.abs(d7) + Math.sqrt(1.0 + d7 * d7)));
            }
            if (d >= 0.0) {
                complex2.real = d3;
                complex2.imag = d2 / (2.0 * d3);
            } else if (d2 >= 0.0) {
                complex2.imag = d3;
                complex2.real = d2 / (2.0 * complex2.imag);
            } else {
                complex2.imag = -d3;
                complex2.real = d2 / (2.0 * complex2.imag);
            }
        }
        return complex2;
    }

    public Complex nthRoot(int n) {
        return Complex.nthRoot(this, n);
    }

    public static Complex nthRoot(Complex complex, int n) {
        Complex complex2 = new Complex();
        complex2 = n == 0 ? new Complex(Double.POSITIVE_INFINITY, 0.0) : (n == 1 ? complex : Complex.exp(Complex.log(complex).over(n)));
        return complex2;
    }

    public static Complex square(Complex complex) {
        Complex complex2 = new Complex();
        complex2.real = complex.real * complex.real - complex.imag * complex.imag;
        complex2.imag = 2.0 * complex.real * complex.imag;
        return complex2;
    }

    public Complex square() {
        return this.times(this);
    }

    public Complex pow(Complex complex) {
        Complex complex2 = new Complex();
        if (this.isZero()) {
            if (complex.imag == 0.0) {
                if (complex.real == 0.0) {
                    complex2 = new Complex(1.0, 0.0);
                } else if (complex.real > 0.0) {
                    complex2 = new Complex(0.0, 0.0);
                } else if (complex.real < 0.0) {
                    complex2 = new Complex(Double.POSITIVE_INFINITY, 0.0);
                }
            } else {
                complex2 = Complex.exp(complex.times(Complex.log(this)));
            }
        } else {
            complex2 = Complex.exp(complex.times(Complex.log(this)));
        }
        return complex2;
    }

    public static Complex pow(Complex complex, Complex complex2) {
        Complex complex3 = new Complex();
        if (complex.isZero()) {
            if (complex2.imag == 0.0) {
                if (complex2.real == 0.0) {
                    complex3 = new Complex(1.0, 0.0);
                } else if (complex.real > 0.0) {
                    complex3 = new Complex(0.0, 0.0);
                } else if (complex.real < 0.0) {
                    complex3 = new Complex(Double.POSITIVE_INFINITY, 0.0);
                }
            } else {
                complex3 = Complex.exp(complex2.times(Complex.log(complex)));
            }
        } else {
            complex3 = Complex.exp(complex2.times(Complex.log(complex)));
        }
        return complex3;
    }

    public Complex pow(double d) {
        return Complex.powDouble(this, d);
    }

    public static Complex pow(Complex complex, double d) {
        return Complex.powDouble(complex, d);
    }

    public Complex pow(int n) {
        double d = n;
        return Complex.powDouble(this, d);
    }

    public static Complex pow(Complex complex, int n) {
        double d = n;
        return Complex.powDouble(complex, d);
    }

    public static Complex pow(double d, Complex complex) {
        Complex complex2 = new Complex();
        if (d == 0.0) {
            if (complex.imag == 0.0) {
                if (complex.real == 0.0) {
                    complex2 = new Complex(1.0, 0.0);
                } else if (complex.real > 0.0) {
                    complex2 = new Complex(0.0, 0.0);
                } else if (complex.real < 0.0) {
                    complex2 = new Complex(Double.POSITIVE_INFINITY, 0.0);
                }
            } else {
                double d2 = Math.pow(d, complex.real);
                complex2 = Complex.exp(Complex.times(Complex.plusJay(), complex.imag * Math.log(d)));
                complex2 = Complex.times(d2, complex2);
            }
        } else {
            double d3 = Math.pow(d, complex.real);
            complex2 = Complex.exp(Complex.times(Complex.plusJay(), complex.imag * Math.log(d)));
            complex2 = Complex.times(d3, complex2);
        }
        return complex2;
    }

    public Complex sin() {
        return Complex.sin(this);
    }

    public static Complex sin(Complex complex) {
        Complex complex2 = new Complex();
        double d = complex.real;
        double d2 = complex.imag;
        complex2.real = Math.sin(d) * Fmath.cosh(d2);
        complex2.imag = Math.cos(d) * Fmath.sinh(d2);
        return complex2;
    }

    public Complex cos() {
        return Complex.cos(this);
    }

    public static Complex cos(Complex complex) {
        Complex complex2 = new Complex();
        double d = complex.real;
        double d2 = complex.imag;
        complex2.real = Math.cos(d) * Fmath.cosh(d2);
        complex2.imag = -Math.sin(d) * Fmath.sinh(d2);
        return complex2;
    }

    public Complex sec() {
        return Complex.sec(this);
    }

    public static Complex sec(Complex complex) {
        Complex complex2 = new Complex();
        double d = complex.real;
        double d2 = complex.imag;
        complex2.real = Math.cos(d) * Fmath.cosh(d2);
        complex2.imag = -Math.sin(d) * Fmath.sinh(d2);
        return complex2.inverse();
    }

    public Complex csc() {
        return Complex.csc(this);
    }

    public static Complex csc(Complex complex) {
        Complex complex2 = new Complex();
        double d = complex.real;
        double d2 = complex.imag;
        complex2.real = Math.sin(d) * Fmath.cosh(d2);
        complex2.imag = Math.cos(d) * Fmath.sinh(d2);
        return complex2.inverse();
    }

    public Complex tan() {
        return Complex.tan(this);
    }

    public static Complex tan(Complex complex) {
        Complex complex2 = new Complex();
        double d = 0.0;
        double d2 = complex.real;
        double d3 = complex.imag;
        Complex complex3 = new Complex(Math.sin(d2) * Fmath.cosh(d3), Math.cos(d2) * Fmath.sinh(d3));
        Complex complex4 = new Complex(Math.cos(d2) * Fmath.cosh(d3), -Math.sin(d2) * Fmath.sinh(d3));
        complex2 = Complex.over(complex3, complex4);
        return complex2;
    }

    public Complex cot() {
        return Complex.cot(this);
    }

    public static Complex cot(Complex complex) {
        Complex complex2 = new Complex();
        double d = 0.0;
        double d2 = complex.real;
        double d3 = complex.imag;
        Complex complex3 = new Complex(Math.sin(d2) * Fmath.cosh(d3), Math.cos(d2) * Fmath.sinh(d3));
        Complex complex4 = new Complex(Math.cos(d2) * Fmath.cosh(d3), -Math.sin(d2) * Fmath.sinh(d3));
        complex2 = Complex.over(complex4, complex3);
        return complex2;
    }

    public Complex exsec() {
        return Complex.exsec(this);
    }

    public static Complex exsec(Complex complex) {
        return Complex.sec(complex).minus(1.0);
    }

    public Complex vers() {
        return Complex.vers(this);
    }

    public static Complex vers(Complex complex) {
        return Complex.plusOne().minus(Complex.cos(complex));
    }

    public Complex covers() {
        return Complex.covers(this);
    }

    public static Complex covers(Complex complex) {
        return Complex.plusOne().minus(Complex.sin(complex));
    }

    public Complex hav() {
        return Complex.hav(this);
    }

    public static Complex hav(Complex complex) {
        return Complex.vers(complex).over(2.0);
    }

    public Complex sinh() {
        return Complex.sinh(this);
    }

    public static Complex sinh(Complex complex) {
        Complex complex2 = new Complex();
        complex2 = complex.times(Complex.plusJay());
        complex2 = Complex.minusJay().times(Complex.sin(complex2));
        return complex2;
    }

    public Complex cosh() {
        return Complex.cosh(this);
    }

    public static Complex cosh(Complex complex) {
        Complex complex2 = new Complex();
        complex2 = complex.times(Complex.plusJay());
        complex2 = Complex.cos(complex2);
        return complex2;
    }

    public Complex tanh() {
        return Complex.tanh(this);
    }

    public static Complex tanh(Complex complex) {
        Complex complex2 = new Complex();
        complex2 = Complex.sinh(complex).over(Complex.cosh(complex));
        return complex2;
    }

    public Complex coth() {
        return Complex.coth(this);
    }

    public static Complex coth(Complex complex) {
        Complex complex2 = new Complex();
        complex2 = Complex.cosh(complex).over(Complex.sinh(complex));
        return complex2;
    }

    public Complex sech() {
        return Complex.sech(this);
    }

    public static Complex sech(Complex complex) {
        Complex complex2 = new Complex();
        complex2 = Complex.cosh(complex).inverse();
        return complex2;
    }

    public Complex csch() {
        return Complex.csch(this);
    }

    public static Complex csch(Complex complex) {
        Complex complex2 = new Complex();
        complex2 = Complex.sinh(complex).inverse();
        return complex2;
    }

    public Complex asin() {
        return Complex.asin(this);
    }

    public static Complex asin(Complex complex) {
        Complex complex2 = new Complex();
        complex2 = Complex.sqrt(Complex.minus(1.0, Complex.square(complex)));
        complex2 = Complex.plusJay().times(complex).plus(complex2);
        complex2 = Complex.minusJay().times(Complex.log(complex2));
        return complex2;
    }

    public Complex acos() {
        return Complex.acos(this);
    }

    public static Complex acos(Complex complex) {
        Complex complex2 = new Complex();
        complex2 = Complex.sqrt(Complex.minus(Complex.square(complex), 1.0));
        complex2 = complex.plus(complex2);
        complex2 = Complex.minusJay().times(Complex.log(complex2));
        return complex2;
    }

    public Complex atan() {
        return Complex.atan(this);
    }

    public static Complex atan(Complex complex) {
        Complex complex2 = new Complex();
        Complex complex3 = new Complex();
        complex2 = Complex.plusJay().plus(complex);
        complex3 = Complex.plusJay().minus(complex);
        complex2 = complex2.over(complex3);
        complex2 = Complex.log(complex2);
        complex2 = Complex.plusJay().times(complex2);
        complex2 = complex2.over(2.0);
        return complex2;
    }

    public Complex acot() {
        return Complex.acot(this);
    }

    public static Complex acot(Complex complex) {
        return Complex.atan(complex.inverse());
    }

    public Complex asec() {
        return Complex.asec(this);
    }

    public static Complex asec(Complex complex) {
        return Complex.acos(complex.inverse());
    }

    public Complex acsc() {
        return Complex.acsc(this);
    }

    public static Complex acsc(Complex complex) {
        return Complex.asin(complex.inverse());
    }

    public Complex aexsec() {
        return Complex.aexsec(this);
    }

    public static Complex aexsec(Complex complex) {
        Complex complex2 = complex.plus(1.0);
        return Complex.asin(complex2.inverse());
    }

    public Complex avers() {
        return Complex.avers(this);
    }

    public static Complex avers(Complex complex) {
        Complex complex2 = Complex.plusOne().plus(complex);
        return Complex.acos(complex2);
    }

    public Complex acovers() {
        return Complex.acovers(this);
    }

    public static Complex acovers(Complex complex) {
        Complex complex2 = Complex.plusOne().plus(complex);
        return Complex.asin(complex2);
    }

    public Complex ahav() {
        return Complex.ahav(this);
    }

    public static Complex ahav(Complex complex) {
        Complex complex2 = Complex.plusOne().minus(complex.times(2.0));
        return Complex.acos(complex2);
    }

    public Complex asinh() {
        return Complex.asinh(this);
    }

    public static Complex asinh(Complex complex) {
        Complex complex2 = new Complex(0.0, 0.0);
        complex2 = Complex.sqrt(Complex.square(complex).plus(1.0));
        complex2 = complex.plus(complex2);
        complex2 = Complex.log(complex2);
        return complex2;
    }

    public Complex acosh() {
        return Complex.acosh(this);
    }

    public static Complex acosh(Complex complex) {
        Complex complex2 = new Complex();
        complex2 = Complex.sqrt(Complex.square(complex).minus(1.0));
        complex2 = complex.plus(complex2);
        complex2 = Complex.log(complex2);
        return complex2;
    }

    public Complex atanh() {
        return Complex.atanh(this);
    }

    public static Complex atanh(Complex complex) {
        Complex complex2 = new Complex();
        Complex complex3 = new Complex();
        complex2 = Complex.plusOne().plus(complex);
        complex3 = Complex.plusOne().minus(complex);
        complex2 = complex2.over(complex3);
        complex2 = Complex.log(complex2);
        complex2 = complex2.over(2.0);
        return complex2;
    }

    public Complex acoth() {
        return Complex.acoth(this);
    }

    public static Complex acoth(Complex complex) {
        Complex complex2 = new Complex();
        Complex complex3 = new Complex();
        complex2 = Complex.plusOne().plus(complex);
        complex3 = complex.plus(1.0);
        complex2 = complex2.over(complex3);
        complex2 = Complex.log(complex2);
        complex2 = complex2.over(2.0);
        return complex2;
    }

    public Complex asech() {
        return Complex.asech(this);
    }

    public static Complex asech(Complex complex) {
        Complex complex2 = complex.inverse();
        Complex complex3 = Complex.square(complex).minus(1.0);
        return Complex.log(complex2.plus(Complex.sqrt(complex3)));
    }

    public Complex acsch() {
        return Complex.acsch(this);
    }

    public static Complex acsch(Complex complex) {
        Complex complex2 = complex.inverse();
        Complex complex3 = Complex.square(complex).plus(1.0);
        return Complex.log(complex2.plus(Complex.sqrt(complex3)));
    }

    public static boolean isReal(Complex complex) {
        boolean bl = false;
        if (Math.abs(complex.imag) == 0.0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isReal(Complex[] complexArray) {
        boolean bl = true;
        int n = complexArray.length;
        for (int i = 0; i < n; ++i) {
            if (Math.abs(complexArray[i].imag) == 0.0) continue;
            bl = false;
        }
        return bl;
    }

    public boolean isReal() {
        boolean bl = false;
        if (Math.abs(this.imag) == 0.0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isReal(Complex complex, double d) {
        boolean bl = false;
        if (Math.abs(complex.imag) <= Math.abs(d)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isReal(Complex[] complexArray, double d) {
        boolean bl = true;
        int n = complexArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(complexArray[i].imag) > Math.abs(d))) continue;
            bl = false;
        }
        return bl;
    }

    public boolean isReal(double d) {
        boolean bl = false;
        if (Math.abs(this.imag) <= Math.abs(d)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isRealPerCent(Complex complex, double d) {
        boolean bl = false;
        if (Math.abs(complex.imag * 100.0 / complex.real) <= Math.abs(d)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isRealPerCent(Complex[] complexArray, double d) {
        boolean bl = true;
        int n = complexArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(complexArray[i].imag * 100.0 / complexArray[i].real) > Math.abs(d))) continue;
            bl = false;
        }
        return bl;
    }

    public boolean isRealperCent(double d) {
        boolean bl = false;
        if (Math.abs(this.imag * 100.0 / this.real) <= Math.abs(d)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isZero(Complex complex) {
        boolean bl = false;
        if (Math.abs(complex.real) == 0.0 && Math.abs(complex.imag) == 0.0) {
            bl = true;
        }
        return bl;
    }

    public boolean isZero() {
        boolean bl = false;
        if (Math.abs(this.real) == 0.0 && Math.abs(this.imag) == 0.0) {
            bl = true;
        }
        return bl;
    }

    public boolean isPlusInfinity() {
        boolean bl = false;
        if (this.real == Double.POSITIVE_INFINITY || this.imag == Double.POSITIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPlusInfinity(Complex complex) {
        boolean bl = false;
        if (complex.real == Double.POSITIVE_INFINITY || complex.imag == Double.POSITIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public boolean isMinusInfinity() {
        boolean bl = false;
        if (this.real == Double.NEGATIVE_INFINITY || this.imag == Double.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public static boolean isMinusInfinity(Complex complex) {
        boolean bl = false;
        if (complex.real == Double.NEGATIVE_INFINITY || complex.imag == Double.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public static boolean isInfinite(Complex complex) {
        boolean bl = false;
        if (complex.real == Double.POSITIVE_INFINITY || complex.imag == Double.POSITIVE_INFINITY) {
            bl = true;
        }
        if (complex.real == Double.NEGATIVE_INFINITY || complex.imag == Double.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public boolean isInfinite() {
        boolean bl = false;
        if (this.real == Double.POSITIVE_INFINITY || this.imag == Double.POSITIVE_INFINITY) {
            bl = true;
        }
        if (this.real == Double.NEGATIVE_INFINITY || this.imag == Double.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public static boolean isNaN(Complex complex) {
        boolean bl = false;
        if (complex.real != complex.real || complex.imag != complex.imag) {
            bl = true;
        }
        return bl;
    }

    public boolean isNaN() {
        boolean bl = false;
        if (this.real != this.real || this.imag != this.imag) {
            bl = true;
        }
        return bl;
    }

    public boolean equals(Complex complex) {
        boolean bl = false;
        if (this.isNaN() && complex.isNaN()) {
            bl = true;
        } else if (this.real == complex.real && this.imag == complex.imag) {
            bl = true;
        }
        return bl;
    }

    public boolean isEqual(Complex complex) {
        boolean bl = false;
        if (this.isNaN() && complex.isNaN()) {
            bl = true;
        } else if (this.real == complex.real && this.imag == complex.imag) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqual(Complex complex, Complex complex2) {
        boolean bl = false;
        if (Complex.isNaN(complex) && Complex.isNaN(complex2)) {
            bl = true;
        } else if (complex.real == complex2.real && complex.imag == complex2.imag) {
            bl = true;
        }
        return bl;
    }

    public boolean equalsWithinLimits(Complex complex, double d) {
        return this.isEqualWithinLimits(complex, d);
    }

    public boolean isEqualWithinLimits(Complex complex, double d) {
        boolean bl = false;
        double d2 = this.getReal();
        double d3 = complex.getReal();
        double d4 = this.getImag();
        double d5 = complex.getImag();
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        if (d2 == 0.0 && d4 == 0.0 && d3 == 0.0 && d5 == 0.0) {
            bl = true;
        }
        if (!bl) {
            d6 = Math.abs(d2);
            if (Math.abs(d3) > d6) {
                d6 = Math.abs(d3);
            }
            d8 = d6 == 0.0 ? 0.0 : Math.abs(d3 - d2) / d6;
            d7 = Math.abs(d4);
            if (Math.abs(d5) > d7) {
                d7 = Math.abs(d5);
            }
            d9 = d7 == 0.0 ? 0.0 : Math.abs(d5 - d4) / d7;
            if (d8 < d && d9 < d) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isEqualWithinLimits(Complex complex, Complex complex2, double d) {
        boolean bl = false;
        double d2 = complex2.getReal();
        double d3 = complex.getReal();
        double d4 = complex2.getImag();
        double d5 = complex.getImag();
        double d6 = 0.0;
        double d7 = 0.0;
        if (d3 == 0.0 && d5 == 0.0 && d2 == 0.0 && d4 == 0.0) {
            bl = true;
        }
        if (!bl) {
            d6 = Math.abs(d2);
            if (Math.abs(d3) > d6) {
                d6 = Math.abs(d3);
            }
            d7 = Math.abs(d4);
            if (Math.abs(d5) > d7) {
                d7 = Math.abs(d5);
            }
            if (Math.abs(d3 - d2) / d6 < d && Math.abs(d5 - d5) / d7 < d) {
                bl = true;
            }
        }
        return bl;
    }

    public static Complex zero() {
        Complex complex = new Complex();
        complex.real = 0.0;
        complex.imag = 0.0;
        return complex;
    }

    public static Complex plusOne() {
        Complex complex = new Complex();
        complex.real = 1.0;
        complex.imag = 0.0;
        return complex;
    }

    public static Complex minusOne() {
        Complex complex = new Complex();
        complex.real = -1.0;
        complex.imag = 0.0;
        return complex;
    }

    public static Complex plusJay() {
        Complex complex = new Complex();
        complex.real = 0.0;
        complex.imag = 1.0;
        return complex;
    }

    public static Complex minusJay() {
        Complex complex = new Complex();
        complex.real = 0.0;
        complex.imag = -1.0;
        return complex;
    }

    public static Complex pi() {
        Complex complex = new Complex();
        complex.real = Math.PI;
        complex.imag = 0.0;
        return complex;
    }

    public static Complex twoPiJay() {
        Complex complex = new Complex();
        complex.real = 0.0;
        complex.imag = Math.PI * 2;
        return complex;
    }

    public static Complex plusInfinity() {
        Complex complex = new Complex();
        complex.real = Double.POSITIVE_INFINITY;
        complex.imag = Double.POSITIVE_INFINITY;
        return complex;
    }

    public static Complex minusInfinity() {
        Complex complex = new Complex();
        complex.real = Double.NEGATIVE_INFINITY;
        complex.imag = Double.NEGATIVE_INFINITY;
        return complex;
    }

    private static Complex powDouble(Complex complex, double d) {
        Complex complex2 = new Complex();
        double d2 = complex.real;
        double d3 = complex.imag;
        if (complex.isZero()) {
            if (d == 0.0) {
                complex2 = new Complex(1.0, 0.0);
            } else if (d > 0.0) {
                complex2 = new Complex(0.0, 0.0);
            } else if (d < 0.0) {
                complex2 = new Complex(Double.POSITIVE_INFINITY, 0.0);
            }
        } else if (d3 == 0.0 && d2 > 0.0) {
            complex2.real = Math.pow(d2, d);
            complex2.imag = 0.0;
        } else if (d2 == 0.0) {
            complex2 = Complex.exp(Complex.times(d, Complex.log(complex)));
        } else {
            double d4 = Math.pow(d2 * d2 + d3 * d3, d / 2.0);
            double d5 = Math.atan2(d3, d2);
            complex2.real = d4 * Math.cos(d * d5);
            complex2.imag = d4 * Math.sin(d * d5);
        }
        return complex2;
    }
}

