/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.TransmissionLine;
import flanagan.complex.Complex;
import flanagan.math.Fmath;

public class SurfaceStripLine
extends TransmissionLine {
    private double trackWidth = -1.0;
    private double effectiveTrackWidth = -1.0;
    private double trackThickness = -1.0;
    private double plateSeparation = -1.0;
    private boolean widthSet = false;
    private boolean separationSet = false;
    private boolean thicknessSet = false;
    private double relativePermittivity = 1.0;
    private double effectivePermittivity = 1.0;
    private boolean permittivitySet = false;
    private double relativePermeability = 1.0;
    private int formulaOption = 0;
    private boolean z0calculated = false;

    public SurfaceStripLine() {
        this.title = "Surface Strip Line";
    }

    public SurfaceStripLine(String string) {
        this.title = string;
    }

    public void setFormulae(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("The option value, " + n + ", must be 1,2 or 3");
        }
        this.formulaOption = n - 1;
        if (this.permittivitySet && this.separationSet && this.widthSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    public void useEdwardsHoffmannFormulae() {
        this.formulaOption = 0;
        if (this.permittivitySet && this.separationSet && this.widthSet) {
            this.calcIdealCharacteristicImpedance();
        }
    }

    public void useWadellWheelerSchneiderFormulae() {
        this.formulaOption = 1;
        if (this.permittivitySet && this.separationSet && this.widthSet && this.thicknessSet) {
            this.calcIdealCharacteristicImpedance();
        }
    }

    public void useIPCD317AFormulae() {
        this.formulaOption = 2;
        if (this.permittivitySet && this.separationSet && this.widthSet && this.thicknessSet) {
            this.calcIdealCharacteristicImpedance();
        }
    }

    public void setSurfaceTrackWidth(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The plate width, " + d + ", must be greater than zero");
        }
        this.trackWidth = d;
        this.effectiveTrackWidth = d;
        this.widthSet = true;
        if (this.permittivitySet && this.separationSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    public double getEffectiveTrackWidth() {
        if (!this.z0calculated) {
            this.calcIdealCharacteristicImpedance();
        }
        if (this.formulaOption == 2) {
            this.effectiveTrackWidth = this.trackWidth;
            System.out.println("Method: getEffectiveTrackWidth()");
            System.out.println("The effective track width is not calculated explicitely for the IPC-D-317A formula.");
            System.out.println("The unadjusted track width has been returned.");
        }
        return this.effectiveTrackWidth;
    }

    public void setSurfaceTrackThickness(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The plate thickness, " + d + ", must be greater than zero");
        }
        this.trackThickness = d;
        this.thicknessSet = true;
        if (this.permittivitySet && this.separationSet && this.widthSet) {
            this.calcIdealCharacteristicImpedance();
        }
    }

    public void setPlateSeparation(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The plate separation, " + d + ", must be greater than zero");
        }
        this.plateSeparation = d;
        this.separationSet = true;
        if (this.permittivitySet && this.widthSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    public void setRelativePermittivity(double d) {
        this.relativePermittivity = d;
        this.permittivitySet = true;
        if (this.widthSet && this.separationSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    public double getEffectiveRelativePermittivity() {
        if (!this.permittivitySet) {
            throw new IllegalArgumentException("The relative permittivity has not been entered");
        }
        if (!this.z0calculated) {
            this.calcIdealCharacteristicImpedance();
        }
        if (this.formulaOption == 2) {
            this.effectivePermittivity = this.relativePermittivity;
            System.out.println("Method: getEffectiveRelativePermittivity()");
            System.out.println("The effective permittivity is not calculated explicitely for the IPC-D-317A formula.");
            System.out.println("The unadjusted relative permittivity has been returned.");
        }
        return this.effectivePermittivity;
    }

    public void setRelativePermeability(double d) {
        this.relativePermeability = d;
        if (this.permittivitySet && this.widthSet && this.separationSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    @Override
    public void setFrequency(double d) {
        this.frequency = d;
        this.omega = this.frequency * 2.0 * Math.PI;
        if (this.permittivitySet && this.widthSet && this.separationSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    private Complex calcIdealCharacteristicImpedance() {
        if (!this.separationSet) {
            throw new IllegalArgumentException("The strip line plate separation has not been entered");
        }
        if (!this.widthSet) {
            throw new IllegalArgumentException("The strip line track width has not been entered");
        }
        if (!this.permittivitySet) {
            throw new IllegalArgumentException("The relative permittivity has not been entered");
        }
        double d = this.trackWidth / this.plateSeparation;
        double d2 = 1.0 / d;
        double d3 = this.trackThickness / this.plateSeparation;
        double d4 = this.relativePermittivity + 1.0;
        double d5 = this.relativePermittivity - 1.0;
        double d6 = this.plateSeparation * this.frequency * 1.0E-6;
        switch (this.formulaOption) {
            case 2: {
                if (!this.thicknessSet) {
                    throw new IllegalArgumentException("The strip line track thickness has not been entered");
                }
                if (d < 0.1 || d > 3.0) {
                    System.out.println("WARNING!");
                    System.out.println("IPC-D-317A FORMULA RESTRICTION");
                    System.out.println("For this model the width over separation ratio, " + d + ", must lie between 0.1 and 3.0 inclusive");
                    System.out.println("The results are likely to be inaccurate");
                }
                if (d3 > 0.25) {
                    System.out.println("WARNING!");
                    System.out.println("IPC-D-317A FORMULA RESTRICTION");
                    System.out.println("For this model the thickness over separation ratio, " + d3 + ", must be less than 0.25");
                    System.out.println("The results are likely to be inaccurate");
                }
                this.idealRealCharacteristicImpedance = 87.0 / Math.sqrt(this.relativePermittivity + 1.41);
                this.idealRealCharacteristicImpedance *= Math.log(5.98 * this.plateSeparation / (0.8 * this.trackWidth + this.trackThickness));
                break;
            }
            case 1: {
                if (!this.thicknessSet) {
                    throw new IllegalArgumentException("The strip line track thickness has not been entered");
                }
                double d7 = 1.0 / Math.sqrt(1.0 + 12.0 * d2);
                if (d < 1.0) {
                    d7 += 0.04 * Fmath.square(1.0 - d);
                }
                this.effectivePermittivity = (d4 + d5 * d7) / 2.0;
                double d8 = d3 * d3;
                double d9 = this.trackThickness / Math.PI * Math.log(10.87312731383618 / Math.sqrt(d8 += Fmath.square(0.3183098861837907 / (this.trackWidth / this.trackThickness + 1.1))));
                double d10 = d9 * ((1.0 + 1.0 / this.effectivePermittivity) / 2.0);
                this.effectiveTrackWidth = this.trackWidth + d10;
                this.idealRealCharacteristicImpedance = 376.73031346177066 / (Math.PI * 2 * Math.sqrt(2.0 * d4));
                double d11 = (1.0 + 1.0 / this.effectivePermittivity) * Math.PI * Math.PI / 2.0;
                d11 += Fmath.square(4.0 * this.plateSeparation / this.effectiveTrackWidth);
                d11 += Fmath.square((14.0 + 8.0 / this.effectivePermittivity) / 11.0);
                d11 = Math.sqrt(d11);
                d11 += (14.0 + 8.0 / this.effectivePermittivity) / 11.0 * (4.0 * this.plateSeparation / this.effectiveTrackWidth);
                d11 *= 4.0 * this.plateSeparation / this.effectiveTrackWidth;
                d11 += 1.0;
                d11 = Math.log(d11);
                this.idealRealCharacteristicImpedance *= d11;
                break;
            }
            case 0: {
                double d12;
                if (!this.separationSet) {
                    throw new IllegalArgumentException("The strip line plate separation has not been entered");
                }
                if (!this.widthSet) {
                    throw new IllegalArgumentException("The strip line track width has not been entered");
                }
                if (!this.permittivitySet) {
                    throw new IllegalArgumentException("The relative permittivity has not been entered");
                }
                double d13 = 0.0;
                if (d < 3.3) {
                    d13 = 376.73031346177066 / (Math.PI * Math.sqrt(2.0 * d4));
                    d12 = Math.log(4.0 * d2 + Math.sqrt(16.0 * d2 * d2 + 2.0));
                    d13 *= (d12 -= 0.5 * (d5 / d4) * (Math.log(1.5707963267948966) + Math.log(1.2732395447351628) / this.relativePermittivity));
                } else {
                    d13 = 376.73031346177066 / (2.0 * Math.sqrt(this.relativePermittivity));
                    d12 = d / 2.0 + Math.log(4.0) / Math.PI + Math.log(1.6767728935975386) / (Math.PI * 2) * d5 / (this.relativePermittivity * this.relativePermittivity);
                    d13 /= (d12 += d4 / (Math.PI * 2 * this.relativePermittivity) * (Math.log(4.269867111336783) + Math.log(d / 2.0 + 0.94)));
                }
                d12 = 0.0;
                double d14 = d13 * Math.sqrt(2.0 * d4) * Math.PI / 376.73031346177066;
                d12 = d < 1.3 ? d4 / 2.0 * Math.pow(1.0 - 0.5 * (d14 += 0.5 * (d5 / d4) * (Math.log(1.5707963267948966) + Math.log(1.2732395447351628) / this.relativePermittivity)) * (d5 / d4) * (Math.log(1.5707963267948966) + Math.log(1.2732395447351628) / this.relativePermittivity), -2.0) : d4 / 2.0 + d5 / 2.0 * Math.pow(1.0 + 10.0 * d2, -0.555);
                double d15 = this.plateSeparation * 376.73031346177066 / (d13 * Math.sqrt(d12));
                if (this.frequency == 0.0) {
                    this.idealRealCharacteristicImpedance = d13;
                    this.effectivePermittivity = d12;
                    this.effectiveTrackWidth = d15;
                    break;
                }
                System.out.println("QQQ");
                double[] dArray = new double[]{0.27488 + (0.6315 + 0.525 / Math.pow(1.0 + 0.157 * d6, 20.0)) * d - 0.065683 * Math.exp(-8.7513 * d), 0.33622 * (1.0 - Math.exp(-0.03442 * this.relativePermittivity)), 0.0363 * Math.exp(-4.6 * d) * (1.0 - Math.exp(-Math.pow(d6 / 3.87, 4.97))), 1.0 + 2.751 * (1.0 - Math.exp(-Math.pow(this.relativePermittivity / 15.916, 8.0)))};
                double d16 = dArray[0] * dArray[1] * Math.pow((0.1844 + dArray[2] * dArray[3]) * 10.0 * d6, 1.5763);
                this.effectivePermittivity = this.relativePermittivity - (this.relativePermittivity - d12) / (1.0 + d16);
                double[] dArray2 = new double[12];
                dArray2[0] = 4.766 * Math.exp(-3.228 * Math.pow(d, 0.641));
                dArray2[1] = 0.016 + Math.pow(0.0514 * this.relativePermittivity, 4.524);
                dArray2[2] = 1.206 - 0.3144 * Math.exp(-0.0389 * Math.pow(this.relativePermittivity, 1.4)) * (1.0 - Math.exp(-0.267 * Math.pow(d, 7.0)));
                dArray2[3] = 1.0 + 1.275 * (1.0 - Math.exp(-0.00463 * dArray2[0] * Math.pow(this.relativePermittivity, 1.674) * Math.pow(d6 / 18.37, 2.745)));
                dArray2[4] = 5.086 * dArray[1] * Math.pow(d6 / 28.84, 12.0) / (0.384 + 0.386 * dArray2[1]);
                dArray2[4] = dArray2[4] * (Math.exp(-22.2 * Math.pow(d, 1.92)) / (1.0 + 1.3 * Math.pow(d6 / 28.84, 12.0)));
                dArray2[4] = dArray2[4] * (Math.pow(d5, 6.0) / (1.0 + 10.0 * Math.pow(d5, 6.0)));
                dArray2[5] = 1.0 / (0.0962 + Math.pow(19.47 / d6, 6.0));
                dArray2[6] = 1.0 / (1.0 + 0.00245 * Math.pow(d, 2.0));
                dArray2[7] = 0.9408 * Math.pow(this.effectivePermittivity, dArray2[3]) - 0.9603;
                dArray2[8] = (0.9408 - dArray2[4]) * Math.pow(d12, dArray2[3]) - 0.9603;
                dArray2[9] = 0.707 * (4.4E-4 * Math.pow(this.relativePermittivity, 2.136) + 0.0184) * Math.pow(d6 / 12.3, 1.097);
                dArray2[10] = 1.0 + 0.0503 * Math.pow(this.relativePermittivity, 2.0) * dArray2[5] * (1.0 - Math.exp(-Math.pow(d / 15.0, 6.0)));
                dArray2[11] = dArray2[2] * (1.0 - 1.1241 * (dArray2[6] / dArray2[10]) * Math.exp(-0.026 * Math.pow(d6, 1.1566) - dArray2[9]));
                this.idealRealCharacteristicImpedance = d13 * Math.pow(dArray2[7] / dArray2[8], dArray2[11]);
                System.out.println(dArray2[7] + " " + dArray2[8] + " " + dArray2[11]);
                this.effectiveTrackWidth = this.plateSeparation * 376.73031346177066 / (this.idealRealCharacteristicImpedance * Math.sqrt(this.effectivePermittivity));
                break;
            }
            default: {
                throw new IllegalArgumentException("Formulae option, " + this.formulaOption + ", must lie between 0 and 2 inclusive");
            }
        }
        this.idealRealCharacteristicImpedance *= Math.sqrt(this.relativePermeability);
        this.idealCharacteristicImpedance = new Complex(this.idealRealCharacteristicImpedance, 0.0);
        this.z0calculated = true;
        this.calculateDistributedCapacitanceAndInductance();
        return this.idealCharacteristicImpedance;
    }

    @Override
    public Complex getIdealCharacteristicImpedance() {
        if (!this.z0calculated) {
            this.calcIdealCharacteristicImpedance();
        }
        return this.idealCharacteristicImpedance;
    }

    @Override
    public double getIdealCharacteristicImpedanceAsReal() {
        if (!this.z0calculated) {
            this.calcIdealCharacteristicImpedance();
        }
        return this.idealRealCharacteristicImpedance;
    }

    private void calculateDistributedCapacitanceAndInductance() {
        if (!this.z0calculated) {
            this.calcIdealCharacteristicImpedance();
        }
        switch (this.formulaOption) {
            case 2: {
                double d = Math.log(5.98 * this.plateSeparation / (0.8 * this.trackWidth + this.trackThickness));
                this.distributedCapacitance = 1.7018000000000003E-14 * (this.relativePermittivity + 1.41) / d;
                break;
            }
            case 0: 
            case 1: {
                this.distributedCapacitance = this.effectiveTrackWidth * this.effectivePermittivity * 8.854187817E-12 / this.plateSeparation;
                break;
            }
            default: {
                throw new IllegalArgumentException("Formulae option, " + this.formulaOption + ", must lie between 0 and 2 inclusive");
            }
        }
        this.distributedInductance = this.distributedCapacitance * this.idealRealCharacteristicImpedance * this.idealRealCharacteristicImpedance;
    }

    @Override
    public SurfaceStripLine copy() {
        if (this == null) {
            return null;
        }
        SurfaceStripLine surfaceStripLine = new SurfaceStripLine();
        surfaceStripLine.formulaOption = this.formulaOption;
        surfaceStripLine.trackWidth = this.trackWidth;
        surfaceStripLine.effectiveTrackWidth = this.effectiveTrackWidth;
        surfaceStripLine.trackThickness = this.trackThickness;
        surfaceStripLine.plateSeparation = this.plateSeparation;
        surfaceStripLine.separationSet = this.separationSet;
        surfaceStripLine.thicknessSet = this.thicknessSet;
        surfaceStripLine.widthSet = this.widthSet;
        surfaceStripLine.z0calculated = this.z0calculated;
        surfaceStripLine.relativePermittivity = this.relativePermittivity;
        surfaceStripLine.effectivePermittivity = this.effectivePermittivity;
        surfaceStripLine.relativePermeability = this.relativePermeability;
        surfaceStripLine.permittivitySet = this.permittivitySet;
        surfaceStripLine.title = this.title;
        surfaceStripLine.distributedResistance = this.distributedResistance;
        surfaceStripLine.distributedConductance = this.distributedConductance;
        surfaceStripLine.distributedCapacitance = this.distributedCapacitance;
        surfaceStripLine.distributedInductance = this.distributedInductance;
        surfaceStripLine.distributedImpedance = this.distributedImpedance.copy();
        surfaceStripLine.distributedAdmittance = this.distributedAdmittance.copy();
        surfaceStripLine.loadImpedance = this.loadImpedance.copy();
        surfaceStripLine.lineLength = this.lineLength;
        surfaceStripLine.segmentLength = this.segmentLength;
        surfaceStripLine.frequency = this.frequency;
        surfaceStripLine.segmentLength = this.segmentLength;
        surfaceStripLine.omega = this.omega;
        surfaceStripLine.inputVoltage = this.inputVoltage.copy();
        surfaceStripLine.inputCurrent = this.inputCurrent.copy();
        surfaceStripLine.outputVoltage = this.outputVoltage.copy();
        surfaceStripLine.outputCurrent = this.outputCurrent.copy();
        surfaceStripLine.idealWavelength = this.idealWavelength;
        surfaceStripLine.generalWavelength = this.generalWavelength;
        surfaceStripLine.lowLossWavelength = this.lowLossWavelength;
        surfaceStripLine.idealPhaseVelocity = this.idealPhaseVelocity;
        surfaceStripLine.generalPhaseVelocity = this.generalPhaseVelocity;
        surfaceStripLine.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
        surfaceStripLine.idealGroupVelocity = this.idealGroupVelocity;
        surfaceStripLine.generalGroupVelocity = this.generalGroupVelocity;
        surfaceStripLine.lowLossGroupVelocity = this.lowLossGroupVelocity;
        surfaceStripLine.delta = this.delta;
        surfaceStripLine.idealAttenuationConstant = this.idealAttenuationConstant;
        surfaceStripLine.generalAttenuationConstant = this.generalAttenuationConstant;
        surfaceStripLine.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
        surfaceStripLine.idealPhaseConstant = this.idealPhaseConstant;
        surfaceStripLine.generalPhaseConstant = this.generalPhaseConstant;
        surfaceStripLine.lowLossPhaseConstant = this.lowLossPhaseConstant;
        surfaceStripLine.idealPropagationConstant = this.idealPropagationConstant.copy();
        surfaceStripLine.loadImpedance = this.loadImpedance.copy();
        surfaceStripLine.loadImpedance = this.loadImpedance.copy();
        surfaceStripLine.loadImpedance = this.loadImpedance.copy();
        surfaceStripLine.generalPropagationConstant = this.generalPropagationConstant.copy();
        surfaceStripLine.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
        surfaceStripLine.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
        surfaceStripLine.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
        surfaceStripLine.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
        surfaceStripLine.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
        surfaceStripLine.idealInputImpedance = this.idealInputImpedance.copy();
        surfaceStripLine.generalInputImpedance = this.generalInputImpedance.copy();
        surfaceStripLine.lowLossInputImpedance = this.lowLossInputImpedance.copy();
        surfaceStripLine.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
        surfaceStripLine.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
        surfaceStripLine.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
        surfaceStripLine.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
        surfaceStripLine.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
        surfaceStripLine.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
        surfaceStripLine.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
        surfaceStripLine.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
        surfaceStripLine.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
        surfaceStripLine.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
        surfaceStripLine.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
        surfaceStripLine.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
        surfaceStripLine.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
        surfaceStripLine.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
        surfaceStripLine.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
        surfaceStripLine.idealStandingWaveRatio = this.idealStandingWaveRatio;
        surfaceStripLine.generalStandingWaveRatio = this.generalStandingWaveRatio;
        surfaceStripLine.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
        surfaceStripLine.idealABCDmatrix = this.idealABCDmatrix.copy();
        surfaceStripLine.generalABCDmatrix = this.generalABCDmatrix.copy();
        surfaceStripLine.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
        surfaceStripLine.numberOfPoints = this.numberOfPoints;
        return surfaceStripLine;
    }

    @Override
    public Object clone() {
        SurfaceStripLine surfaceStripLine = null;
        if (this != null) {
            SurfaceStripLine surfaceStripLine2 = new SurfaceStripLine();
            surfaceStripLine2.formulaOption = this.formulaOption;
            surfaceStripLine2.trackWidth = this.trackWidth;
            surfaceStripLine2.effectiveTrackWidth = this.effectiveTrackWidth;
            surfaceStripLine2.trackThickness = this.trackThickness;
            surfaceStripLine2.plateSeparation = this.plateSeparation;
            surfaceStripLine2.separationSet = this.separationSet;
            surfaceStripLine2.thicknessSet = this.thicknessSet;
            surfaceStripLine2.widthSet = this.widthSet;
            surfaceStripLine2.z0calculated = this.z0calculated;
            surfaceStripLine2.relativePermittivity = this.relativePermittivity;
            surfaceStripLine2.effectivePermittivity = this.effectivePermittivity;
            surfaceStripLine2.relativePermeability = this.relativePermeability;
            surfaceStripLine2.permittivitySet = this.permittivitySet;
            surfaceStripLine2.title = this.title;
            surfaceStripLine2.distributedResistance = this.distributedResistance;
            surfaceStripLine2.distributedConductance = this.distributedConductance;
            surfaceStripLine2.distributedCapacitance = this.distributedCapacitance;
            surfaceStripLine2.distributedInductance = this.distributedInductance;
            surfaceStripLine2.distributedImpedance = this.distributedImpedance.copy();
            surfaceStripLine2.distributedAdmittance = this.distributedAdmittance.copy();
            surfaceStripLine2.loadImpedance = this.loadImpedance.copy();
            surfaceStripLine2.lineLength = this.lineLength;
            surfaceStripLine2.segmentLength = this.segmentLength;
            surfaceStripLine2.frequency = this.frequency;
            surfaceStripLine2.segmentLength = this.segmentLength;
            surfaceStripLine2.omega = this.omega;
            surfaceStripLine2.inputVoltage = this.inputVoltage.copy();
            surfaceStripLine2.inputCurrent = this.inputCurrent.copy();
            surfaceStripLine2.outputVoltage = this.outputVoltage.copy();
            surfaceStripLine2.outputCurrent = this.outputCurrent.copy();
            surfaceStripLine2.idealWavelength = this.idealWavelength;
            surfaceStripLine2.generalWavelength = this.generalWavelength;
            surfaceStripLine2.lowLossWavelength = this.lowLossWavelength;
            surfaceStripLine2.idealPhaseVelocity = this.idealPhaseVelocity;
            surfaceStripLine2.generalPhaseVelocity = this.generalPhaseVelocity;
            surfaceStripLine2.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
            surfaceStripLine2.idealGroupVelocity = this.idealGroupVelocity;
            surfaceStripLine2.generalGroupVelocity = this.generalGroupVelocity;
            surfaceStripLine2.lowLossGroupVelocity = this.lowLossGroupVelocity;
            surfaceStripLine2.delta = this.delta;
            surfaceStripLine2.idealAttenuationConstant = this.idealAttenuationConstant;
            surfaceStripLine2.generalAttenuationConstant = this.generalAttenuationConstant;
            surfaceStripLine2.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
            surfaceStripLine2.idealPhaseConstant = this.idealPhaseConstant;
            surfaceStripLine2.generalPhaseConstant = this.generalPhaseConstant;
            surfaceStripLine2.lowLossPhaseConstant = this.lowLossPhaseConstant;
            surfaceStripLine2.idealPropagationConstant = this.idealPropagationConstant.copy();
            surfaceStripLine2.loadImpedance = this.loadImpedance.copy();
            surfaceStripLine2.loadImpedance = this.loadImpedance.copy();
            surfaceStripLine2.loadImpedance = this.loadImpedance.copy();
            surfaceStripLine2.generalPropagationConstant = this.generalPropagationConstant.copy();
            surfaceStripLine2.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
            surfaceStripLine2.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
            surfaceStripLine2.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
            surfaceStripLine2.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
            surfaceStripLine2.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
            surfaceStripLine2.idealInputImpedance = this.idealInputImpedance.copy();
            surfaceStripLine2.generalInputImpedance = this.generalInputImpedance.copy();
            surfaceStripLine2.lowLossInputImpedance = this.lowLossInputImpedance.copy();
            surfaceStripLine2.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
            surfaceStripLine2.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
            surfaceStripLine2.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
            surfaceStripLine2.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
            surfaceStripLine2.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
            surfaceStripLine2.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
            surfaceStripLine2.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
            surfaceStripLine2.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
            surfaceStripLine2.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
            surfaceStripLine2.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
            surfaceStripLine2.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
            surfaceStripLine2.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
            surfaceStripLine2.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
            surfaceStripLine2.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
            surfaceStripLine2.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
            surfaceStripLine2.idealStandingWaveRatio = this.idealStandingWaveRatio;
            surfaceStripLine2.generalStandingWaveRatio = this.generalStandingWaveRatio;
            surfaceStripLine2.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
            surfaceStripLine2.idealABCDmatrix = this.idealABCDmatrix.copy();
            surfaceStripLine2.generalABCDmatrix = this.generalABCDmatrix.copy();
            surfaceStripLine2.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
            surfaceStripLine2.numberOfPoints = this.numberOfPoints;
            surfaceStripLine = surfaceStripLine2;
        }
        return surfaceStripLine;
    }
}

